<?php
/**
* @version 1.0.0
* @package RSTester! 1.0.0
* @copyright (C) 2016 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/

defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.model');

class RSTesterModelRSTester extends JModelLegacy
{
	public function __construct() {
		parent::__construct();
	}

	public function getComponent() {
		return JFactory::getApplication()->input->get('component');
	}

	public function getResults() {
		$result = array(
			'PHP' 				=> $this->getPHPVersion(),
			'MySQL'				=> $this->getMySQLVersion(),
			'Joomla! Version' 	=> $this->getJoomlaVersion(),
			'is_compatible' 	=> true
		);

		switch ($this->getComponent()) {
			case 'com_rsform':
				$result['GD']				= $this->getGD();
				$result['FreeType'] 		= $this->getFreeType();
				$result['fsockopen()'] 		= $this->getFSockOpen();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}

				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct)
					$result['is_compatible'] = false;

			break;

			case 'com_rsblog':
				$result['PHP']				 = $this->getPHPVersion('5.3');
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				$result['cURL'] 			 = $this->getcURL();
				$result['fopen'] 			 = $this->getFopen();
				$result['file_get_contents'] = $this->getFilegetcontents();
				$result['IMAP'] 			 = $this->getImap();
				
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
				
				if(!$result['GD']->is_correct || !$result['cURL']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['fopen']->is_correct || !$result['file_get_contents']->is_correct || !$result['IMAP']->is_correct )
					$result['is_compatible'] = false;
			break;
			
			case 'com_rscomments':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}

				if (!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['Joomla! Version']->is_correct) 
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsdirectory':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				$result['cURL'] 			 = $this->getcURL();
				
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}

				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['cURL'] || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rseventspro':
				$result['PHP']				 = $this->getPHPVersion('5.3');
				$result['MooTools'] 		 = $this->getMootools('1.2.5');
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['cURL'] 			 = $this->getcURL();
				$result['fopen'] 			 = $this->getFopen();
				$result['mb_strlen'] 		 = $this->getMbstrlen();
				$result['json_encode'] 		 = $this->getJsonencode();
				
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}

				if(!$result['mb_strlen']->is_correct || !$result['MooTools']->is_correct || !$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['cURL']->is_correct || !$result['fopen']->is_correct || !$result['mb_strlen']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsfeedback':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
				
				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsfiles':
				$result['MooTools'] 		 = $this->getMootools('1.2.5');
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
				
				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;

			case 'com_rsfirewall':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}

				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct)
					$result['is_compatible'] = false;
				$result['PHP']				 = $this->getPHPVersion('5.2');
			break;

			case 'com_rsmail':
				$result['IMAP'] 			 = $this->getImap();
				$result['iconv'] 			 = $this->getIconv();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}

				if(!$result['IMAP']->is_correct || !$result['iconv']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;

			case 'com_rsmediagallery':
				$result['GD']				 = $this->getGD();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
				
				if (!$result['GD']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsmembership':
				$result['GD']				 = $this->getGD();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				$result['cURL'] 			 = $this->getcURL();
				$result['FreeType'] 		 = $this->getFreeType();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
				
				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['cURL']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsseo':
				$result['mb_strlen'] 	= $this->getMbstrlen();
				$result['mb_eregi'] 	= $this->getMBRegex();
				$result['DOMDocument'] 	= $this->getDomDocument();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}

			break;

			case 'com_rsticketspro':
				$result['PHP']				 = $this->getPHPVersion('5.3');
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
				
				if(!$result['fsockopen()'] || !$result['FreeType'] || !$result['GD'])
					$result['is_compatible'] = false;
			break;

			case 'plg_rsticketspro_cron':

				$result['iconv'] 			 = $this->getIconv();
				$result['IMAP'] 			 = $this->getImap();

				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
				
				if (!$result['iconv']->is_correct || !$result['IMAP']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rssearch':
				// no special requirements
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
			break;
			
			case 'com_rsfinder':
				// no special requirements
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
			break;
			
			case 'com_rspagebuilder':
				if ( version_compare($result['Joomla! Version']->status, '3.7.0', '<') ) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');
				}
			break;
		}

		if (!$result['PHP']->is_correct || !$result['MySQL']->is_correct)
			$result['is_compatible'] = false;
			
		return $result;
	}
	
	public function getPHPVersion($min = '5.0') {
		$your_php 	 = phpversion();
		$correct_php = version_compare($your_php, $min, '>=');

		$requirement 				= new stdClass();
		$requirement->status 		= $your_php;
		$requirement->is_correct 	= $correct_php;
		$requirement->description 	= JText::_('RSTE_PHP_DESCRIPTION');
		$requirement->solution		= JText::sprintf('RSTE_PHP_SOLUTION', $min);

		return $requirement;
	}

	public function getMySQLVersion($min = '5.0') {
		$db = JFactory::getDBO();

		$db->setQuery("SELECT VERSION()");
		$your_sql 	 = $db->loadResult();
		$correct_sql = version_compare($your_sql, $min);

		$requirement 			= new stdClass();
		$requirement->status 		= $your_sql;
		$requirement->is_correct 	= $correct_sql;
		$requirement->description 	= JText::_('RSTE_MYSQL_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_MYSQL_SOLUTION');
		
		return $requirement;
	}
	
	public function getGD() {
		$correct_gd = extension_loaded('gd') && function_exists('gd_info');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_gd ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_gd;
		$requirement->description 	= JText::_('RSTE_GD_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_GD_SOLUTION_'.$this->getComponent());

		return $requirement;
	}
	
	public function getJoomlaVersion() {
		jimport('joomla.version');
		$version = new JVersion();

		$requirement 				= new stdClass();
		$requirement->status 		= $version->getShortVersion();
		$requirement->is_correct 	= true;
		$requirement->description 	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_JOOMLA_VERSION_SOLUTION', '3.7.0');

		return $requirement;
	}
	
	public function getFreeType() {
		$correct_freetype = function_exists('imagettftext');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_freetype ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_freetype;
		$requirement->description 	= JText::_('RSTE_FREETYPE_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FREETYPE_SOLUTION_'.$this->getComponent());

		return $requirement;
	}
	
	public function getFSockOpen() {
		$correct_fsockopen = function_exists('fsockopen');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_fsockopen ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_fsockopen;
		$requirement->description 	= JText::_('RSTE_FSOCKOPEN_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FSOCKOPEN_SOLUTION_'.$this->getComponent());

		return $requirement;
	}

	public function getcURL() {
		$correct_curl = extension_loaded('curl') && function_exists('curl_init');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_curl ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_curl;
		$requirement->description 	= JText::_('RSTE_CURL_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_CURL_SOLUTION_'.$this->getComponent());

		return $requirement;
	}
	
	public function getFopen() {
		$correct_fopen = function_exists('fopen') && ini_get('allow_url_fopen');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_fopen ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_fopen;
		$requirement->description 	= JText::_('RSTE_FOPEN_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FOPEN_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	public function getFilegetcontents() {
		$correct_filegetcontents = function_exists('file_get_contents') && ini_get('allow_url_fopen');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_filegetcontents ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_filegetcontents;
		$requirement->description 	= JText::_('RSTE_FILEGETCONTENTS_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FILEGETCONTENTS_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	public function getImap() {
		$correct_imap = function_exists('imap_open');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_imap ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_imap;
		$requirement->description 	= JText::_('RSTE_IMAP_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_IMAP_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	public function getMbstrlen() {
		$correct_mbstrlen = function_exists('mb_strlen');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_mbstrlen ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_mbstrlen;
		$requirement->description 	= JText::_('RSTE_MBSTRLEN_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_MBSTRLEN_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	public function getMBRegex() {
		$correct_mbregex = function_exists('mb_eregi');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_mbregex ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_mbregex;
		$requirement->description 	= JText::_('RSTE_MBREGEX_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_MBREGEX_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}

	public function getJsonencode() {
		$correct_json_encode = function_exists('json_encode');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_json_encode ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_json_encode;
		$requirement->description 	= JText::_('RSTE_JSONENCODE_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_JSONENCODE_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	public function getIconv() {
		$correct_iconv = function_exists('iconv');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_iconv ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_iconv;
		$requirement->description 	= JText::_('RSTE_ICONV_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_ICONV_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	public function getMootools($min = '1.2.4') {
		jimport('joomla.version');
		jimport('joomla.plugin.helper');
		$version 	 = new JVersion();
		$requirement = new stdClass();

		if($version->isCompatible('1.6.0')) {
			if (file_exists(JPATH_SITE.'/media/system/js/mootools-core.js')) {
				$mooContents = file_get_contents(JPATH_SITE.'/media/system/js/mootools-core.js');
				preg_match('#version:"([0-9\.]+)"#is',$mooContents,$match);
				if (!empty($match) && !empty($match[1])) {
					$requirement->status = 'MooTools '.$match[1];
				} else {
					preg_match('#version: \'([0-9\.]+)\'#is',$mooContents,$match);
					if (!empty($match) && !empty($match[1])) {
						$requirement->status = 'MooTools '.$match[1];
					}
				}
			} else {
				$requirement->status 	= 'Mootools 1.3';
			}
			
			$requirement->is_correct 		= true;
		} elseif(JPluginHelper::isEnabled('system', 'mtupgrade')) {
			if (file_exists(JPATH_SITE.'/plugins/system/mtupgrade/mootools.js')) {
				$mooContents = file_get_contents(JPATH_SITE.'/plugins/system/mtupgrade/mootools.js');
				preg_match('#\'version\': \'([0-9\.]+)\'#is',$mooContents,$match);
				if (!empty($match) && !empty($match[1])) {
					$requirement->status = 'MooTools '.$match[1];
					$requirement->is_correct = version_compare($match[1], $min,'>=');
				} else {
					preg_match('#version:"([0-9\.]+)"#is',$mooContents,$match);
					if (!empty($match) && !empty($match[1])) {
						$requirement->status = 'MooTools '.$match[1];
						$requirement->is_correct = version_compare($match[1], $min,'>=');
					}
				}
			} else {
				$requirement->status 	 =  'Mootools 1.2.4';
				$requirement->is_correct = version_compare('1.2.4', $min);
			}
		} else {
			$requirement->status 	= 'Mootools 1.12';
			$requirement->is_correct 		= false;
		}

		$requirement->description 	= JText::_('RSTE_MOOTOOLS_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_MOOTOOLS_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}

	protected static function checkForJoomla($content) {
		$count	= 0;
		$search = array('media/jui/js/jquery.min.js', '/media/jui/js/jquery-migrate.min.js', 'media/jui/js/bootstrap.min.js', 'media/system/js/core.js', 'media/system/js/modal.js', 'media/system/css/modal.css', 'media/system/js/mootools-core.js', 'Joomla.JText');
		
		foreach ($search as $key) {
			if (strpos($content,$key) !== false) {
				$count++;
			}
		}
		
		return empty($count) ? false : true;
	}
	
	public static function getHeaders($host, $doc) {
		$httpheader = '';
		$fp = @fsockopen($host, 80, $errno, $errstr, 30);
		if (!$fp) {
			return false;
		} else {
			@fputs($fp, 'GET '.$doc.' HTTP/1.0'."\r\n".'Host: '.$host."\r\n\r\n");
			
			while(!@feof($fp)) {
				$httpresult = @fgets ($fp,1024);
				$httpheader = $httpheader.$httpresult;
				if ($httpresult == "\r\n")
					break;
			}
			@fclose ($fp);
		}
		return $httpheader;
	}
	
	public static function fopen($url, $headers = 1, $test = false, $onlyHeaders = false) {
		$uri		= JURI::getInstance();
		$host		= $uri->getHost();
		$useragent  = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.3) Gecko/20090824 Firefox/3.5.3 (.NET CLR 3.5.30729)";
		$data		= false;
		$url		= html_entity_decode($url);
		$google		= JFactory::getApplication()->input->getInt('google',0);
		$host		= str_replace('www.','',$host);
		
		$errors = array('cURL' 	=> true, 'fsockopen' 		=> true,
						'fopen' => true, 'file_get_contents' => true
						);
		
		// cURL
		if (extension_loaded('curl')) {
			$ch = @curl_init();
			
			// Set options
			@curl_setopt($ch, CURLOPT_URL, $url);
			@curl_setopt($ch, CURLOPT_HEADER, $headers);
			//@curl_setopt($ch, CURLOPT_FAILONERROR, 1);
			@curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			@curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
			@curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
			@curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			@curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			
			// Set timeout
			@curl_setopt($ch, CURLOPT_TIMEOUT, 5);
			
			// Grab data
			$data = @curl_exec($ch);
			
			$headers_sent = false;
			if ($headers) {
				$objs = explode("\n",$data);
				foreach($objs as $obj) {
					if(strpos($obj,'Location:') !== false) {
						$new_url = trim(str_replace('Location: ','',$obj));
						if(strpos($new_url,$host) !== false) {
							$data = self::fopen($new_url,0);
							
							if (!empty($data))
								$headers_sent = true;
						}
					}
				}
			}
			
			$curl_error = curl_error($ch);
			$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			@curl_close($ch);
			
			if ($onlyHeaders)
				return $httpcode;
			
			if ($httpcode > 300 && !$headers_sent && !$test && !$google) 
				return 'RSSEOINVALID';
			
			if(empty($data)) {
				$errors['cURL'] = false;
			}
			
			// Return data
			if ($data !== false && !$test)
				return $data;
		} else {
			$errors['cURL'] = false;
		}

		// file_get_contents
		if(function_exists('file_get_contents') && ini_get('allow_url_fopen')) {
			$url = str_replace('://localhost', '://127.0.0.1', $url);
			@ini_set('user_agent',$useragent);
			$data = @file_get_contents($url);
			
			$response = false;
			if (isset($http_response_header)) {
				if (is_array($http_response_header))
					foreach ($http_response_header as $header) {
						if (substr($header,0,4) == 'HTTP') {
							if (substr_count($header, '200 OK') > 0)
								$response = true;
						}
					}
			}
			
			if ($onlyHeaders) {
				if (isset($http_response_header)) {
					foreach ($http_response_header as $header) {
						if (substr($header,0,4) == 'HTTP') {
							if (preg_match("/[0-9]{3}/", $header, $match))
								return isset($match[0]) ? $match[0] : '';
						}
					}
				}
				return '';
			}
			
			if (!$response && !$test && !$google)
				return 'RSSEOINVALID';
			
			if(empty($data)) 
				$errors['file_get_contents'] = false;
			
			// Return data
			if ($data !== false && !$test)
				return $data;
		} else {
			$errors['file_get_contents'] = false;
		}
		
	 	// fopen
		if (function_exists('fopen') && ini_get('allow_url_fopen')) {
			if (ini_get('default_socket_timeout') < 5) ini_set('default_socket_timeout', 5);
			@stream_set_blocking($handle, 1);
			@stream_set_timeout($handle, 5);
			@ini_set('user_agent',$useragent);
			
			$url = str_replace('://localhost', '://127.0.0.1', $url);
			if ($handle = @fopen ($url, 'r')) {
				$data = '';
				while (!feof($handle))
					$data .= @fread($handle, 8192);
			
				// Clean up
				@fclose($handle);
			
				if(empty($data))
					$errors['fopen'] = false;
				
				$response1 = false;
				if (isset($http_response_header)) {
					if (is_array($http_response_header))
						foreach ($http_response_header as $header) {
							if (substr($header,0,4) == 'HTTP') {
								if (substr_count($header, '200 OK') > 0)
									$response1 = true;
							}
						}
				}
				
				if ($onlyHeaders) {
					if (isset($http_response_header)) {
						foreach ($http_response_header as $header) {
							if (substr($header,0,4) == 'HTTP') {
								if (preg_match("/[0-9]{3}/", $header, $match))
									return isset($match[0]) ? $match[0] : '';
							}
						}
					}
					return '';
				}
				
				if (!$response1 && !$test && !$google)
					return 'RSSEOINVALID';
				
				// Return data
				if ($data !== false && !$test)
					return $data;
			} else {
				$response = false;
				if (isset($http_response_header)) {
					if (is_array($http_response_header))
						foreach ($http_response_header as $header) {
							if (substr($header,0,4) == 'HTTP') {
								if (substr_count($header, '200 OK') > 0)
									$response = true;
							}
						}
				}
				
				if ($onlyHeaders) {
					if (isset($http_response_header)) {
						foreach ($http_response_header as $header) {
							if (substr($header,0,4) == 'HTTP') {
								if (preg_match("/[0-9]{3}/", $header, $match))
									return isset($match[0]) ? $match[0] : '';
							}
						}
					}
					return '';
				}
				
				if ($test) {
					$errors['fopen'] = false;
				}
				
				if (!$response && !$test && !$google)
					return 'RSSEOINVALID';
			}
		} else {
			$errors['fopen'] = false;
		}
		
		// fsockopen
		if (function_exists('fsockopen')) {
			$errno = 0;
			$errstr = '';

			$url_info = parse_url($url);
			if(isset($url_info['host']) && $url_info['host'] == 'localhost') {
				$url_info['host'] = '127.0.0.1';
			}
		
			if ($fsock = @fsockopen($url_info['host'], 80, $errno, $errstr, 5)) {

				@fputs($fsock, 'GET '.$url_info['path'].(!empty($url_info['query']) ? '?'.$url_info['query'] : '').' HTTP/1.1'."\r\n");
				@fputs($fsock, 'HOST: '.$url_info['host']."\r\n");
				@fputs($fsock, "User-Agent: ".$useragent."\r\n");
				@fputs($fsock, 'Connection: close'."\r\n\r\n");
        
				// Set timeout
				@stream_set_blocking($fsock, 1);
				@stream_set_timeout($fsock, 5);
				
				$data		= '';
				$fheaders	= '';
				$response	= @fgets($fsock);

				if ($onlyHeaders) {
					$Urlheaders = $this->getHeaders($url_info['host'],$url_info['path'].(!empty($url_info['query']) ? '?'.$url_info['query'] : ''));
					$http_response_header = explode("\n",$Urlheaders);
					if (isset($http_response_header)) {
						foreach ($http_response_header as $header) {
							if (substr($header,0,4) == 'HTTP') {
								if (preg_match("/[0-9]{3}/", $header, $match))
									return isset($match[0]) ? $match[0] : '';
							}
						}
					}
					return '';
				}

				if (substr_count($response, '200 OK') > 0) {
					$passed_header = false;
					while (!@feof($fsock)) {
						if ($passed_header)
							$data .= @fread($fsock, 1024);
						else {
							if (@fgets($fsock,1024) == "\r\n") {
								$passed_header = true;
							}
						}
					}
				} else {
					$fheaders = self::getHeaders($url_info['host'],$url_info['path'].(!empty($url_info['query']) ? '?'.$url_info['query'] : ''));
					
					if ($headers && !empty($fheaders)) {
						$objs = explode("\n",$fheaders);
						foreach($objs as $obj) {
							if(strpos($obj,'Location:') !== false) {
								$new_url = trim(str_replace('Location: ','',$obj));
								if(strpos($new_url,$url_info['host']) !== false){
									$data = self::fopen($new_url,0);
									break;
								}
							}
						}
					}
					
					if (empty($data) && !$test && !$google) {
						return 'RSSEOINVALID';
					}
				}
				
				// Clean up
				@fclose($fsock);
				
				if(empty($data)) {
					$errors['fsockopen'] = false;
				}
				
				// Return data
				if ($data !== false && !$test)
					return $data;
			} else {
				$errors['fsockopen'] = false;
			}
		} else {
			$errors['fsockopen'] = false;
		}
		
		if ($test) {
			$errors['data'] = self::fopen($url, 1);
			
			return $errors;
		} else {
			return $data;
		}
	}
	
	public function getDomDocument() {
		$dom_exists	= class_exists('DOMDocument');

		$requirement 				= new stdClass();
		$requirement->status 		= $dom_exists ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $dom_exists;
		$requirement->description 	= JText::_('RSTE_DOMDOCUMENT_CHECK_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_DOMDOCUMENT_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
}