/**
 * Copyright 2009, Moxiecode Systems AB
 * Released under LGPL License.
 * License: http://tinymce.moxiecode.com/license
 * Contributing: http://tinymce.moxiecode.com/contributing
**/
!function(){"use strict";function mimeToExt(mime){var mimes={"image/jpeg":"jpg","image/jpg":"jpg","image/gif":"gif","image/png":"png"};return mimes[mime.toLowerCase()]||"dat"}function create(o,blob,base64,filename){return toBlobInfo("object"==typeof o?o:{id:o,name:filename,blob:blob,base64:base64})}function toBlobInfo(o){var id,name;if(!o.blob||!o.base64)throw"blob and base64 representations of the image are required for BlobInfo to be created";return id=o.id||Uuid.uuid("blobid"),name=o.name||id,{id:constant(id),name:constant(name),filename:constant(name+"."+mimeToExt(o.blob.type)),blob:constant(o.blob),base64:constant(o.base64),blobUri:constant(o.blobUri||URL.createObjectURL(o.blob)),uri:constant(o.uri)}}function add(blobInfo){get(blobInfo.id())||cache.push(blobInfo)}function get(id){return findFirst(function(cachedBlobInfo){return cachedBlobInfo.id()===id})}function findFirst(predicate){return Arr.filter(cache,predicate)[0]}function getByUri(blobUri){return findFirst(function(blobInfo){return blobInfo.blobUri()==blobUri})}function removeByUri(blobUri){cache=Arr.filter(cache,function(blobInfo){return blobInfo.blobUri()!==blobUri||(URL.revokeObjectURL(blobInfo.blobUri()),!1)})}function destroy(){Arr.each(cache,function(cachedBlobInfo){URL.revokeObjectURL(cachedBlobInfo.blobUri())}),cache=[]}function blobUriToBlob(url){return new Promise(function(resolve,reject){var rejectWithError=function(){reject("Cannot convert "+url+" to Blob. Resource might not exist or is inaccessible.")};try{var xhr=new XMLHttpRequest;xhr.open("GET",url,!0),xhr.responseType="blob",xhr.onload=function(){200==this.status?resolve(this.response):rejectWithError()},xhr.onerror=rejectWithError,xhr.send()}catch(ex){rejectWithError()}})}function parseDataUri(uri){var type,matches;return uri=decodeURIComponent(uri).split(","),matches=/data:([^;]+)/.exec(uri[0]),matches&&(type=matches[1]),{type:type,data:uri[1]}}function dataUriToBlob(uri){return new Promise(function(resolve){var str,arr,i;uri=parseDataUri(uri);try{str=atob(uri.data)}catch(e){return void resolve(new Blob([]))}for(arr=new Uint8Array(str.length),i=0;i<arr.length;i++)arr[i]=str.charCodeAt(i);resolve(new Blob([arr],{type:uri.type}))})}function uriToBlob(url){return 0===url.indexOf("blob:")?blobUriToBlob(url):0===url.indexOf("data:")?dataUriToBlob(url):null}function blobToDataUri(blob){return new Promise(function(resolve){var reader=new FileReader;reader.onloadend=function(){resolve(reader.result)},reader.readAsDataURL(blob)})}!function(win){var undef,whiteSpaceRe=/^\s*|\s*$/g,slice=[].slice,tinymce={majorVersion:"@@tinymce_major_version@@",minorVersion:"@@tinymce_minor_version@@",releaseDate:"@@tinymce_release_date@@",_init:function(){function getBase(n){return n.src&&/tiny_mce(|_gzip|_jquery|_prototype|_full)(_dev|_src)?.js/.test(n.src)?(/_(src|dev)\.js/g.test(n.src)&&(self.suffix="_src"),(p=n.src.indexOf("?"))!=-1&&(self.query=n.src.substring(p+1)),self.baseURL=n.src.substring(0,n.src.lastIndexOf("/")),base&&self.baseURL.indexOf("://")==-1&&0!==self.baseURL.indexOf("/")&&(self.baseURL=base+self.baseURL),self.baseURL):null}var i,nl,n,base,p,v,self=this,doc=document,na=navigator,ua=na.userAgent;self.isOpera=win.opera&&win.opera.buildNumber||!1,self.isWebKit=/WebKit/.test(ua);var isIE=!self.isWebKit&&!self.isOpera&&/MSIE/gi.test(ua)&&/Explorer/gi.test(na.appName);for(isIE=isIE&&/MSIE (\w+)\./.exec(ua)[1],self.isIE11=ua.indexOf("Trident/")!=-1&&(ua.indexOf("rv:")!=-1||na.appName.indexOf("Netscape")!=-1)&&11,self.isIE=isIE||self.isIE11,self.isIE12=ua.indexOf("Edge/")!=-1&&!self.isIE&&12,self.isIE12&&(self.isWebKit=!1),self.isGecko=!self.isWebKit&&!self.isIE11&&/Gecko/.test(ua),self.isMac=ua.indexOf("Mac")!=-1,self.isAir=/adobeair/i.test(ua),self.isIDevice=/(iPad|iPhone)/.test(ua),self.isIOS=self.isIDevice,self.isIOS5=self.isIDevice&&ua.match(/AppleWebKit\/(\d*)/)[1]>=534,self.suffix="",nl=doc.getElementsByTagName("base"),i=0;i<nl.length;i++)v=nl[i].href,v&&(/^https?:\/\/[^\/]+$/.test(v)&&(v+="/"),base=v?v.match(/.*\//)[0]:"");for(nl=doc.getElementsByTagName("script"),i=0;i<nl.length;i++)if(getBase(nl[i]))return;if(n=doc.getElementsByTagName("head")[0])for(nl=n.getElementsByTagName("script"),i=0;i<nl.length;i++)if(getBase(nl[i]))return},is:function(o,t){return t?!("array"!=t||!tinymce.isArray(o))||typeof o==t:o!==undef},isArray:Array.isArray||function(obj){return"[object Array]"===Object.prototype.toString.call(obj)},makeMap:function(items,delim,map){var i;for(items=items||[],delim=delim||",","string"==typeof items&&(items=items.split(delim)),map=map||{},i=items.length;i--;)map[items[i]]={};return map},each:function(o,cb,s){var n,l;if(!o)return 0;if(s=s||o,o.length!==undef){for(n=0,l=o.length;n<l;n++)if(cb.call(s,o[n],n,o)===!1)return 0}else for(n in o)if(o.hasOwnProperty(n)&&cb.call(s,o[n],n,o)===!1)return 0;return 1},map:function(a,f){var o=[];return tinymce.each(a,function(v){o.push(f(v))}),o},grep:function(a,f){var o=[];return tinymce.each(a,function(v){f&&!f(v)||o.push(v)}),o},inArray:function(a,v){var i,l;if(a)for(i=0,l=a.length;i<l;i++)if(a[i]===v)return i;return-1},toArray:function(obj){var i,l,array=obj;if(!tinymce.isArray(obj))for(array=[],i=0,l=obj.length;i<l;i++)array[i]=obj[i];return array},extend:function(obj,ext){var i,l,name,value,args=arguments;for(i=1,l=args.length;i<l;i++){ext=args[i];for(name in ext)ext.hasOwnProperty(name)&&(value=ext[name],value!==undef&&(obj[name]=value))}return obj},trim:function(s){return(s?""+s:"").replace(whiteSpaceRe,"")},create:function(s,p,root){var sp,ns,cn,scn,c,self=this,de=0;if(s=/^((static) )?([\w.]+)(:([\w.]+))?/.exec(s),cn=s[3].match(/(^|\.)(\w+)$/i)[2],ns=self.createNS(s[3].replace(/\.\w+$/,""),root),!ns[cn]){if("static"==s[2])return ns[cn]=p,void(this.onCreate&&this.onCreate(s[2],s[3],ns[cn]));p[cn]||(p[cn]=function(){},de=1),ns[cn]=p[cn],self.extend(ns[cn].prototype,p),s[5]&&(sp=self.resolve(s[5]).prototype,scn=s[5].match(/\.(\w+)$/i)[1],c=ns[cn],de?ns[cn]=function(){return sp[scn].apply(this,arguments)}:ns[cn]=function(){return this._super=sp[scn],c.apply(this,arguments)},ns[cn].prototype[cn]=ns[cn],self.each(sp,function(f,n){ns[cn].prototype[n]=sp[n]}),self.each(p,function(f,n){sp[n]?ns[cn].prototype[n]=function(){return this._super=sp[n],f.apply(this,arguments)}:n!=cn&&(ns[cn].prototype[n]=f)})),self.each(p.static,function(f,n){ns[cn][n]=f})}},walk:function(o,f,n,s){s=s||this,o&&(n&&(o=o[n]),tinymce.each(o,function(o,i){return f.call(s,o,i,n)!==!1&&void tinymce.walk(o,f,n,s)}))},createNS:function(n,o){var i,v;for(o=o||win,n=n.split("."),i=0;i<n.length;i++)v=n[i],o[v]||(o[v]={}),o=o[v];return o},resolve:function(n,o){var i,l;for(o=o||win,n=n.split("."),i=0,l=n.length;i<l&&(o=o[n[i]]);i++);return o},addUnload:function(f,s){function fakeUnload(){function stop(){doc.detachEvent("onstop",stop),unload&&unload(),doc=0}var doc=document;"interactive"==doc.readyState&&(doc&&doc.attachEvent("onstop",stop),win.setTimeout(function(){doc&&doc.detachEvent("onstop",stop)},0))}var unload;return unload=function(){var o,n,li=self.unloads;if(li){for(n in li)o=li[n],o&&o.func&&o.func.call(o.scope,1);win.detachEvent?(win.detachEvent("onbeforeunload",fakeUnload),win.detachEvent("onunload",unload)):win.removeEventListener&&win.removeEventListener("unload",unload,!1),self.unloads=o=li=unload=0,win.CollectGarbage&&CollectGarbage()}},f={func:f,scope:s||this},self.unloads?self.unloads.push(f):(win.attachEvent?(win.attachEvent("onunload",unload),win.attachEvent("onbeforeunload",fakeUnload)):win.addEventListener&&win.addEventListener("unload",unload,!1),self.unloads=[f]),f},removeUnload:function(f){var u=this.unloads,r=null;return tinymce.each(u,function(o,i){if(o&&o.func==f)return u.splice(i,1),r=f,!1}),r},explode:function(s,d){return!s||tinymce.is(s,"array")?s:tinymce.map(s.split(d||","),tinymce.trim)},curry:function(fn){var args=slice.call(arguments);return args.length-1>=fn.length?fn.apply(this,args.slice(1)):function(){var tempArgs=args.concat([].slice.call(arguments));return tinymce.curry.apply(this,tempArgs)}},_addVer:function(u){var v;return this.query?(v=(u.indexOf("?")==-1?"?":"&")+this.query,u.indexOf("#")==-1?u+v:u.replace("#",v+"#")):u}};tinymce._init(),win.tinymce=win.tinyMCE=tinymce,tinymce.dom={},tinymce.geom={},tinymce.text={},tinymce.caret={},tinymce.html={},tinymce.ui={},tinymce.util={},tinymce.file={}}(window);var count=0,seed=function(){var rnd=function(){return Math.round(4294967295*Math.random()).toString(36)},now=(new Date).getTime();return"s"+now.toString(36)+rnd()+rnd()+rnd()},uuid=function(prefix){return prefix+count++ +seed()};tinymce.util.Uuid={uuid:uuid},function(tinymce){function requestAnimationFrame(callback,element){function featurefill(callback){window.setTimeout(callback,0)}var i,requestAnimationFrameFunc=window.requestAnimationFrame,vendors=["ms","moz","webkit"];for(i=0;i<vendors.length&&!requestAnimationFrameFunc;i++)requestAnimationFrameFunc=window[vendors[i]+"RequestAnimationFrame"];requestAnimationFrameFunc||(requestAnimationFrameFunc=featurefill),requestAnimationFrameFunc(callback,element)}function wrappedSetTimeout(callback,time){return"number"!=typeof time&&(time=0),setTimeout(callback,time)}function wrappedSetInterval(callback,time){return"number"!=typeof time&&(time=1),setInterval(callback,time)}function wrappedClearTimeout(id){return clearTimeout(id)}function wrappedClearInterval(id){return clearInterval(id)}function debounce(callback,time){var timer,func;return func=function(){var args=arguments;clearTimeout(timer),timer=wrappedSetTimeout(function(){callback.apply(this,args)},time)},func.stop=function(){clearTimeout(timer)},func}var requestAnimationFramePromise;tinymce.util.Delay={requestAnimationFrame:function(callback,element){return requestAnimationFramePromise?void requestAnimationFramePromise.then(callback):void(requestAnimationFramePromise=new Promise(function(resolve){element||(element=document.body),requestAnimationFrame(resolve,element)}).then(callback))},setTimeout:wrappedSetTimeout,setInterval:wrappedSetInterval,setEditorTimeout:function(editor,callback,time){return wrappedSetTimeout(function(){editor.removed||callback()},time)},setEditorInterval:function(editor,callback,time){var timer;return timer=wrappedSetInterval(function(){editor.removed?clearInterval(timer):callback()},time)},debounce:debounce,throttle:debounce,clearInterval:wrappedClearInterval,clearTimeout:wrappedClearTimeout}}(tinymce),tinymce.create("tinymce.util.Dispatcher",{scope:null,listeners:null,inDispatch:!1,Dispatcher:function(scope){this.scope=scope||this,this.listeners=[]},add:function(callback,scope){return this.listeners.push({cb:callback,scope:scope||this.scope}),callback},addToTop:function(callback,scope){var self=this,listener={cb:callback,scope:scope||self.scope};return self.inDispatch?self.listeners=[listener].concat(self.listeners):self.listeners.unshift(listener),callback},remove:function(callback){var listeners=this.listeners,output=null;return tinymce.each(listeners,function(listener,i){if(callback==listener.cb)return output=listener,listeners.splice(i,1),!1}),output},dispatch:function(){var returnValue,i,listener,self=this,args=arguments,listeners=self.listeners;for(self.inDispatch=!0,i=0;i<listeners.length&&(listener=listeners[i],returnValue=listener.cb.apply(listener.scope,args.length>0?args:[listener.scope]),returnValue!==!1);i++);return self.inDispatch=!1,returnValue}}),function(tinymce){var each=tinymce.each,trim=tinymce.trim,queryParts="source protocol authority userInfo user password host port relative path directory file query anchor".split(" "),DEFAULT_PORTS={ftp:21,http:80,https:443,mailto:25};tinymce.create("tinymce.util.URI",{URI:function(url,settings){var baseUri,base_url,self=this;if(url=trim(url),settings=self.settings=settings||{},baseUri=settings.base_uri,/^([\w\-]+):([^\/]{2})/i.test(url)||/^\s*#/.test(url))return void(self.source=url);var isProtocolRelative=0===url.indexOf("//");0!==url.indexOf("/")||isProtocolRelative||(url=(baseUri?baseUri.protocol||"http":"http")+"://mce_host"+url),/^[\w\-]*:?\/\//.test(url)||(base_url=settings.base_uri?settings.base_uri.path:new tinymce.util.URI(location.href).directory,""===settings.base_uri.protocol?url="//mce_host"+self.toAbsPath(base_url,url):(url=/([^#?]*)([#?]?.*)/.exec(url),url=(baseUri&&baseUri.protocol||"http")+"://mce_host"+self.toAbsPath(base_url,url[1])+url[2])),url=url.replace(/@@/g,"(mce_at)"),url=/^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@\/]*):?([^:@\/]*))?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/.exec(url),each(queryParts,function(v,i){var part=url[i];part&&(part=part.replace(/\(mce_at\)/g,"@@")),self[v]=part}),baseUri&&(self.protocol||(self.protocol=baseUri.protocol),self.userInfo||(self.userInfo=baseUri.userInfo),self.port||"mce_host"!==self.host||(self.port=baseUri.port),self.host&&"mce_host"!==self.host||(self.host=baseUri.host),self.source=""),isProtocolRelative&&(self.protocol="")},setPath:function(path){var self=this;path=/^(.*?)\/?(\w+)?$/.exec(path),self.path=path[0],self.directory=path[1],self.file=path[2],self.source="",self.getURI()},toRelative:function(uri){var output,self=this;if("./"===uri)return uri;if(uri=new tinymce.util.URI(uri,{base_uri:self}),"mce_host"!=uri.host&&self.host!=uri.host&&uri.host||self.port!=uri.port||self.protocol!=uri.protocol&&""!==uri.protocol)return uri.getURI();var tu=self.getURI(),uu=uri.getURI();return tu==uu||"/"==tu.charAt(tu.length-1)&&tu.substr(0,tu.length-1)==uu?tu:(output=self.toRelPath(self.path,uri.path),uri.query&&(output+="?"+uri.query),uri.anchor&&(output+="#"+uri.anchor),output)},toAbsolute:function(uri,noHost){return uri=new tinymce.util.URI(uri,{base_uri:this}),uri.getURI(noHost&&this.isSameOrigin(uri))},isSameOrigin:function(uri){if(this.host==uri.host&&this.protocol==uri.protocol){if(this.port==uri.port)return!0;var defaultPort=DEFAULT_PORTS[this.protocol];if(defaultPort&&(this.port||defaultPort)==(uri.port||defaultPort))return!0}return!1},toRelPath:function(base,path){var items,i,l,breakPoint=0,out="";if(base=base.substring(0,base.lastIndexOf("/")),base=base.split("/"),items=path.split("/"),base.length>=items.length)for(i=0,l=base.length;i<l;i++)if(i>=items.length||base[i]!=items[i]){breakPoint=i+1;break}if(base.length<items.length)for(i=0,l=items.length;i<l;i++)if(i>=base.length||base[i]!=items[i]){breakPoint=i+1;break}if(1===breakPoint)return path;for(i=0,l=base.length-(breakPoint-1);i<l;i++)out+="../";for(i=breakPoint-1,l=items.length;i<l;i++)out+=i!=breakPoint-1?"/"+items[i]:items[i];return out},toAbsPath:function(base,path){var i,tr,outPath,nb=0,o=[];for(tr=/\/$/.test(path)?"/":"",base=base.split("/"),path=path.split("/"),each(base,function(k){k&&o.push(k)}),base=o,i=path.length-1,o=[];i>=0;i--)0!==path[i].length&&"."!==path[i]&&(".."!==path[i]?nb>0?nb--:o.push(path[i]):nb++);return i=base.length-nb,outPath=i<=0?o.reverse().join("/"):base.slice(0,i).join("/")+"/"+o.reverse().join("/"),0!==outPath.indexOf("/")&&(outPath="/"+outPath),tr&&outPath.lastIndexOf("/")!==outPath.length-1&&(outPath+=tr),outPath},getURI:function(noProtoHost){var s,self=this;return self.source&&!noProtoHost||(s="",noProtoHost||(s+=self.protocol?self.protocol+"://":"//",self.userInfo&&(s+=self.userInfo+"@"),self.host&&(s+=self.host),self.port&&(s+=":"+self.port)),self.path&&(s+=self.path),self.query&&(s+="?"+self.query),self.anchor&&(s+="#"+self.anchor),self.source=s),self.source}}),tinymce.util.URI.parseDataUri=function(uri){var type,matches;return uri=decodeURIComponent(uri).split(","),matches=/data:([^;]+)/.exec(uri[0]),matches&&(type=matches[1]),{type:type,data:uri[1]}},tinymce.util.URI.getDocumentBaseUrl=function(loc){var baseUrl;return baseUrl=0!==loc.protocol.indexOf("http")&&"file:"!==loc.protocol?loc.href:loc.protocol+"//"+loc.host+loc.pathname,/^[^:]+:\/\/\/?[^\/]+\//.test(baseUrl)&&(baseUrl=baseUrl.replace(/[\?#].*$/,"").replace(/[\/\\][^\/]+$/,""),/[\/\\]$/.test(baseUrl)||(baseUrl+="/")),baseUrl}}(tinymce),function(tinymce){tinymce.create("static tinymce.util.Storage",{getHash:function(n){var h,v=this.get(n);if(v)try{h=JSON.parse(v)}catch(e){}return h},setHash:function(n,v){this.set(n,JSON.stringify(v))},get:function(n,s){if(!window.sessionStorage)return null;var val=sessionStorage.getItem(n);return tinymce.is(val)&&null!=val?"true"===val||"false"!==val&&("null"===val?null:val):s},set:function(n,v){window.sessionStorage&&sessionStorage.setItem(n,v)}}),tinymce.create("static tinymce.util.Cookie",{getHash:function(n){return tinymce.util.Storage.getHash(n)},setHash:function(n,v){return tinymce.util.Storage.setHash(n,v)},get:function(n,s){return tinymce.util.Storage.get(n,s)},set:function(n,v){return tinymce.util.Storage.set(n,v)}})}(tinymce),function(tinymce){tinymce.util.JSON={serialize:function(obj){try{return JSON.stringify(obj)}catch(ex){}},parse:function(str){try{return JSON.parse(str)}catch(ex){}}}}(tinymce),tinymce.create("static tinymce.util.JSONP",{callbacks:{},count:0,send:function(o){var self=this,dom=tinymce.DOM,count=void 0!==o.count?o.count:this.count,id="tinymce_jsonp_"+count;this.callbacks[count]=function(json){dom.remove(id),delete self.callbacks[count],o.callback(json)},dom.add(dom.doc.body,"script",{id:id,src:o.url,type:"text/javascript"}),this.count++}}),tinymce.create("static tinymce.util.XHR",{send:function(o){function ready(){!o.async||4==xhr.readyState||c++>1e4?(o.success&&c<1e4&&200==xhr.status?o.success.call(o.success_scope,""+xhr.responseText,xhr,o):o.error&&o.error.call(o.error_scope,c>1e4?"TIMED_OUT":"GENERAL",xhr,o),xhr=null):window.setTimeout(ready,10)}var xhr,c=0;if(o.scope=o.scope||this,o.success_scope=o.success_scope||o.scope,o.error_scope=o.error_scope||o.scope,o.async=o.async!==!1,o.data=o.data||"",xhr=new XMLHttpRequest){if(xhr.overrideMimeType&&xhr.overrideMimeType(o.content_type),xhr.open(o.type||(o.data?"POST":"GET"),o.url,o.async),o.content_type&&xhr.setRequestHeader("Content-Type",o.content_type),xhr.setRequestHeader("X-Requested-With","XMLHttpRequest"),xhr.send(o.data),!o.async)return ready();window.setTimeout(ready,10)}}}),function(tinymce){var extend=tinymce.extend,JSON=tinymce.util.JSON,XHR=tinymce.util.XHR;tinymce.create("tinymce.util.JSONRequest",{JSONRequest:function(s){this.settings=extend({},s),this.count=0},send:function(o){var ecb=o.error,scb=o.success;o=extend(this.settings,o),o.success=function(c,x){c=JSON.parse(c),"undefined"==typeof c&&(c={error:"JSON Parse error."}),c.error?ecb.call(o.error_scope||o.scope,c.error,x):scb.call(o.success_scope||o.scope,c.result)},o.error=function(ty,x){ecb&&ecb.call(o.error_scope||o.scope,ty,x)},o.data=JSON.serialize({id:o.id||"c"+this.count++,method:o.method,params:o.params}),o.content_type="application/json",XHR.send(o)},static:{sendRPC:function(o){return(new tinymce.util.JSONRequest).send(o)}}})}(tinymce),function(tinymce){tinymce.VK={BACKSPACE:8,DELETE:46,DOWN:40,ENTER:13,LEFT:37,RIGHT:39,SPACEBAR:32,TAB:9,UP:38,modifierPressed:function(e){return e.shiftKey||e.ctrlKey||e.altKey||this.metaKeyPressed(e)},metaKeyPressed:function(e){return tinymce.isMac?e.metaKey:e.ctrlKey&&!e.altKey}}}(tinymce),tinymce.util.Quirks=function(editor){function setEditorCommandState(cmd,state){try{editor.getDoc().execCommand(cmd,!1,state)}catch(ex){}}function isDefaultPrevented(e){return e.isDefaultPrevented()}function setMceInternalContent(e){var selectionHtml,internalContent;e.dataTransfer&&(editor.selection.isCollapsed()&&"IMG"==e.target.tagName&&selection.select(e.target),selectionHtml=editor.selection.getContent(),selectionHtml.length>0&&(internalContent=mceInternalUrlPrefix+escape(editor.id)+","+escape(selectionHtml),e.dataTransfer.setData(mceInternalDataType,internalContent)))}function getMceInternalContent(e){var internalContent;return e.dataTransfer&&(internalContent=e.dataTransfer.getData(mceInternalDataType),internalContent&&internalContent.indexOf(mceInternalUrlPrefix)>=0)?(internalContent=internalContent.substr(mceInternalUrlPrefix.length).split(","),{id:unescape(internalContent[0]),html:unescape(internalContent[1])}):null}function insertClipboardContents(content){editor.queryCommandSupported("mceInsertClipboardContent")?editor.execCommand("mceInsertClipboardContent",!1,{content:content}):editor.execCommand("mceInsertContent",!1,content)}function cleanupStylesWhenDeleting(){function isTrailingBr(node){var blockElements=dom.schema.getBlockElements(),rootNode=editor.getBody();if("BR"!=node.nodeName)return!1;for(;node!=rootNode&&!blockElements[node.nodeName];node=node.parentNode)if(node.nextSibling)return!1;return!0}function isSiblingsIgnoreWhiteSpace(node1,node2){var node;for(node=node1.nextSibling;node&&node!=node2;node=node.nextSibling)if((3!=node.nodeType||0!==tinymce.trim(node.data).length)&&node!==node2)return!1;return node===node2}function findCaretNode(node,forward,startNode){var walker,current,nonEmptyElements;if(dom.isChildOf(node,editor.getBody()))for(nonEmptyElements=dom.schema.getNonEmptyElements(),walker=new TreeWalker(startNode||node,node);current=walker[forward?"next":"prev"]();){if(nonEmptyElements[current.nodeName]&&!isTrailingBr(current))return current;if(3==current.nodeType&&current.data.length>0)return current}}function deleteRangeBetweenTextBlocks(rng){var startBlock,endBlock,caretNodeBefore,caretNodeAfter,textBlockElements;if(!rng.collapsed&&(startBlock=dom.getParent(RangeUtils.getNode(rng.startContainer,rng.startOffset),dom.isBlock),endBlock=dom.getParent(RangeUtils.getNode(rng.endContainer,rng.endOffset),dom.isBlock),textBlockElements=editor.schema.getTextBlockElements(),startBlock!=endBlock&&textBlockElements[startBlock.nodeName]&&textBlockElements[endBlock.nodeName]&&"false"!==dom.getContentEditable(startBlock)&&"false"!==dom.getContentEditable(endBlock))){if(rng.deleteContents(),caretNodeBefore=findCaretNode(startBlock,!1),caretNodeAfter=findCaretNode(endBlock,!0),caretNodeBefore&&caretNodeAfter){if(!dom.isEmpty(endBlock)){var nodes=tinymce.toArray(endBlock.childNodes);each(nodes,function(node){node&&node.nodeType&&startBlock.appendChild(node)})}dom.remove(endBlock)}return each([startBlock,endBlock],function(node){dom.isEmpty(node)&&dom.remove(node)}),caretNodeBefore?1==caretNodeBefore.nodeType?"BR"==caretNodeBefore.nodeName?(rng.setStartBefore(caretNodeBefore),rng.setEndBefore(caretNodeBefore)):(rng.setStartAfter(caretNodeBefore),rng.setEndAfter(caretNodeBefore)):(rng.setStart(caretNodeBefore,caretNodeBefore.data.length),rng.setEnd(caretNodeBefore,caretNodeBefore.data.length)):caretNodeAfter&&(1==caretNodeAfter.nodeType?(rng.setStartBefore(caretNodeAfter),rng.setEndBefore(caretNodeAfter)):(rng.setStart(caretNodeAfter,0),rng.setEnd(caretNodeAfter,0))),selection.setRng(rng),!0}}function expandBetweenBlocks(rng,isForward){var caretNode,targetCaretNode,textBlock,targetTextBlock,container,offset;if(!rng.collapsed)return rng;if(container=rng.startContainer,offset=rng.startOffset,3==container.nodeType)if(isForward){if(offset<container.data.length)return rng}else if(offset>0)return rng;caretNode=RangeUtils.getNode(container,offset),textBlock=dom.getParent(caretNode,dom.isBlock),targetCaretNode=findCaretNode(editor.getBody(),isForward,caretNode),targetTextBlock=dom.getParent(targetCaretNode,dom.isBlock);var isAfter=1===container.nodeType&&offset>container.childNodes.length-1;if(!caretNode||!targetCaretNode)return rng;if(targetTextBlock&&textBlock!=targetTextBlock)if(isForward){if(!isSiblingsIgnoreWhiteSpace(textBlock,targetTextBlock))return rng;1==caretNode.nodeType?"BR"==caretNode.nodeName?rng.setStartBefore(caretNode):rng.setStartAfter(caretNode):rng.setStart(caretNode,caretNode.data.length),1==targetCaretNode.nodeType?rng.setEnd(targetCaretNode,0):rng.setEndBefore(targetCaretNode)}else{if(!isSiblingsIgnoreWhiteSpace(targetTextBlock,textBlock))return rng;1==targetCaretNode.nodeType?"BR"==targetCaretNode.nodeName?rng.setStartBefore(targetCaretNode):rng.setStartAfter(targetCaretNode):rng.setStart(targetCaretNode,targetCaretNode.data.length),1==caretNode.nodeType&&isAfter?rng.setEndAfter(caretNode):rng.setEndBefore(caretNode)}return rng}function handleTextBlockMergeDelete(isForward){var rng=selection.getRng();if(rng=expandBetweenBlocks(rng,isForward),deleteRangeBetweenTextBlocks(rng))return!0}function handleLastBlockCharacterDelete(isForward,rng){function cloneTextBlockWithFormats(blockElm,node){return currentFormatNodes=dom.getParents(node,function(n){return!!editor.schema.getTextInlineElements()[n.nodeName]}),newBlockElm=blockElm.cloneNode(!1),currentFormatNodes=tinymce.map(currentFormatNodes,function(formatNode){return formatNode=formatNode.cloneNode(!1),newBlockElm.hasChildNodes()?(formatNode.appendChild(newBlockElm.firstChild),newBlockElm.appendChild(formatNode)):newBlockElm.appendChild(formatNode),newBlockElm.appendChild(formatNode),formatNode}),currentFormatNodes.length?(br=dom.create("br"),currentFormatNodes[0].appendChild(br),dom.replace(newBlockElm,blockElm),rng.setStartBefore(br),rng.setEndBefore(br),editor.selection.setRng(rng),br):null}function isTextBlock(node){return node&&editor.schema.getTextBlockElements()[node.tagName]}function NodePathCreate(rootNode,targetNode,normalized){for(var path=[];targetNode&&targetNode!=rootNode;targetNode=targetNode.parentNode)path.push(tinymce.DOM.nodeIndex(targetNode,normalized));return path}function NodePathResolve(rootNode,path){var i,node,children;for(node=rootNode,i=path.length-1;i>=0;i--){if(children=node.childNodes,path[i]>children.length-1)return null;node=children[path[i]]}return node}var path,blockElm,newBlockElm,clonedBlockElm,sibling,container,offset,br,currentFormatNodes;if(rng.collapsed&&(container=rng.startContainer,offset=rng.startOffset,blockElm=dom.getParent(container,dom.isBlock),isTextBlock(blockElm)))if(1==container.nodeType){if(container=container.childNodes[offset],container&&"BR"!=container.tagName)return;if(sibling=isForward?blockElm.nextSibling:blockElm.previousSibling,dom.isEmpty(blockElm)&&isTextBlock(sibling)&&dom.isEmpty(sibling)&&cloneTextBlockWithFormats(blockElm,container))return dom.remove(sibling),!0}else if(3==container.nodeType){if(path=NodePathCreate(blockElm,container),clonedBlockElm=blockElm.cloneNode(!0),container=NodePathResolve(clonedBlockElm,path),isForward){if(offset>=container.data.length)return;container.deleteData(offset,1)}else{if(offset<=0)return;container.deleteData(offset-1,1)}if(dom.isEmpty(clonedBlockElm))return cloneTextBlockWithFormats(blockElm,container)}}function customDelete(isForward){var mutationObserver,rng,caretElement;handleTextBlockMergeDelete(isForward)||(tinymce.each(editor.getBody().getElementsByTagName("*"),function(elm){"SPAN"==elm.tagName&&elm.setAttribute("mce-data-marked",1),!elm.hasAttribute("data-mce-style")&&elm.hasAttribute("style")&&editor.dom.setAttrib(elm,"style",editor.dom.getAttrib(elm,"style"))}),mutationObserver=new MutationObserver(function(){}),mutationObserver.observe(editor.getDoc(),{childList:!0,attributes:!0,subtree:!0,attributeFilter:["style"]}),editor.getDoc().execCommand(isForward?"ForwardDelete":"Delete",!1,null),rng=editor.selection.getRng(),caretElement=rng.startContainer.parentNode,tinymce.each(mutationObserver.takeRecords(),function(record){if(dom.isChildOf(record.target,editor.getBody())){if("style"==record.attributeName){var oldValue=record.target.getAttribute("data-mce-style");oldValue?record.target.setAttribute("style",oldValue):record.target.removeAttribute("style")}tinymce.each(record.addedNodes,function(node){if(1!==node.nodeType)return!0;if(node.getAttribute("style")&&!node.getAttribute("data-mce-style")&&node.removeAttribute("style"),"SPAN"==node.nodeName&&!node.getAttribute("mce-data-marked")){var offset,container;node==caretElement&&(offset=rng.startOffset,container=node.firstChild),dom.remove(node,!0),container&&(rng.setStart(container,offset),rng.setEnd(container,offset),editor.selection.setRng(rng))}})}}),mutationObserver.disconnect(),tinymce.each(editor.dom.select("span[mce-data-marked]"),function(span){span.removeAttribute("mce-data-marked")}))}function transactCustomDelete(isForward){customDelete(isForward),editor.undoManager.add()}var dragStartRng,doc=editor.getDoc(),dom=editor.dom,selection=editor.selection,MutationObserver=window.MutationObserver;editor.onKeyDown.add(function(editor,e){var isForward=e.keyCode==DELETE,isMetaOrCtrl=e.ctrlKey||e.metaKey;if(!isDefaultPrevented(e)&&(isForward||e.keyCode==BACKSPACE)){var rng=editor.selection.getRng(),container=rng.startContainer,offset=rng.startOffset;if(isForward&&e.shiftKey)return;if(handleLastBlockCharacterDelete(isForward,rng))return void e.preventDefault();if(!isMetaOrCtrl&&rng.collapsed&&3==container.nodeType&&(isForward?offset<container.data.length:offset>0))return;e.preventDefault(),isMetaOrCtrl&&editor.selection.getSel().modify("extend",isForward?"forward":"backward",e.metaKey?"lineboundary":"word"),customDelete(isForward)}}),editor.addCommand("Delete",function(){customDelete()}),editor.addCommand("ForwardDelete",function(){customDelete(!0)}),editor.dom.bind(editor.getBody(),"dragstart",function(e){dragStartRng=selection.getRng(),setMceInternalContent(e)}),editor.dom.bind(editor.getBody(),"drop",function(e){if(!isDefaultPrevented(e)){var internalContent=getMceInternalContent(e);internalContent&&(e.preventDefault(),setTimeout(function(){var pointRng=RangeUtils.getCaretRangeFromPoint(e.x,e.y,doc);dragStartRng&&(selection.setRng(dragStartRng),dragStartRng=null,transactCustomDelete()),selection.setRng(pointRng),insertClipboardContents(internalContent.html)},0))}})}function cleanupRuntimeStyles(){function removeRuntimeStyle(node){var style=node.attr("style");style&&(style=style.replace(/\s/g,""),"color:inherit;font-family:inherit;font-size:1rem;"===style&&node.unwrap())}editor.parser.addNodeFilter("span",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],removeRuntimeStyle(node)}),editor.serializer.addNodeFilter("span",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],removeRuntimeStyle(node)})}function emptyEditorWhenDeleting(){function serializeRng(rng){var body=dom.create("body"),contents=rng.cloneContents();return body.appendChild(contents),selection.serializer.serialize(body,{format:"html"})}function allContentsSelected(rng){if(!rng.setStart){if(rng.item)return!1;var bodyRng=rng.duplicate();return bodyRng.moveToElementText(editor.getBody()),RangeUtils.compareRanges(rng,bodyRng)}var selection=serializeRng(rng),allRng=dom.createRng();allRng.selectNode(editor.getBody());var allSelection=serializeRng(allRng);return selection===allSelection}editor.onKeyDown.add(function(editor,e){var isCollapsed,body,keyCode=e.keyCode;if(!isDefaultPrevented(e)&&(keyCode==DELETE||keyCode==BACKSPACE)){if(isCollapsed=editor.selection.isCollapsed(),body=editor.getBody(),isCollapsed&&!dom.isEmpty(body)){if(!tinymce.util.isFakeRoot(body.firstChild))return;if(tinymce.util.isFakeRoot(body.firstChild)&&!dom.isEmpty(body.firstChild))return}if(!isCollapsed&&!allContentsSelected(editor.selection.getRng()))return;e.preventDefault(),editor.setContent(""),body.firstChild&&dom.isBlock(body.firstChild)?editor.selection.setCursorLocation(body.firstChild,0):editor.selection.setCursorLocation(body,0),editor.nodeChanged()}})}function selectAll(){editor.onKeyDown.add(function(editor,e){!isDefaultPrevented(e)&&65==e.keyCode&&VK.metaKeyPressed(e)&&(e.preventDefault(),editor.execCommand("SelectAll"))})}function inputMethodFocus(){editor.settings.content_editable||dom.bind(editor.getDoc(),"mousedown mouseup",function(e){var rng;e.target==editor.getDoc().documentElement&&(rng=selection.getRng(),editor.getBody().focus(),"mousedown"==e.type?selection.placeCaretAt(e.clientX,e.clientY):selection.setRng(rng))})}function removeHrOnBackspace(){editor.onKeyDown.add(function(editor,e){if(!isDefaultPrevented(e)&&e.keyCode===BACKSPACE){if(!editor.getBody().getElementsByTagName("hr").length)return;if(selection.isCollapsed()&&0===selection.getRng(!0).startOffset){var node=selection.getNode(),previousSibling=node.previousSibling;
if("HR"==node.nodeName)return dom.remove(node),void e.preventDefault();previousSibling&&previousSibling.nodeName&&"hr"===previousSibling.nodeName.toLowerCase()&&(dom.remove(previousSibling),e.preventDefault())}}})}function removeStylesWhenDeletingAcrossBlockElements(){function getAttributeApplyFunction(){var template=dom.getAttribs(selection.getStart().cloneNode(!1));return function(){var target=selection.getStart();target!==editor.getBody()&&(dom.setAttrib(target,"style",null),each(template,function(attr){target.setAttributeNode(attr.cloneNode(!0))}))}}function isSelectionAcrossElements(){return!selection.isCollapsed()&&dom.getParent(selection.getStart(),dom.isBlock)!=dom.getParent(selection.getEnd(),dom.isBlock)}editor.onKeyPress.add(function(editor,e){var applyAttributes;if(!isDefaultPrevented(e)&&(8==e.keyCode||46==e.keyCode)&&isSelectionAcrossElements())return applyAttributes=getAttributeApplyFunction(),editor.getDoc().execCommand("delete",!1,null),applyAttributes(),e.preventDefault(),!1}),dom.bind(editor.getDoc(),"cut",function(e){var applyAttributes;!isDefaultPrevented(e)&&isSelectionAcrossElements()&&(applyAttributes=getAttributeApplyFunction(),setTimeout(function(){applyAttributes()},0))})}function disableBackspaceIntoATable(){editor.onKeyDown.add(function(editor,e){if(!isDefaultPrevented(e)&&e.keyCode===BACKSPACE&&selection.isCollapsed()&&0===selection.getRng(!0).startOffset){var previousSibling=selection.getNode().previousSibling;if(previousSibling&&previousSibling.nodeName&&"table"===previousSibling.nodeName.toLowerCase())return e.preventDefault(),!1}})}function removeBlockQuoteOnBackSpace(){editor.onKeyDown.add(function(editor,e){var rng,container,offset,root,parent;if(!isDefaultPrevented(e)&&e.keyCode==VK.BACKSPACE&&(rng=selection.getRng(),container=rng.startContainer,offset=rng.startOffset,root=dom.getRoot(),parent=container,rng.collapsed&&0===offset)){for(;parent&&parent.parentNode&&parent.parentNode.firstChild==parent&&parent.parentNode!=root;)parent=parent.parentNode;"BLOCKQUOTE"===parent.tagName&&(editor.formatter.toggle("blockquote",null,parent),rng=dom.createRng(),rng.setStart(container,0),rng.setEnd(container,0),selection.setRng(rng))}})}function setGeckoEditingOptions(){function setOpts(){setEditorCommandState("StyleWithCSS",!1),setEditorCommandState("enableInlineTableEditing",!1),settings.object_resizing||setEditorCommandState("enableObjectResizing",!1)}settings.readonly||(editor.onBeforeExecCommand.add(setOpts),editor.onMouseDown.add(setOpts))}function addBrAfterLastLinks(){function fixLinks(){each(dom.select("a"),function(node){var parentNode=node.parentNode,root=dom.getRoot();if(parentNode.lastChild===node){for(;parentNode&&!dom.isBlock(parentNode);){if(parentNode.parentNode.lastChild!==parentNode||parentNode===root)return;parentNode=parentNode.parentNode}dom.add(parentNode,"br",{"data-mce-bogus":1})}})}editor.onExecCommand.add(function(editor,cmd){"mceInsertLink"===cmd&&fixLinks()}),editor.onSetContent.add(selection.onSetContent.add(fixLinks))}function setDefaultBlockType(){settings.forced_root_block&&editor.onInit.add(function(){setEditorCommandState("DefaultParagraphSeparator",settings.forced_root_block)})}function showBrokenImageIcon(){editor.contentStyles.push("img:-moz-broken {-moz-force-broken-image-icon:1;min-width:24px;min-height:24px}")}function restoreFocusOnKeyDown(){editor.onKeyDown.add(function(){document.activeElement==document.body&&editor.getWin().focus()})}function bodyHeight(){editor.inline||(editor.contentStyles.push("body {min-height: 150px}"),editor.onClick.add(function(editor,e){var rng;if("HTML"==e.target.nodeName){if(tinymce.isIE12)return void editor.getBody().focus();rng=editor.selection.getRng(),editor.getBody().focus(),editor.selection.setRng(rng),editor.selection.normalize(),editor.nodeChanged()}}))}function blockCmdArrowNavigation(){tinymce.isMac&&editor.onKeyDown.add(function(editor,e){!VK.metaKeyPressed(e)||e.shiftKey||37!=e.keyCode&&39!=e.keyCode||(e.preventDefault(),editor.selection.getSel().modify("move",37==e.keyCode?"backward":"forward","lineboundary"))})}function disableAutoUrlDetect(){setEditorCommandState("AutoUrlDetect",!1)}function tapLinksAndImages(){editor.onClick.add(function(editor,e){var elm=e.target;do if("A"===elm.tagName)return void e.preventDefault();while(elm=elm.parentNode)}),editor.contentStyles.push(".mce-content-body {-webkit-touch-callout: none}")}function blockFormSubmitInsideEditor(){editor.onInit.add(function(){editor.dom.bind(editor.getBody(),"submit",function(e){e.preventDefault()})})}function removeAppleInterchangeBrs(){parser.addNodeFilter("br",function(nodes){for(var i=nodes.length;i--;)"Apple-interchange-newline"==nodes[i].attr("class")&&nodes[i].remove()})}function ieInternalDragAndDrop(){editor.dom.bind("dragstart",function(e){setMceInternalContent(e)}),editor.dom.bind("dragstart",function(e){if(!isDefaultPrevented(e)){var internalContent=getMceInternalContent(e);if(internalContent&&internalContent.id!=editor.id){e.preventDefault();var rng=RangeUtils.getCaretRangeFromPoint(e.x,e.y,editor.getDoc());selection.setRng(rng),insertClipboardContents(internalContent.html)}}})}function imageFloatLinkBug(){editor.onBeforeExecCommand.add(function(ed,cmd){if("mceInsertLink"==cmd){var se=ed.selection,n=se.getNode();n&&"IMG"==n.nodeName&&(ed.dom.setAttrib(n,"data-mce-style",n.style.cssText),n.style.cssText=null)}}),editor.onExecCommand.add(function(ed,cmd){if("mceInsertLink"==cmd){var se=ed.selection,n=se.getNode();tinymce.each(ed.dom.select("img[data-mce-style]",n),function(el){"A"!=el.parentNode.nodeName||el.style.cssText||(el.style.cssText=ed.dom.getAttrib(el,"data-mce-style"))})}})}function selectControlElements(){editor.onClick.add(function(editor,e){function selectElm(e){e.preventDefault(),selection.select(target),editor.nodeChanged()}var target=e.target;/^(IMG|HR)$/.test(target.nodeName)&&selectElm(e),"A"==target.nodeName&&dom.hasClass(target,"mce-item-anchor")&&selectElm(e)})}function normalizeSelection(){var normalize=function(e){65==e.keyCode&&VK.metaKeyPressed(e)||selection.normalize()};editor.onKeyUp.add(normalize),editor.onMouseUp.add(normalize)}function inlineBoundary(){function isBr(node){return node&&1==node.nodeType&&"BR"==node.nodeName}function isRootNode(node){return node==editor.getBody()||tinymce.util.isFakeRoot(node)}function isLastChild(node){var parent=node.parentNode;return!!isRootNode(parent)||node==parent.lastChild||!(!node.nextSibling||!isBr(node.nextSibling)||node.nextSibling!=parent.lastChild)}function isEmpty(node){return isBr(node)||node&&3==node.nodeType&&/^[ \t\r\n]*$/.test(node.nodeValue)}function isChildOf(container,node){return node.lastChild&&1==node.lastChild.nodeType&&(node=node.lastChild),dom.isChildOf(container,node)}function moveCursorToEnd(e){function moveToMarker(){rng=dom.createRng(),rng.setStart(marker,0),rng.setEnd(marker,0),rng.collapse(),selection.setRng(rng)}var rng=selection.getRng(),container=rng.startContainer,node=container.parentNode;if(node&&node!=editor.getBody()&&(node=dom.getParent(node,"a"),node&&(isLastChild(node)||isEmpty(node.nextSibling))&&3==container.nodeType&&isChildOf(container,node))){var text=container.data;text&&text.length&&rng.startOffset==text.length&&(marker=dom.create("span",{"data-mce-type":"caret"},"\ufeff"),dom.isBlock(node.parentNode)&&isLastChild(node)?(node.parentNode.appendChild(marker),moveToMarker(),dom.remove(marker)):(isBr(node.nextSibling)&&node.nextSibling==node.parentNode.lastChild&&(node=node.nextSibling),node.insertAdjacentElement("afterend",marker),moveToMarker()),e.preventDefault(),editor.nodeChanged())}}var marker;editor.onKeyDown.addToTop(function(editor,e){dom.remove(marker),e.keyCode==VK.RIGHT&&moveCursorToEnd(e)}),editor.onMouseDown.add(function(editor,e){dom.remove(marker),moveCursorToEnd(e)})}var VK=tinymce.VK,BACKSPACE=VK.BACKSPACE,DELETE=VK.DELETE,dom=editor.dom,selection=editor.selection,settings=editor.settings,parser=editor.parser,each=tinymce.each,RangeUtils=tinymce.dom.RangeUtils,TreeWalker=tinymce.dom.TreeWalker,mceInternalUrlPrefix="data:text/mce-internal,",mceInternalDataType=tinymce.isIE?"Text":"URL";normalizeSelection(),removeBlockQuoteOnBackSpace(),emptyEditorWhenDeleting(),inlineBoundary(),tinymce.isWebKit&&(cleanupStylesWhenDeleting(),inputMethodFocus(),setDefaultBlockType(),blockFormSubmitInsideEditor(),disableBackspaceIntoATable(),removeAppleInterchangeBrs(),imageFloatLinkBug(),selectControlElements(),cleanupRuntimeStyles(),tinymce.isIOS?(restoreFocusOnKeyDown(),bodyHeight(),tapLinksAndImages()):selectAll()),tinymce.isIE&&(bodyHeight(),selectAll(),disableAutoUrlDetect(),ieInternalDragAndDrop()),tinymce.isIE>=11&&disableBackspaceIntoATable(),tinymce.isGecko&&(removeHrOnBackspace(),removeStylesWhenDeletingAcrossBlockElements(),setGeckoEditingOptions(),addBrAfterLastLinks(),showBrokenImageIcon(),blockCmdArrowNavigation(),disableBackspaceIntoATable(),selectControlElements())},function(tinymce){function getRGBA(val){if(!rgba[val]){var values,match,r=0,b=0,g=0,a=1;val.indexOf("#")!==-1?(val=val.substr(1),3===val.length&&(val+=val),r=parseInt(val.substring(0,2),16),g=parseInt(val.substring(2,4),16),b=parseInt(val.substring(4,6),16),val.length>6&&(a=parseInt(val.substring(6,8),16),a=+(a/255).toFixed(2))):(val=val.replace(/\s/g,""),match=/^(?:rgb|rgba)\(([^\)]*)\)$/.exec(val),match&&(values=match[1].split(",").map(function(x){return parseFloat(x)})),values&&(r=values[0],g=values[1],b=values[2],4===values.length&&(a=values[3]||1))),rgba[val]={r:r,g:g,b:b,a:a}}return rgba[val]}function getLuminance(val){if(!luma[val]){var RsRGB,GsRGB,BsRGB,R,G,B,col=getRGBA(val);RsRGB=col.r/255,GsRGB=col.g/255,BsRGB=col.b/255,R=RsRGB<=.03928?RsRGB/12.92:Math.pow((RsRGB+.055)/1.055,2.4),G=GsRGB<=.03928?GsRGB/12.92:Math.pow((GsRGB+.055)/1.055,2.4),B=BsRGB<=.03928?BsRGB/12.92:Math.pow((BsRGB+.055)/1.055,2.4),luma[val]=.2126*R+.7152*G+.0722*B}return luma[val]}function isReadable(color1,color2){var l1=getLuminance(color1),l2=getLuminance(color2),lvl=(Math.max(l1,l2)+.05)/(Math.min(l1,l2)+.05);return lvl>=2}var previewElm,each=tinymce.each,extend=tinymce.extend,rgba={},luma={},white="rgb(255, 255, 255)",resetElm=function(){previewElm&&previewElm.parentNode&&(previewElm.parentNode.removeChild(previewElm),previewElm=null)},getCssText=function(ed,fmt,reset){function removeVars(val){return val&&"string"==typeof val&&(val=val.replace(/%(\w+)/g,"")),val}var name,dom=ed.dom,previewCss={};fmt=extend({styles:[],attributes:[],classes:""},fmt);var previewStyles=ed.settings.preview_styles;if(previewStyles===!1)return"";previewStyles||(previewStyles="font-family font-size font-weight text-decoration text-transform background-color color"),name=fmt.block||fmt.inline||"div",previewElm&&previewElm.nodeName==name.toUpperCase()||(previewElm=dom.create(name),ed.getBody().appendChild(previewElm)),dom.removeAllAttribs(previewElm),each(fmt.styles,function(value,name){value=removeVars(value),value&&dom.setStyle(previewElm,name,value)}),each(fmt.attributes,function(value,name){value=removeVars(value),value&&dom.setAttrib(previewElm,name,value)}),each(fmt.classes,function(value){value=removeVars(value),dom.addClass(previewElm,value)}),dom.setStyles(previewElm,{position:"absolute",left:-65535}),previewElm.setAttribute("data-mce-type","temp");for(var bodybg=dom.getStyle(ed.getBody(),"background-color",!0),elmbg=dom.getStyle(previewElm,"background-color",!0),styles=previewStyles.split(" "),css="",i=0,len=styles.length;i<len;i++){var key=styles[i],value=dom.getStyle(previewElm,key,!0);previewCss[key]||("color"==key&&(/transparent|rgba\s*\([^)]+,\s*0\)/.test(elmbg)&&(elmbg=white),isReadable(value,elmbg)||(value=value&&isReadable(value,bodybg)?bodybg:"inherit")),value||(value="inherit"),"font-size"==key&&0===parseInt(value,10)&&(value="inherit"),previewCss[key]=value,css+=key+":"+value+";")}return reset&&resetElm(),css};tinymce.util.PreviewCss={getCssText:getCssText,reset:resetElm}}(tinymce),function(tinymce){function toArray(obj){var i,l,array=obj;if(!isArray(obj))for(array=[],i=0,l=obj.length;i<l;i++)array[i]=obj[i];return array}function each(o,cb,s){var n,l;if(!o)return 0;if(s=s||o,void 0!==o.length){for(n=0,l=o.length;n<l;n++)if(cb.call(s,o[n],n,o)===!1)return 0}else for(n in o)if(o.hasOwnProperty(n)&&cb.call(s,o[n],n,o)===!1)return 0;return 1}function map(array,callback){var out=[];return each(array,function(item,index){out.push(callback(item,index,array))}),out}function filter(a,f){var o=[];return each(a,function(v,index){f&&!f(v,index,a)||o.push(v)}),o}function indexOf(a,v){var i,l;if(a)for(i=0,l=a.length;i<l;i++)if(a[i]===v)return i;return-1}function contains(a,v){return indexOf(a,v)>-1}function forall(xs,pred){for(var i=0,len=xs.length;i<len;++i){var x=xs[i];if(pred(x,i)!==!0)return!1}return!0}function reduce(collection,iteratee,accumulator,thisArg){var i=0;for(arguments.length<3&&(accumulator=collection[0]);i<collection.length;i++)accumulator=iteratee.call(thisArg,accumulator,collection[i],i);return accumulator}function findIndex(array,predicate,thisArg){var i,l;for(i=0,l=array.length;i<l;i++)if(predicate.call(thisArg,array[i],i,array))return i;return-1}function find(array,predicate,thisArg){var idx=findIndex(array,predicate,thisArg);if(idx!==-1)return array[idx]}function last(collection){return collection[collection.length-1]}function toObject(array,callback){var i,l,object={};for(i=0,l=array.length;i<l;i++){var x=array[i];object[x]=callback(x,i)}return object}function flat(arr){var i,l,out=[];for(i=0,l=arr.length;i<l;i++)isArray(arr[i])&&Array.prototype.push.apply(out,arr[i]);return out}function flatMap(array,callback){var output=map(array,callback);return flat(output)}var isArray=Array.isArray||function(obj){return"[object Array]"===Object.prototype.toString.call(obj)};tinymce.util.Arr={isArray:isArray,toArray:toArray,each:each,map:map,filter:filter,indexOf:indexOf,reduce:reduce,findIndex:findIndex,find:find,last:last,toObject:toObject,flat:flat,flatMap:flatMap,bind:flatMap,contains:contains,forall:forall}}(tinymce),function(tinymce){function constant(value){return function(){return value}}function negate(predicate){return function(x){return!predicate(x)}}function compose(f,g){return function(x){return f(g(x))}}function or(){var args=slice.call(arguments);return function(x){for(var i=0;i<args.length;i++)if(args[i](x))return!0;return!1}}function and(){var args=slice.call(arguments);return function(x){for(var i=0;i<args.length;i++)if(!args[i](x))return!1;return!0}}function noop(){}var slice=[].slice,curry=function(fn){var args=slice.call(arguments);return args.length-1>=fn.length?fn.apply(this,args.slice(1)):function(){var tempArgs=args.concat([].slice.call(arguments));return curry.apply(this,tempArgs)}};tinymce.util.Fun={constant:constant,negate:negate,and:and,or:or,curry:curry,compose:compose,noop:noop}}(tinymce);var Arr=tinymce.util.Arr,Fun=tinymce.util.Fun,Uuid=tinymce.util.Uuid,cache=[],constant=Fun.constant;tinymce.file.BlobCache={create:create,add:add,get:get,getByUri:getByUri,findFirst:findFirst,removeByUri:removeByUri,destroy:destroy},tinymce.file.Conversions={uriToBlob:uriToBlob,blobToDataUri:blobToDataUri,parseDataUri:parseDataUri},function(tinymce){function nativeDecode(text){var elm;return elm=document.createElement("div"),elm.innerHTML=text,elm.textContent||elm.innerText||text}function buildEntitiesLookup(items,radix){var i,chr,entity,lookup={};if(items){for(items=items.split(","),radix=radix||10,i=0;i<items.length;i+=2)chr=String.fromCharCode(parseInt(items[i],radix)),baseEntities[chr]||(entity="&"+items[i+1]+";",lookup[chr]=entity,lookup[entity]=chr);return lookup}}var namedEntities,baseEntities,reverseEntities,attrsCharsRegExp=/[&<>\"\u0060\u007E-\uD7FF\uE000-\uFFEF]|[\uD800-\uDBFF][\uDC00-\uDFFF]/g,textCharsRegExp=/[<>&\u007E-\uD7FF\uE000-\uFFEF]|[\uD800-\uDBFF][\uDC00-\uDFFF]/g,rawCharsRegExp=/[<>&\"\']/g,entityRegExp=/&#([a-z0-9]+);?|&([a-z0-9]+);/gi,asciiMap={128:"\u20ac",130:"\u201a",131:"\u0192",132:"\u201e",133:"\u2026",134:"\u2020",135:"\u2021",136:"\u02c6",137:"\u2030",138:"\u0160",139:"\u2039",140:"\u0152",142:"\u017d",145:"\u2018",146:"\u2019",147:"\u201c",148:"\u201d",149:"\u2022",150:"\u2013",151:"\u2014",152:"\u02dc",153:"\u2122",154:"\u0161",155:"\u203a",156:"\u0153",158:"\u017e",159:"\u0178"};baseEntities={'"':"&quot;","'":"&#39;","<":"&lt;",">":"&gt;","&":"&amp;","`":"&#96;"},reverseEntities={"&lt;":"<","&gt;":">","&amp;":"&","&quot;":'"',"&apos;":"'"},namedEntities=buildEntitiesLookup("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),tinymce.html=tinymce.html||{},tinymce.html.Entities={encodeRaw:function(text,attr){return text.replace(attr?attrsCharsRegExp:textCharsRegExp,function(chr){return baseEntities[chr]||chr})},encodeAllRaw:function(text){return(""+text).replace(rawCharsRegExp,function(chr){return baseEntities[chr]||chr})},encodeNumeric:function(text,attr){return text.replace(attr?attrsCharsRegExp:textCharsRegExp,function(chr){return chr.length>1?"&#"+(1024*(chr.charCodeAt(0)-55296)+(chr.charCodeAt(1)-56320)+65536)+";":baseEntities[chr]||"&#"+chr.charCodeAt(0)+";"})},encodeNamed:function(text,attr,entities){return entities=entities||namedEntities,text.replace(attr?attrsCharsRegExp:textCharsRegExp,function(chr){return baseEntities[chr]||entities[chr]||chr})},getEncodeFunc:function(name,entities){function encodeNamedAndNumeric(text,attr){return text.replace(attr?attrsCharsRegExp:textCharsRegExp,function(chr){return baseEntities[chr]||entities[chr]||"&#"+chr.charCodeAt(0)+";"||chr})}function encodeCustomNamed(text,attr){return Entities.encodeNamed(text,attr,entities)}var Entities=tinymce.html.Entities;return entities=buildEntitiesLookup(entities)||namedEntities,name=tinymce.makeMap(name.replace(/\+/g,",")),name.named&&name.numeric?encodeNamedAndNumeric:name.named?entities?encodeCustomNamed:Entities.encodeNamed:name.numeric?Entities.encodeNumeric:Entities.encodeRaw},decode:function(text){return text.replace(entityRegExp,function(all,numeric){return numeric?(numeric="x"===numeric.charAt(0).toLowerCase()?parseInt(numeric.substr(1),16):parseInt(numeric,10),numeric>65535?(numeric-=65536,String.fromCharCode(55296+(numeric>>10),56320+(1023&numeric))):asciiMap[numeric]||String.fromCharCode(numeric)):reverseEntities[all]||namedEntities[all]||nativeDecode(all)})}}}(tinymce),tinymce.html.Styles=function(settings,schema){function toHex(match,r,g,b){function hex(val){return val=parseInt(val,10).toString(16),val.length>1?val:"0"+val}return"#"+hex(r)+hex(g)+hex(b)}var undef,i,encodingItems,validStyles,invalidStyles,rgbRegExp=/rgb\s*\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*\)/gi,urlOrStrRegExp=/(?:url(?:(?:\(\s*\"([^\"]+)\"\s*\))|(?:\(\s*\'([^\']+)\'\s*\))|(?:\(\s*([^)\s]+)\s*\))))|(?:\'([^\']+)\')|(?:\"([^\"]+)\")/gi,styleRegExp=/\s*([^:]+):\s*([^;]+);?/g,trimRightRegExp=/\s+$/,encodingLookup={},invisibleChar="\ufeff";for(settings=settings||{},schema&&(validStyles=schema.getValidStyles(),invalidStyles=schema.getInvalidStyles()),encodingItems=("\\\" \\' \\; \\: ; : "+invisibleChar).split(" "),i=0;i<encodingItems.length;i++)encodingLookup[encodingItems[i]]=invisibleChar+i,encodingLookup[invisibleChar+i]=encodingItems[i];return{toHex:function(color){return color.replace(rgbRegExp,toHex)},parse:function(css){function compress(prefix,suffix,noJoin){var top,right,bottom,left;if(top=styles[prefix+"-top"+suffix],top&&(right=styles[prefix+"-right"+suffix],right&&(bottom=styles[prefix+"-bottom"+suffix],bottom&&(left=styles[prefix+"-left"+suffix])))){var box=[top,right,bottom,left];for(i=box.length-1;i--&&box[i]===box[i+1];);i>-1&&noJoin||(styles[prefix+suffix]=i==-1?box[0]:box.join(" "),delete styles[prefix+"-top"+suffix],delete styles[prefix+"-right"+suffix],delete styles[prefix+"-bottom"+suffix],delete styles[prefix+"-left"+suffix])}}function canCompress(key){var i,value=styles[key];if(value){for(value=value.split(" "),i=value.length;i--;)if(value[i]!==value[0])return!1;return styles[key]=value[0],!0}}function compress2(target,a,b,c){canCompress(a)&&canCompress(b)&&canCompress(c)&&(styles[target]=styles[a]+" "+styles[b]+" "+styles[c],delete styles[a],delete styles[b],delete styles[c])}function encode(str){return isEncoded=!0,encodingLookup[str]}function decode(str,keep_slashes){return isEncoded&&(str=str.replace(/\uFEFF[0-9]/g,function(str){return encodingLookup[str]})),keep_slashes||(str=str.replace(/\\([\'\";:])/g,"$1")),str}function processUrl(match,url,url2,url3,str,str2){if(str=str||str2)return str=decode(str),"'"+str.replace(/\'/g,"\\'")+"'";if(url=decode(url||url2||url3),!settings.allow_script_urls){var scriptUrl=url.replace(/[\s\r\n]+/,"");if(/(java|vb)script:/i.test(scriptUrl))return"";if(!settings.allow_svg_data_urls&&/^data:image\/svg/i.test(scriptUrl))return""}return urlConverter&&(url=urlConverter.call(urlConverterScope,url,"style")),"url('"+url.replace(/\'/g,"\\'")+"')"}var matches,name,value,isEncoded,styles={},urlConverter=settings.url_converter,urlConverterScope=settings.url_converter_scope||this;if(css){for(css=css.replace(/[\u0000-\u001F]/g,""),css=css.replace(/\\[\"\';:\uFEFF]/g,encode).replace(/\"[^\"]+\"|\'[^\']+\'/g,function(str){return str.replace(/[;:]/g,encode)});matches=styleRegExp.exec(css);){if(name=matches[1].replace(trimRightRegExp,"").toLowerCase(),value=matches[2].replace(trimRightRegExp,""),value=value.replace(/\\[0-9a-f]+/g,function(e){return String.fromCharCode(parseInt(e.substr(1),16))}),name&&value.length>0){if(!settings.allow_script_urls&&("behavior"==name||/expression\s*\(|\/\*|\*\//.test(value)))continue;"font-weight"===name&&"700"===value?value="bold":"color"!==name&&"background-color"!==name||(value=value.toLowerCase()),value=value.replace(rgbRegExp,toHex),value=value.replace(urlOrStrRegExp,processUrl),styles[name]=isEncoded?decode(value,!0):value}styleRegExp.lastIndex=matches.index+matches[0].length}compress("border","",!0),compress("border","-width"),compress("border","-color"),compress("border","-style"),compress("padding",""),compress("margin",""),compress2("border","border-width","border-style","border-color"),"medium none"===styles.border&&delete styles.border,"none"===styles["border-image"]&&delete styles["border-image"]}return styles},serialize:function(styles,elementName){function serializeStyles(name){var styleList,i,l,value;if(styleList=validStyles[name])for(i=0,l=styleList.length;i<l;i++)name=styleList[i],value=styles[name],value!==undef&&value.length>0&&(css+=(css.length>0?" ":"")+name+": "+value+";")}function isValid(name,elementName){var styleMap;return styleMap=invalidStyles["*"],!(styleMap&&styleMap[name]||(styleMap=invalidStyles[elementName],styleMap&&styleMap[name]))}var name,value,css="";if(elementName&&validStyles)serializeStyles("*"),serializeStyles(elementName);else for(name in styles)value=styles[name],value!==undef&&value.length>0&&(invalidStyles&&!isValid(name,elementName)||(css+=(css.length>0?" ":"")+name+": "+value+";"));return css}}},function(tinymce){function split(items,delim){return items?items.split(delim||" "):[]}function compileSchema(type){function add(name,attributes,children){function arrayToMap(array,obj){var i,l,map={};for(i=0,l=array.length;i<l;i++)map[array[i]]=obj||{};return map}var ni,i,attributesOrder,args=arguments;for(children=children||[],attributes=attributes||"","string"==typeof children&&(children=split(children)),i=3;i<args.length;i++)"string"==typeof args[i]&&(args[i]=split(args[i])),children.push.apply(children,args[i]);for(name=split(name),ni=name.length;ni--;)attributesOrder=[].concat(split(attributes),globalAttributes),schema[name[ni]]={attributes:arrayToMap(attributesOrder),attributesOrder:attributesOrder,children:arrayToMap(children,dummyObj)}}function addAttrs(name,attributes){var ni,schemaItem,i,l;for(name=split(name),ni=name.length,attributes=split(attributes);ni--;)for(schemaItem=schema[name[ni]],i=0,l=attributes.length;i<l;i++)schemaItem.attributes[attributes[i]]||(schemaItem.attributes[attributes[i]]={},schemaItem.attributesOrder.push(attributes[i]))}var globalAttributes,blockContent,phrasingContent,flowContent,html4BlockContent,html4PhrasingContent,eventAttributes,schema={};return mapCache[type]?mapCache[type]:(globalAttributes=split("id accesskey class dir lang style tabindex title"),eventAttributes=split("onclick ondblclick onmousedown onmouseup onmouseover onmousemove onmouseout onkeypress onkeydown onkeyup"),"html4"!=type&&eventAttributes.push.apply(eventAttributes,split("onabort onblur oncancel oncanplay oncanplaythrough onchange onclose oncontextmenu oncuechange ondrag ondragend ondragenter ondragleave ondragover ondragstart ondrop ondurationchange onemptied onended onerror onfocus oninput oninvalid onload onloadeddata onloadedmetadata onloadstart onmouseenter onmouseleave onmousewheel onpause onplay onplaying onprogress onratechange onreset onscroll onseeked onseeking onseeking onselect onshow onstalled onsubmit onsuspend ontimeupdate onvolumechange onwaiting onwheel")),globalAttributes.push.apply(globalAttributes,eventAttributes),globalAttributes.push.apply(globalAttributes,split("itemscope itemtype itemid itemprop itemref")),globalAttributes.push.apply(globalAttributes,split("role")),blockContent=split("address blockquote div dl fieldset form h1 h2 h3 h4 h5 h6 hr menu ol p pre table ul"),phrasingContent=split("a abbr b bdo br button cite code del dfn em embed i iframe img input ins kbd label map noscript object q s samp script select small span strong sub sup textarea u var link style #text #comment"),"html4"!=type&&(globalAttributes.push.apply(globalAttributes,split("contenteditable contextmenu draggable dropzone hidden spellcheck translate")),blockContent.push.apply(blockContent,split("article aside details dialog figure header footer hgroup section nav")),phrasingContent.push.apply(phrasingContent,split("audio canvas command datalist mark meter output picture progress time wbr video ruby bdi keygen"))),"html5-strict"!=type&&(globalAttributes.push("xml:lang"),html4PhrasingContent=split("acronym applet basefont big font strike tt"),phrasingContent.push.apply(phrasingContent,html4PhrasingContent),each(html4PhrasingContent,function(name){add(name,"",phrasingContent)}),html4BlockContent=split("center dir isindex noframes"),blockContent.push.apply(blockContent,html4BlockContent),flowContent=[].concat(blockContent,phrasingContent),each(html4BlockContent,function(name){add(name,"",flowContent)})),flowContent=flowContent||[].concat(blockContent,phrasingContent),add("html","manifest","head body"),add("head","","base command link meta noscript script style title"),add("title hr noscript br"),add("base","href target"),add("link","href rel media hreflang type sizes"),add("meta","name http-equiv content charset"),add("style","media type scoped"),add("script","src async defer type charset"),add("body","onafterprint onbeforeprint onbeforeunload onblur onerror onfocus onhashchange onload onmessage onoffline ononline onpagehide onpageshow onpopstate onresize onscroll onstorage onunload",flowContent),add("address dt dd div caption","",flowContent),add("h1 h2 h3 h4 h5 h6 pre p abbr code var samp kbd sub sup i b u bdo span legend em strong small s cite dfn","",phrasingContent),add("blockquote","cite",flowContent),add("ol","reversed start type","li"),add("ul","","li"),add("li","value",flowContent),add("dl","","dt dd"),add("a","href target rel media hreflang type",phrasingContent),add("q","cite",phrasingContent),add("ins del","cite datetime",flowContent),add("img","src sizes srcset alt usemap ismap width height"),add("iframe","src name width height",flowContent),add("embed","src type width height"),add("object","data type typemustmatch name usemap form width height",flowContent,"param"),add("param","name value"),add("map","name",flowContent,"area"),add("area","alt coords shape href target rel media hreflang type"),add("table","border","caption colgroup thead tfoot tbody tr"+("html4"==type?" col":"")),add("colgroup","span","col"),add("col","span"),add("tbody thead tfoot","","tr"),add("tr","","td th"),add("td","colspan rowspan headers",flowContent),add("th","colspan rowspan headers scope abbr",flowContent),add("form","accept-charset action autocomplete enctype method name novalidate target",flowContent),add("fieldset","disabled form name",flowContent,"legend"),add("label","form for",phrasingContent),add("input","accept alt autocomplete checked dirname disabled form formaction formenctype formmethod formnovalidate formtarget height list max maxlength min multiple name pattern readonly required size src step type value width"),add("button","disabled form formaction formenctype formmethod formnovalidate formtarget name type value","html4"==type?flowContent:phrasingContent),add("select","disabled form multiple name required size","option optgroup"),add("optgroup","disabled label","option"),add("option","disabled label selected value"),add("textarea","cols dirname disabled form maxlength name readonly required rows wrap"),add("menu","type label",flowContent,"li"),add("noscript","",flowContent),"html4"!=type&&(add("wbr"),add("ruby","",phrasingContent,"rt rp"),add("figcaption","",flowContent),add("mark rt rp summary bdi","",phrasingContent),add("canvas","width height",flowContent),add("video","src crossorigin poster preload autoplay mediagroup loop muted controls width height buffered controlslist playsinline",flowContent,"track source"),add("audio","src crossorigin preload autoplay mediagroup loop muted controls buffered volume controlslist",flowContent,"track source"),add("picture","","img source"),add("source","src srcset type media sizes"),add("track","kind src srclang label default"),add("datalist","",phrasingContent,"option"),add("article section nav aside header footer","",flowContent),add("hgroup","","h1 h2 h3 h4 h5 h6"),add("figure","",flowContent,"figcaption"),add("time","datetime",phrasingContent),
add("dialog","open",flowContent),add("command","type label icon disabled checked radiogroup command"),add("output","for form name",phrasingContent),add("progress","value max",phrasingContent),add("meter","value min max low high optimum",phrasingContent),add("details","open",flowContent,"summary"),add("keygen","autofocus challenge disabled form keytype name"),add("a","href target rel media hreflang type",flowContent)),addAttrs("form","onblur onchange onfocus onselect onsubmit"),"html5-strict"!=type&&(addAttrs("script","language xml:space"),addAttrs("style","xml:space"),addAttrs("object","declare classid code codebase codetype archive standby align border hspace vspace"),addAttrs("embed","align name hspace vspace"),addAttrs("param","valuetype type"),addAttrs("a","charset name rev shape coords"),addAttrs("br","clear"),addAttrs("applet","codebase archive code object alt name width height align hspace vspace"),addAttrs("img","name longdesc align border hspace vspace"),addAttrs("iframe","longdesc frameborder marginwidth marginheight scrolling align"),addAttrs("font basefont","size color face"),addAttrs("input","usemap align"),addAttrs("select","onchange"),addAttrs("textarea"),addAttrs("h1 h2 h3 h4 h5 h6 div p legend caption","align"),addAttrs("ul","type compact"),addAttrs("li","type"),addAttrs("ol dl menu dir","compact"),addAttrs("pre","width xml:space"),addAttrs("hr","align noshade size width"),addAttrs("isindex","prompt"),addAttrs("table","summary width frame rules cellspacing cellpadding align bgcolor"),addAttrs("col","width align char charoff valign"),addAttrs("colgroup","width align char charoff valign"),addAttrs("thead","align char charoff valign"),addAttrs("tr","align char charoff valign bgcolor"),addAttrs("th","axis align char charoff valign nowrap bgcolor width height"),addAttrs("form","accept"),addAttrs("td","abbr axis scope align char charoff valign nowrap bgcolor width height"),addAttrs("tfoot","align char charoff valign"),addAttrs("tbody","align char charoff valign"),addAttrs("area","nohref"),addAttrs("body","background bgcolor text link vlink alink"),addAttrs("form","onreset")),"html4"!=type&&(addAttrs("input button select textarea","autofocus"),addAttrs("input textarea","placeholder"),addAttrs("a","download"),addAttrs("link script img","crossorigin"),addAttrs("iframe","sandbox seamless allowfullscreen allow referrerpolicy loading"),addAttrs("img","loading decoding"),addAttrs("link","as disabled imagesizes imagesrcset title"),addAttrs("form","oncontextmenu onformchange onforminput oninput oninvalid"),addAttrs("video audio","onabort oncanplay oncanplaythrough ondurationchange onemptied onended onerror onloadeddata onloadedmetadata onloadstart onpause onplay onplaying onprogress onratechange onreadystatechange onseeked onseeking onstalled onsuspend ontimeupdate onvolumechange onwaiting")),each(split("a form meter progress dfn"),function(name){schema[name]&&delete schema[name].children[name]}),delete schema.caption.children.table,mapCache[type]=schema,schema)}function compileElementMap(value,mode){var styles;return value&&(styles={},"string"==typeof value&&(value={"*":value}),each(value,function(value,key){styles[key]=styles[key.toUpperCase()]="map"==mode?makeMap(value,/[, ]/):explode(value,/[, ]/)})),styles}var mapCache={},dummyObj={},makeMap=tinymce.makeMap,each=tinymce.each,extend=tinymce.extend,explode=tinymce.explode,inArray=tinymce.inArray;tinymce.html.Schema=function(settings){function createLookupTable(option,default_value,extendWith){var value=settings[option];return value?value=makeMap(value,/[, ]/,makeMap(value.toUpperCase(),/[, ]/)):(value=mapCache[option],value||(value=makeMap(default_value," ",makeMap(default_value.toUpperCase()," ")),value=extend(value,extendWith),mapCache[option]=value)),value}function patternToRegExp(str){return new RegExp("^"+str.replace(/([?+*])/g,".$1")+"$")}function addValidElements(validElements){var ei,el,ai,al,matches,element,attr,attrData,elementName,attrName,attrType,attributes,attributesOrder,prefix,outputName,globalAttributes,globalAttributesOrder,key,value,elementRuleRegExp=/^([#+\-])?([^\[!\/]+)(?:\/([^\[!]+))?(?:(!?)\[([^\]]+)\])?$/,attrRuleRegExp=/^([!\-])?(\w+::\w+|[^=:<]+)?(?:([=:<])(.*))?$/,hasPatternsRegExp=/[*?+]/;if(validElements)for(validElements=split(validElements,","),elements["@"]&&(globalAttributes=elements["@"].attributes,globalAttributesOrder=elements["@"].attributesOrder),ei=0,el=validElements.length;ei<el;ei++)if(matches=elementRuleRegExp.exec(validElements[ei])){if(prefix=matches[1],elementName=matches[2],outputName=matches[3],attrData=matches[5],attributes={},attributesOrder=[],element={attributes:attributes,attributesOrder:attributesOrder},"#"===prefix&&(element.paddEmpty=!0),"-"===prefix&&(element.removeEmpty=!0),"!"===matches[4]&&(element.removeEmptyAttrs=!0),globalAttributes){for(key in globalAttributes)attributes[key]=globalAttributes[key];attributesOrder.push.apply(attributesOrder,globalAttributesOrder)}if(attrData)for(attrData=split(attrData,"|"),ai=0,al=attrData.length;ai<al;ai++)if(matches=attrRuleRegExp.exec(attrData[ai])){if(attr={},attrType=matches[1],attrName=matches[2].replace(/::/g,":"),prefix=matches[3],value=matches[4],"!"===attrType&&(element.attributesRequired=element.attributesRequired||[],element.attributesRequired.push(attrName),attr.required=!0),"-"===attrType){delete attributes[attrName],attributesOrder.splice(inArray(attributesOrder,attrName),1);continue}prefix&&("="===prefix&&(element.attributesDefault=element.attributesDefault||[],element.attributesDefault.push({name:attrName,value:value}),attr.defaultValue=value),":"===prefix&&(element.attributesForced=element.attributesForced||[],element.attributesForced.push({name:attrName,value:value}),attr.forcedValue=value),"<"===prefix&&(attr.validValues=makeMap(value,"?"))),hasPatternsRegExp.test(attrName)?(element.attributePatterns=element.attributePatterns||[],attr.pattern=patternToRegExp(attrName),element.attributePatterns.push(attr)):(attributes[attrName]||attributesOrder.push(attrName),attributes[attrName]=attr)}globalAttributes||"@"!=elementName||(globalAttributes=attributes,globalAttributesOrder=attributesOrder),outputName&&(element.outputName=elementName,elements[outputName]=element),hasPatternsRegExp.test(elementName)?(element.pattern=patternToRegExp(elementName),patternElements.push(element)):elements[elementName]=element}}function setValidElements(validElements){elements={},patternElements=[],addValidElements(validElements),each(schemaItems,function(element,name){children[name]=element.children})}function addCustomElements(customElements){var customElementRegExp=/^(~)?(.+)$/;customElements&&(mapCache.text_block_elements=mapCache.block_elements=null,each(split(customElements,","),function(rule){var matches=customElementRegExp.exec(rule),inline="~"===matches[1],cloneName=inline?"span":"div",name=matches[2];if(children[name]=children[cloneName],customElementsMap[name]=cloneName,inline||(blockElementsMap[name.toUpperCase()]={},blockElementsMap[name]={}),!elements[name]){var customRule=elements[cloneName];customRule=extend({},customRule),delete customRule.removeEmptyAttrs,delete customRule.removeEmpty,elements[name]=customRule}each(children,function(element,elmName){element[cloneName]&&(children[elmName]=element=extend({},children[elmName]),element[name]=element[cloneName])})}))}function addValidChildren(validChildren){var childRuleRegExp=/^([+\-]?)(\w+)\[([^\]]+)\]$/;validChildren&&each(split(validChildren,","),function(rule){var parent,prefix,matches=childRuleRegExp.exec(rule);matches&&(prefix=matches[1],parent=prefix?children[matches[2]]:children[matches[2]]={"#comment":{}},parent=children[matches[2]],each(split(matches[3],"|"),function(child){"-"===prefix?(children[matches[2]]=parent=extend({},children[matches[2]]),delete parent[child]):parent[child]={}}))})}function getElementRule(name){var i,element=elements[name];if(element)return element;for(i=patternElements.length;i--;)if(element=patternElements[i],element.pattern.test(name))return element}var validStyles,invalidStyles,schemaItems,whiteSpaceElementsMap,selfClosingElementsMap,shortEndedElementsMap,boolAttrMap,validClasses,blockElementsMap,nonEmptyElementsMap,moveCaretBeforeOnEnterElementsMap,textBlockElementsMap,textInlineElementsMap,self=this,elements={},children={},patternElements=[],customElementsMap={},specialElements={};settings=settings||{},schemaItems=compileSchema(settings.schema),settings.verify_html===!1&&(settings.valid_elements="*[*]"),validStyles=compileElementMap(settings.valid_styles),invalidStyles=compileElementMap(settings.invalid_styles,"map"),validClasses=compileElementMap(settings.valid_classes,"map"),whiteSpaceElementsMap=createLookupTable("whitespace_elements","pre script noscript style textarea video audio iframe object"),selfClosingElementsMap=createLookupTable("self_closing_elements","colgroup dd dt li option p td tfoot th thead tr"),shortEndedElementsMap=createLookupTable("short_ended_elements","area base basefont br col frame hr img input isindex link meta param embed source wbr track"),boolAttrMap=createLookupTable("boolean_attributes","async checked compact declare defer disabled ismap multiple nohref noresize noshade nowrap readonly selected autoplay loop controls itemscope playsinline spellcheck contextmenu draggable hidden allowfullscreen muted"),nonEmptyElementsMap=createLookupTable("non_empty_elements","td th iframe video audio object script pre code",shortEndedElementsMap),moveCaretBeforeOnEnterElementsMap=createLookupTable("move_caret_before_on_enter_elements","table",nonEmptyElementsMap),textBlockElementsMap=createLookupTable("text_block_elements","h1 h2 h3 h4 h5 h6 p div address pre form blockquote center dir fieldset header footer article section hgroup aside nav figure"),blockElementsMap=createLookupTable("block_elements","hr table tbody thead tfoot th tr td li ol ul caption dl dt dd noscript menu isindex option datalist select optgroup",textBlockElementsMap),textInlineElementsMap=createLookupTable("text_inline_elements","span strong b em i font strike u var cite dfn code mark q sup sub samp"),each((settings.special||"script noscript iframe noframes noembed title style textarea xmp").split(" "),function(name){specialElements[name]=new RegExp("</"+name+"[^>]*>","gi")}),settings.valid_elements?setValidElements(settings.valid_elements):(each(schemaItems,function(element,name){elements[name]={attributes:element.attributes,attributesOrder:element.attributesOrder},children[name]=element.children}),"html4"===settings.schema&&each(split("strong/b em/i"),function(item){item=split(item,"/"),elements[item[1]].outputName=item[0]}),elements.img.attributesDefault=[{name:"alt",value:""}],each(split("ol ul sub sup blockquote font table tbody tr strong b"),function(name){elements[name]&&(elements[name].removeEmpty=!0)}),each(split("p h1 h2 h3 h4 h5 h6 th td pre div address caption"),function(name){elements[name].paddEmpty=!0}),settings.allow_empty_spans===!1&&each(split("span"),function(name){elements[name].removeEmptyAttrs=!0})),addCustomElements(settings.custom_elements),addValidChildren(settings.valid_children),addValidElements(settings.extended_valid_elements),addValidChildren("+ol[ul|ol],+ul[ul|ol]"),settings.invalid_elements&&each(explode(settings.invalid_elements),function(item){elements[item]&&delete elements[item]}),getElementRule("span")||addValidElements("span[*]"),self.children=children,self.getValidStyles=function(){return validStyles},self.getInvalidStyles=function(){return invalidStyles},self.getValidClasses=function(){return validClasses},self.getBoolAttrs=function(){return boolAttrMap},self.getBlockElements=function(){return blockElementsMap},self.getTextBlockElements=function(){return textBlockElementsMap},self.getTextInlineElements=function(){return textInlineElementsMap},self.getShortEndedElements=function(){return shortEndedElementsMap},self.getSelfClosingElements=function(){return selfClosingElementsMap},self.getNonEmptyElements=function(){return nonEmptyElementsMap},self.getMoveCaretBeforeOnEnterElements=function(){return moveCaretBeforeOnEnterElementsMap},self.getWhiteSpaceElements=function(){return whiteSpaceElementsMap},self.getSpecialElements=function(){return specialElements},self.isValidChild=function(name,child){var parent=children[name];return!(!parent||!parent[child])},self.isValid=function(name,attr){var attrPatterns,i,rule=getElementRule(name);if(rule){if(!attr)return!0;if(rule.attributes[attr])return!0;if(attrPatterns=rule.attributePatterns)for(i=attrPatterns.length;i--;)if(attrPatterns[i].pattern.test(name))return!0}return!1},self.getElementRule=getElementRule,self.getCustomElements=function(){return customElementsMap},self.addValidElements=addValidElements,self.setValidElements=setValidElements,self.addCustomElements=addCustomElements,self.addValidChildren=addValidChildren,self.elements=elements}}(tinymce),function(tinymce){var each=tinymce.each,Entities=tinymce.html.Entities;tinymce.html.SaxParser=function(settings,schema){function noop(){}var self=this;settings=settings||{},self.schema=schema=schema||new tinymce.html.Schema,settings.fix_self_closing!==!1&&(settings.fix_self_closing=!0),settings.allow_event_attributes!==!0&&(settings.allow_event_attributes=!1),settings.preserve_cdata!==!1&&(settings.preserve_cdata=!0),each("comment cdata text start end pi doctype".split(" "),function(name){name&&(self[name]=settings[name]||noop)}),self.findEndTag=function(schema,html,startIndex){var index,matches,tokenRegExp,shortEndedElements,count=1;for(shortEndedElements=schema.getShortEndedElements(),tokenRegExp=/<([!?\/])?([A-Za-z0-9\-_\:\.]+)((?:\s+[^"\'>]+(?:(?:"[^"]*")|(?:\'[^\']*\')|[^>]*))*|\/|\s+)>/g,tokenRegExp.lastIndex=index=startIndex;matches=tokenRegExp.exec(html);){if(index=tokenRegExp.lastIndex,"/"===matches[1])count--;else if(!matches[1]){if(matches[2]in shortEndedElements)continue;count++}if(0===count)break}return index},self.parse=function(html,format){function processEndTag(name){var pos,i;for(pos=stack.length;pos--&&stack[pos].name!==name;);if(pos>=0){for(i=stack.length-1;i>=pos;i--)name=stack[i],name.valid&&self.end(name.name);stack.length=pos}}function isInvalidUri(settings,uri){return!settings.allow_html_data_urls&&(/^data:image\//i.test(uri)?settings.allow_svg_data_urls===!1&&/^data:image\/svg\+xml/i.test(uri):/^data:/i.test(uri))}function isDataAttribute(name){return name.indexOf("-")>0}function isEventAttribute(name){return 0==name.indexOf("on")}function processComment(value){return""===value?value:(">"===value.charAt(0)&&(value=" "+value),settings.allow_conditional_comments||"[if"!==value.substr(0,3).toLowerCase()||(value=" "+value),value)}function processMalformedComment(value,startIndex){var startTag=value||"",isBogus=0!==startTag.indexOf("--"),endIndex=findCommentEndIndex(value,isBogus,startIndex);return value=value.substr(startIndex,endIndex-startIndex),value=processComment(isBogus?startTag+value:value),endIndex+1}function isConditionalComment(html,startIndex){return/^\s*\[if [\w\W]+\]>.*<!\[endif\](--!?)?>/.test(html.substr(startIndex))}function findCommentEndIndex(html,isBogus,startIndex){var lcHtml=html.toLowerCase();if(lcHtml.indexOf("[if ",startIndex)!==-1&&isConditionalComment(lcHtml,startIndex)){var endIfIndex=lcHtml.indexOf("[endif]",startIndex);return lcHtml.indexOf(">",endIfIndex)}if(isBogus){var endIndex=lcHtml.indexOf(">",startIndex);return endIndex!==-1?endIndex:lcHtml.length}var endCommentRegexp=/--!?>/;endCommentRegexp.lastIndex=startIndex;var match=endCommentRegexp.exec(html);return match?match.index+match[0].length:lcHtml.length}function trimComments(text){for(var sanitizedText=text;/<!--|--!?>/g.test(sanitizedText);)sanitizedText=sanitizedText.replace(/<!--|--!?>/g,"");return sanitizedText}function checkBogusAttribute(regExp,attrString){var matches=regExp.exec(attrString);if(matches){var name=matches[1],value=matches[2];return"string"==typeof name&&"data-mce-bogus"===name.toLowerCase()?value:null}return null}function parseAttribute(match,name,value,val2,val3){var attrRule,i,trimRegExp=/[\s\u0000-\u001F]+/g;if(name=name.toLowerCase(),value=name in fillAttrsMap?name:decode(value||val2||val3||""),validate&&!isInternalElement&&!isDataAttribute(name)){if(!settings.allow_event_attributes&&isEventAttribute(name))return;if(attrRule=validAttributesMap[name],!attrRule&&validAttributePatterns){for(i=validAttributePatterns.length;i--&&(attrRule=validAttributePatterns[i],!attrRule.pattern.test(name)););i===-1&&(attrRule=null)}if(!attrRule)return;if(attrRule.validValues&&!(value in attrRule.validValues))return}if(filteredUrlAttrs[name]&&!settings.allow_script_urls){var uri=value.replace(trimRegExp,"");try{uri=decodeURIComponent(uri)}catch(ex){uri=unescape(uri)}if(scriptUriRegExp.test(uri))return;if(isInvalidUri(settings,uri))return}attrList.map[name]=value,attrList.push({name:name,value:value})}var matches,value,endRegExp,attrList,i,text,name,isInternalElement,removeInternalElements,shortEndedElements,fillAttrsMap,isShortEnded,validate,elementRule,isValidElement,attr,attribsValue,validAttributesMap,validAttributePatterns,attributesRequired,attributesDefault,attributesForced,anyAttributesRequired,selfClosing,tokenRegExp,attrRegExp,specialElements,attrValue,fixSelfClosing,processHtml,self=this,index=0,stack=[],idCount=0,decode=Entities.decode,filteredUrlAttrs=tinymce.makeMap("src,href,data,background,formaction,poster,xlink:href"),scriptUriRegExp=/((java|vb)script|mhtml):/i;for(format=format||"html",tokenRegExp=new RegExp("<(?:(?:!--([\\w\\W]*?)--!?>)|(?:!\\[CDATA\\[([\\w\\W]*?)\\]\\]>)|(?:![Dd][Oo][Cc][Tt][Yy][Pp][Ee]([\\w\\W]*?)>)|(?:\\?([^\\s\\/<>]+) ?([\\w\\W]*?)[?/]>)|(?:\\/([A-Za-z][A-Za-z0-9\\-_\\:\\.]*)>)|(?:([A-Za-z][A-Za-z0-9\\-_\\:\\.]*)((?:\\s+[^\"'>]+(?:(?:\"[^\"]*\")|(?:'[^']*')|[^>]*))*|\\/|\\s+)>))","g"),attrRegExp=/([\w:\-]+)(?:\s*=\s*(?:(?:\"((?:[^\"])*)\")|(?:\'((?:[^\'])*)\')|([^>\s]+)))?/g,shortEndedElements=schema.getShortEndedElements(),selfClosing=settings.self_closing_elements||schema.getSelfClosingElements(),fillAttrsMap=schema.getBoolAttrs(),validate=settings.validate,removeInternalElements=settings.remove_internals,fixSelfClosing=settings.fix_self_closing,specialElements=schema.getSpecialElements(),processHtml=html+">";matches=tokenRegExp.exec(processHtml);){if(index<matches.index&&self.text(decode(html.substr(index,matches.index-index))),value=matches[6])value=value.toLowerCase(),":"===value.charAt(0)&&(value=value.substr(1)),processEndTag(value);else if(value=matches[7]){if(matches.index+matches[0].length>html.length){self.text(decode(html.substr(matches.index))),index=matches.index+matches[0].length;continue}value=value.toLowerCase(),":"===value.charAt(0)&&(value=value.substr(1)),isShortEnded=value in shortEndedElements,fixSelfClosing&&selfClosing[value]&&stack.length>0&&stack[stack.length-1].name===value&&processEndTag(value);var bogusValue=checkBogusAttribute(attrRegExp,matches[8]);if(null!==bogusValue){if("all"===bogusValue){index=self.findEndTag(schema,html,tokenRegExp.lastIndex),tokenRegExp.lastIndex=index;continue}isValidElement=!1}if(!validate||(elementRule=schema.getElementRule(value))){if(isValidElement=!0,validate&&(validAttributesMap=elementRule.attributes,validAttributePatterns=elementRule.attributePatterns),(attribsValue=matches[8])?(isInternalElement=attribsValue.indexOf("data-mce-type")!==-1,isInternalElement&&removeInternalElements&&(isValidElement=!1),attrList=[],attrList.map={},attribsValue.replace(attrRegExp,parseAttribute)):(attrList=[],attrList.map={}),validate&&!isInternalElement){if(attributesRequired=elementRule.attributesRequired,attributesDefault=elementRule.attributesDefault,attributesForced=elementRule.attributesForced,anyAttributesRequired=elementRule.removeEmptyAttrs,anyAttributesRequired&&!attrList.length&&(isValidElement=!1),attributesForced)for(i=attributesForced.length;i--;)attr=attributesForced[i],name=attr.name,attrValue=attr.value,"{$uid}"===attrValue&&(attrValue="mce_"+idCount++),attrList.map[name]=attrValue,attrList.push({name:name,value:attrValue});if(attributesDefault)for(i=attributesDefault.length;i--;)attr=attributesDefault[i],name=attr.name,name in attrList.map||(attrValue=attr.value,"{$uid}"===attrValue&&(attrValue="mce_"+idCount++),attrList.map[name]=attrValue,attrList.push({name:name,value:attrValue}));if(attributesRequired){for(i=attributesRequired.length;i--&&!(attributesRequired[i]in attrList.map););i===-1&&(isValidElement=!1)}if(attr=attrList.map["data-mce-bogus"]){if("all"===attr){index=self.findEndTag(schema,html,tokenRegExp.lastIndex),tokenRegExp.lastIndex=index;continue}isValidElement=!1}}isValidElement&&self.start(value,attrList,isShortEnded)}else isValidElement=!1;if(endRegExp=specialElements[value]){endRegExp.lastIndex=index=matches.index+matches[0].length,(matches=endRegExp.exec(html))?(isValidElement&&(text=html.substr(index,matches.index-index)),index=matches.index+matches[0].length):(text=html.substr(index),index=html.length),isValidElement&&(text.length>0&&self.text(text,!0),self.end(value)),tokenRegExp.lastIndex=index;continue}isShortEnded||(attribsValue&&attribsValue.indexOf("/")==attribsValue.length-1?isValidElement&&self.end(value):stack.push({name:value,valid:isValidElement}))}else if(value=matches[1])self.comment(trimComments(processComment(value)));else if(value=matches[2]){var isValidCdataSection="xml"===format||settings.preserve_cdata||stack.length>0&&schema.isValidChild(stack[stack.length-1].name,"#cdata");if(!isValidCdataSection){index=processMalformedComment("",matches.index+2),tokenRegExp.lastIndex=index;continue}self.cdata(trimComments(value))}else(value=matches[3])?self.doctype(value):(value=matches[4])&&self.pi(value,matches[5]);index=matches.index+matches[0].length}for(index<html.length&&self.text(decode(html.substr(index))),i=stack.length-1;i>=0;i--)value=stack[i],value.valid&&self.end(value.name)}}}(tinymce),function(tinymce){function walk(node,root_node,prev){var sibling,parent,startName=prev?"lastChild":"firstChild",siblingName=prev?"prev":"next";if(node[startName])return node[startName];if(node!==root_node){if(sibling=node[siblingName])return sibling;for(parent=node.parent;parent&&parent!==root_node;parent=parent.parent)if(sibling=parent[siblingName])return sibling}}function Node(name,type){this.name=name,this.type=type,1===type&&(this.attributes=[],this.attributes.map={})}var whiteSpaceRegExp=/^[ \t\r\n]*$/,typeLookup={"#text":3,"#comment":8,"#cdata":4,"#pi":7,"#doctype":10,"#document-fragment":11};tinymce.extend(Node.prototype,{replace:function(node){var self=this;return node.parent&&node.remove(),self.insert(node,self),self.remove(),self},attr:function(name,value){var attrs,i,undef,self=this;if("string"!=typeof name){for(i in name)self.attr(i,name[i]);return self}if(attrs=self.attributes){if(value!==undef){if(null===value){if(name in attrs.map)for(delete attrs.map[name],i=attrs.length;i--;)if(attrs[i].name===name)return attrs=attrs.splice(i,1),self;return self}if(name in attrs.map){for(value=""+value,i=attrs.length;i--;)if(attrs[i].name===name){attrs[i].value=value;break}}else attrs.push({name:name,value:value});return attrs.map[name]=value,self}return attrs.map[name]}},addClass:function(str){var self=this,cls=self.attr("class")||"";return str?str.indexOf(" ")===-1?self.hasClass(str)?cls:(cls=tinymce.trim(cls+" "+str),self.attr("class",cls),cls):void tinymce.each(str.split(" "),function(val){self.addClass(val)}):cls},hasClass:function(str){var cls=this.attr("class")||"";return(" "+cls+" ").indexOf(" "+str+" ")!==-1},removeClass:function(str){var self=this,cls=self.attr("class")||"";return str?str.indexOf(" ")===-1?(self.hasClass(str)&&(cls=tinymce.trim((" "+cls+" ").replace(" "+str+" "," ")),cls?self.attr("class",cls):self.attr("class",null)),cls):void tinymce.each(str.split(" "),function(val){self.removeClass(val)}):cls},clone:function(deep){var i,l,selfAttrs,selfAttr,cloneAttrs,node,next,self=this,clone=new Node(self.name,self.type);if(selfAttrs=self.attributes){for(cloneAttrs=[],cloneAttrs.map={},i=0,l=selfAttrs.length;i<l;i++)selfAttr=selfAttrs[i],"id"!==selfAttr.name&&(cloneAttrs[cloneAttrs.length]={name:selfAttr.name,value:selfAttr.value},cloneAttrs.map[selfAttr.name]=selfAttr.value);clone.attributes=cloneAttrs}if(clone.value=self.value,clone.shortEnded=self.shortEnded,deep)for(node=self.firstChild;node;)next=node.next,clone.append(node),node=next;return clone},wrap:function(wrapper){var self=this;return self.parent.insert(wrapper,self),wrapper.append(self),self},unwrap:function(){var node,next,self=this;for(node=self.firstChild;node;)next=node.next,self.insert(node,self,!0),node=next;self.remove()},remove:function(){var self=this,parent=self.parent,next=self.next,prev=self.prev;return parent&&(parent.firstChild===self?(parent.firstChild=next,next&&(next.prev=null)):prev.next=next,parent.lastChild===self?(parent.lastChild=prev,prev&&(prev.next=null)):next.prev=prev,self.parent=self.next=self.prev=null),self},append:function(node){var last,self=this;return node.parent&&node.remove(),last=self.lastChild,last?(last.next=node,node.prev=last,self.lastChild=node):self.lastChild=self.firstChild=node,node.parent=self,node},insert:function(node,ref_node,before){var parent;return node.parent&&node.remove(),parent=ref_node.parent||this,before?(ref_node===parent.firstChild?parent.firstChild=node:ref_node.prev.next=node,node.prev=ref_node.prev,node.next=ref_node,ref_node.prev=node):(ref_node===parent.lastChild?parent.lastChild=node:ref_node.next.prev=node,node.next=ref_node.next,node.prev=ref_node,ref_node.next=node),node.parent=parent,node},getAll:function(name){var node,self=this,collection=[];for(node=self.firstChild;node;node=walk(node,self))node.name===name&&collection.push(node);return collection},empty:function(){var nodes,i,node,self=this;if(self.firstChild){for(nodes=[],node=self.firstChild;node;node=walk(node,self))nodes.push(node);for(i=nodes.length;i--;)node=nodes[i],node.parent=node.firstChild=node.lastChild=node.next=node.prev=null}return self.firstChild=self.lastChild=null,self},isEmpty:function(elements){function isValidAttribute(name){return"name"==name||"id"==name||"class"==name||name.indexOf("-")!=-1&&("data-mce-bookmark"==name||name.indexOf("data-mce-")==-1)}var i,name,self=this,node=self.firstChild;if(node)do{if(1===node.type){if(node.attributes.map["data-mce-bogus"])continue;if(elements[node.name])return!1;for(i=node.attributes.length;i--;)if(name=node.attributes[i].name,isValidAttribute(name))return!1}if(8===node.type)return!1;if(3===node.type&&!whiteSpaceRegExp.test(node.value))return!1}while(node=walk(node,self));return!0},walk:function(prev){return walk(this,null,prev)}}),tinymce.extend(Node,{create:function(name,attrs){var node,attrName;if(node=new Node(name,typeLookup[name]||1),attrs){for(attrName in attrs)node.attr(attrName,attrs[attrName]);return node}}}),tinymce.html.Node=Node}(tinymce),function(tinymce){var Node=tinymce.html.Node,each=tinymce.each,explode=tinymce.explode,extend=tinymce.extend,makeMap=tinymce.makeMap;tinymce.html.DomParser=function(settings,schema){function fixInvalidChildren(nodes){var ni,node,parent,parents,newParent,currentNode,tempNode,childNode,i,nonEmptyElements,nonSplitableElements,textBlockElements,specialElements,sibling,nextNode;for(nonSplitableElements=makeMap("tr,td,th,tbody,thead,tfoot,table"),nonEmptyElements=schema.getNonEmptyElements(),textBlockElements=schema.getTextBlockElements(),specialElements=schema.getSpecialElements(),ni=0;ni<nodes.length;ni++)if(node=nodes[ni],node.parent&&!node.fixed)if(textBlockElements[node.name]&&"li"==node.parent.name){for(sibling=node.next;sibling&&textBlockElements[sibling.name];)sibling.name="li",sibling.fixed=!0,node.parent.insert(sibling,node.parent),sibling=sibling.next;node.unwrap(node)}else{for(parents=[node],parent=node.parent;parent&&!schema.isValidChild(parent.name,node.name)&&!nonSplitableElements[parent.name];parent=parent.parent)parents.push(parent);if(parent&&parents.length>1){for(parents.reverse(),newParent=currentNode=self.filterNode(parents[0].clone()),i=0;i<parents.length-1;i++){for(schema.isValidChild(currentNode.name,parents[i].name)?(tempNode=self.filterNode(parents[i].clone()),currentNode.append(tempNode)):tempNode=currentNode,childNode=parents[i].firstChild;childNode&&childNode!=parents[i+1];)nextNode=childNode.next,tempNode.append(childNode),childNode=nextNode;currentNode=tempNode}newParent.isEmpty(nonEmptyElements)?parent.insert(node,parents[0],!0):(parent.insert(newParent,parents[0],!0),parent.insert(node,newParent)),parent=parents[0],(parent.isEmpty(nonEmptyElements)||parent.firstChild===parent.lastChild&&"br"===parent.firstChild.name)&&parent.empty().remove()}else if(node.parent){if("li"===node.name){if(sibling=node.prev,sibling&&("ul"===sibling.name||"ul"===sibling.name)){sibling.append(node);continue}if(sibling=node.next,sibling&&("ul"===sibling.name||"ul"===sibling.name)){sibling.insert(node,sibling.firstChild,!0);continue}node.wrap(self.filterNode(new Node("ul",1)));continue}schema.isValidChild(node.parent.name,"div")&&schema.isValidChild("div",node.name)?node.wrap(self.filterNode(new Node("div",1))):specialElements[node.name]?node.empty().remove():node.unwrap()}}}var self=this,nodeFilters={},attributeFilters=[],matchedNodes={},matchedAttributes={};settings=settings||{},settings.validate=!("validate"in settings)||settings.validate,settings.root_name=settings.root_name||"body",self.schema=schema=schema||new tinymce.html.Schema,self.filterNode=function(node){var i,name,list;name in nodeFilters&&(list=matchedNodes[name],list?list.push(node):matchedNodes[name]=[node]),i=attributeFilters.length;for(;i--;)name=attributeFilters[i].name,name in node.attributes.map&&(list=matchedAttributes[name],list?list.push(node):matchedAttributes[name]=[node]);return node},self.addNodeFilter=function(name,callback){each(explode(name),function(name){var list=nodeFilters[name];list||(nodeFilters[name]=list=[]),list.push(callback)})},self.addAttributeFilter=function(name,callback){each(explode(name),function(name){var i;for(i=0;i<attributeFilters.length;i++)if(attributeFilters[i].name===name)return void attributeFilters[i].callbacks.push(callback);attributeFilters.push({name:name,callbacks:[callback]})})},self.parse=function(html,args){function addRootBlocks(){function trim(rootBlockNode){rootBlockNode&&(node=rootBlockNode.firstChild,node&&3==node.type&&(node.value=node.value.replace(startWhiteSpaceRegExp,"")),node=rootBlockNode.lastChild,node&&3==node.type&&(node.value=node.value.replace(endWhiteSpaceRegExp,"")))}var next,rootBlockNode,node=rootNode.firstChild;if(schema.isValidChild(rootNode.name,rootBlockName.toLowerCase())){for(;node;)next=node.next,3==node.type&&tinymce.trim(node.value)||1==node.type&&"p"!==node.name&&!blockElements[node.name]&&!node.attr("data-mce-type")?rootBlockNode?rootBlockNode.append(node):(rootBlockNode=createNode(rootBlockName,1),rootBlockNode.attr(settings.forced_root_block_attrs),rootNode.insert(rootBlockNode,node),rootBlockNode.append(node)):(trim(rootBlockNode),rootBlockNode=null),node=next;trim(rootBlockNode)}}function createNode(name,type){var list,node=new Node(name,type);return name in nodeFilters&&(list=matchedNodes[name],list?list.push(node):matchedNodes[name]=[node]),node}function removeWhitespaceBefore(node){var textNode,textNodeNext,textVal,sibling,blockElements=schema.getBlockElements();for(textNode=node.prev;textNode&&3===textNode.type;){if(textVal=textNode.value.replace(endWhiteSpaceRegExp,""),textVal.length>0)return void(textNode.value=textVal);if(textNodeNext=textNode.next){if(3==textNodeNext.type&&textNodeNext.value.length){textNode=textNode.prev;continue}if(!blockElements[textNodeNext.name]&&"script"!=textNodeNext.name&&"style"!=textNodeNext.name){textNode=textNode.prev;continue}}sibling=textNode.prev,textNode.remove(),textNode=sibling}}function cloneAndExcludeBlocks(input){var name,output={};for(name in input)"li"!==name&&"p"!=name&&(output[name]=input[name]);
return output}var parser,rootNode,node,nodes,i,l,fi,fl,list,name,validate,blockElements,startWhiteSpaceRegExp,isInWhiteSpacePreservedElement,endWhiteSpaceRegExp,allWhiteSpaceRegExp,isAllWhiteSpaceRegExp,whiteSpaceElements,children,nonEmptyElements,rootBlockName,invalidChildren=[];if(args=args||{},matchedNodes={},matchedAttributes={},blockElements=extend(makeMap("script,style,head,html,body,title,meta,param"),schema.getBlockElements()),nonEmptyElements=schema.getNonEmptyElements(),children=schema.children,validate=settings.validate,rootBlockName="forced_root_block"in args?args.forced_root_block:settings.forced_root_block,whiteSpaceElements=schema.getWhiteSpaceElements(),startWhiteSpaceRegExp=/^[ \t\r\n]+/,endWhiteSpaceRegExp=/[ \t\r\n]+$/,allWhiteSpaceRegExp=/[ \t\r\n]+/g,isAllWhiteSpaceRegExp=/^[ \t\r\n]+$/,parser=new tinymce.html.SaxParser({validate:validate,allow_script_urls:settings.allow_script_urls,allow_conditional_comments:settings.allow_conditional_comments,allow_event_attributes:settings.allow_event_attributes,self_closing_elements:cloneAndExcludeBlocks(schema.getSelfClosingElements()),cdata:function(text){node.append(createNode("#cdata",4)).value=text},text:function(text,raw){var textNode;isInWhiteSpacePreservedElement||(text=text.replace(allWhiteSpaceRegExp," "),node.lastChild&&blockElements[node.lastChild.name]&&(text=text.replace(startWhiteSpaceRegExp,""))),0!==text.length&&(textNode=createNode("#text",3),textNode.raw=!!raw,node.append(textNode).value=text)},comment:function(text){node.append(createNode("#comment",8)).value=text},pi:function(name,text){node.append(createNode(name,7)).value=text,removeWhitespaceBefore(node)},doctype:function(text){var newNode;newNode=node.append(createNode("#doctype",10)),newNode.value=text,removeWhitespaceBefore(node)},start:function(name,attrs,empty){var newNode,attrFiltersLen,elementRule,attrName,parent;if(elementRule=validate?schema.getElementRule(name):{}){for(newNode=createNode(elementRule.outputName||name,1),newNode.attributes=attrs,newNode.shortEnded=empty,node.append(newNode),parent=children[node.name],parent&&children[newNode.name]&&!parent[newNode.name]&&invalidChildren.push(newNode),attrFiltersLen=attributeFilters.length;attrFiltersLen--;)attrName=attributeFilters[attrFiltersLen].name,attrName in attrs.map&&(list=matchedAttributes[attrName],list?list.push(newNode):matchedAttributes[attrName]=[newNode]);blockElements[name]&&removeWhitespaceBefore(newNode),empty||(node=newNode),!isInWhiteSpacePreservedElement&&whiteSpaceElements[name]&&(isInWhiteSpacePreservedElement=!0)}},end:function(name){var textNode,elementRule,text,sibling,tempNode;if(elementRule=validate?schema.getElementRule(name):{}){if(blockElements[name]&&!isInWhiteSpacePreservedElement){if(textNode=node.firstChild,textNode&&3===textNode.type)if(text=textNode.value.replace(startWhiteSpaceRegExp,""),text.length>0)textNode.value=text,textNode=textNode.next;else for(sibling=textNode.next,textNode.remove(),textNode=sibling;textNode&&3===textNode.type;)text=textNode.value,sibling=textNode.next,(0===text.length||isAllWhiteSpaceRegExp.test(text))&&(textNode.remove(),textNode=sibling),textNode=sibling;if(textNode=node.lastChild,textNode&&3===textNode.type)if(text=textNode.value.replace(endWhiteSpaceRegExp,""),text.length>0)textNode.value=text,textNode=textNode.prev;else for(sibling=textNode.prev,textNode.remove(),textNode=sibling;textNode&&3===textNode.type;)text=textNode.value,sibling=textNode.prev,(0===text.length||isAllWhiteSpaceRegExp.test(text))&&(textNode.remove(),textNode=sibling),textNode=sibling}if(isInWhiteSpacePreservedElement&&whiteSpaceElements[name]&&(isInWhiteSpacePreservedElement=!1),(elementRule.removeEmpty||elementRule.paddEmpty)&&node.isEmpty(nonEmptyElements))if(elementRule.paddEmpty)node.empty().append(new Node("#text","3")).value="\xa0";else if(!node.attributes.map.name&&!node.attributes.map.id)return tempNode=node.parent,blockElements[node.name]?node.empty().remove():node.unwrap(),void(node=tempNode);node=node.parent}}},schema),rootNode=node=new Node(args.context||settings.root_name,11),parser.parse(html),validate&&invalidChildren.length&&(args.context?args.invalid=!0:fixInvalidChildren(invalidChildren)),rootBlockName&&("body"==rootNode.name||args.isRootContent)&&addRootBlocks(),!args.invalid){for(name in matchedNodes){for(list=nodeFilters[name],nodes=matchedNodes[name],fi=nodes.length;fi--;)nodes[fi].parent||nodes.splice(fi,1);for(i=0,l=list.length;i<l;i++)list[i](nodes,name,args)}for(i=0,l=attributeFilters.length;i<l;i++)if(list=attributeFilters[i],list.name in matchedAttributes){for(nodes=matchedAttributes[list.name],fi=nodes.length;fi--;)nodes[fi].parent||nodes.splice(fi,1);for(fi=0,fl=list.callbacks.length;fi<fl;fi++)list.callbacks[fi](nodes,list.name,args)}}return rootNode},settings.remove_trailing_brs&&self.addNodeFilter("br",function(nodes){var i,node,parent,lastParent,prev,prevName,textNode,elementRule,l=nodes.length,blockElements=extend({},schema.getBlockElements()),nonEmptyElements=schema.getNonEmptyElements();for(blockElements.body=1,i=0;i<l;i++)if(node=nodes[i],parent=node.parent,blockElements[node.parent.name]&&node===parent.lastChild){for(prev=node.prev;prev;){if(prevName=prev.name,"span"!==prevName||"bookmark"!==prev.attr("data-mce-type")){if("br"!==prevName)break;if("br"===prevName){node=null;break}}prev=prev.prev}if(node){if(node.attributes.length&&"data-mce-bogus"!==node.attributes[0].name)continue;node.remove(),parent.isEmpty(nonEmptyElements)&&(elementRule=schema.getElementRule(parent.name),elementRule&&(elementRule.removeEmpty?parent.remove():elementRule.paddEmpty&&(parent.empty().append(new Node("#text",3)).value="\xa0")))}}else{for(lastParent=node;parent&&parent.firstChild===lastParent&&parent.lastChild===lastParent&&(lastParent=parent,!blockElements[parent.name]);)parent=parent.parent;lastParent===parent&&(textNode=new Node("#text",3),textNode.value="\xa0",node.replace(textNode))}}),self.addAttributeFilter("href",function(nodes){var node,i=nodes.length,appendRel=function(rel){var parts=rel.split(" ").filter(function(p){return p.length>0});return parts.concat(["noopener"]).sort().join(" ")},addNoOpener=function(rel){var newRel=rel?tinymce.trim(rel):"";return/\b(noopener)\b/g.test(newRel)?newRel:appendRel(newRel)};if(!settings.allow_unsafe_link_target)for(;i--;)node=nodes[i],"a"===node.name&&"_blank"===node.attr("target")&&/:\/\//.test(node.attr("href"))&&node.attr("rel",addNoOpener(node.attr("rel")))}),settings.allow_html_in_named_anchor||self.addAttributeFilter("id,name",function(nodes){for(var sibling,prevSibling,parent,node,i=nodes.length;i--;)if(node=nodes[i],"a"===node.name&&node.firstChild&&!node.attr("href")){parent=node.parent,sibling=node.lastChild;do prevSibling=sibling.prev,parent.insert(sibling,node),sibling=prevSibling;while(sibling)}}),settings.validate&&schema.getValidClasses()&&self.addAttributeFilter("class",function(nodes){for(var node,classList,ci,className,classValue,validClassesMap,valid,i=nodes.length,validClasses=schema.getValidClasses();i--;){for(node=nodes[i],classList=node.attr("class").split(" "),classValue="",ci=0;ci<classList.length;ci++)className=classList[ci],valid=!1,validClassesMap=validClasses["*"],validClassesMap&&validClassesMap[className]&&(valid=!0),validClassesMap=validClasses[node.name],!valid&&validClassesMap&&validClassesMap[className]&&(valid=!0),valid&&(classValue&&(classValue+=" "),classValue+=className);classValue.length||(classValue=null),node.attr("class",classValue)}})}}(tinymce),function(tinymce){tinymce.html.Serializer=function(settings,schema){var self=this,writer=new tinymce.html.Writer(settings,schema);settings=settings||{},settings.validate=!("validate"in settings)||settings.validate,self.schema=schema=schema||new tinymce.html.Schema,self.writer=writer,self.serialize=function(node){function walk(node){var name,isEmpty,attrs,attrName,attrValue,sortedAttrs,i,l,elementRule,handler=handlers[node.type];if(handler)handler(node);else{if(name=node.name,isEmpty=node.shortEnded,attrs=node.attributes,validate&&attrs&&attrs.length>1){if(sortedAttrs=[],sortedAttrs.map={},elementRule=schema.getElementRule(node.name),!elementRule)return;for(i=0,l=elementRule.attributesOrder.length;i<l;i++)attrName=elementRule.attributesOrder[i],attrName in attrs.map&&(attrValue=attrs.map[attrName],sortedAttrs.map[attrName]=attrValue,sortedAttrs.push({name:attrName,value:attrValue}));for(i=0,l=attrs.length;i<l;i++)attrName=attrs[i].name,attrName in sortedAttrs.map||(attrValue=attrs.map[attrName],sortedAttrs.map[attrName]=attrValue,sortedAttrs.push({name:attrName,value:attrValue}));attrs=sortedAttrs}if(writer.start(node.name,attrs,isEmpty),!isEmpty){if(node=node.firstChild)do walk(node);while(node=node.next);writer.end(name)}}}var handlers,validate;return validate=settings.validate,handlers={3:function(node){writer.text(node.value,node.raw)},8:function(node){writer.comment(node.value)},7:function(node){writer.pi(node.name,node.value)},10:function(node){writer.doctype(node.value)},4:function(node){writer.cdata(node.value)},11:function(node){if(node=node.firstChild)do walk(node);while(node=node.next)}},writer.reset(),1!=node.type||settings.inner?handlers[11](node):walk(node),writer.getContent()}}}(tinymce),tinymce.html.Writer=function(settings,schema){var indent,indentBefore,indentAfter,encode,htmlOutput,html=[],makeMap=tinymce.makeMap,Entities=tinymce.html.Entities;return settings=settings||{},indent=settings.indent,indentBefore=makeMap(settings.indent_before||""),indentAfter=makeMap(settings.indent_after||""),encode=Entities.getEncodeFunc(settings.entity_encoding||"raw",settings.entities),htmlOutput="html"==settings.element_format,{start:function(name,attrs,empty){var i,l,attr,value;if(indent&&indentBefore[name]&&html.length>0&&(value=html[html.length-1],value.length>0&&"\n"!==value&&html.push("\n")),html.push("<",name),attrs)for(i=0,l=attrs.length;i<l;i++)attr=attrs[i],attr.boolean?html.push(" ",attr.name):html.push(" ",attr.name,'="',encode(""+attr.value,!0),'"');!empty||htmlOutput?html[html.length]=">":"html5-strict"==settings.schema?html[html.length]=">":html[html.length]=" />",empty&&indent&&indentAfter[name]&&html.length>0&&(value=html[html.length-1],value.length>0&&"\n"!==value&&html.push("\n"))},end:function(name){var value;html.push("</",name,">"),indent&&indentAfter[name]&&html.length>0&&(value=html[html.length-1],value.length>0&&"\n"!==value&&html.push("\n"))},text:function(text,raw){text.length>0&&(html[html.length]=raw?text:encode(text))},cdata:function(text){html.push("<![CDATA[",text,"]]>")},comment:function(text){html.push("<!--",text,"-->")},pi:function(name,text){text?html.push("<?",name," ",encode(text),"?>"):html.push("<?",name,"?>"),indent&&html.push("\n")},doctype:function(text){html.push("<!DOCTYPE",text,">",indent?"\n":"")},reset:function(){html.length=0},getContent:function(){return html.join("").replace(/\n$/,"")}}},function(tinymce){var round=Math.round,clone=function(rect){return rect?{left:round(rect.left),top:round(rect.top),bottom:round(rect.bottom),right:round(rect.right),width:round(rect.width),height:round(rect.height)}:{left:0,top:0,bottom:0,right:0,width:0,height:0}},collapse=function(clientRect,toStart){return clientRect=clone(clientRect),toStart?clientRect.right=clientRect.left:(clientRect.left=clientRect.left+clientRect.width,clientRect.right=clientRect.left),clientRect.width=0,clientRect},isEqual=function(rect1,rect2){return rect1.left===rect2.left&&rect1.top===rect2.top&&rect1.bottom===rect2.bottom&&rect1.right===rect2.right},isValidOverflow=function(overflowY,clientRect1,clientRect2){return overflowY>=0&&overflowY<=Math.min(clientRect1.height,clientRect2.height)/2},isAbove=function(clientRect1,clientRect2){return clientRect1.bottom-clientRect1.height/2<clientRect2.top||!(clientRect1.top>clientRect2.bottom)&&isValidOverflow(clientRect2.top-clientRect1.bottom,clientRect1,clientRect2)},isBelow=function(clientRect1,clientRect2){return clientRect1.top>clientRect2.bottom||!(clientRect1.bottom<clientRect2.top)&&isValidOverflow(clientRect2.bottom-clientRect1.top,clientRect1,clientRect2)},isLeft=function(clientRect1,clientRect2){return clientRect1.left<clientRect2.left},isRight=function(clientRect1,clientRect2){return clientRect1.right>clientRect2.right},compare=function(clientRect1,clientRect2){return isAbove(clientRect1,clientRect2)?-1:isBelow(clientRect1,clientRect2)?1:isLeft(clientRect1,clientRect2)?-1:isRight(clientRect1,clientRect2)?1:0},containsXY=function(clientRect,clientX,clientY){return clientX>=clientRect.left&&clientX<=clientRect.right&&clientY>=clientRect.top&&clientY<=clientRect.bottom};tinymce.geom.ClientRect={clone:clone,collapse:collapse,isEqual:isEqual,isAbove:isAbove,isBelow:isBelow,isLeft:isLeft,isRight:isRight,compare:compare,containsXY:containsXY}}(tinymce),function(tinymce){var min=Math.min,max=Math.max,round=Math.round,relativePosition=function(rect,targetRect,rel){var x,y,w,h,targetW,targetH;return x=targetRect.x,y=targetRect.y,w=rect.w,h=rect.h,targetW=targetRect.w,targetH=targetRect.h,rel=(rel||"").split(""),"b"===rel[0]&&(y+=targetH),"r"===rel[1]&&(x+=targetW),"c"===rel[0]&&(y+=round(targetH/2)),"c"===rel[1]&&(x+=round(targetW/2)),"b"===rel[3]&&(y-=h),"r"===rel[4]&&(x-=w),"c"===rel[3]&&(y-=round(h/2)),"c"===rel[4]&&(x-=round(w/2)),create(x,y,w,h)},findBestRelativePosition=function(rect,targetRect,constrainRect,rels){var pos,i;for(i=0;i<rels.length;i++)if(pos=relativePosition(rect,targetRect,rels[i]),pos.x>=constrainRect.x&&pos.x+pos.w<=constrainRect.w+constrainRect.x&&pos.y>=constrainRect.y&&pos.y+pos.h<=constrainRect.h+constrainRect.y)return rels[i];return null},inflate=function(rect,w,h){return create(rect.x-w,rect.y-h,rect.w+2*w,rect.h+2*h)},intersect=function(rect,cropRect){var x1,y1,x2,y2;return x1=max(rect.x,cropRect.x),y1=max(rect.y,cropRect.y),x2=min(rect.x+rect.w,cropRect.x+cropRect.w),y2=min(rect.y+rect.h,cropRect.y+cropRect.h),x2-x1<0||y2-y1<0?null:create(x1,y1,x2-x1,y2-y1)},clamp=function(rect,clampRect,fixedSize){var underflowX1,underflowY1,overflowX2,overflowY2,x1,y1,x2,y2,cx2,cy2;return x1=rect.x,y1=rect.y,x2=rect.x+rect.w,y2=rect.y+rect.h,cx2=clampRect.x+clampRect.w,cy2=clampRect.y+clampRect.h,underflowX1=max(0,clampRect.x-x1),underflowY1=max(0,clampRect.y-y1),overflowX2=max(0,x2-cx2),overflowY2=max(0,y2-cy2),x1+=underflowX1,y1+=underflowY1,fixedSize&&(x2+=underflowX1,y2+=underflowY1,x1-=overflowX2,y1-=overflowY2),x2-=overflowX2,y2-=overflowY2,create(x1,y1,x2-x1,y2-y1)},create=function(x,y,w,h){return{x:x,y:y,w:w,h:h}},fromClientRect=function(clientRect){return create(clientRect.left,clientRect.top,clientRect.width,clientRect.height)};tinymce.geom.Rect={inflate:inflate,relativePosition:relativePosition,findBestRelativePosition:findBestRelativePosition,intersect:intersect,clamp:clamp,create:create,fromClientRect:fromClientRect}}(tinymce),tinymce.dom={},function(namespace){function addEvent(target,name,callback,capture){target.addEventListener(name,callback,capture||!1)}function removeEvent(target,name,callback,capture){target.removeEventListener(name,callback,capture||!1)}function fix(originalEvent,data){function returnFalse(){return!1}function returnTrue(){return!0}var name,undef,event=data||{};for(name in originalEvent)deprecated[name]||(event[name]=originalEvent[name]);if(event.target||(event.target=event.srcElement||document),originalEvent&&mouseEventRe.test(originalEvent.type)&&originalEvent.pageX===undef&&originalEvent.clientX!==undef){var eventDoc=event.target.ownerDocument||document,doc=eventDoc.documentElement,body=eventDoc.body;event.pageX=originalEvent.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0),event.pageY=originalEvent.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0)}return event.preventDefault=function(){event.isDefaultPrevented=returnTrue,originalEvent&&originalEvent.preventDefault()},event.stopPropagation=function(){event.isPropagationStopped=returnTrue,originalEvent&&originalEvent.stopPropagation()},event.stopImmediatePropagation=function(){event.isImmediatePropagationStopped=returnTrue,event.stopPropagation()},event.isDefaultPrevented||(event.isDefaultPrevented=returnFalse,event.isPropagationStopped=returnFalse,event.isImmediatePropagationStopped=returnFalse),event}function bindOnReady(win,callback,eventUtils){function readyHandler(){eventUtils.domLoaded||(eventUtils.domLoaded=!0,callback(event))}var doc=win.document,event={type:"ready"};return eventUtils.domLoaded?void callback(event):("complete"===doc.readyState?readyHandler():addEvent(win,"DOMContentLoaded",readyHandler),void addEvent(win,"load",readyHandler))}function EventUtils(){function executeHandlers(evt,id){var callbackList,i,l,callback,container=events[id];if(callbackList=container&&container[evt.type])for(i=0,l=callbackList.length;i<l;i++)if(callback=callbackList[i],callback&&callback.func.call(callback.scope,evt)===!1&&evt.preventDefault(),evt.isImmediatePropagationStopped())return}var count,expando,hasFocusIn,hasMouseEnterLeave,mouseEnterLeave,self=this,events={};expando=eventExpandoPrefix+(+new Date).toString(32),hasMouseEnterLeave="onmouseenter"in document.documentElement,hasFocusIn="onfocusin"in document.documentElement,mouseEnterLeave={mouseenter:"mouseover",mouseleave:"mouseout"},count=1,self.domLoaded=!1,self.events=events,self.bind=function(target,names,callback,scope){function defaultNativeHandler(evt){executeHandlers(fix(evt||win.event),id)}var id,callbackList,i,name,fakeName,nativeHandler,capture,win=window;if(target&&3!==target.nodeType&&8!==target.nodeType){for(target[expando]?id=target[expando]:(id=count++,target[expando]=id,events[id]={}),scope=scope||target,names=names.split(" "),i=names.length;i--;)name=names[i],nativeHandler=defaultNativeHandler,fakeName=capture=!1,"DOMContentLoaded"===name&&(name="ready"),self.domLoaded&&"ready"===name&&"complete"==target.readyState?callback.call(scope,fix({type:name})):(hasMouseEnterLeave||(fakeName=mouseEnterLeave[name],fakeName&&(nativeHandler=function(evt){var current,related;if(current=evt.currentTarget,related=evt.relatedTarget,related&&current.contains)related=current.contains(related);else for(;related&&related!==current;)related=related.parentNode;related||(evt=fix(evt||win.event),evt.type="mouseout"===evt.type?"mouseleave":"mouseenter",evt.target=current,executeHandlers(evt,id))})),hasFocusIn||"focusin"!==name&&"focusout"!==name||(capture=!0,fakeName="focusin"===name?"focus":"blur",nativeHandler=function(evt){evt=fix(evt||win.event),evt.type="focus"===evt.type?"focusin":"focusout",executeHandlers(evt,id)}),callbackList=events[id][name],callbackList?"ready"===name&&self.domLoaded?callback({type:name}):callbackList.push({func:callback,scope:scope}):(events[id][name]=callbackList=[{func:callback,scope:scope}],callbackList.fakeName=fakeName,callbackList.capture=capture,callbackList.nativeHandler=nativeHandler,"ready"===name?bindOnReady(target,nativeHandler,self):addEvent(target,fakeName||name,nativeHandler,capture)));return target=callbackList=0,callback}},self.unbind=function(target,names,callback){var id,callbackList,i,ci,name,eventMap;if(!target||3===target.nodeType||8===target.nodeType)return self;if(id=target[expando]){if(eventMap=events[id],names){for(names=names.split(" "),i=names.length;i--;)if(name=names[i],callbackList=eventMap[name]){if(callback)for(ci=callbackList.length;ci--;)if(callbackList[ci].func===callback){var nativeHandler=callbackList.nativeHandler,fakeName=callbackList.fakeName,capture=callbackList.capture;callbackList=callbackList.slice(0,ci).concat(callbackList.slice(ci+1)),callbackList.nativeHandler=nativeHandler,callbackList.fakeName=fakeName,callbackList.capture=capture,eventMap[name]=callbackList}callback&&0!==callbackList.length||(delete eventMap[name],removeEvent(target,callbackList.fakeName||name,callbackList.nativeHandler,callbackList.capture))}}else{for(name in eventMap)callbackList=eventMap[name],removeEvent(target,callbackList.fakeName||name,callbackList.nativeHandler,callbackList.capture);eventMap={}}for(name in eventMap)return self;delete events[id];try{delete target[expando]}catch(ex){target[expando]=null}}return self},self.fire=function(target,name,args){var id;if(!target||3===target.nodeType||8===target.nodeType)return self;args=fix(null,args),args.type=name,args.target=target;do id=target[expando],id&&executeHandlers(args,id),target=target.parentNode||target.ownerDocument||target.defaultView||target.parentWindow;while(target&&!args.isPropagationStopped());return self},self.clean=function(target){var i,children,unbind=self.unbind;if(!target||3===target.nodeType||8===target.nodeType)return self;if(target[expando]&&unbind(target),target.getElementsByTagName||(target=target.document),target&&target.getElementsByTagName)for(unbind(target),children=target.getElementsByTagName("*"),i=children.length;i--;)target=children[i],target[expando]&&unbind(target);return self},self.destroy=function(){events={}},self.cancel=function(e){return e&&(e.preventDefault(),e.stopImmediatePropagation()),!1},self.add=function(target,events,func,scope){if("string"==typeof target&&(target=document.getElementById(target)),!(target&&target instanceof Array))return"init"===events&&(events="ready"),self.bind(target,events instanceof Array?events.join(" "):events,func,scope);for(var i=target.length;i--;)self.add(target[i],events,func,scope)},self.remove=function(target,events,func,scope){if(!target)return self;if("string"==typeof target&&(target=document.getElementById(target)),target instanceof Array){for(var i=target.length;i--;)self.remove(target[i],events,func,scope);return self}return self.unbind(target,events instanceof Array?events.join(" "):events,func)},self.clear=function(target){return"string"==typeof target&&(target=document.getElementById(target)),self.clean(target)}}var eventExpandoPrefix="mce-data-",mouseEventRe=/^(?:mouse|contextmenu)|click/,deprecated={keyLocation:1,layerX:1,layerY:1,returnValue:1,webkitMovementX:1,webkitMovementY:1,keyIdentifier:1,mozPressure:1,path:1};namespace.EventUtils=EventUtils,namespace.Event=new EventUtils,namespace.Event.bind(window,"ready",function(){}),namespace=0}(tinymce.dom),tinymce.dom.TreeWalker=function(startNode,rootNode){function findSibling(node,startName,siblingName,shallow){var sibling,parent;if(node){if(!shallow&&node[startName])return node[startName];if(node!=rootNode){if(sibling=node[siblingName])return sibling;for(parent=node.parentNode;parent&&parent!=rootNode;parent=parent.parentNode)if(sibling=parent[siblingName])return sibling}}}function findPreviousNode(node,startName,siblingName,shallow){var sibling,parent,child;if(node){if(sibling=node[siblingName],rootNode&&sibling===rootNode)return;if(sibling){if(!shallow)for(child=sibling[startName];child;child=child[startName])if(!child[startName])return child;return sibling}if(parent=node.parentNode,parent&&parent!==rootNode)return parent}}var node=startNode;this.current=function(){return node},this.next=function(shallow){return node=findSibling(node,"firstChild","nextSibling",shallow)},this.prev=function(shallow){return node=findSibling(node,"lastChild","previousSibling",shallow)},this.prev2=function(shallow){return node=findPreviousNode(node,"lastChild","previousSibling",shallow)}},function(tinymce){var each=tinymce.each,is=tinymce.is,isWebKit=tinymce.isWebKit,isIE=tinymce.isIE,Entities=tinymce.html.Entities,simpleSelectorRe=/^([a-z0-9],?)+$/i,whiteSpaceRegExp=/^[ \t\r\n]*$/;tinymce.dom.DOMUtils=function(d,s){var blockElementsMap,self=this;self.doc=d,self.win=window,self.files={},self.cssFlicker=!1,self.counter=0,self.stdMode=!tinymce.isIE||d.documentMode>=8,self.boxModel=!tinymce.isIE||"CSS1Compat"==d.compatMode||self.stdMode,self.hasOuterHTML="outerHTML"in d.createElement("a"),self.settings=s=tinymce.extend({keep_values:!1,hex_colors:1},s),self.schema=s.schema,self.styles=new tinymce.html.Styles({url_converter:s.url_converter,url_converter_scope:s.url_converter_scope},s.schema),self.events=s.ownEvents?new tinymce.dom.EventUtils(s.proxy):tinymce.dom.Event,tinymce.addUnload(self.destroy,this),blockElementsMap=s.schema?s.schema.getBlockElements():{},self.isBlock=function(node){if(!node)return!1;var type=node.nodeType;return type?!(1!==type||!blockElementsMap[node.nodeName]):!!blockElementsMap[node]}},tinymce.dom.DOMUtils.prototype={doc:null,root:null,files:null,pixelStyles:/^(top|left|bottom|right|width|height|maxWidth|maxHeight|minWidth|minHeight|borderWidth)$/,props:{for:"htmlFor",class:"className",className:"className",checked:"checked",disabled:"disabled",maxlength:"maxLength",readonly:"readOnly",selected:"selected",value:"value",id:"id",name:"name",type:"type"},clone:function(node,deep){var clone,doc,self=this;return!isIE||tinymce.isIE11||1!==node.nodeType||deep?node.cloneNode(deep):(doc=self.doc,deep?clone.firstChild:(clone=doc.createElement(node.nodeName),each(self.getAttribs(node),function(attr){self.setAttrib(clone,attr.nodeName,self.getAttrib(node,attr.nodeName))}),clone))},getRoot:function(){var self=this,s=self.settings;return s&&self.get(s.root_element)||self.doc.body},getViewPort:function(w){var d,b;return w=w?w:this.win,d=w.document,b=this.boxModel?d.documentElement:d.body,{x:w.pageXOffset||b.scrollLeft,y:w.pageYOffset||b.scrollTop,w:w.innerWidth||b.clientWidth,h:w.innerHeight||b.clientHeight}},getRect:function(e){var p,sr,self=this;return e=self.get(e),p=self.getPos(e),sr=self.getSize(e),{x:p.x,y:p.y,w:sr.w,h:sr.h}},getSize:function(e){var w,h,self=this;return e=self.get(e),w=self.getStyle(e,"width"),h=self.getStyle(e,"height"),w.indexOf("px")===-1&&(w=0),h.indexOf("px")===-1&&(h=0),{w:parseInt(w,10)||e.offsetWidth||e.clientWidth,h:parseInt(h,10)||e.offsetHeight||e.clientHeight}},getParent:function(n,f,r){return this.getParents(n,f,r,!1)},getParents:function(n,f,r,c){var na,self=this,se=self.settings,o=[];for(n=self.get(n),c=void 0===c,se.strict_root&&(r=r||self.getRoot()),is(f,"string")&&(na=f,f="*"===f?function(n){return 1==n.nodeType}:function(n){return self.is(n,na)});n&&n!=r&&n.nodeType&&9!==n.nodeType;){if(!f||f(n)){if(!c)return n;o.push(n)}n=n.parentNode}return c?o:null},get:function(e){var n;return e&&this.doc&&"string"==typeof e&&(n=e,e=this.doc.getElementById(e),e&&e.id!==n)?this.doc.getElementsByName(n)[1]:e},getNext:function(node,selector){return this._findSib(node,selector,"nextSibling")},getPrev:function(node,selector){return this._findSib(node,selector,"previousSibling")},select:function(selector,scope){var self=this;return tinymce.dom.Sizzle(selector,self.get(scope)||self.settings.root_element||self.doc,[])},unique:function(arr){return tinymce.dom.Sizzle.uniqueSort(arr)},is:function(elm,selector){var i;if(void 0===elm.length){if("*"===selector)return 1==elm.nodeType;if(simpleSelectorRe.test(selector)){for(selector=selector.toLowerCase().split(/,/),elm=elm.nodeName.toLowerCase(),i=selector.length-1;i>=0;i--)if(selector[i]==elm)return!0;return!1}}if(elm.nodeType&&1!=elm.nodeType)return!1;var elms=elm.nodeType?[elm]:elm;return tinymce.dom.Sizzle(selector,elms[0].ownerDocument||elms[0],null,elms).length>0},closest:function(n,selector){for(var self=this,result=[];n;){if("string"==typeof selector&&self.is(n,selector)){result.push(n);break}if(n===selector){result.push(n);break}n=n.parentNode}return result},contains:function(context,elm){return tinymce.dom.Sizzle.contains(context,elm)},add:function(p,n,a,h,c){var self=this;return this.run(p,function(p){var e;return e=is(n,"string")?self.doc.createElement(n):n,self.setAttribs(e,a),h&&(h.nodeType?e.appendChild(h):self.setHTML(e,h)),c?e:p.appendChild(e)})},create:function(n,a,h){return this.add(this.doc.createElement(n),n,a,h,1)},wrap:function(elements,wrapper,all){var lastParent,newWrapper;return wrapper=this.get(wrapper),this.run(elements,function(elm){all&&lastParent==elm.parentNode?newWrapper.appendChild(elm):(lastParent=elm.parentNode,newWrapper=wrapper.cloneNode(!1),elm.parentNode.insertBefore(newWrapper,elm),newWrapper.appendChild(elm))})},createHTML:function(n,a,h){var k,o="",self=this;o+="<"+n;for(k in a)a.hasOwnProperty(k)&&""!=a[k]&&(o+=" "+k+'="'+self.encode(a[k])+'"');return"undefined"!=typeof h?o+">"+h+"</"+n+">":o+" />"},createFragment:function(html){var frag,node,container,doc=this.doc;for(container=doc.createElement("div"),frag=doc.createDocumentFragment(),frag.appendChild(container),html&&(container.innerHTML=html);node=container.firstChild;)frag.appendChild(node);return frag.removeChild(container),frag},remove:function(node,keep_children){return this.run(node,function(node){var child,parent=node.parentNode;if(!parent)return null;if(keep_children)for(;child=node.firstChild;)!tinymce.isIE||3!==child.nodeType||child.nodeValue?parent.insertBefore(child,node):node.removeChild(child);return parent.removeChild(node)})},empty:function(node){return this.run(node,function(node){for(var n,i=node.length;i--;)for(n=node[i];n.firstChild;)n.removeChild(n.firstChild);return!0})},setStyle:function(n,na,v){var self=this;return self.run(n,function(e){var s;s=e.style,na=na.replace(/-(\D)/g,function(a,b){return b.toUpperCase()}),self.pixelStyles.test(na)&&(tinymce.is(v,"number")||/^[\-0-9\.]+$/.test(v))&&(v+="px"),"float"==na&&(na=tinymce.isIE&&tinymce.isIE<12?"styleFloat":"cssFloat"),s[na]=v||"",self.settings.update_styles&&(v=self.serializeStyle(self.parseStyle(e.style.cssText),e.nodeName),self.setAttrib(e,"data-mce-style",v))})},getStyle:function(n,na,c){if(n=this.get(n)){if(this.doc.defaultView&&c){na=na.replace(/[A-Z]/g,function(a){return"-"+a});try{return this.doc.defaultView.getComputedStyle(n,null).getPropertyValue(na)}catch(ex){return null}}return na=na.replace(/-(\D)/g,function(a,b){return b.toUpperCase()}),"float"==na&&(na="cssFloat"),n.currentStyle&&c?n.currentStyle[na]:n.style?n.style[na]:void 0}},setStyles:function(e,o){var ol,v,self=this,s=self.settings;ol=s.update_styles,s.update_styles=0,this.run(e,function(e){each(o,function(v,n){self.setStyle(e,n,v)}),ol&&(v=self.serializeStyle(self.parseStyle(e.style.cssText),e.nodeName),self.setAttrib(e,"data-mce-style",v))}),s.update_styles=ol},removeAllAttribs:function(e){return this.run(e,function(e){var i,attrs=e.attributes;for(i=attrs.length-1;i>=0;i--)e.removeAttributeNode(attrs.item(i))})},removeAttrib:function(e,n){var self=this;if(e&&n)return self.settings.strict&&(n=n.toLowerCase()),this.run(e,function(e){e.removeAttribute(n,2)})},setAttrib:function(e,n,v){var self=this;if(e&&n)return self.settings.strict&&(n=n.toLowerCase()),this.run(e,function(e){var s=self.settings,originalValue=e.getAttribute(n);if(null!==v)switch(n){case"style":if(!is(v,"string"))return void each(v,function(v,n){self.setStyle(e,n,v)});s.keep_values&&(v&&!self._isRes(v)?e.setAttribute("data-mce-style",v,2):e.removeAttribute("data-mce-style",2)),e.style.cssText=v;break;case"class":e.className=v||"";break;case"src":case"href":s.keep_values&&(s.url_converter&&(v=s.url_converter.call(s.url_converter_scope||self,v,n,e)),self.setAttrib(e,"data-mce-"+n,v,2));break;case"shape":e.setAttribute("data-mce-style",v)}if(is(v)&&null!==v&&0!==v.length?e.setAttribute(n,""+v,2):e.removeAttribute(n,2),tinymce.activeEditor&&originalValue!=v){var ed=tinymce.activeEditor;ed.onSetAttrib.dispatch(ed,e,n,v)}})},setAttribs:function(e,o){var self=this;return this.run(e,function(e){each(o,function(v,n){self.setAttrib(e,n,v)})})},getAttrib:function(e,n,dv){var v,undef,self=this;if(e=self.get(e),!e||1!==e.nodeType)return dv!==undef&&dv;if(is(dv)||(dv=""),/^(src|href|style|coords|shape)$/.test(n)&&(v=e.getAttribute("data-mce-"+n)))return v;if(isIE&&self.props[n]&&(v=e[self.props[n]],v=v&&v.nodeValue?v.nodeValue:v),v||(v=e.getAttribute(n,2)),/^(checked|compact|declare|defer|disabled|ismap|multiple|nohref|noshade|nowrap|readonly|selected)$/.test(n))return e[self.props[n]]===!0&&""===v?n:v?n:"";if("FORM"===e.nodeName&&e.getAttributeNode(n))return e.getAttributeNode(n).nodeValue;if("style"===n&&(v=v||e.style.cssText,
v&&(v=self.serializeStyle(self.parseStyle(v),e.nodeName),self.settings.keep_values&&!self._isRes(v)&&e.setAttribute("data-mce-style",v))),isWebKit&&"class"===n&&v&&(v=v.replace(/(apple|webkit)\-[a-z\-]+/gi,"")),isIE)switch(n){case"rowspan":case"colspan":1===v&&(v="");break;case"size":"+0"!==v&&20!==v&&0!==v||(v="");break;case"width":case"height":case"vspace":case"checked":case"disabled":case"readonly":0===v&&(v="");break;case"hspace":v===-1&&(v="");break;case"maxlength":case"tabindex":32768!==v&&2147483647!==v&&"32768"!==v||(v="");break;case"multiple":case"compact":case"noshade":case"nowrap":return 65535===v?n:dv;case"shape":v=v.toLowerCase();break;default:0===n.indexOf("on")&&v&&(v=""+v,v=v.replace(/^function\s+\w+\(\)\s+\{\s+(.*)\s+\}$/,"$1"))}return v!==undef&&null!==v&&""!==v?""+v:dv},setValue:function(n,value){return n=this.get(n),n&&1===n.nodeType?void("SELECT"===n.nodeName?each(this.select('option[value="'+value+'"]',n),function(elm){elm.selected=!0}):n.value=value):null},getValue:function(n){return n=this.get(n),n&&1===n.nodeType?"SELECT"===n.nodeName?null==n.options||n.selectedIndex===-1?"":n.options[n.selectedIndex].value:n.value:null},getPos:function(n,ro){var e,r,self=this,x=0,y=0,d=self.doc,body=d.body;if(n=self.get(n),ro=ro||body,n){if(ro===body&&n.getBoundingClientRect&&"static"===self.getStyle(body,"position"))return n=n.getBoundingClientRect(),e=self.boxModel?d.documentElement:d.body,x=n.left+(d.documentElement.scrollLeft||d.body.scrollLeft)-e.clientTop,y=n.top+(d.documentElement.scrollTop||d.body.scrollTop)-e.clientLeft,{x:x,y:y};for(r=n;r&&r!=ro&&r.nodeType;)x+=r.offsetLeft||0,y+=r.offsetTop||0,r=r.offsetParent;for(r=n.parentNode;r&&r!=ro&&r.nodeType;)x-=r.scrollLeft||0,y-=r.scrollTop||0,r=r.parentNode}return{x:x,y:y}},parseStyle:function(st){return this.styles.parse(st)},serializeStyle:function(o,name){return this.styles.serialize(o,name)},addStyle:function(cssText){var head,styleElm,doc=this.doc;styleElm=doc.getElementById("mceDefaultStyles"),styleElm||(styleElm=doc.createElement("style"),styleElm.id="mceDefaultStyles",styleElm.type="text/css",head=doc.getElementsByTagName("head")[0],head.firstChild?head.insertBefore(styleElm,head.firstChild):head.appendChild(styleElm)),styleElm.styleSheet?styleElm.styleSheet.cssText+=cssText:styleElm.appendChild(doc.createTextNode(cssText))},loadCSS:function(u){var head,self=this,d=self.doc;u||(u=""),head=d.getElementsByTagName("head")[0],each(u.split(","),function(u){var link;self.files[u]||(self.files[u]=!0,link=self.create("link",{rel:"stylesheet","data-cfasync":!1,href:tinymce._addVer(u)}),head.appendChild(link))})},addClass:function(e,c){function valueToArray(value){return Array.isArray(value)?value:"string"==typeof value?value.split(" "):[]}return c?this.run(e,function(e){var values=valueToArray(c);return each(values,function(cls){return cls.trim(),!cls||void e.classList.add(cls)}),e.className}):""},removeClass:function(e,c){var self=this;return self.run(e,function(e){return e.classList.remove(c),e.className||(e.removeAttribute("class"),e.removeAttribute("className")),e.className})},hasClass:function(n,c){return n=this.get(n),!(!n||!c)&&n.classList&&n.classList.contains(c)},toggleClass:function(n,c){return n=this.get(n),!(!n||!c)&&(this.hasClass(n,c)?this.removeClass(n,c):this.addClass(n,c))},show:function(e){return this.setStyle(e,"display","block")},hide:function(e){return this.setStyle(e,"display","none")},isHidden:function(e){return e=this.get(e),!e||"none"==e.style.display||"none"==this.getStyle(e,"display")},uniqueId:function(p){return(p?p:"mce_")+this.counter++},setHTML:function(element,html){var self=this;return self.run(element,function(element){if(isIE){for(;element.firstChild;)element.removeChild(element.firstChild);try{element.innerHTML="<br />"+html,element.removeChild(element.firstChild)}catch(ex){var newElement=self.create("div");newElement.innerHTML="<br />"+html,each(tinymce.grep(newElement.childNodes),function(node,i){i&&element.canHaveHTML&&element.appendChild(node)})}}else element.innerHTML=html;return html})},getOuterHTML:function(elm){var doc,self=this;return(elm=self.get(elm))?1===elm.nodeType?elm.outerHTML:(doc=(elm.ownerDocument||self.doc).createElement("body"),doc.appendChild(elm.cloneNode(!0)),doc.innerHTML):null},setOuterHTML:function(e,h,d){function setHTML(e,h,d){var n,tp;for(tp=d.createElement("body"),tp.innerHTML=h,n=tp.lastChild;n;)self.insertAfter(n.cloneNode(!0),e),n=n.previousSibling;self.remove(e)}var self=this;return this.run(e,function(e){if(e=self.get(e),1==e.nodeType)if(d=d||e.ownerDocument||self.doc,isIE)try{isIE&&1==e.nodeType?e.outerHTML=h:setHTML(e,h,d)}catch(ex){setHTML(e,h,d)}else setHTML(e,h,d)})},decode:Entities.decode,encode:Entities.encodeAllRaw,insertAfter:function(node,reference_node){return reference_node=this.get(reference_node),this.run(node,function(node){var parent,nextSibling;return parent=reference_node.parentNode,nextSibling=reference_node.nextSibling,nextSibling?parent.insertBefore(node,nextSibling):parent.appendChild(node),node})},insertBefore:function(node,reference_node){return reference_node=this.get(reference_node),this.run(node,function(node){return reference_node.parentNode.insertBefore(node,reference_node),node})},replace:function(n,o,k){var self=this;return is(o,"array")&&(n=n.cloneNode(!0)),self.run(o,function(o){return k&&each(tinymce.grep(o.childNodes),function(c){n.appendChild(c)}),o.parentNode.replaceChild(n,o)})},rename:function(elm,name){var newElm,self=this;return elm.nodeName!=name.toUpperCase()&&(newElm=self.create(name),each(self.getAttribs(elm),function(attr_node){self.setAttrib(newElm,attr_node.nodeName,self.getAttrib(elm,attr_node.nodeName))}),self.replace(newElm,elm,1)),newElm||elm},findCommonAncestor:function(a,b){for(var pe,ps=a;ps;){for(pe=b;pe&&ps!=pe;)pe=pe.parentNode;if(ps==pe)break;ps=ps.parentNode}return!ps&&a.ownerDocument?a.ownerDocument.documentElement:ps},toHex:function(s){function hex(s){return s=parseInt(s,10).toString(16),s.length>1?s:"0"+s}s=s.replace(/\s/g,"").replace(/(rgb|rgba)\(/i,"").replace(/\)/,"").replace(/\s/g,"");var c=s.split(",");return c.length>=3?s="#"+hex(c[0])+hex(c[1])+hex(c[2]):s},getClasses:function(){function addClasses(s){each(s.imports,function(r){addClasses(r)}),each(s.cssRules||s.rules,function(r){switch(r.type||1){case 1:r.selectorText&&each(r.selectorText.split(","),function(v){v=v.replace(/^\s*|\s*$|^\s\./g,""),!/\.mce/.test(v)&&/\.[\w\-]+$/.test(v)&&(ov=v,v=v.replace(/.*\.([a-z0-9_\-]+).*/i,"$1"),f&&!(v=f(v,ov))||lo[v]||(cl.push({class:v}),lo[v]=1))});break;case 3:try{addClasses(r.styleSheet)}catch(ex){}}})}var ov,self=this,cl=[],lo={},f=self.settings.class_filter;if(self.classes)return self.classes;try{each(self.doc.styleSheets,addClasses)}catch(ex){}return cl.length>0&&(self.classes=cl),cl},run:function(e,f,s){var o,self=this;return self.doc&&"string"==typeof e&&(e=self.get(e)),!!e&&(s=s||this,e.nodeType||!e.length&&0!==e.length?f.call(s,e):(o=[],each(e,function(e,i){e&&("string"==typeof e&&(e=self.doc.getElementById(e)),o.push(f.call(s,e,i)))}),o))},getAttribs:function(n){var o;return n=this.get(n),n?isIE?(o=[],"OBJECT"==n.nodeName?n.attributes:("OPTION"===n.nodeName&&this.getAttrib(n,"selected")&&o.push({specified:1,nodeName:"selected"}),n.cloneNode(!1).outerHTML.replace(/<\/?[\w:\-]+ ?|=[\"][^\"]+\"|=\'[^\']+\'|=[\w\-]+|>/gi,"").replace(/[\w:\-]+/gi,function(a){o.push({specified:1,nodeName:a})}),o)):n.attributes:[]},isEmpty:function(node,elements){function isValidAttribute(name){return"name"==name||"id"==name||"class"==name||name.indexOf("-")!=-1&&("data-mce-bookmark"==name||name.indexOf("data-mce-")==-1)}var i,attributes,type,whitespace,walker,name,self=this,brCount=0;if(node=node.firstChild){walker=new tinymce.dom.TreeWalker(node,node.parentNode),elements=elements||(self.schema?self.schema.getNonEmptyElements():null),whitespace=self.schema?self.schema.getWhiteSpaceElements():{};do{if(type=node.nodeType,1===type){var bogusVal=node.getAttribute("data-mce-bogus");if(bogusVal){node=walker.next("all"===bogusVal);continue}if(name=node.nodeName.toLowerCase(),elements&&elements[name]){if("br"===name){brCount++,node=walker.next();continue}return!1}for(attributes=self.getAttribs(node),i=attributes.length;i--;)if(name=attributes[i].nodeName,isValidAttribute(name))return!1}if(8==type)return!1;if(3===type&&!whiteSpaceRegExp.test(node.nodeValue))return!1;if(3===type&&node.parentNode&&whitespace[node.parentNode.nodeName]&&whiteSpaceRegExp.test(node.nodeValue))return!1;node=walker.next()}while(node)}return brCount<=1},destroy:function(s){var self=this;self.win=self.doc=self.root=self.events=self.frag=null,s||tinymce.removeUnload(self.destroy)},createRng:function(){return this.doc.createRange()},nodeIndex:function(node,normalized){var lastNodeType,nodeType,idx=0;if(node)for(lastNodeType=node.nodeType,node=node.previousSibling;node;node=node.previousSibling)nodeType=node.nodeType,(!normalized||3!=nodeType||nodeType!=lastNodeType&&node.nodeValue.length)&&(idx++,lastNodeType=nodeType);return idx},split:function(pe,e,re){function trim(node){function surroundedBySpans(node){var previousIsSpan=node.previousSibling&&"SPAN"==node.previousSibling.nodeName,nextIsSpan=node.nextSibling&&"SPAN"==node.nextSibling.nodeName;return previousIsSpan&&nextIsSpan}var i,children=node.childNodes,type=node.nodeType;if(1!=type||"bookmark"!=node.getAttribute("data-mce-type")){for(i=children.length-1;i>=0;i--)trim(children[i]);if(9!=type){if(3==type&&node.nodeValue.length>0){var trimmedLength=tinymce.trim(node.nodeValue).length;if(!self.isBlock(node.parentNode)||trimmedLength>0||0===trimmedLength&&surroundedBySpans(node))return}else if(1==type&&(children=node.childNodes,1==children.length&&children[0]&&1==children[0].nodeType&&"bookmark"==children[0].getAttribute("data-mce-type")&&node.parentNode.insertBefore(children[0],node),children.length||/^(br|hr|input|img)$/i.test(node.nodeName)))return;self.remove(node)}return node}}var bef,aft,pa,self=this,r=self.createRng();if(pe&&e)return r.setStart(pe.parentNode,self.nodeIndex(pe)),r.setEnd(e.parentNode,self.nodeIndex(e)),bef=r.extractContents(),r=self.createRng(),r.setStart(e.parentNode,self.nodeIndex(e)+1),r.setEnd(pe.parentNode,self.nodeIndex(pe)+1),aft=r.extractContents(),pa=pe.parentNode,pa.insertBefore(trim(bef),pe),re?pa.replaceChild(re,e):pa.insertBefore(e,pe),pa.insertBefore(trim(aft),pe),self.remove(pe),re||e},bind:function(target,name,func,scope){return this.events.add(target,name,func,scope||this)},unbind:function(target,name,func){return this.events.remove(target,name,func)},fire:function(target,name,evt){return this.events.fire(target,name,evt)},getContentEditable:function(node){var contentEditable;return node&&1==node.nodeType?(contentEditable=node.getAttribute("data-mce-contenteditable"),contentEditable&&"inherit"!==contentEditable?contentEditable:"inherit"!==node.contentEditable?node.contentEditable:null):null},getContentEditableParent:function(node){for(var root=this.getRoot(),state=null;node&&node!==root&&(state=this.getContentEditable(node),null===state);node=node.parentNode);return state},isChildOf:function(node,parent){for(;node;){if(parent===node)return!0;node=node.parentNode}return!1},dumpRng:function(r){return"startContainer: "+r.startContainer.nodeName+", startOffset: "+r.startOffset+", endContainer: "+r.endContainer.nodeName+", endOffset: "+r.endOffset},_findSib:function(node,selector,name){var self=this,f=selector;if(node)for(is(f,"string")&&(f=function(node){return self.is(node,selector)}),node=node[name];node;node=node[name])if(f(node))return node;return null},_isRes:function(c){return/^(top|left|bottom|right|width|height)/i.test(c)||/;\s*(top|left|bottom|right|width|height)/i.test(c)}},tinymce.DOM=new tinymce.dom.DOMUtils(document,{process_html:0})}(tinymce),function(tinymce){function isNodeType(type){return function(node){return!!node&&node.nodeType==type}}function matchNodeNames(names){return names=names.toLowerCase().split(" "),function(node){var i,name;if(node&&node.nodeType)for(name=node.nodeName.toLowerCase(),i=0;i<names.length;i++)if(name===names[i])return!0;return!1}}function matchStyleValues(name,values){return values=values.toLowerCase().split(" "),function(node){var i,cssValue;if(isElement(node))for(i=0;i<values.length;i++)if(cssValue=node.ownerDocument.defaultView.getComputedStyle(node,null).getPropertyValue(name),cssValue===values[i])return!0;return!1}}function hasPropValue(propName,propValue){return function(node){return isElement(node)&&node[propName]===propValue}}function hasAttributeValue(attrName,attrValue){return function(node){return isElement(node)&&node.getAttribute(attrName)===attrValue}}function isBogus(node){return isElement(node)&&node.hasAttribute("data-mce-bogus")}function isBookmark(node){return isElement(node)&&"bookmark"==node.getAttribute("data-mce-type")}function isCaret(node){return isElement(node)&&"_mce_caret"===node.id}function isInternal(node){return isBogus(node)||isBookmark(node)||isCaret(node)}function hasContentEditableState(value){return function(node){if(isElement(node)){if(node.hasAttribute("data-mce-contenteditable"))return node.getAttribute("data-mce-contenteditable")===value;if(node.contentEditable===value)return!0}return!1}}var isElement=isNodeType(1);tinymce.dom.NodeType={isText:isNodeType(3),isElement:isElement,isComment:isNodeType(8),isDocument:isNodeType(9),isDocumentFragment:isNodeType(11),isBr:matchNodeNames("br"),isContentEditableTrue:hasContentEditableState("true"),isContentEditableFalse:hasContentEditableState("false"),matchNodeNames:matchNodeNames,hasPropValue:hasPropValue,hasAttributeValue:hasAttributeValue,matchStyleValues:matchStyleValues,isBogus:isBogus,isBookmark:isBookmark,isInternal:isInternal}}(tinymce),function(tinymce){function getClientRects(node){function toArrayWithNode(clientRects){return Arr.map(clientRects,function(clientRect){return clientRect=ClientRect.clone(clientRect),clientRect.node=node,clientRect})}if(Arr.isArray(node))return Arr.reduce(node,function(result,node){return result.concat(getClientRects(node))},[]);if(NodeType.isElement(node))return toArrayWithNode(node.getClientRects());if(NodeType.isText(node)){var rng=node.ownerDocument.createRange();return rng.setStart(node,0),rng.setEnd(node,node.data.length),toArrayWithNode(rng.getClientRects())}}var NodeType=tinymce.dom.NodeType,Arr=tinymce.util.Arr,ClientRect=tinymce.geom.ClientRect;tinymce.dom.Dimensions={getClientRects:getClientRects}}(tinymce),function(tinymce){function getEndChild(container,index){var childNodes=container.childNodes;return index--,index>childNodes.length-1?index=childNodes.length-1:index<0&&(index=0),childNodes[index]||container}var each=tinymce.each,TreeWalker=tinymce.dom.TreeWalker;tinymce.dom.RangeUtils=function(dom){this.walk=function(rng,callback){function exclude(nodes){var node;return node=nodes[0],3===node.nodeType&&node===startContainer&&startOffset>=node.nodeValue.length&&nodes.splice(0,1),node=nodes[nodes.length-1],0===endOffset&&nodes.length>0&&node===endContainer&&3===node.nodeType&&nodes.splice(nodes.length-1,1),nodes}function collectSiblings(node,name,end_node){for(var siblings=[];node&&node!=end_node;node=node[name])siblings.push(node);return siblings}function findEndPoint(node,root){do{if(node.parentNode==root)return node;node=node.parentNode}while(node)}function walkBoundary(start_node,end_node,next){var siblingName=next?"nextSibling":"previousSibling";for(node=start_node,parent=node.parentNode;node&&node!=end_node;node=parent)parent=node.parentNode,siblings=collectSiblings(node==start_node?node:node[siblingName],siblingName),siblings.length&&(next||siblings.reverse(),callback(exclude(siblings)))}var ancestor,startPoint,endPoint,node,parent,siblings,nodes,startContainer=rng.startContainer,startOffset=rng.startOffset,endContainer=rng.endContainer,endOffset=rng.endOffset;if(nodes=dom.select("td.mceSelected,th.mceSelected,div.mceSelected"),nodes.length>0)return void each(nodes,function(node){callback([node])});if(1==startContainer.nodeType&&startContainer.hasChildNodes()&&(startContainer=startContainer.childNodes[startOffset]),1==endContainer.nodeType&&endContainer.hasChildNodes()&&(endContainer=getEndChild(endContainer,endOffset)),startContainer==endContainer)return callback(exclude([startContainer]));for(ancestor=dom.findCommonAncestor(startContainer,endContainer),node=startContainer;node;node=node.parentNode){if(node===endContainer)return walkBoundary(startContainer,ancestor,!0);if(node===ancestor)break}for(node=endContainer;node;node=node.parentNode){if(node===startContainer)return walkBoundary(endContainer,ancestor);if(node===ancestor)break}startPoint=findEndPoint(startContainer,ancestor)||startContainer,endPoint=findEndPoint(endContainer,ancestor)||endContainer,walkBoundary(startContainer,startPoint,!0),siblings=collectSiblings(startPoint==startContainer?startPoint:startPoint.nextSibling,"nextSibling",endPoint==endContainer?endPoint.nextSibling:endPoint),siblings.length&&callback(exclude(siblings)),walkBoundary(endContainer,endPoint)},this.split=function(rng){function splitText(node,offset){return node.splitText(offset)}var startContainer=rng.startContainer,startOffset=rng.startOffset,endContainer=rng.endContainer,endOffset=rng.endOffset;return startContainer==endContainer&&3==startContainer.nodeType?startOffset>0&&startOffset<startContainer.nodeValue.length&&(endContainer=splitText(startContainer,startOffset),startContainer=endContainer.previousSibling,endOffset>startOffset?(endOffset-=startOffset,startContainer=endContainer=splitText(endContainer,endOffset).previousSibling,endOffset=endContainer.nodeValue.length,startOffset=0):endOffset=0):(3==startContainer.nodeType&&startOffset>0&&startOffset<startContainer.nodeValue.length&&(startContainer=splitText(startContainer,startOffset),startOffset=0),3==endContainer.nodeType&&endOffset>0&&endOffset<endContainer.nodeValue.length&&(endContainer=splitText(endContainer,endOffset).previousSibling,endOffset=endContainer.nodeValue.length)),{startContainer:startContainer,startOffset:startOffset,endContainer:endContainer,endOffset:endOffset}},this.normalize=function(rng){function normalizeEndPoint(start){function hasBrBeforeAfter(node,left){for(var walker=new TreeWalker(node,dom.getParent(node.parentNode,dom.isBlock)||body);node=walker[left?"prev":"next"]();)if("BR"===node.nodeName)return!0}function isPrevNode(node,name){return node.previousSibling&&node.previousSibling.nodeName==name}function findTextNodeRelative(left,startNode){var walker,lastInlineElement,parentBlockContainer;if(startNode=startNode||container,parentBlockContainer=dom.getParent(startNode.parentNode,dom.isBlock)||body,left&&"BR"==startNode.nodeName&&isAfterNode&&dom.isEmpty(parentBlockContainer))return container=startNode.parentNode,offset=dom.nodeIndex(startNode),void(normalized=!0);for(walker=new TreeWalker(startNode,parentBlockContainer);node=walker[left?"prev":"next"]();){if("false"===dom.getContentEditableParent(node))return;if(3===node.nodeType&&node.nodeValue.length>0)return container=node,offset=left?node.nodeValue.length:0,void(normalized=!0);if(dom.isBlock(node)||nonEmptyElementsMap[node.nodeName.toLowerCase()])return;lastInlineElement=node}collapsed&&lastInlineElement&&(container=lastInlineElement,normalized=!0,offset=0)}var container,offset,walker,node,nonEmptyElementsMap,directionLeft,isAfterNode,body=dom.getRoot();if(container=rng[(start?"start":"end")+"Container"],offset=rng[(start?"start":"end")+"Offset"],isAfterNode=1==container.nodeType&&offset===container.childNodes.length,nonEmptyElementsMap=dom.schema.getNonEmptyElements(),directionLeft=start,1==container.nodeType&&offset>container.childNodes.length-1&&(directionLeft=!1),9===container.nodeType&&(container=dom.getRoot(),offset=0),container===body){if(directionLeft&&(node=container.childNodes[offset>0?offset-1:0],node&&(nonEmptyElementsMap[node.nodeName]||"TABLE"==node.nodeName)))return;if(container.hasChildNodes()&&(offset=Math.min(!directionLeft&&offset>0?offset-1:offset,container.childNodes.length-1),container=container.childNodes[offset],offset=0,container.hasChildNodes()&&!/TABLE/.test(container.nodeName))){node=container,walker=new TreeWalker(container,body);do{if(3===node.nodeType&&node.nodeValue.length>0){offset=directionLeft?0:node.nodeValue.length,container=node,normalized=!0;break}if(nonEmptyElementsMap[node.nodeName.toLowerCase()]){offset=dom.nodeIndex(node),container=node.parentNode,"IMG"!=node.nodeName||directionLeft||offset++,normalized=!0;break}}while(node=directionLeft?walker.next():walker.prev())}}collapsed&&(3===container.nodeType&&0===offset&&findTextNodeRelative(!0),1===container.nodeType&&(node=container.childNodes[offset],node||(node=container.childNodes[offset-1]),!node||"BR"!==node.nodeName||isPrevNode(node,"A")||hasBrBeforeAfter(node)||hasBrBeforeAfter(node,!0)||findTextNodeRelative(!0,node))),directionLeft&&!collapsed&&3===container.nodeType&&offset===container.nodeValue.length&&findTextNodeRelative(!1),normalized&&rng["set"+(start?"Start":"End")](container,offset)}var normalized,collapsed;return collapsed=rng.collapsed,normalizeEndPoint(!0),collapsed||normalizeEndPoint(),normalized&&collapsed&&rng.collapse(!0),normalized}},tinymce.dom.RangeUtils.compareRanges=function(rng1,rng2){if(rng1&&rng2){if(!rng1.item&&!rng1.duplicate)return rng1.startContainer==rng2.startContainer&&rng1.startOffset==rng2.startOffset;if(rng1.item&&rng2.item&&rng1.item(0)===rng2.item(0))return!0;if(rng1.isEqual&&rng2.isEqual&&rng2.isEqual(rng1))return!0}return!1},tinymce.dom.RangeUtils.getCaretRangeFromPoint=function(x,y,doc){var rng,point;if(doc.caretPositionFromPoint)point=doc.caretPositionFromPoint(x,y),rng=doc.createRange(),rng.setStart(point.offsetNode,point.offset),rng.collapse(!0);else if(doc.caretRangeFromPoint)rng=doc.caretRangeFromPoint(x,y);else if(doc.body.createTextRange){rng=doc.body.createTextRange();try{rng.moveToPoint(x,y),rng.collapse(!0)}catch(ex){rng.collapse(y<doc.body.clientHeight)}}return rng},tinymce.dom.RangeUtils.getSelectedNode=function(range){var startContainer=range.startContainer,startOffset=range.startOffset;return startContainer.hasChildNodes()&&range.endOffset==startOffset+1?startContainer.childNodes[startOffset]:null},tinymce.dom.RangeUtils.getNode=function(container,offset){return 1==container.nodeType&&container.hasChildNodes()&&(offset>=container.childNodes.length&&(offset=container.childNodes.length-1),container=container.childNodes[offset]),container}}(tinymce),function(tinymce){function isExtendingChar(ch){return"string"==typeof ch&&ch.charCodeAt(0)>=768&&extendingChars.test(ch)}var extendingChars=new RegExp("[\u0300-\u036f\u0483-\u0487\u0488-\u0489\u0591-\u05bd\u05bf\u05c1-\u05c2\u05c4-\u05c5\u05c7\u0610-\u061a\u064b-\u065f\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08e3-\u0902\u093a\u093c\u0941-\u0948\u094d\u0951-\u0957\u0962-\u0963\u0981\u09bc\u09be\u09c1-\u09c4\u09cd\u09d7\u09e2-\u09e3\u0a01-\u0a02\u0a3c\u0a41-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a51\u0a70-\u0a71\u0a75\u0a81-\u0a82\u0abc\u0ac1-\u0ac5\u0ac7-\u0ac8\u0acd\u0ae2-\u0ae3\u0b01\u0b3c\u0b3e\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b57\u0b62-\u0b63\u0b82\u0bbe\u0bc0\u0bcd\u0bd7\u0c00\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c62-\u0c63\u0c81\u0cbc\u0cbf\u0cc2\u0cc6\u0ccc-\u0ccd\u0cd5-\u0cd6\u0ce2-\u0ce3\u0d01\u0d3e\u0d41-\u0d44\u0d4d\u0d57\u0d62-\u0d63\u0dca\u0dcf\u0dd2-\u0dd4\u0dd6\u0ddf\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb-\u0ebc\u0ec8-\u0ecd\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039-\u103a\u103d-\u103e\u1058-\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085-\u1086\u108d\u109d\u135d-\u135f\u1712-\u1714\u1732-\u1734\u1752-\u1753\u1772-\u1773\u17b4-\u17b5\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927-\u1928\u1932\u1939-\u193b\u1a17-\u1a18\u1a1b\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1ab0-\u1abd\u1abe\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80-\u1b81\u1ba2-\u1ba5\u1ba8-\u1ba9\u1bab-\u1bad\u1be6\u1be8-\u1be9\u1bed\u1bef-\u1bf1\u1c2c-\u1c33\u1c36-\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1cf4\u1cf8-\u1cf9\u1dc0-\u1df5\u1dfc-\u1dff\u200c-\u200d\u20d0-\u20dc\u20dd-\u20e0\u20e1\u20e2-\u20e4\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302d\u302e-\u302f\u3099-\u309a\ua66f\ua670-\ua672\ua674-\ua67d\ua69e-\ua69f\ua6f0-\ua6f1\ua802\ua806\ua80b\ua825-\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\ua9e5\uaa29-\uaa2e\uaa31-\uaa32\uaa35-\uaa36\uaa43\uaa4c\uaa7c\uaab0\uaab2-\uaab4\uaab7-\uaab8\uaabe-\uaabf\uaac1\uaaec-\uaaed\uaaf6\uabe5\uabe8\uabed\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\uff9e-\uff9f]");tinymce.text.ExtendingChar={isExtendingChar:isExtendingChar}}(tinymce),function(tinymce){var ZWSP="\ufeff",isZwsp=function(chr){return chr===ZWSP},trim=function(text){return text.replace(new RegExp(ZWSP,"g"),"")};tinymce.text.Zwsp={isZwsp:isZwsp,ZWSP:ZWSP,trim:trim}}(tinymce),function(tinymce){function normalizedParent(node){var parentNode=node.parentNode;return isBogus(parentNode)?normalizedParent(parentNode):parentNode}function getChildNodes(node){return node?Arr.reduce(node.childNodes,function(result,node){return isBogus(node)&&"BR"!=node.nodeName?result=result.concat(getChildNodes(node)):result.push(node),result},[]):[]}function normalizedTextOffset(textNode,offset){for(;(textNode=textNode.previousSibling)&&isText(textNode);)offset+=textNode.data.length;return offset}function equal(targetValue){return function(value){return targetValue===value}}function normalizedNodeIndex(node){var nodes,index,numTextFragments;return nodes=getChildNodes(normalizedParent(node)),index=Arr.findIndex(nodes,equal(node),node),nodes=nodes.slice(0,index+1),numTextFragments=Arr.reduce(nodes,function(result,node,i){return isText(node)&&isText(nodes[i-1])&&result++,result},0),nodes=Arr.filter(nodes,NodeType.matchNodeNames(node.nodeName)),index=Arr.findIndex(nodes,equal(node),node),index-numTextFragments}function createPathItem(node){var name;return name=isText(node)?"text()":node.nodeName.toLowerCase(),name+"["+normalizedNodeIndex(node)+"]"}function parentsUntil(rootNode,node,predicate){var parents=[];for(node=node.parentNode;!(node==rootNode||predicate&&predicate(node));node=node.parentNode)parents.push(node);return parents}function create(rootNode,caretPosition){var container,offset,outputOffset,childNodes,parents,path=[];return container=caretPosition.container(),offset=caretPosition.offset(),isText(container)?outputOffset=normalizedTextOffset(container,offset):(childNodes=container.childNodes,offset>=childNodes.length?(outputOffset="after",offset=childNodes.length-1):outputOffset="before",container=childNodes[offset]),path.push(createPathItem(container)),parents=parentsUntil(rootNode,container),parents=Arr.filter(parents,Fun.negate(NodeType.isBogus)),path=path.concat(Arr.map(parents,function(node){return createPathItem(node)})),path.reverse().join("/")+","+outputOffset}function resolvePathItem(node,name,index){var nodes=getChildNodes(node);return nodes=Arr.filter(nodes,function(node,index){return!isText(node)||!isText(nodes[index-1])}),nodes=Arr.filter(nodes,NodeType.matchNodeNames(name)),nodes[index]}function findTextPosition(container,offset){for(var dataLen,node=container,targetOffset=0;isText(node);){if(dataLen=node.data.length,offset>=targetOffset&&offset<=targetOffset+dataLen){container=node,offset-=targetOffset;break}if(!isText(node.nextSibling)){container=node,offset=dataLen;break}targetOffset+=dataLen,node=node.nextSibling}return offset>container.data.length&&(offset=container.data.length),new tinymce.caret.CaretPosition(container,offset)}function resolve(rootNode,path){var parts,container,offset;return path?(parts=path.split(","),path=parts[0].split("/"),offset=parts.length>1?parts[1]:"before",container=Arr.reduce(path,function(result,value){return(value=/([\w\-\(\)]+)\[([0-9]+)\]/.exec(value))?("text()"===value[1]&&(value[1]="#text"),resolvePathItem(result,value[1],parseInt(value[2],10))):null},rootNode),container?isText(container)?findTextPosition(container,parseInt(offset,10)):(offset="after"===offset?nodeIndex(container)+1:nodeIndex(container),new tinymce.caret.CaretPosition(container.parentNode,offset)):null):null}var NodeType=tinymce.dom.NodeType,DOMUtils=tinymce.DOM,Fun=tinymce.util.Fun,Arr=tinymce.util.Arr,isText=NodeType.isText,isBogus=NodeType.isBogus,nodeIndex=DOMUtils.nodeIndex;tinymce.caret.CaretBookmark={create:create,resolve:resolve}}(tinymce),function(tinymce){function isCaretContainerBlock(node){return isText(node)&&(node=node.parentNode),isElement(node)&&node.hasAttribute("data-mce-caret")}function isCaretContainerInline(node){return isText(node)&&Zwsp.isZwsp(node.data)}function isCaretContainer(node){return isCaretContainerBlock(node)||isCaretContainerInline(node)}function insertInline(node,before){var doc,sibling,textNode,parentNode;if(doc=node.ownerDocument,textNode=doc.createTextNode(Zwsp.ZWSP),parentNode=node.parentNode,before){if(sibling=node.previousSibling,isText(sibling)){if(isCaretContainer(sibling))return sibling;if(endsWithCaretContainer(sibling))return sibling.splitText(sibling.data.length-1)}parentNode.insertBefore(textNode,node)}else{if(sibling=node.nextSibling,isText(sibling)){if(isCaretContainer(sibling))return sibling;if(startsWithCaretContainer(sibling))return sibling.splitText(1),sibling}node.nextSibling?parentNode.insertBefore(textNode,node.nextSibling):parentNode.appendChild(textNode)}return textNode}function createBogusBr(){var br=document.createElement("br");return br.setAttribute("data-mce-bogus","1"),br}function insertBlock(blockName,node,before){var doc,blockNode,parentNode;return doc=node.ownerDocument,blockNode=doc.createElement(blockName),blockNode.setAttribute("data-mce-caret",before?"before":"after"),blockNode.setAttribute("data-mce-bogus","all"),blockNode.appendChild(createBogusBr()),parentNode=node.parentNode,before?parentNode.insertBefore(blockNode,node):node.nextSibling?parentNode.insertBefore(blockNode,node.nextSibling):parentNode.appendChild(blockNode),blockNode}function startsWithCaretContainer(node){return isText(node)&&node.data[0]==Zwsp.ZWSP}function endsWithCaretContainer(node){return isText(node)&&node.data[node.data.length-1]==Zwsp.ZWSP}function trimBogusBr(elm){var brs=elm.getElementsByTagName("br"),lastBr=brs[brs.length-1];NodeType.isBogus(lastBr)&&lastBr.parentNode.removeChild(lastBr)}function showCaretContainerBlock(caretContainer){return caretContainer&&caretContainer.hasAttribute("data-mce-caret")?(trimBogusBr(caretContainer),caretContainer.removeAttribute("data-mce-caret"),caretContainer.removeAttribute("data-mce-bogus"),caretContainer.removeAttribute("style"),caretContainer.removeAttribute("_moz_abspos"),caretContainer):null}var NodeType=tinymce.dom.NodeType,Zwsp=tinymce.text.Zwsp,isElement=NodeType.isElement,isText=NodeType.isText,hasContent=function(node){return node.firstChild!==node.lastChild||!NodeType.isBr(node.firstChild)};tinymce.caret.CaretContainer={isCaretContainer:isCaretContainer,isCaretContainerBlock:isCaretContainerBlock,isCaretContainerInline:isCaretContainerInline,showCaretContainerBlock:showCaretContainerBlock,insertInline:insertInline,insertBlock:insertBlock,hasContent:hasContent,startsWithCaretContainer:startsWithCaretContainer,endsWithCaretContainer:endsWithCaretContainer}}(tinymce),function(tinymce){function isCaretCandidate(node){return!isCaretContainer(node)&&(isText(node)?!isInvalidTextElement(node.parentNode):isAtomicInline(node)||isBr(node)||isTable(node)||isContentEditableFalse(node))}function isInEditable(node,rootNode){for(node=node.parentNode;node&&node!=rootNode;node=node.parentNode){if(isContentEditableFalse(node))return!1;if(isContentEditableTrue(node))return!0}return!0;
}function isAtomicContentEditableFalse(node){return!!isContentEditableFalse(node)&&Arr.reduce(node.getElementsByTagName("*"),function(result,elm){return result||isContentEditableTrue(elm)},!1)!==!0}function isAtomic(node){return isAtomicInline(node)||isAtomicContentEditableFalse(node)}function isEditableCaretCandidate(node,rootNode){return isCaretCandidate(node)&&isInEditable(node,rootNode)}var NodeType=tinymce.dom.NodeType,CaretContainer=tinymce.caret.CaretContainer,Arr=tinymce.util.Arr,isContentEditableTrue=NodeType.isContentEditableTrue,isContentEditableFalse=NodeType.isContentEditableFalse,isBr=NodeType.isBr,isText=NodeType.isText,isInvalidTextElement=NodeType.matchNodeNames("script style textarea"),isAtomicInline=NodeType.matchNodeNames("img input textarea hr iframe video audio object"),isTable=NodeType.matchNodeNames("table"),isCaretContainer=CaretContainer.isCaretContainer;tinymce.caret.CaretCandidate={isCaretCandidate:isCaretCandidate,isInEditable:isInEditable,isAtomic:isAtomic,isEditableCaretCandidate:isEditableCaretCandidate}}(tinymce),function(tinymce){var NodeType=tinymce.dom.NodeType,Zwsp=tinymce.text.Zwsp,CaretContainer=tinymce.caret.CaretContainer,CaretPosition=tinymce.caret.CaretPosition,Arr=tinymce.util.Arr,isElement=NodeType.isElement,isText=NodeType.isText,removeNode=function(node){var parentNode=node.parentNode;parentNode&&parentNode.removeChild(node)},getNodeValue=function(node){try{return node.nodeValue}catch(ex){return""}},setNodeValue=function(node,text){0===text.length?removeNode(node):node.nodeValue=text},trimCount=function(text){var trimmedText=Zwsp.trim(text);return{count:text.length-trimmedText.length,text:trimmedText}},removeUnchanged=function(caretContainer,pos){return remove(caretContainer),pos},removeTextAndReposition=function(caretContainer,pos){var before=trimCount(caretContainer.data.substr(0,pos.offset())),after=trimCount(caretContainer.data.substr(pos.offset())),text=before.text+after.text;return text.length>0?(setNodeValue(caretContainer,text),new CaretPosition(caretContainer,pos.offset()-before.count)):pos},removeElementAndReposition=function(caretContainer,pos){var parentNode=pos.container(),newPosition=Arr.indexOf(parentNode.childNodes,caretContainer).map(function(index){return index<pos.offset()?new CaretPosition(parentNode,pos.offset()-1):pos}).getOr(pos);return remove(caretContainer),newPosition},removeTextCaretContainer=function(caretContainer,pos){return pos.container()===caretContainer?removeTextAndReposition(caretContainer,pos):removeUnchanged(caretContainer,pos)},removeElementCaretContainer=function(caretContainer,pos){return pos.container()===caretContainer.parentNode?removeElementAndReposition(caretContainer,pos):removeUnchanged(caretContainer,pos)},removeAndReposition=function(container,pos){return CaretPosition.isTextPosition(pos)?removeTextCaretContainer(container,pos):removeElementCaretContainer(container,pos)},remove=function(caretContainerNode){if(isElement(caretContainerNode)&&CaretContainer.isCaretContainer(caretContainerNode)&&(CaretContainer.hasContent(caretContainerNode)?caretContainerNode.removeAttribute("data-mce-caret"):removeNode(caretContainerNode)),isText(caretContainerNode)){var text=Zwsp.trim(getNodeValue(caretContainerNode));setNodeValue(caretContainerNode,text)}};tinymce.caret.CaretContainerRemove={removeAndReposition:removeAndReposition,remove:remove}}(tinymce),function(tinymce){function createRange(doc){return"createRange"in doc?doc.createRange():DOMUtils.createRng()}function isWhiteSpace(chr){return chr&&/[\r\n\t ]/.test(chr)}function isHiddenWhiteSpaceRange(range){var text,container=range.startContainer,offset=range.startOffset;return!!(isWhiteSpace(range.toString())&&isNotPre(container.parentNode)&&(text=container.data,isWhiteSpace(text[offset-1])||isWhiteSpace(text[offset+1])))}function getCaretPositionClientRects(caretPosition){function getBoundingClientRect(item){var clientRect,clientRects;return clientRects=item.getClientRects(),clientRect=clientRects.length>0?ClientRect.clone(clientRects[0]):ClientRect.clone(item.getBoundingClientRect())}function collapseAndInflateWidth(clientRect,toStart){return clientRect=ClientRect.collapse(clientRect,toStart),clientRect.width=1,clientRect.right=clientRect.left+1,clientRect}function addUniqueAndValidRect(clientRect){0!==clientRect.height&&(clientRects.length>0&&ClientRect.isEqual(clientRect,clientRects[clientRects.length-1])||clientRects.push(clientRect))}function addCharacterOffset(container,offset){var range=createRange(container.ownerDocument);if(offset<container.data.length){if(ExtendingChar.isExtendingChar(container.data[offset]))return clientRects;if(ExtendingChar.isExtendingChar(container.data[offset-1])&&(range.setStart(container,offset),range.setEnd(container,offset+1),!isHiddenWhiteSpaceRange(range)))return addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect(range),!1)),clientRects}offset>0&&(range.setStart(container,offset-1),range.setEnd(container,offset),isHiddenWhiteSpaceRange(range)||addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect(range),!1))),offset<container.data.length&&(range.setStart(container,offset),range.setEnd(container,offset+1),isHiddenWhiteSpaceRange(range)||addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect(range),!0)))}var beforeNode,node,clientRects=[];if(isText(caretPosition.container()))return addCharacterOffset(caretPosition.container(),caretPosition.offset()),clientRects;if(isElement(caretPosition.container()))if(caretPosition.isAtEnd())node=resolveIndex(caretPosition.container(),caretPosition.offset()),isText(node)&&addCharacterOffset(node,node.data.length),isValidElementCaretCandidate(node)&&!isBr(node)&&addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect(node),!1));else{if(node=resolveIndex(caretPosition.container(),caretPosition.offset()),isText(node)&&addCharacterOffset(node,0),isValidElementCaretCandidate(node)&&caretPosition.isAtEnd())return addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect(node),!1)),clientRects;beforeNode=resolveIndex(caretPosition.container(),caretPosition.offset()-1),isValidElementCaretCandidate(beforeNode)&&!isBr(beforeNode)&&(isBlock(beforeNode)||isBlock(node)||!isValidElementCaretCandidate(node))&&addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect(beforeNode),!1)),isValidElementCaretCandidate(node)&&addUniqueAndValidRect(collapseAndInflateWidth(getBoundingClientRect(node),!0))}return clientRects}function CaretPosition(container,offset,clientRects){function isAtStart(){return isText(container)?0===offset:0===offset}function isAtEnd(){return isText(container)?offset>=container.data.length:offset>=container.childNodes.length}function toRange(){var range;return range=createRange(container.ownerDocument),range.setStart(container,offset),range.setEnd(container,offset),range}function getClientRects(){return clientRects||(clientRects=getCaretPositionClientRects(new CaretPosition(container,offset))),clientRects}function isVisible(){return getClientRects().length>0}function isEqual(caretPosition){return caretPosition&&container===caretPosition.container()&&offset===caretPosition.offset()}function getNode(before){return resolveIndex(container,before?offset-1:offset)}return{container:Fun.constant(container),offset:Fun.constant(offset),toRange:toRange,getClientRects:getClientRects,isVisible:isVisible,isAtStart:isAtStart,isAtEnd:isAtEnd,isEqual:isEqual,getNode:getNode}}var NodeType=tinymce.dom.NodeType,DOMUtils=tinymce.DOM,CaretCandidate=tinymce.caret.CaretCandidate,RangeUtils=tinymce.dom.RangeUtils,ClientRect=tinymce.geom.ClientRect,ExtendingChar=tinymce.text.ExtendingChar,Fun=tinymce.util.Fun,isElement=NodeType.isElement,isCaretCandidate=CaretCandidate.isCaretCandidate,isBlock=NodeType.matchStyleValues("display","block table"),isFloated=NodeType.matchStyleValues("float","left right"),isValidElementCaretCandidate=Fun.and(isElement,isCaretCandidate,Fun.negate(isFloated)),isNotPre=Fun.negate(NodeType.matchStyleValues("white-space","pre pre-line pre-wrap")),isText=NodeType.isText,isBr=NodeType.isBr,nodeIndex=DOMUtils.nodeIndex,resolveIndex=RangeUtils.getNode;CaretPosition.fromRangeStart=function(range){return new CaretPosition(range.startContainer,range.startOffset)},CaretPosition.fromRangeEnd=function(range){return new CaretPosition(range.endContainer,range.endOffset)},CaretPosition.after=function(node){return new CaretPosition(node.parentNode,nodeIndex(node)+1)},CaretPosition.before=function(node){return new CaretPosition(node.parentNode,nodeIndex(node))},tinymce.caret.CaretPosition=CaretPosition}(tinymce),function(tinymce){function isForwards(direction){return direction>0}function isBackwards(direction){return direction<0}function skipCaretContainers(walk,shallow){for(var node;node=walk(shallow);)if(!isCaretContainerBlock(node))return node;return null}function findNode(node,direction,predicateFn,rootNode,shallow){var walker=new TreeWalker(node,rootNode);if(isBackwards(direction)){if((isContentEditableFalse(node)||isCaretContainerBlock(node))&&(node=skipCaretContainers(walker.prev,!0),predicateFn(node)))return node;for(;node=skipCaretContainers(walker.prev,shallow);)if(predicateFn(node))return node}if(isForwards(direction)){if((isContentEditableFalse(node)||isCaretContainerBlock(node))&&(node=skipCaretContainers(walker.next,!0),predicateFn(node)))return node;for(;node=skipCaretContainers(walker.next,shallow);)if(predicateFn(node))return node}return null}function getEditingHost(node,rootNode){for(node=node.parentNode;node&&node!=rootNode;node=node.parentNode)if(isContentEditableTrue(node))return node;return rootNode}function getParentBlock(node,rootNode){for(;node&&node!=rootNode;){if(isBlockLike(node))return node;node=node.parentNode}return null}function isInSameBlock(caretPosition1,caretPosition2,rootNode){return getParentBlock(caretPosition1.container(),rootNode)==getParentBlock(caretPosition2.container(),rootNode)}function isInSameEditingHost(caretPosition1,caretPosition2,rootNode){return getEditingHost(caretPosition1.container(),rootNode)==getEditingHost(caretPosition2.container(),rootNode)}function getChildNodeAtRelativeOffset(relativeOffset,caretPosition){var container,offset;return caretPosition?(container=caretPosition.container(),offset=caretPosition.offset(),isElement(container)?container.childNodes[offset+relativeOffset]:null):null}function beforeAfter(before,node){var range=node.ownerDocument.createRange();return before?(range.setStartBefore(node),range.setEndBefore(node)):(range.setStartAfter(node),range.setEndAfter(node)),range}function isNodesInSameBlock(rootNode,node1,node2){return getParentBlock(node1,rootNode)==getParentBlock(node2,rootNode)}function lean(left,rootNode,node){var sibling,siblingName;for(siblingName=left?"previousSibling":"nextSibling";node&&node!=rootNode;){if(sibling=node[siblingName],isCaretContainer(sibling)&&(sibling=sibling[siblingName]),isContentEditableFalse(sibling)){if(isNodesInSameBlock(rootNode,sibling,node))return sibling;break}if(isCaretCandidate(sibling))break;node=node.parentNode}return null}function normalizeRange(direction,rootNode,range){var node,container,offset,location,leanLeft=curry(lean,!0,rootNode),leanRight=curry(lean,!1,rootNode);if(container=range.startContainer,offset=range.startOffset,CaretContainer.isCaretContainerBlock(container)){if(isElement(container)||(container=container.parentNode),location=container.getAttribute("data-mce-caret"),"before"==location&&(node=container.nextSibling,isContentEditableFalse(node)))return before(node);if("after"==location&&(node=container.previousSibling,isContentEditableFalse(node)))return after(node)}if(!range.collapsed)return range;if(NodeType.isText(container)){if(isCaretContainer(container)){if(1===direction){if(node=leanRight(container))return before(node);if(node=leanLeft(container))return after(node)}if(direction===-1){if(node=leanLeft(container))return after(node);if(node=leanRight(container))return before(node)}return range}if(CaretContainer.endsWithCaretContainer(container)&&offset>=container.data.length-1)return 1===direction&&(node=leanRight(container))?before(node):range;if(CaretContainer.startsWithCaretContainer(container)&&offset<=1)return direction===-1&&(node=leanLeft(container))?after(node):range;if(offset===container.data.length)return node=leanRight(container),node?before(node):range;if(0===offset)return node=leanLeft(container),node?after(node):range}return range}function isNextToContentEditableFalse(relativeOffset,caretPosition){return isContentEditableFalse(getChildNodeAtRelativeOffset(relativeOffset,caretPosition))}var NodeType=tinymce.dom.NodeType,TreeWalker=tinymce.dom.TreeWalker,CaretContainer=tinymce.caret.CaretContainer,CaretCandidate=tinymce.caret.CaretCandidate,Fun=tinymce.util.Fun,isContentEditableTrue=NodeType.isContentEditableTrue,isContentEditableFalse=NodeType.isContentEditableFalse,isBlockLike=NodeType.matchStyleValues("display","block table table-cell table-caption"),isCaretContainer=CaretContainer.isCaretContainer,isCaretContainerBlock=CaretContainer.isCaretContainerBlock,curry=Fun.curry,isElement=NodeType.isElement,isCaretCandidate=CaretCandidate.isCaretCandidate,before=curry(beforeAfter,!0),after=curry(beforeAfter,!1);tinymce.caret.CaretUtils={isForwards:isForwards,isBackwards:isBackwards,findNode:findNode,getEditingHost:getEditingHost,getParentBlock:getParentBlock,isInSameBlock:isInSameBlock,isInSameEditingHost:isInSameEditingHost,isBeforeContentEditableFalse:curry(isNextToContentEditableFalse,0),isAfterContentEditableFalse:curry(isNextToContentEditableFalse,-1),normalizeRange:normalizeRange}}(tinymce),function(tinymce){function getParents(node,rootNode){for(var parents=[];node&&node!=rootNode;)parents.push(node),node=node.parentNode;return parents}function nodeAtIndex(container,offset){return container.hasChildNodes()&&offset<container.childNodes.length?container.childNodes[offset]:null}function getCaretCandidatePosition(direction,node){if(isForwards(direction)){if(isCaretCandidate(node.previousSibling)&&!isText(node.previousSibling))return CaretPosition.before(node);if(isText(node))return CaretPosition(node,0)}if(isBackwards(direction)){if(isCaretCandidate(node.nextSibling)&&!isText(node.nextSibling))return CaretPosition.after(node);if(isText(node))return CaretPosition(node,node.data.length)}return isBackwards(direction)?isBr(node)?CaretPosition.before(node):CaretPosition.after(node):CaretPosition.before(node)}function isBrBeforeBlock(node,rootNode){var next;return!!NodeType.isBr(node)&&(next=findCaretPosition(1,CaretPosition.after(node),rootNode),!!next&&!CaretUtils.isInSameBlock(CaretPosition.before(node),CaretPosition.before(next),rootNode))}function findCaretPosition(direction,startCaretPosition,rootNode){var container,offset,node,nextNode,innerNode,rootContentEditableFalseElm,caretPosition;if(!isElement(rootNode)||!startCaretPosition)return null;if(caretPosition=startCaretPosition,container=caretPosition.container(),offset=caretPosition.offset(),isText(container)){if(isBackwards(direction)&&offset>0)return CaretPosition(container,--offset);if(isForwards(direction)&&offset<container.length)return CaretPosition(container,++offset);node=container}else{if(isBackwards(direction)&&offset>0&&(nextNode=nodeAtIndex(container,offset-1),isCaretCandidate(nextNode)))return!isAtomic(nextNode)&&(innerNode=CaretUtils.findNode(nextNode,direction,isEditableCaretCandidate,nextNode))?isText(innerNode)?CaretPosition(innerNode,innerNode.data.length):CaretPosition.after(innerNode):isText(nextNode)?CaretPosition(nextNode,nextNode.data.length):CaretPosition.before(nextNode);if(isForwards(direction)&&offset<container.childNodes.length&&(nextNode=nodeAtIndex(container,offset),isCaretCandidate(nextNode)))return isBrBeforeBlock(nextNode,rootNode)?findCaretPosition(direction,CaretPosition.after(nextNode),rootNode):!isAtomic(nextNode)&&(innerNode=CaretUtils.findNode(nextNode,direction,isEditableCaretCandidate,nextNode))?isText(innerNode)?CaretPosition(innerNode,0):CaretPosition.before(innerNode):isText(nextNode)?CaretPosition(nextNode,0):CaretPosition.after(nextNode);node=caretPosition.getNode()}return(isForwards(direction)&&caretPosition.isAtEnd()||isBackwards(direction)&&caretPosition.isAtStart())&&(node=CaretUtils.findNode(node,direction,Fun.constant(!0),rootNode,!0),isEditableCaretCandidate(node))?getCaretCandidatePosition(direction,node):(nextNode=CaretUtils.findNode(node,direction,isEditableCaretCandidate,rootNode),rootContentEditableFalseElm=Arr.last(Arr.filter(getParents(container,rootNode),isContentEditableFalse)),!rootContentEditableFalseElm||nextNode&&rootContentEditableFalseElm.contains(nextNode)?nextNode?getCaretCandidatePosition(direction,nextNode):null:caretPosition=isForwards(direction)?CaretPosition.after(rootContentEditableFalseElm):CaretPosition.before(rootContentEditableFalseElm))}var NodeType=tinymce.dom.NodeType,CaretPosition=tinymce.caret.CaretPosition,CaretUtils=tinymce.caret.CaretUtils,CaretCandidate=tinymce.caret.CaretCandidate,Arr=tinymce.util.Arr,Fun=tinymce.util.Fun,isContentEditableFalse=NodeType.isContentEditableFalse,isText=NodeType.isText,isElement=NodeType.isElement,isBr=NodeType.isBr,isForwards=CaretUtils.isForwards,isBackwards=CaretUtils.isBackwards,isCaretCandidate=CaretCandidate.isCaretCandidate,isAtomic=CaretCandidate.isAtomic,isEditableCaretCandidate=CaretCandidate.isEditableCaretCandidate;tinymce.caret.CaretWalker=function(rootNode){return{next:function(caretPosition){return findCaretPosition(1,caretPosition,rootNode)},prev:function(caretPosition){return findCaretPosition(-1,caretPosition,rootNode)}}}}(tinymce),function(tinymce){var NodeType=tinymce.dom.NodeType,DOM=tinymce.DOM,ClientRect=tinymce.geom.ClientRect,CaretContainer=tinymce.caret.CaretContainer,CaretContainerRemove=tinymce.caret.CaretContainerRemove,isContentEditableFalse=NodeType.isContentEditableFalse;tinymce.caret.FakeCaret=function(rootNode,isBlock){function getAbsoluteClientRect(node,before){var docElm,scrollX,scrollY,margin,rootRect,clientRect=ClientRect.collapse(node.getBoundingClientRect(),before);return"BODY"==rootNode.tagName?(docElm=rootNode.ownerDocument.documentElement,scrollX=rootNode.scrollLeft||docElm.scrollLeft,scrollY=rootNode.scrollTop||docElm.scrollTop):(rootRect=rootNode.getBoundingClientRect(),scrollX=rootNode.scrollLeft-rootRect.left,scrollY=rootNode.scrollTop-rootRect.top),clientRect.left+=scrollX,clientRect.right+=scrollX,clientRect.top+=scrollY,clientRect.bottom+=scrollY,clientRect.width=1,margin=node.offsetWidth-node.clientWidth,margin>0&&(before&&(margin*=-1),clientRect.left+=margin,clientRect.right+=margin),clientRect}function trimInlineCaretContainers(){var contentEditableFalseNodes,node,sibling,i,data;for(contentEditableFalseNodes=DOM.select("*[contentEditable=false]",rootNode),i=0;i<contentEditableFalseNodes.length;i++)node=contentEditableFalseNodes[i],sibling=node.previousSibling,CaretContainer.endsWithCaretContainer(sibling)&&(data=sibling.data,1==data.length?sibling.parentNode.removeChild(sibling):sibling.deleteData(data.length-1,1)),sibling=node.nextSibling,CaretContainer.startsWithCaretContainer(sibling)&&(data=sibling.data,1==data.length?sibling.parentNode.removeChild(sibling):sibling.deleteData(0,1));return null}function show(before,node){var clientRect,rng;return hide(),isBlock(node)?(caretContainerNode=CaretContainer.insertBlock("p",node,before),clientRect=getAbsoluteClientRect(node,before),DOM.setStyle(caretContainerNode,"top",clientRect.top),$lastVisualCaret=DOM.add(rootNode,"div",{class:"mce-visual-caret","data-mce-bogus":"all",style:clientRect}),before&&DOM.addClass($lastVisualCaret,"mce-visual-caret-before"),startBlink(),rng=node.ownerDocument.createRange(),rng.setStart(caretContainerNode,0),rng.setEnd(caretContainerNode,0),rng):(caretContainerNode=CaretContainer.insertInline(node,before),rng=node.ownerDocument.createRange(),isContentEditableFalse(caretContainerNode.nextSibling)?(rng.setStart(caretContainerNode,0),rng.setEnd(caretContainerNode,0)):(rng.setStart(caretContainerNode,1),rng.setEnd(caretContainerNode,1)),rng)}function hide(){trimInlineCaretContainers(),caretContainerNode&&(CaretContainerRemove.remove(caretContainerNode),caretContainerNode=null),$lastVisualCaret&&(DOM.remove($lastVisualCaret),$lastVisualCaret=null),clearInterval(cursorInterval)}function startBlink(){cursorInterval=setInterval(function(){var caret=DOM.select("div.mce-visual-caret",rootNode)[0];hasFocus()?DOM.toggleClass(caret,"mce-visual-caret-hidden"):DOM.addClass(caret,"mce-visual-caret-hidden")},500)}function destroy(){clearInterval(cursorInterval)}function getCss(){return".mce-visual-caret {position: absolute;background-color: black;background-color: currentcolor;}.mce-visual-caret-hidden {display: none;}*[data-mce-caret] {position: absolute;left: -1000px;right: auto;top: 0;margin: 0;padding: 0;}"}var cursorInterval,$lastVisualCaret,caretContainerNode,hasFocus=function(){return rootNode.ownerDocument.activeElement===rootNode};return{show:show,hide:hide,getCss:getCss,destroy:destroy}}}(tinymce),function(tinymce){function distanceToRectLeft(clientRect,clientX){return Math.abs(clientRect.left-clientX)}function distanceToRectRight(clientRect,clientX){return Math.abs(clientRect.right-clientX)}function findClosestClientRect(clientRects,clientX){function isInside(clientX,clientRect){return clientX>=clientRect.left&&clientX<=clientRect.right}return Arr.reduce(clientRects,function(oldClientRect,clientRect){var oldDistance,newDistance;return oldDistance=Math.min(distanceToRectLeft(oldClientRect,clientX),distanceToRectRight(oldClientRect,clientX)),newDistance=Math.min(distanceToRectLeft(clientRect,clientX),distanceToRectRight(clientRect,clientX)),isInside(clientX,clientRect)?clientRect:isInside(clientX,oldClientRect)?oldClientRect:newDistance==oldDistance&&isContentEditableFalse(clientRect.node)?clientRect:newDistance<oldDistance?clientRect:oldClientRect})}function walkUntil(direction,rootNode,predicateFn,node){for(;node=findNode(node,direction,CaretCandidate.isEditableCaretCandidate,rootNode);)if(predicateFn(node))return}function findLineNodeRects(rootNode,targetNodeRect){function collect(checkPosFn,node){var lineRects;return lineRects=Arr.filter(Dimensions.getClientRects(node),function(clientRect){return!checkPosFn(clientRect,targetNodeRect)}),clientRects=clientRects.concat(lineRects),0===lineRects.length}var clientRects=[];return clientRects.push(targetNodeRect),walkUntil(-1,rootNode,curry(collect,ClientRect.isAbove),targetNodeRect.node),walkUntil(1,rootNode,curry(collect,ClientRect.isBelow),targetNodeRect.node),clientRects}function getContentEditableFalseChildren(rootNode){return Arr.filter(Arr.toArray(rootNode.getElementsByTagName("*")),isContentEditableFalse)}function caretInfo(clientRect,clientX){return{node:clientRect.node,before:distanceToRectLeft(clientRect,clientX)<distanceToRectRight(clientRect,clientX)}}function closestCaret(rootNode,clientX,clientY){var contentEditableFalseNodeRects,closestNodeRect;return contentEditableFalseNodeRects=Dimensions.getClientRects(getContentEditableFalseChildren(rootNode)),contentEditableFalseNodeRects=Arr.filter(contentEditableFalseNodeRects,function(clientRect){return clientY>=clientRect.top&&clientY<=clientRect.bottom}),closestNodeRect=findClosestClientRect(contentEditableFalseNodeRects,clientX),closestNodeRect&&(closestNodeRect=findClosestClientRect(findLineNodeRects(rootNode,closestNodeRect),clientX),closestNodeRect&&isContentEditableFalse(closestNodeRect.node))?caretInfo(closestNodeRect,clientX):null}var NodeType=tinymce.dom.NodeType,Fun=tinymce.util.Fun,Arr=tinymce.util.Arr,Dimensions=tinymce.dom.Dimensions,ClientRect=tinymce.geom.ClientRect,CaretUtils=tinymce.caret.CaretUtils,CaretCandidate=tinymce.caret.CaretCandidate,isContentEditableFalse=NodeType.isContentEditableFalse,findNode=CaretUtils.findNode,curry=Fun.curry;tinymce.caret.LineUtils={findClosestClientRect:findClosestClientRect,findLineNodeRects:findLineNodeRects,closestCaret:closestCaret}}(tinymce),function(tinymce){function findUntil(direction,rootNode,predicateFn,node){for(;node=CaretUtils.findNode(node,direction,CaretCandidate.isEditableCaretCandidate,rootNode);)if(predicateFn(node))return}function walkUntil(direction,isAboveFn,isBeflowFn,rootNode,predicateFn,caretPosition){function add(node){var i,clientRect,clientRects;for(clientRects=Dimensions.getClientRects(node),direction==-1&&(clientRects=clientRects.reverse()),i=0;i<clientRects.length;i++)if(clientRect=clientRects[i],!isBeflowFn(clientRect,targetClientRect)){if(result.length>0&&isAboveFn(clientRect,Arr.last(result))&&line++,clientRect.line=line,predicateFn(clientRect))return!0;result.push(clientRect)}}var node,targetClientRect,line=0,result=[];return(targetClientRect=Arr.last(caretPosition.getClientRects()))?(node=caretPosition.getNode(),add(node),findUntil(direction,rootNode,add,node),result):result}function aboveLineNumber(lineNumber,clientRect){return clientRect.line>lineNumber}function isLine(lineNumber,clientRect){return clientRect.line===lineNumber}function positionsUntil(direction,rootNode,predicateFn,node){function getClientRect(caretPosition){return 1==direction?Arr.last(caretPosition.getClientRects()):Arr.last(caretPosition.getClientRects())}var walkFn,isBelowFn,isAboveFn,caretPosition,clientRect,targetClientRect,caretWalker=new CaretWalker(rootNode),result=[],line=0;1==direction?(walkFn=caretWalker.next,isBelowFn=ClientRect.isBelow,isAboveFn=ClientRect.isAbove,caretPosition=CaretPosition.after(node)):(walkFn=caretWalker.prev,isBelowFn=ClientRect.isAbove,isAboveFn=ClientRect.isBelow,caretPosition=CaretPosition.before(node)),targetClientRect=getClientRect(caretPosition);do if(caretPosition.isVisible()&&(clientRect=getClientRect(caretPosition),!isAboveFn(clientRect,targetClientRect))){if(result.length>0&&isBelowFn(clientRect,Arr.last(result))&&line++,clientRect=ClientRect.clone(clientRect),clientRect.position=caretPosition,clientRect.line=line,predicateFn(clientRect))return result;result.push(clientRect)}while(caretPosition=walkFn(caretPosition));return result}var Fun=tinymce.util.Fun,Arr=tinymce.util.Arr,Dimensions=tinymce.dom.Dimensions,ClientRect=tinymce.geom.ClientRect,CaretUtils=tinymce.caret.CaretUtils,CaretCandidate=tinymce.caret.CaretCandidate,CaretWalker=tinymce.caret.CaretWalker,CaretPosition=tinymce.caret.CaretPosition,curry=Fun.curry,upUntil=curry(walkUntil,-1,ClientRect.isAbove,ClientRect.isBelow),downUntil=curry(walkUntil,1,ClientRect.isBelow,ClientRect.isAbove);tinymce.caret.LineWalker={upUntil:upUntil,downUntil:downUntil,positionsUntil:positionsUntil,isAboveLine:curry(aboveLineNumber),isLine:curry(isLine)}}(tinymce),function(tinymce){function Sizzle(selector,context,results,seed){var match,elem,m,nodeType,i,groups,old,nid,newContext,newSelector;if((context?context.ownerDocument||context:preferredDoc)!==document&&setDocument(context),context=context||document,results=results||[],!selector||"string"!=typeof selector)return results;if(1!==(nodeType=context.nodeType)&&9!==nodeType)return[];if(documentIsHTML&&!seed){if(match=rquickExpr.exec(selector))if(m=match[1]){if(9===nodeType){if(elem=context.getElementById(m),!elem||!elem.parentNode)return results;if(elem.id===m)return results.push(elem),results}else if(context.ownerDocument&&(elem=context.ownerDocument.getElementById(m))&&contains(context,elem)&&elem.id===m)return results.push(elem),results}else{if(match[2])return push.apply(results,context.getElementsByTagName(selector)),results;if((m=match[3])&&support.getElementsByClassName)return push.apply(results,context.getElementsByClassName(m)),results}if(support.qsa&&(!rbuggyQSA||!rbuggyQSA.test(selector))){if(nid=old=expando,newContext=context,newSelector=9===nodeType&&selector,1===nodeType&&"object"!==context.nodeName.toLowerCase()){for(groups=tokenize(selector),(old=context.getAttribute("id"))?nid=old.replace(rescape,"\\$&"):context.setAttribute("id",nid),nid="[id='"+nid+"'] ",i=groups.length;i--;)groups[i]=nid+toSelector(groups[i]);newContext=rsibling.test(selector)&&testContext(context.parentNode)||context,newSelector=groups.join(",")}if(newSelector)try{return push.apply(results,newContext.querySelectorAll(newSelector)),results}catch(qsaError){}finally{old||context.removeAttribute("id")}}}return select(selector.replace(rtrim,"$1"),context,results,seed)}function createCache(){function cache(key,value){return keys.push(key+" ")>Expr.cacheLength&&delete cache[keys.shift()],cache[key+" "]=value}var keys=[];return cache}function markFunction(fn){return fn[expando]=!0,fn}function assert(fn){var div=document.createElement("div");try{return!!fn(div)}catch(e){return!1}finally{div.parentNode&&div.parentNode.removeChild(div),div=null}}function addHandle(attrs,handler){for(var arr=attrs.split("|"),i=attrs.length;i--;)Expr.attrHandle[arr[i]]=handler}function siblingCheck(a,b){var cur=b&&a,diff=cur&&1===a.nodeType&&1===b.nodeType&&(~b.sourceIndex||MAX_NEGATIVE)-(~a.sourceIndex||MAX_NEGATIVE);if(diff)return diff;if(cur)for(;cur=cur.nextSibling;)if(cur===b)return-1;return a?1:-1}function createInputPseudo(type){return function(elem){var name=elem.nodeName.toLowerCase();return"input"===name&&elem.type===type}}function createButtonPseudo(type){return function(elem){var name=elem.nodeName.toLowerCase();return("input"===name||"button"===name)&&elem.type===type}}function createPositionalPseudo(fn){return markFunction(function(argument){return argument=+argument,markFunction(function(seed,matches){for(var j,matchIndexes=fn([],seed.length,argument),i=matchIndexes.length;i--;)seed[j=matchIndexes[i]]&&(seed[j]=!(matches[j]=seed[j]))})})}function testContext(context){return context&&typeof context.getElementsByTagName!==strundefined&&context}function setFilters(){}function toSelector(tokens){for(var i=0,len=tokens.length,selector="";i<len;i++)selector+=tokens[i].value;return selector}function addCombinator(matcher,combinator,base){var dir=combinator.dir,checkNonElements=base&&"parentNode"===dir,doneName=done++;return combinator.first?function(elem,context,xml){for(;elem=elem[dir];)if(1===elem.nodeType||checkNonElements)return matcher(elem,context,xml)}:function(elem,context,xml){var oldCache,outerCache,newCache=[dirruns,doneName];if(xml){for(;elem=elem[dir];)if((1===elem.nodeType||checkNonElements)&&matcher(elem,context,xml))return!0}else for(;elem=elem[dir];)if(1===elem.nodeType||checkNonElements){if(outerCache=elem[expando]||(elem[expando]={}),(oldCache=outerCache[dir])&&oldCache[0]===dirruns&&oldCache[1]===doneName)return newCache[2]=oldCache[2];if(outerCache[dir]=newCache,newCache[2]=matcher(elem,context,xml))return!0}}}function elementMatcher(matchers){return matchers.length>1?function(elem,context,xml){for(var i=matchers.length;i--;)if(!matchers[i](elem,context,xml))return!1;return!0}:matchers[0]}function multipleContexts(selector,contexts,results){for(var i=0,len=contexts.length;i<len;i++)Sizzle(selector,contexts[i],results);return results}function condense(unmatched,map,filter,context,xml){for(var elem,newUnmatched=[],i=0,len=unmatched.length,mapped=null!=map;i<len;i++)(elem=unmatched[i])&&(filter&&!filter(elem,context,xml)||(newUnmatched.push(elem),mapped&&map.push(i)));return newUnmatched}function setMatcher(preFilter,selector,matcher,postFilter,postFinder,postSelector){return postFilter&&!postFilter[expando]&&(postFilter=setMatcher(postFilter)),postFinder&&!postFinder[expando]&&(postFinder=setMatcher(postFinder,postSelector)),markFunction(function(seed,results,context,xml){var temp,i,elem,preMap=[],postMap=[],preexisting=results.length,elems=seed||multipleContexts(selector||"*",context.nodeType?[context]:context,[]),matcherIn=!preFilter||!seed&&selector?elems:condense(elems,preMap,preFilter,context,xml),matcherOut=matcher?postFinder||(seed?preFilter:preexisting||postFilter)?[]:results:matcherIn;if(matcher&&matcher(matcherIn,matcherOut,context,xml),postFilter)for(temp=condense(matcherOut,postMap),postFilter(temp,[],context,xml),
i=temp.length;i--;)(elem=temp[i])&&(matcherOut[postMap[i]]=!(matcherIn[postMap[i]]=elem));if(seed){if(postFinder||preFilter){if(postFinder){for(temp=[],i=matcherOut.length;i--;)(elem=matcherOut[i])&&temp.push(matcherIn[i]=elem);postFinder(null,matcherOut=[],temp,xml)}for(i=matcherOut.length;i--;)(elem=matcherOut[i])&&(temp=postFinder?indexOf.call(seed,elem):preMap[i])>-1&&(seed[temp]=!(results[temp]=elem))}}else matcherOut=condense(matcherOut===results?matcherOut.splice(preexisting,matcherOut.length):matcherOut),postFinder?postFinder(null,results,matcherOut,xml):push.apply(results,matcherOut)})}function matcherFromTokens(tokens){for(var checkContext,matcher,j,len=tokens.length,leadingRelative=Expr.relative[tokens[0].type],implicitRelative=leadingRelative||Expr.relative[" "],i=leadingRelative?1:0,matchContext=addCombinator(function(elem){return elem===checkContext},implicitRelative,!0),matchAnyContext=addCombinator(function(elem){return indexOf.call(checkContext,elem)>-1},implicitRelative,!0),matchers=[function(elem,context,xml){return!leadingRelative&&(xml||context!==outermostContext)||((checkContext=context).nodeType?matchContext(elem,context,xml):matchAnyContext(elem,context,xml))}];i<len;i++)if(matcher=Expr.relative[tokens[i].type])matchers=[addCombinator(elementMatcher(matchers),matcher)];else{if(matcher=Expr.filter[tokens[i].type].apply(null,tokens[i].matches),matcher[expando]){for(j=++i;j<len&&!Expr.relative[tokens[j].type];j++);return setMatcher(i>1&&elementMatcher(matchers),i>1&&toSelector(tokens.slice(0,i-1).concat({value:" "===tokens[i-2].type?"*":""})).replace(rtrim,"$1"),matcher,i<j&&matcherFromTokens(tokens.slice(i,j)),j<len&&matcherFromTokens(tokens=tokens.slice(j)),j<len&&toSelector(tokens))}matchers.push(matcher)}return elementMatcher(matchers)}function matcherFromGroupMatchers(elementMatchers,setMatchers){var bySet=setMatchers.length>0,byElement=elementMatchers.length>0,superMatcher=function(seed,context,xml,results,outermost){var elem,j,matcher,matchedCount=0,i="0",unmatched=seed&&[],setMatched=[],contextBackup=outermostContext,elems=seed||byElement&&Expr.find.TAG("*",outermost),dirrunsUnique=dirruns+=null==contextBackup?1:Math.random()||.1,len=elems.length;for(outermost&&(outermostContext=context!==document&&context);i!==len&&null!=(elem=elems[i]);i++){if(byElement&&elem){for(j=0;matcher=elementMatchers[j++];)if(matcher(elem,context,xml)){results.push(elem);break}outermost&&(dirruns=dirrunsUnique)}bySet&&((elem=!matcher&&elem)&&matchedCount--,seed&&unmatched.push(elem))}if(matchedCount+=i,bySet&&i!==matchedCount){for(j=0;matcher=setMatchers[j++];)matcher(unmatched,setMatched,context,xml);if(seed){if(matchedCount>0)for(;i--;)unmatched[i]||setMatched[i]||(setMatched[i]=pop.call(results));setMatched=condense(setMatched)}push.apply(results,setMatched),outermost&&!seed&&setMatched.length>0&&matchedCount+setMatchers.length>1&&Sizzle.uniqueSort(results)}return outermost&&(dirruns=dirrunsUnique,outermostContext=contextBackup),unmatched};return bySet?markFunction(superMatcher):superMatcher}var i,support,Expr,getText,isXML,tokenize,compile,select,outermostContext,sortInput,hasDuplicate,setDocument,document,docElem,documentIsHTML,rbuggyQSA,rbuggyMatches,matches,contains,expando="sizzle"+-new Date,preferredDoc=window.document,dirruns=0,done=0,classCache=createCache(),tokenCache=createCache(),compilerCache=createCache(),sortOrder=function(a,b){return a===b&&(hasDuplicate=!0),0},strundefined="undefined",MAX_NEGATIVE=1<<31,hasOwn={}.hasOwnProperty,arr=[],pop=arr.pop,push_native=arr.push,push=arr.push,slice=arr.slice,indexOf=arr.indexOf||function(elem){for(var i=0,len=this.length;i<len;i++)if(this[i]===elem)return i;return-1},booleans="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",whitespace="[\\x20\\t\\r\\n\\f]",identifier="(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",attributes="\\["+whitespace+"*("+identifier+")(?:"+whitespace+"*([*^$|!~]?=)"+whitespace+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+identifier+"))|)"+whitespace+"*\\]",pseudos=":("+identifier+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+attributes+")*)|.*)\\)|)",rtrim=new RegExp("^"+whitespace+"+|((?:^|[^\\\\])(?:\\\\.)*)"+whitespace+"+$","g"),rcomma=new RegExp("^"+whitespace+"*,"+whitespace+"*"),rcombinators=new RegExp("^"+whitespace+"*([>+~]|"+whitespace+")"+whitespace+"*"),rattributeQuotes=new RegExp("="+whitespace+"*([^\\]'\"]*?)"+whitespace+"*\\]","g"),rpseudo=new RegExp(pseudos),ridentifier=new RegExp("^"+identifier+"$"),matchExpr={ID:new RegExp("^#("+identifier+")"),CLASS:new RegExp("^\\.("+identifier+")"),TAG:new RegExp("^("+identifier+"|[*])"),ATTR:new RegExp("^"+attributes),PSEUDO:new RegExp("^"+pseudos),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+whitespace+"*(even|odd|(([+-]|)(\\d*)n|)"+whitespace+"*(?:([+-]|)"+whitespace+"*(\\d+)|))"+whitespace+"*\\)|)","i"),bool:new RegExp("^(?:"+booleans+")$","i"),needsContext:new RegExp("^"+whitespace+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+whitespace+"*((?:-\\d)?\\d*)"+whitespace+"*\\)|)(?=[^-]|$)","i")},rinputs=/^(?:input|select|textarea|button)$/i,rheader=/^h\d$/i,rnative=/^[^{]+\{\s*\[native \w/,rquickExpr=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,rsibling=/[+~]/,rescape=/'|\\/g,runescape=new RegExp("\\\\([\\da-f]{1,6}"+whitespace+"?|("+whitespace+")|.)","ig"),funescape=function(_,escaped,escapedWhitespace){var high="0x"+escaped-65536;return high!==high||escapedWhitespace?escaped:high<0?String.fromCharCode(high+65536):String.fromCharCode(high>>10|55296,1023&high|56320)};try{push.apply(arr=slice.call(preferredDoc.childNodes),preferredDoc.childNodes),arr[preferredDoc.childNodes.length].nodeType}catch(e){push={apply:arr.length?function(target,els){push_native.apply(target,slice.call(els))}:function(target,els){for(var j=target.length,i=0;target[j++]=els[i++];);target.length=j-1}}}support=Sizzle.support={},isXML=Sizzle.isXML=function(elem){var documentElement=elem&&(elem.ownerDocument||elem).documentElement;return!!documentElement&&"HTML"!==documentElement.nodeName},setDocument=Sizzle.setDocument=function(node){function getTop(win){try{return win.top}catch(ex){}return null}var hasCompare,doc=node?node.ownerDocument||node:preferredDoc,parent=doc.defaultView;return doc!==document&&9===doc.nodeType&&doc.documentElement?(document=doc,docElem=doc.documentElement,documentIsHTML=!isXML(doc),parent&&parent!==getTop(parent)&&(parent.addEventListener?parent.addEventListener("unload",function(){setDocument()},!1):parent.attachEvent&&parent.attachEvent("onunload",function(){setDocument()})),support.attributes=assert(function(div){return div.className="i",!div.getAttribute("className")}),support.getElementsByTagName=assert(function(div){return div.appendChild(doc.createComment("")),!div.getElementsByTagName("*").length}),support.getElementsByClassName=rnative.test(doc.getElementsByClassName),support.getById=assert(function(div){return docElem.appendChild(div).id=expando,!doc.getElementsByName||!doc.getElementsByName(expando).length}),support.getById?(Expr.find.ID=function(id,context){if(typeof context.getElementById!==strundefined&&documentIsHTML){var m=context.getElementById(id);return m&&m.parentNode?[m]:[]}},Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){return elem.getAttribute("id")===attrId}}):(delete Expr.find.ID,Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){var node=typeof elem.getAttributeNode!==strundefined&&elem.getAttributeNode("id");return node&&node.value===attrId}}),Expr.find.TAG=support.getElementsByTagName?function(tag,context){if(typeof context.getElementsByTagName!==strundefined)return context.getElementsByTagName(tag)}:function(tag,context){var elem,tmp=[],i=0,results=context.getElementsByTagName(tag);if("*"===tag){for(;elem=results[i++];)1===elem.nodeType&&tmp.push(elem);return tmp}return results},Expr.find.CLASS=support.getElementsByClassName&&function(className,context){if(documentIsHTML)return context.getElementsByClassName(className)},rbuggyMatches=[],rbuggyQSA=[],(support.qsa=rnative.test(doc.querySelectorAll))&&(assert(function(div){div.innerHTML="<select msallowcapture=''><option selected=''></option></select>",div.querySelectorAll("[msallowcapture^='']").length&&rbuggyQSA.push("[*^$]="+whitespace+"*(?:''|\"\")"),div.querySelectorAll("[selected]").length||rbuggyQSA.push("\\["+whitespace+"*(?:value|"+booleans+")"),div.querySelectorAll(":checked").length||rbuggyQSA.push(":checked")}),assert(function(div){var input=doc.createElement("input");input.setAttribute("type","hidden"),div.appendChild(input).setAttribute("name","D"),div.querySelectorAll("[name=d]").length&&rbuggyQSA.push("name"+whitespace+"*[*^$|!~]?="),div.querySelectorAll(":enabled").length||rbuggyQSA.push(":enabled",":disabled"),div.querySelectorAll("*,:x"),rbuggyQSA.push(",.*:")})),(support.matchesSelector=rnative.test(matches=docElem.matches||docElem.webkitMatchesSelector||docElem.mozMatchesSelector||docElem.oMatchesSelector||docElem.msMatchesSelector))&&assert(function(div){support.disconnectedMatch=matches.call(div,"div"),matches.call(div,"[s!='']:x"),rbuggyMatches.push("!=",pseudos)}),rbuggyQSA=rbuggyQSA.length&&new RegExp(rbuggyQSA.join("|")),rbuggyMatches=rbuggyMatches.length&&new RegExp(rbuggyMatches.join("|")),hasCompare=rnative.test(docElem.compareDocumentPosition),contains=hasCompare||rnative.test(docElem.contains)?function(a,b){var adown=9===a.nodeType?a.documentElement:a,bup=b&&b.parentNode;return a===bup||!(!bup||1!==bup.nodeType||!(adown.contains?adown.contains(bup):a.compareDocumentPosition&&16&a.compareDocumentPosition(bup)))}:function(a,b){if(b)for(;b=b.parentNode;)if(b===a)return!0;return!1},sortOrder=hasCompare?function(a,b){if(a===b)return hasDuplicate=!0,0;var compare=!a.compareDocumentPosition-!b.compareDocumentPosition;return compare?compare:(compare=(a.ownerDocument||a)===(b.ownerDocument||b)?a.compareDocumentPosition(b):1,1&compare||!support.sortDetached&&b.compareDocumentPosition(a)===compare?a===doc||a.ownerDocument===preferredDoc&&contains(preferredDoc,a)?-1:b===doc||b.ownerDocument===preferredDoc&&contains(preferredDoc,b)?1:sortInput?indexOf.call(sortInput,a)-indexOf.call(sortInput,b):0:4&compare?-1:1)}:function(a,b){if(a===b)return hasDuplicate=!0,0;var cur,i=0,aup=a.parentNode,bup=b.parentNode,ap=[a],bp=[b];if(!aup||!bup)return a===doc?-1:b===doc?1:aup?-1:bup?1:sortInput?indexOf.call(sortInput,a)-indexOf.call(sortInput,b):0;if(aup===bup)return siblingCheck(a,b);for(cur=a;cur=cur.parentNode;)ap.unshift(cur);for(cur=b;cur=cur.parentNode;)bp.unshift(cur);for(;ap[i]===bp[i];)i++;return i?siblingCheck(ap[i],bp[i]):ap[i]===preferredDoc?-1:bp[i]===preferredDoc?1:0},doc):document},Sizzle.matches=function(expr,elements){return Sizzle(expr,null,null,elements)},Sizzle.matchesSelector=function(elem,expr){if((elem.ownerDocument||elem)!==document&&setDocument(elem),expr=expr.replace(rattributeQuotes,"='$1']"),support.matchesSelector&&documentIsHTML&&(!rbuggyMatches||!rbuggyMatches.test(expr))&&(!rbuggyQSA||!rbuggyQSA.test(expr)))try{var ret=matches.call(elem,expr);if(ret||support.disconnectedMatch||elem.document&&11!==elem.document.nodeType)return ret}catch(e){}return Sizzle(expr,document,null,[elem]).length>0},Sizzle.contains=function(context,elem){return(context.ownerDocument||context)!==document&&setDocument(context),contains(context,elem)},Sizzle.attr=function(elem,name){(elem.ownerDocument||elem)!==document&&setDocument(elem);var fn=Expr.attrHandle[name.toLowerCase()],val=fn&&hasOwn.call(Expr.attrHandle,name.toLowerCase())?fn(elem,name,!documentIsHTML):void 0;return void 0!==val?val:support.attributes||!documentIsHTML?elem.getAttribute(name):(val=elem.getAttributeNode(name))&&val.specified?val.value:null},Sizzle.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg)},Sizzle.uniqueSort=function(results){var elem,duplicates=[],j=0,i=0;if(hasDuplicate=!support.detectDuplicates,sortInput=!support.sortStable&&results.slice(0),results.sort(sortOrder),hasDuplicate){for(;elem=results[i++];)elem===results[i]&&(j=duplicates.push(i));for(;j--;)results.splice(duplicates[j],1)}return sortInput=null,results},getText=Sizzle.getText=function(elem){var node,ret="",i=0,nodeType=elem.nodeType;if(nodeType){if(1===nodeType||9===nodeType||11===nodeType){if("string"==typeof elem.textContent)return elem.textContent;for(elem=elem.firstChild;elem;elem=elem.nextSibling)ret+=getText(elem)}else if(3===nodeType||4===nodeType)return elem.nodeValue}else for(;node=elem[i++];)ret+=getText(node);return ret},Expr=Sizzle.selectors={cacheLength:50,createPseudo:markFunction,match:matchExpr,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(match){return match[1]=match[1].replace(runescape,funescape),match[3]=(match[3]||match[4]||match[5]||"").replace(runescape,funescape),"~="===match[2]&&(match[3]=" "+match[3]+" "),match.slice(0,4)},CHILD:function(match){return match[1]=match[1].toLowerCase(),"nth"===match[1].slice(0,3)?(match[3]||Sizzle.error(match[0]),match[4]=+(match[4]?match[5]+(match[6]||1):2*("even"===match[3]||"odd"===match[3])),match[5]=+(match[7]+match[8]||"odd"===match[3])):match[3]&&Sizzle.error(match[0]),match},PSEUDO:function(match){var excess,unquoted=!match[6]&&match[2];return matchExpr.CHILD.test(match[0])?null:(match[3]?match[2]=match[4]||match[5]||"":unquoted&&rpseudo.test(unquoted)&&(excess=tokenize(unquoted,!0))&&(excess=unquoted.indexOf(")",unquoted.length-excess)-unquoted.length)&&(match[0]=match[0].slice(0,excess),match[2]=unquoted.slice(0,excess)),match.slice(0,3))}},filter:{TAG:function(nodeNameSelector){var nodeName=nodeNameSelector.replace(runescape,funescape).toLowerCase();return"*"===nodeNameSelector?function(){return!0}:function(elem){return elem.nodeName&&elem.nodeName.toLowerCase()===nodeName}},CLASS:function(className){var pattern=classCache[className+" "];return pattern||(pattern=new RegExp("(^|"+whitespace+")"+className+"("+whitespace+"|$)"))&&classCache(className,function(elem){return pattern.test("string"==typeof elem.className&&elem.className||typeof elem.getAttribute!==strundefined&&elem.getAttribute("class")||"")})},ATTR:function(name,operator,check){return function(elem){var result=Sizzle.attr(elem,name);return null==result?"!="===operator:!operator||(result+="","="===operator?result===check:"!="===operator?result!==check:"^="===operator?check&&0===result.indexOf(check):"*="===operator?check&&result.indexOf(check)>-1:"$="===operator?check&&result.slice(-check.length)===check:"~="===operator?(" "+result+" ").indexOf(check)>-1:"|="===operator&&(result===check||result.slice(0,check.length+1)===check+"-"))}},CHILD:function(type,what,argument,first,last){var simple="nth"!==type.slice(0,3),forward="last"!==type.slice(-4),ofType="of-type"===what;return 1===first&&0===last?function(elem){return!!elem.parentNode}:function(elem,context,xml){var cache,outerCache,node,diff,nodeIndex,start,dir=simple!==forward?"nextSibling":"previousSibling",parent=elem.parentNode,name=ofType&&elem.nodeName.toLowerCase(),useCache=!xml&&!ofType;if(parent){if(simple){for(;dir;){for(node=elem;node=node[dir];)if(ofType?node.nodeName.toLowerCase()===name:1===node.nodeType)return!1;start=dir="only"===type&&!start&&"nextSibling"}return!0}if(start=[forward?parent.firstChild:parent.lastChild],forward&&useCache){for(outerCache=parent[expando]||(parent[expando]={}),cache=outerCache[type]||[],nodeIndex=cache[0]===dirruns&&cache[1],diff=cache[0]===dirruns&&cache[2],node=nodeIndex&&parent.childNodes[nodeIndex];node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop();)if(1===node.nodeType&&++diff&&node===elem){outerCache[type]=[dirruns,nodeIndex,diff];break}}else if(useCache&&(cache=(elem[expando]||(elem[expando]={}))[type])&&cache[0]===dirruns)diff=cache[1];else for(;(node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())&&((ofType?node.nodeName.toLowerCase()!==name:1!==node.nodeType)||!++diff||(useCache&&((node[expando]||(node[expando]={}))[type]=[dirruns,diff]),node!==elem)););return diff-=last,diff===first||diff%first===0&&diff/first>=0}}},PSEUDO:function(pseudo,argument){var args,fn=Expr.pseudos[pseudo]||Expr.setFilters[pseudo.toLowerCase()]||Sizzle.error("unsupported pseudo: "+pseudo);return fn[expando]?fn(argument):fn.length>1?(args=[pseudo,pseudo,"",argument],Expr.setFilters.hasOwnProperty(pseudo.toLowerCase())?markFunction(function(seed,matches){for(var idx,matched=fn(seed,argument),i=matched.length;i--;)idx=indexOf.call(seed,matched[i]),seed[idx]=!(matches[idx]=matched[i])}):function(elem){return fn(elem,0,args)}):fn}},pseudos:{not:markFunction(function(selector){var input=[],results=[],matcher=compile(selector.replace(rtrim,"$1"));return matcher[expando]?markFunction(function(seed,matches,context,xml){for(var elem,unmatched=matcher(seed,null,xml,[]),i=seed.length;i--;)(elem=unmatched[i])&&(seed[i]=!(matches[i]=elem))}):function(elem,context,xml){return input[0]=elem,matcher(input,null,xml,results),!results.pop()}}),has:markFunction(function(selector){return function(elem){return Sizzle(selector,elem).length>0}}),contains:markFunction(function(text){return text=text.replace(runescape,funescape),function(elem){return(elem.textContent||elem.innerText||getText(elem)).indexOf(text)>-1}}),lang:markFunction(function(lang){return ridentifier.test(lang||"")||Sizzle.error("unsupported lang: "+lang),lang=lang.replace(runescape,funescape).toLowerCase(),function(elem){var elemLang;do if(elemLang=documentIsHTML?elem.lang:elem.getAttribute("xml:lang")||elem.getAttribute("lang"))return elemLang=elemLang.toLowerCase(),elemLang===lang||0===elemLang.indexOf(lang+"-");while((elem=elem.parentNode)&&1===elem.nodeType);return!1}}),target:function(elem){var hash=window.location&&window.location.hash;return hash&&hash.slice(1)===elem.id},root:function(elem){return elem===docElem},focus:function(elem){return elem===document.activeElement&&(!document.hasFocus||document.hasFocus())&&!!(elem.type||elem.href||~elem.tabIndex)},enabled:function(elem){return elem.disabled===!1},disabled:function(elem){return elem.disabled===!0},checked:function(elem){var nodeName=elem.nodeName.toLowerCase();return"input"===nodeName&&!!elem.checked||"option"===nodeName&&!!elem.selected},selected:function(elem){return elem.parentNode&&elem.parentNode.selectedIndex,elem.selected===!0},empty:function(elem){for(elem=elem.firstChild;elem;elem=elem.nextSibling)if(elem.nodeType<6)return!1;return!0},parent:function(elem){return!Expr.pseudos.empty(elem)},header:function(elem){return rheader.test(elem.nodeName)},input:function(elem){return rinputs.test(elem.nodeName)},button:function(elem){var name=elem.nodeName.toLowerCase();return"input"===name&&"button"===elem.type||"button"===name},text:function(elem){var attr;return"input"===elem.nodeName.toLowerCase()&&"text"===elem.type&&(null==(attr=elem.getAttribute("type"))||"text"===attr.toLowerCase())},first:createPositionalPseudo(function(){return[0]}),last:createPositionalPseudo(function(matchIndexes,length){return[length-1]}),eq:createPositionalPseudo(function(matchIndexes,length,argument){return[argument<0?argument+length:argument]}),even:createPositionalPseudo(function(matchIndexes,length){for(var i=0;i<length;i+=2)matchIndexes.push(i);return matchIndexes}),odd:createPositionalPseudo(function(matchIndexes,length){for(var i=1;i<length;i+=2)matchIndexes.push(i);return matchIndexes}),lt:createPositionalPseudo(function(matchIndexes,length,argument){for(var i=argument<0?argument+length:argument;--i>=0;)matchIndexes.push(i);return matchIndexes}),gt:createPositionalPseudo(function(matchIndexes,length,argument){for(var i=argument<0?argument+length:argument;++i<length;)matchIndexes.push(i);return matchIndexes})}},Expr.pseudos.nth=Expr.pseudos.eq;for(i in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})Expr.pseudos[i]=createInputPseudo(i);for(i in{submit:!0,reset:!0})Expr.pseudos[i]=createButtonPseudo(i);setFilters.prototype=Expr.filters=Expr.pseudos,Expr.setFilters=new setFilters,tokenize=Sizzle.tokenize=function(selector,parseOnly){var matched,match,tokens,type,soFar,groups,preFilters,cached=tokenCache[selector+" "];if(cached)return parseOnly?0:cached.slice(0);for(soFar=selector,groups=[],preFilters=Expr.preFilter;soFar;){matched&&!(match=rcomma.exec(soFar))||(match&&(soFar=soFar.slice(match[0].length)||soFar),groups.push(tokens=[])),matched=!1,(match=rcombinators.exec(soFar))&&(matched=match.shift(),tokens.push({value:matched,type:match[0].replace(rtrim," ")}),soFar=soFar.slice(matched.length));for(type in Expr.filter)!(match=matchExpr[type].exec(soFar))||preFilters[type]&&!(match=preFilters[type](match))||(matched=match.shift(),tokens.push({value:matched,type:type,matches:match}),soFar=soFar.slice(matched.length));if(!matched)break}return parseOnly?soFar.length:soFar?Sizzle.error(selector):tokenCache(selector,groups).slice(0)},compile=Sizzle.compile=function(selector,match){var i,setMatchers=[],elementMatchers=[],cached=compilerCache[selector+" "];if(!cached){for(match||(match=tokenize(selector)),i=match.length;i--;)cached=matcherFromTokens(match[i]),cached[expando]?setMatchers.push(cached):elementMatchers.push(cached);cached=compilerCache(selector,matcherFromGroupMatchers(elementMatchers,setMatchers)),cached.selector=selector}return cached},select=Sizzle.select=function(selector,context,results,seed){var i,tokens,token,type,find,compiled="function"==typeof selector&&selector,match=!seed&&tokenize(selector=compiled.selector||selector);if(results=results||[],1===match.length){if(tokens=match[0]=match[0].slice(0),tokens.length>2&&"ID"===(token=tokens[0]).type&&support.getById&&9===context.nodeType&&documentIsHTML&&Expr.relative[tokens[1].type]){if(context=(Expr.find.ID(token.matches[0].replace(runescape,funescape),context)||[])[0],!context)return results;compiled&&(context=context.parentNode),selector=selector.slice(tokens.shift().value.length)}for(i=matchExpr.needsContext.test(selector)?0:tokens.length;i--&&(token=tokens[i],!Expr.relative[type=token.type]);)if((find=Expr.find[type])&&(seed=find(token.matches[0].replace(runescape,funescape),rsibling.test(tokens[0].type)&&testContext(context.parentNode)||context))){if(tokens.splice(i,1),selector=seed.length&&toSelector(tokens),!selector)return push.apply(results,seed),results;break}}return(compiled||compile(selector,match))(seed,context,!documentIsHTML,results,rsibling.test(selector)&&testContext(context.parentNode)||context),results},support.sortStable=expando.split("").sort(sortOrder).join("")===expando,support.detectDuplicates=!!hasDuplicate,setDocument(),support.sortDetached=assert(function(div1){return 1&div1.compareDocumentPosition(document.createElement("div"))}),assert(function(div){return div.innerHTML="<a href='#'></a>","#"===div.firstChild.getAttribute("href")})||addHandle("type|href|height|width",function(elem,name,isXML){if(!isXML)return elem.getAttribute(name,"type"===name.toLowerCase()?1:2)}),support.attributes&&assert(function(div){return div.innerHTML="<input/>",div.firstChild.setAttribute("value",""),""===div.firstChild.getAttribute("value")})||addHandle("value",function(elem,name,isXML){if(!isXML&&"input"===elem.nodeName.toLowerCase())return elem.defaultValue}),assert(function(div){return null==div.getAttribute("disabled")})||addHandle(booleans,function(elem,name,isXML){var val;if(!isXML)return elem[name]===!0?name.toLowerCase():(val=elem.getAttributeNode(name))&&val.specified?val.value:null}),tinymce.dom.Sizzle=Sizzle}(tinymce),function(tinymce){var NodeType=tinymce.dom.NodeType,Dispatcher=tinymce.util.Dispatcher,getPos=function(elm){for(var x=0,y=0,offsetParent=elm;offsetParent&&offsetParent.nodeType;)x+=offsetParent.offsetLeft||0,y+=offsetParent.offsetTop||0,offsetParent=offsetParent.offsetParent;return{x:x,y:y}},fireScrollIntoViewEvent=function(editor,elm,alignToTop){var scrollEvent={elm:elm,alignToTop:alignToTop,cancel:!1};return editor.onScrollIntoView.dispatch(editor,scrollEvent),scrollEvent.cancel===!0};tinymce.dom.ScrollIntoView=function(editor,elm,alignToTop){var y,viewPort,viewPortY,viewPortH,dom=editor.dom,root=dom.getRoot(),offsetY=0;if(editor.onScrollIntoView=new Dispatcher,!fireScrollIntoViewEvent(editor,elm,alignToTop)&&NodeType.isElement(elm)){if(alignToTop===!1&&(offsetY=elm.offsetHeight),"BODY"!==root.nodeName){var scrollContainer=editor.selection.getScrollContainer();if(scrollContainer)return y=getPos(elm).y-getPos(scrollContainer).y+offsetY,viewPortH=scrollContainer.clientHeight,viewPortY=scrollContainer.scrollTop,void((y<viewPortY||y+25>viewPortY+viewPortH)&&(scrollContainer.scrollTop=y<viewPortY?y:y-viewPortH+25))}viewPort=dom.getViewPort(editor.getWin()),y=dom.getPos(elm).y+offsetY,viewPortY=viewPort.y,viewPortH=viewPort.h,(y<viewPort.y||y+25>viewPortY+viewPortH)&&editor.getWin().scrollTo(0,y<viewPortY?y:y-viewPortH+25)}}}(tinymce),function(tinymce){function BookmarkManager(selection){var dom=selection.dom;this.getBookmark=function(type,normalized){function findIndex(name,element){var count=0;return tinymce.each(dom.select(name),function(node){if("all"!==node.getAttribute("data-mce-bogus"))return node!=element&&void count++}),count}function normalizeTableCellSelection(rng){function moveEndPoint(start){var container,offset,childNodes,prefix=start?"start":"end";container=rng[prefix+"Container"],offset=rng[prefix+"Offset"],1==container.nodeType&&"TR"==container.nodeName&&(childNodes=container.childNodes,container=childNodes[Math.min(start?offset:offset-1,childNodes.length-1)],container&&(offset=start?0:container.childNodes.length,rng["set"+(start?"Start":"End")](container,offset)))}return moveEndPoint(!0),moveEndPoint(),rng}function getLocation(rng){function getPoint(rng,start){var childNodes,container=rng[start?"startContainer":"endContainer"],offset=rng[start?"startOffset":"endOffset"],point=[],after=0;for(3===container.nodeType?point.push(normalized?getNormalizedTextOffset(container,offset):offset):(childNodes=container.childNodes,offset>=childNodes.length&&childNodes.length&&(after=1,offset=Math.max(0,childNodes.length-1)),point.push(dom.nodeIndex(childNodes[offset],normalized)+after));container&&container!=root;container=container.parentNode)point.push(dom.nodeIndex(container,normalized));return point}var root=dom.getRoot(),bookmark={};return bookmark.start=getPoint(rng,!0),selection.isCollapsed()||(bookmark.end=getPoint(rng)),bookmark}function findAdjacentContentEditableFalseElm(rng){function findSibling(node,offset){var sibling;if(NodeType.isElement(node)&&(node=RangeUtils.getNode(node,offset),isContentEditableFalse(node)))return node;if(CaretContainer.isCaretContainer(node)){if(NodeType.isText(node)&&CaretContainer.isCaretContainerBlock(node)&&(node=node.parentNode),sibling=node.previousSibling,isContentEditableFalse(sibling))return sibling;if(sibling=node.nextSibling,isContentEditableFalse(sibling))return sibling}}return findSibling(rng.startContainer,rng.startOffset)||findSibling(rng.endContainer,rng.endOffset)}var rng,rng2,id,collapsed,name,element,styles,chr="&#xFEFF;";if(2==type)return element=selection.getNode(),name=element?element.nodeName:null,rng=selection.getRng(),isContentEditableFalse(element)||"IMG"==name?{name:name,index:findIndex(name,element)}:selection.tridentSel?selection.tridentSel.getBookmark(type):(element=findAdjacentContentEditableFalseElm(rng),element?(name=element.tagName,{name:name,index:findIndex(name,element)}):getLocation(rng));if(3==type)return rng=selection.getRng(),{start:CaretBookmark.create(dom.getRoot(),CaretPosition.fromRangeStart(rng)),end:CaretBookmark.create(dom.getRoot(),CaretPosition.fromRangeEnd(rng))};if(type)return{rng:selection.getRng()};if(rng=selection.getRng(),id=dom.uniqueId(),collapsed=selection.isCollapsed(),styles="overflow:hidden;line-height:0px",rng.duplicate||rng.item){if(rng.item)return element=rng.item(0),name=element.nodeName,{name:name,index:findIndex(name,element)};rng2=rng.duplicate();try{rng.collapse(),rng.pasteHTML('<span data-mce-type="bookmark" id="'+id+'_start" style="'+styles+'">'+chr+"</span>"),collapsed||(rng2.collapse(!1),rng.moveToElementText(rng2.parentElement()),0===rng.compareEndPoints("StartToEnd",rng2)&&rng2.move("character",-1),rng2.pasteHTML('<span data-mce-type="bookmark" id="'+id+'_end" style="'+styles+'">'+chr+"</span>"))}catch(ex){return null}}else{if(element=selection.getNode(),name=element.nodeName,"IMG"==name)return{name:name,index:findIndex(name,element)};if(rng2=normalizeTableCellSelection(rng.cloneRange()),!collapsed){rng2.collapse(!1);var endBookmarkNode=dom.create("span",{"data-mce-type":"bookmark",id:id+"_end",style:styles},chr);rng2.insertNode(endBookmarkNode),trimEmptyTextNode(endBookmarkNode.nextSibling)}rng=normalizeTableCellSelection(rng),rng.collapse(!0);var startBookmarkNode=dom.create("span",{"data-mce-type":"bookmark",id:id+"_start",style:styles},chr);rng.insertNode(startBookmarkNode),trimEmptyTextNode(startBookmarkNode.previousSibling)}return selection.moveToBookmark({id:id,keep:1}),{id:id}},this.moveToBookmark=function(bookmark){function setEndPoint(start){var i,node,offset,children,point=bookmark[start?"start":"end"];if(point){for(offset=point[0],node=root,i=point.length-1;i>=1;i--){if(children=node.childNodes,point[i]>children.length-1)return;node=children[point[i]]}3===node.nodeType&&(offset=Math.min(point[0],node.nodeValue.length)),1===node.nodeType&&(offset=Math.min(point[0],node.childNodes.length)),start?rng.setStart(node,offset):rng.setEnd(node,offset)}return!0}function restoreEndPoint(suffix){var node,idx,next,prev,marker=dom.get(bookmark.id+"_"+suffix),keep=bookmark.keep;if(marker&&(node=marker.parentNode,"start"==suffix?(keep?(node=marker.firstChild,idx=1):idx=dom.nodeIndex(marker),startContainer=endContainer=node,startOffset=endOffset=idx):(keep?(node=marker.firstChild,idx=1):idx=dom.nodeIndex(marker),endContainer=node,endOffset=idx),!keep)){for(prev=marker.previousSibling,next=marker.nextSibling,tinymce.each(tinymce.grep(marker.childNodes),function(node){3==node.nodeType&&(node.nodeValue=node.nodeValue.replace(/\uFEFF/g,""))});marker=dom.get(bookmark.id+"_"+suffix);)dom.remove(marker,1);prev&&next&&prev.nodeType==next.nodeType&&3==prev.nodeType&&(idx=prev.nodeValue.length,prev.appendData(next.nodeValue),dom.remove(next),"start"==suffix?(startContainer=endContainer=prev,startOffset=endOffset=idx):(endContainer=prev,endOffset=idx))}}function addBogus(node){return dom.isBlock(node)&&!node.innerHTML&&(node.innerHTML='<br data-mce-bogus="1" />'),node}function resolveCaretPositionBookmark(){var rng,pos;return rng=dom.createRng(),pos=CaretBookmark.resolve(dom.getRoot(),bookmark.start),rng.setStart(pos.container(),pos.offset()),pos=CaretBookmark.resolve(dom.getRoot(),bookmark.end),rng.setEnd(pos.container(),pos.offset()),rng}var rng,root,startContainer,endContainer,startOffset,endOffset;if(bookmark)if(Arr.isArray(bookmark.start)){if(rng=dom.createRng(),root=dom.getRoot(),selection.tridentSel)return selection.tridentSel.moveToBookmark(bookmark);setEndPoint(!0)&&setEndPoint()&&selection.setRng(rng)}else"string"==typeof bookmark.start?selection.setRng(resolveCaretPositionBookmark()):bookmark.id?(restoreEndPoint("start"),restoreEndPoint("end"),startContainer&&(rng=dom.createRng(),rng.setStart(addBogus(startContainer),startOffset),rng.setEnd(addBogus(endContainer),endOffset),selection.setRng(rng))):bookmark.name?selection.select(dom.select(bookmark.name)[bookmark.index]):bookmark.rng&&selection.setRng(bookmark.rng)}}var NodeType=tinymce.dom.NodeType,CaretBookmark=tinymce.caret.CaretBookmark,CaretContainer=tinymce.caret.CaretContainer,CaretPosition=tinymce.caret.CaretPosition,RangeUtils=tinymce.dom.RangeUtils,Zwsp=tinymce.text.Zwsp,Arr=tinymce.util.Arr,isContentEditableFalse=NodeType.isContentEditableFalse,getNormalizedTextOffset=function(container,offset){
var node,trimmedOffset;for(trimmedOffset=Zwsp.trim(container.data.slice(0,offset)).length,node=container.previousSibling;node&&3===node.nodeType;node=node.previousSibling)trimmedOffset+=Zwsp.trim(node.data).length;return trimmedOffset},trimEmptyTextNode=function(node){NodeType.isText(node)&&0===node.data.length&&node.parentNode.removeChild(node)};BookmarkManager.isBookmarkNode=function(node){return node&&"SPAN"===node.tagName&&"bookmark"===node.getAttribute("data-mce-type")},tinymce.dom.BookmarkManager=BookmarkManager}(tinymce),function(tinymce){function debounce(callback,time){var timer,func;return func=function(){var args=arguments;clearTimeout(timer),timer=setTimeout(function(){callback.apply(this,args)},time||0)},func.stop=function(){clearTimeout(timer)},func}function hasContentEditableState(node,value){if(node&&1===node.nodeType){if(node.contentEditable===value)return!0;if(node.getAttribute("data-mce-contenteditable")===value)return!0}return!1}var Dispatcher=tinymce.util.Dispatcher,VK=tinymce.VK;tinymce.dom.ControlSelection=function(selection,editor){function getContentEditableRoot(root,node){for(;node&&node!=root;){if(hasContentEditableState(node,"true")||hasContentEditableState(node,"false"))return node;node=node.parentNode}return null}function isResizable(elm){var selector=editor.settings.object_resizing;return selector!==!1&&("string"!=typeof selector&&(selector="table,img,[data-mce-resize]"),"false"!==elm.getAttribute("data-mce-resize")&&elm!=editor.getBody()&&editor.dom.is(elm,selector))}function updateWithTouchData(e){var keys,i;if(e.changedTouches)for(keys="screenX screenY pageX pageY clientX clientY".split(" "),i=0;i<keys.length;i++)e[keys[i]]=e.changedTouches[0][keys[i]]}function isProportionalResize(elm){return"IMG"===elm.nodeName||"proportional"===elm.getAttribute("data-mce-resize")}function resizeGhostElement(e){var deltaX,deltaY,proportional,resizeHelperX,resizeHelperY;updateWithTouchData(e),deltaX=e.screenX-startX,deltaY=e.screenY-startY,width=deltaX*selectedHandle[2]+startW,height=deltaY*selectedHandle[3]+startH,width=width<5?5:width,height=height<5?5:height,proportional=isProportionalResize(selectedElm)&&editor.settings.resize_img_proportional!==!1?!VK.modifierPressed(e):VK.modifierPressed(e)||"IMG"==selectedElm.nodeName&&selectedHandle[2]*selectedHandle[3]!==0,proportional&&(abs(deltaX)>abs(deltaY)?(height=round(width*ratio),width=round(height/ratio)):(width=round(height/ratio),height=round(width*ratio))),dom.setStyles(selectedElmGhost,{width:width,height:height}),resizeHelperX=selectedHandle.startPos.x+deltaX,resizeHelperY=selectedHandle.startPos.y+deltaY,resizeHelperX=resizeHelperX>0?resizeHelperX:0,resizeHelperY=resizeHelperY>0?resizeHelperY:0,dom.setStyles(resizeHelper,{left:resizeHelperX,top:resizeHelperY,display:"block"}),resizeHelper.innerHTML=width+" &times; "+height,selectedHandle[2]<0&&selectedElmGhost.clientWidth<=width&&dom.setStyle(selectedElmGhost,"left",selectedElmX+(startW-width)),selectedHandle[3]<0&&selectedElmGhost.clientHeight<=height&&dom.setStyle(selectedElmGhost,"top",selectedElmY+(startH-height)),deltaX=rootElement.scrollWidth-startScrollWidth,deltaY=rootElement.scrollHeight-startScrollHeight,deltaX+deltaY!==0&&dom.setStyles(resizeHelper,{left:resizeHelperX-deltaX,top:resizeHelperY-deltaY}),resizeStarted||(editor.onObjectResizeStart.dispatch(editor,selectedElm,startW,startH),resizeStarted=!0)}function endGhostResize(){function setSizeProp(name,value){value&&("IMG"!==selectedElm.nodeName?dom.setStyle(selectedElm,name,value):dom.setAttrib(selectedElm,name,value))}resizeStarted=!1,setSizeProp("width",width),setSizeProp("height",height),dom.unbind(editableDoc,"mousemove touchmove",resizeGhostElement),dom.unbind(editableDoc,"mouseup touchend",endGhostResize),rootDocument!=editableDoc&&(dom.unbind(rootDocument,"mousemove touchmove",resizeGhostElement),dom.unbind(rootDocument,"mouseup touchend",endGhostResize)),dom.remove(selectedElmGhost),dom.remove(resizeHelper),dom.removeClass(selectedElm,"mce-resizing"),isIE&&"TABLE"!=selectedElm.nodeName||showResizeRect(selectedElm),editor.onObjectResized.dispatch(editor,selectedElm,width,height),dom.setAttrib(selectedElm,"style",dom.getAttrib(selectedElm,"style")),editor.nodeChanged()}function showResizeRect(targetElm,mouseDownHandleName,mouseDownEvent){var position,targetWidth,targetHeight,rect;hideResizeRect(),unbindResizeHandleEvents(),position=dom.getPos(targetElm,rootElement),selectedElmX=position.x,selectedElmY=position.y,rect=targetElm.getBoundingClientRect(),targetWidth=rect.width||rect.right-rect.left,targetHeight=rect.height||rect.bottom-rect.top,selectedElm!=targetElm&&(detachResizeStartListener(),selectedElm=targetElm,width=height=0),editor.onObjectSelected.dispatch(editor,targetElm),isResizable(targetElm)?each(resizeHandles,function(handle,name){function startDrag(e){startX=e.screenX,startY=e.screenY,startW=selectedElm.clientWidth,startH=selectedElm.clientHeight,ratio=startH/startW,selectedHandle=handle,handle.startPos={x:targetWidth*handle[0]+selectedElmX,y:targetHeight*handle[1]+selectedElmY},startScrollWidth=rootElement.scrollWidth,startScrollHeight=rootElement.scrollHeight,selectedElmGhost=selectedElm.cloneNode(),dom.addClass(selectedElmGhost,"mce-clonedresizable"),dom.setAttrib(selectedElmGhost,"data-mce-bogus","all"),selectedElmGhost.contentEditable=!1,selectedElmGhost.unSelectabe=!0,dom.setStyles(selectedElmGhost,{left:selectedElmX,top:selectedElmY,margin:0}),dom.addClass(selectedElm,"mce-resizing"),selectedElmGhost.removeAttribute("data-mce-selected"),rootElement.appendChild(selectedElmGhost),dom.bind(editableDoc,"mousemove touchmove",resizeGhostElement),dom.bind(editableDoc,"mouseup touchend",endGhostResize),rootDocument!=editableDoc&&(dom.bind(rootDocument,"mousemove touchmove",resizeGhostElement),dom.bind(rootDocument,"mouseup touchend",endGhostResize)),resizeHelper=dom.add(rootElement,"div",{class:"mce-resize-helper","data-mce-bogus":"all"},startW+" &times; "+startH)}var handleElm;return mouseDownHandleName?void(name==mouseDownHandleName&&startDrag(mouseDownEvent)):(handleElm=dom.get("mceResizeHandle"+name.toUpperCase()),handleElm&&dom.remove(handleElm),handleElm=dom.add(rootElement,"div",{id:"mceResizeHandle"+name.toUpperCase(),"data-mce-bogus":"all",class:"mce-resizehandle mce-resizehandle-"+name,unselectable:!0,style:"cursor:"+name+"-resize;"}),11===isIE&&(handleElm.contentEditable=!1),dom.bind(handleElm,"mousedown",function(e){e.stopImmediatePropagation(),e.preventDefault(),startDrag(e)}),handle.elm=handleElm,void dom.setStyles(handleElm,{left:targetWidth*handle[0]+selectedElmX-handleElm.offsetWidth/2,top:targetHeight*handle[1]+selectedElmY-handleElm.offsetHeight/2}))}):hideResizeRect(),selectedElm.setAttribute("data-mce-selected","1")}function hideResizeRect(){var name,handleElm;unbindResizeHandleEvents(),selectedElm&&selectedElm.removeAttribute("data-mce-selected");for(name in resizeHandles)handleElm=dom.get("mceResizeHandle"+name.toUpperCase()),handleElm&&(dom.unbind(handleElm),dom.remove(handleElm))}function updateResizeRect(e){function isChildOrEqual(node,parent){if(node)do if(node===parent)return!0;while(node=node.parentNode)}var startElm,controlElm;if(!resizeStarted&&!editor.removed&&editor===tinymce.activeEditor)return each(dom.select("img[data-mce-selected][data-mce-resize],hr[data-mce-selected][data-mce-resize],span[data-mce-selected][data-mce-resize]"),function(img){img.removeAttribute("data-mce-selected")}),controlElm="mousedown"==e.type?e.target:selection.getNode(),controlElm=dom.closest(controlElm,isIE?"table":"table,img,[data-mce-resize]")[0],isChildOrEqual(controlElm,rootElement)&&(disableGeckoResize(),startElm=selection.getStart(!0),isChildOrEqual(startElm,controlElm)&&isChildOrEqual(selection.getEnd(!0),controlElm)&&(!isIE||controlElm!=startElm&&"IMG"!==startElm.nodeName))?void showResizeRect(controlElm):void hideResizeRect()}function attachEvent(elm,name,func){elm&&elm.attachEvent&&elm.attachEvent("on"+name,func)}function detachEvent(elm,name,func){elm&&elm.detachEvent&&elm.detachEvent("on"+name,func)}function resizeNativeStart(e){var pos,name,corner,cornerX,cornerY,relativeX,relativeY,target=e.srcElement;pos=target.getBoundingClientRect(),relativeX=lastMouseDownEvent.clientX-pos.left,relativeY=lastMouseDownEvent.clientY-pos.top;for(name in resizeHandles)if(corner=resizeHandles[name],cornerX=target.offsetWidth*corner[0],cornerY=target.offsetHeight*corner[1],abs(cornerX-relativeX)<8&&abs(cornerY-relativeY)<8){selectedHandle=corner;break}resizeStarted=!0,editor.onObjectResizeStart.dispatch(editor,selectedElm,selectedElm.clientWidth,selectedElm.clientHeight),editor.getDoc().selection.empty(),showResizeRect(target,name,lastMouseDownEvent)}function preventDefault(e){e.preventDefault?e.preventDefault():e.returnValue=!1}function isWithinContentEditableFalse(elm){return hasContentEditableState(getContentEditableRoot(editor.getBody(),elm),"false")}function nativeControlSelect(e){var target=e.srcElement;if(isWithinContentEditableFalse(target))return void preventDefault(e);if(target!=selectedElm){if(editor.onObjectSelected.dispatch(editor,target),detachResizeStartListener(),0===target.id.indexOf("mceResizeHandle"))return void(e.returnValue=!1);"IMG"!=target.nodeName&&"TABLE"!=target.nodeName||(hideResizeRect(),selectedElm=target,attachEvent(target,"resizestart",resizeNativeStart))}}function detachResizeStartListener(){detachEvent(selectedElm,"resizestart",resizeNativeStart)}function unbindResizeHandleEvents(){for(var name in resizeHandles){var handle=resizeHandles[name];handle.elm&&(dom.unbind(handle.elm),delete handle.elm)}}function disableGeckoResize(){try{editor.getDoc().execCommand("enableObjectResizing",!1,!1)}catch(ex){}}function controlSelect(elm){var ctrlRng;if(isIE){ctrlRng=editableDoc.body.createControlRange();try{return ctrlRng.addElement(elm),ctrlRng.select(),!0}catch(ex){}}}function selectControl(editor,e){var target=e.target,nodeName=target.nodeName;resizeStarted||!/^(TABLE|IMG|HR)$/.test(nodeName)||isWithinContentEditableFalse(target)||(editor.selection.select(target,"TABLE"==nodeName),"mousedown"==e.type&&editor.nodeChanged())}function destroy(){selectedElm=selectedElmGhost=null,isIE&&(detachResizeStartListener(),detachEvent(rootElement,"controlselect",nativeControlSelect))}var selectedElm,selectedElmGhost,resizeHelper,resizeHandles,selectedHandle,lastMouseDownEvent,startX,startY,selectedElmX,selectedElmY,startW,startH,ratio,resizeStarted,width,height,startScrollWidth,startScrollHeight,dom=editor.dom,each=tinymce.each,editableDoc=editor.getDoc(),rootDocument=document,isIE=tinymce.isIE&&tinymce.isIE<11,abs=Math.abs,round=Math.round,rootElement=editor.getBody();return editor.onObjectSelected=new Dispatcher,editor.onObjectResizeStart=new Dispatcher,editor.onObjectResized=new Dispatcher,resizeHandles={nw:[0,0,-1,-1],ne:[1,0,1,-1],se:[1,1,1,1],sw:[0,1,-1,1]},editor.onInit.add(function(editor){function updateTableRect(editor,e){selectedElm&&"TABLE"==selectedElm.nodeName&&throttledUpdateResizeRect(e)}isIE?(editor.onObjectResized.add(function(editor,e){"TABLE"!=e.target.nodeName&&(hideResizeRect(),controlSelect(e.target))}),attachEvent(rootElement,"controlselect",nativeControlSelect),editor.onMouseDown.add(function(editor,e){lastMouseDownEvent=e})):(disableGeckoResize(),(tinymce.isIE>=11||tinymce.isIE12)&&(editor.onClick.add(selectControl),editor.onMouseDown.add(selectControl),editor.dom.bind(rootElement,"mscontrolselect",function(e){function delayedSelect(node){setTimeout(function(){editor.selection.select(node)},0)}return isWithinContentEditableFalse(e.target)?(e.preventDefault(),void delayedSelect(e.target)):void(/^(TABLE|IMG|HR)$/.test(e.target.nodeName)&&(e.preventDefault(),"IMG"==e.target.tagName&&delayedSelect(e.target)))})));var throttledUpdateResizeRect=debounce(function(e){updateResizeRect(e)});editor.onNodeChange.add(function(){setTimeout(function(){throttledUpdateResizeRect({type:""})},100)}),editor.dom.bind(editor.getBody(),"drop",function(e){throttledUpdateResizeRect(e)}),editor.onBeforeGetContent.add(hideResizeRect),editor.onKeyUp.add(updateTableRect),editor.dom.bind(editor.getBody(),"compositionend",function(e){updateTableRect(editor,e)}),editor.onBlur.add(hideResizeRect),editor.onHide.add(hideResizeRect)}),editor.onRemove.add(unbindResizeHandleEvents),{isResizable:isResizable,showResizeRect:showResizeRect,hideResizeRect:hideResizeRect,updateResizeRect:updateResizeRect,controlSelect:controlSelect,destroy:destroy}}}(tinymce),function(tinymce){function isRestricted(element){return!!element&&!Object.getPrototypeOf(element)}var is=tinymce.is,isIE=tinymce.isIE,each=tinymce.each,extend=tinymce.extend,TreeWalker=tinymce.dom.TreeWalker,BookmarkManager=tinymce.dom.BookmarkManager,ControlSelection=tinymce.dom.ControlSelection;tinymce.dom.Selection=function(dom,win,serializer,editor){var self=this;self.dom=dom,self.win=win,self.serializer=serializer,self.editor=editor,self.bookmarkManager=new BookmarkManager(self),self.controlSelection=new ControlSelection(self,editor),each(["onBeforeSetContent","onBeforeGetContent","onSetContent","onGetContent","onGetSelectionRange","onSetSelectionRange","onAfterSetSelectionRange"],function(e){self[e]=new tinymce.util.Dispatcher(self)}),self.onBeforeSetContent.add(function(e,args){if("raw"!==args.format){var node=new tinymce.html.DomParser(editor.settings,editor.schema).parse(args.content,extend(args,{isRootContent:!0,forced_root_block:!1}));args.content=new tinymce.html.Serializer({validate:!1},editor.schema).serialize(node)}}),tinymce.addUnload(self.destroy,self)},tinymce.dom.Selection.prototype={setCursorLocation:function(node,offset){var self=this,r=self.dom.createRng();r.setStart(node,offset),r.setEnd(node,offset),self.setRng(r),self.collapse(!1)},getContextualFragment:function(rng,frag){function isBlock(elm){return dom.isBlock(elm)&&!/H[1-6]/.test(elm.nodeName)}var self=this,ed=self.editor,dom=self.dom,node=rng.commonAncestorContainer;if(node===ed.getBody())return frag;var tableCells=dom.select("td.mceSelected, th.mceSelected",node);if(tableCells.length){var table=dom.getParent(node,"table");if(table){var parent=dom.clone(table),row=dom.create("tr");return each(tableCells,function(cell){row.appendChild(dom.clone(cell,!0))}),parent.appendChild(row),parent}}if(rng.collapsed)return frag;var parents=dom.getParents(node,null,ed.getBody()),elms=tinymce.grep(parents,function(elm){return 1===elm.nodeType&&!isBlock(elm)});if(!elms.length)return frag;var nodes=document.createDocumentFragment();return each(elms,function(elm){var n=dom.clone(elm);n.appendChild(frag),nodes.appendChild(n)}),nodes},getContent:function(s){var wb,wa,frag,self=this,r=self.getRng(),e=self.dom.create("body"),se=self.getSel();return s=s||{},wb=wa="",s.get=!0,s.format=s.format||"html",s.forced_root_block="",self.onBeforeGetContent.dispatch(self,s),"text"==s.format?self.isCollapsed()?"":r.text||(se.toString?se.toString():""):(r.cloneContents?(frag=r.cloneContents(),frag&&(s.contextual&&(frag=self.getContextualFragment(r,frag)),e.appendChild(frag))):is(r.item)||is(r.htmlText)?(e.innerHTML="<br>"+(r.item?r.item(0).outerHTML:r.htmlText),e.removeChild(e.firstChild)):e.innerHTML=r.toString(),/^\s/.test(e.innerHTML)&&(wb=" "),/\s+$/.test(e.innerHTML)&&(wa=" "),s.getInner=!0,s.content=self.isCollapsed()?"":wb+self.serializer.serialize(e,s)+wa,self.onGetContent.dispatch(self,s),s.content)},setContent:function(content,args){var caretNode,self=this,rng=self.getRng(),doc=self.win.document;if(args=args||{format:"html"},args.set=!0,args.content=content,args.no_events||self.onBeforeSetContent.dispatch(self,args),content=args.content,rng.insertNode){content+='<span id="__caret">_</span>',rng.startContainer==doc&&rng.endContainer==doc?doc.body.innerHTML=content:(rng.deleteContents(),0===doc.body.childNodes.length?doc.body.innerHTML=content:rng.insertNode(rng.createContextualFragment(content))),caretNode=self.dom.get("__caret"),rng=doc.createRange(),rng.setStartBefore(caretNode),rng.setEndBefore(caretNode),self.setRng(rng),self.dom.remove("__caret");try{self.setRng(rng)}catch(ex){}}else rng.item&&(doc.execCommand("Delete",!1,null),rng=self.getRng()),/^\s+/.test(content)?(rng.pasteHTML('<span id="__mce_tmp">_</span>'+content),self.dom.remove("__mce_tmp")):rng.pasteHTML(content);args.no_events||self.onSetContent.dispatch(self,args)},getStart:function(real){var startElement,parentElement,checkRng,node,self=this,rng=self.getRng();if(rng.duplicate||rng.item){if(rng.item)return rng.item(0);for(checkRng=rng.duplicate(),checkRng.collapse(1),startElement=checkRng.parentElement(),startElement.ownerDocument!==self.dom.doc&&(startElement=self.dom.getRoot()),parentElement=node=rng.parentElement();node=node.parentNode;)if(node==startElement){startElement=parentElement;break}return startElement}return startElement=rng.startContainer,1==startElement.nodeType&&startElement.hasChildNodes()&&(real&&rng.collapsed||(startElement=startElement.childNodes[Math.min(startElement.childNodes.length-1,rng.startOffset)])),startElement&&3==startElement.nodeType?startElement.parentNode:startElement},getEnd:function(real){var endElement,endOffset,self=this,rng=self.getRng();return rng.duplicate||rng.item?rng.item?rng.item(0):(rng=rng.duplicate(),rng.collapse(0),endElement=rng.parentElement(),endElement.ownerDocument!==self.dom.doc&&(endElement=self.dom.getRoot()),endElement&&"BODY"==endElement.nodeName?endElement.lastChild||endElement:endElement):(endElement=rng.endContainer,endOffset=rng.endOffset,1==endElement.nodeType&&endElement.hasChildNodes()&&(real&&rng.collapsed||(endElement=endElement.childNodes[endOffset>0?endOffset-1:endOffset])),endElement&&3==endElement.nodeType?endElement.parentNode:endElement)},getBookmark:function(type,normalized){return this.bookmarkManager.getBookmark(type,normalized)},moveToBookmark:function(bookmark){return this.bookmarkManager.moveToBookmark(bookmark)},select:function(node,content){function setPoint(node,start){var walker=new TreeWalker(node,node);do{if(3==node.nodeType&&0!==tinymce.trim(node.nodeValue).length)return void(start?rng.setStart(node,0):rng.setEnd(node,node.nodeValue.length));if("BR"==node.nodeName)return void(start?rng.setStartBefore(node):rng.setEndBefore(node))}while(node=start?walker.next():walker.prev())}var idx,self=this,dom=self.dom,rng=dom.createRng();if(node){if(!content&&self.controlSelection.controlSelect(node))return;idx=dom.nodeIndex(node),rng.setStart(node.parentNode,idx),rng.setEnd(node.parentNode,idx+1),content&&(setPoint(node,1),setPoint(node)),self.setRng(rng)}return node},isCollapsed:function(){var self=this,r=self.getRng(),s=self.getSel();return!(!r||r.item)&&(r.compareEndPoints?0===r.compareEndPoints("StartToEnd",r):!s||r.collapsed)},collapse:function(to_start){var node,self=this,rng=self.getRng();rng.item&&(node=rng.item(0),rng=self.win.document.body.createTextRange(),rng.moveToElementText(node)),rng.collapse(!!to_start),self.setRng(rng)},getSel:function(){var w=this.win;return w.getSelection?w.getSelection():w.document.selection},getRng:function(w3c){function tryCompareBoundaryPoints(how,sourceRange,destinationRange){try{return sourceRange.compareBoundaryPoints(how,destinationRange)}catch(ex){return-1}}var selection,rng,elm,doc,ieRng,evt,self=this;if(!self.win)return null;if(doc=self.win.document,"undefined"==typeof doc||null===doc)return null;if(!w3c&&self.lastFocusBookmark){var bookmark=self.lastFocusBookmark;return bookmark.startContainer?(rng=doc.createRange(),rng.setStart(bookmark.startContainer,bookmark.startOffset),rng.setEnd(bookmark.endContainer,bookmark.endOffset)):rng=bookmark,rng}try{(selection=self.getSel())&&!isRestricted(selection.anchorNode)&&(rng=selection.rangeCount>0?selection.getRangeAt(0):selection.createRange?selection.createRange():doc.createRange())}catch(ex){}if(evt={range:rng},self.onGetSelectionRange.dispatch(self,evt),evt.range!==rng)return evt.range;if(isIE&&rng&&rng.setStart&&doc.selection){try{ieRng=doc.selection.createRange()}catch(ex){}ieRng&&ieRng.item&&(elm=ieRng.item(0),rng=doc.createRange(),rng.setStartBefore(elm),rng.setEndAfter(elm))}return rng&&isRestricted(rng.startContainer)&&(rng=null),rng||(rng=doc.createRange?doc.createRange():doc.body.createTextRange()),rng.setStart&&9===rng.startContainer.nodeType&&rng.collapsed&&(elm=self.dom.getRoot(),rng.setStart(elm,0),rng.setEnd(elm,0)),self.selectedRange&&self.explicitRange&&(0===tryCompareBoundaryPoints(rng.START_TO_START,rng,self.selectedRange)&&0===tryCompareBoundaryPoints(rng.END_TO_END,rng,self.selectedRange)?rng=self.explicitRange:(self.selectedRange=null,self.explicitRange=null)),rng},setRng:function(rng,forward){var sel,node,self=this;if(rng)if(rng.select){self.explicitRange=null;try{rng.select()}catch(ex){}}else{sel=self.getSel();var evt={range:rng};if(self.onSetSelectionRange.dispatch(self,evt),rng=evt.range,sel){self.explicitRange=rng;try{sel.removeAllRanges(),sel.addRange(rng)}catch(ex){}forward===!1&&sel.extend&&(sel.collapse(rng.endContainer,rng.endOffset),sel.extend(rng.startContainer,rng.startOffset)),self.selectedRange=sel.rangeCount>0?sel.getRangeAt(0):null}rng.collapsed||rng.startContainer!==rng.endContainer||!sel.setBaseAndExtent||tinymce.isIE||rng.endOffset-rng.startOffset<2&&rng.startContainer.hasChildNodes()&&(node=rng.startContainer.childNodes[rng.startOffset],node&&"IMG"===node.tagName&&(sel.setBaseAndExtent(rng.startContainer,rng.startOffset,rng.endContainer,rng.endOffset),sel.anchorNode===rng.startContainer&&sel.focusNode===rng.endContainer||sel.setBaseAndExtent(node,0,node,1))),self.onAfterSetSelectionRange.dispatch(self,{range:rng})}},setNode:function(n){var self=this;return self.setContent(self.dom.getOuterHTML(n)),n},getNode:function(){function skipEmptyTextNodes(node,forwards){for(var orig=node;node&&3===node.nodeType&&0===node.length;)node=forwards?node.nextSibling:node.previousSibling;return node||orig}var elm,startContainer,endContainer,startOffset,endOffset,self=this,rng=self.getRng(),root=self.dom.getRoot();return rng?(startContainer=rng.startContainer,endContainer=rng.endContainer,startOffset=rng.startOffset,endOffset=rng.endOffset,rng.setStart?(elm=rng.commonAncestorContainer,!rng.collapsed&&(startContainer==endContainer&&endOffset-startOffset<2&&startContainer.hasChildNodes()&&(elm=startContainer.childNodes[startOffset]),3===startContainer.nodeType&&3===endContainer.nodeType&&(startContainer=startContainer.length===startOffset?skipEmptyTextNodes(startContainer.nextSibling,!0):startContainer.parentNode,endContainer=0===endOffset?skipEmptyTextNodes(endContainer.previousSibling,!1):endContainer.parentNode,startContainer&&startContainer===endContainer))?startContainer:elm&&3==elm.nodeType?elm.parentNode:elm):elm=rng.item?rng.item(0):rng.parentElement()):root},getSelectedBlocks:function(st,en){var sb,eb,n,self=this,dom=self.dom,bl=[];if(sb=dom.getParent(st||self.getStart(),dom.isBlock),eb=dom.getParent(en||self.getEnd(),dom.isBlock),sb&&bl.push(sb),sb&&eb&&sb!=eb){n=sb;for(var walker=new TreeWalker(sb,dom.getRoot());(n=walker.next())&&n!=eb;)dom.isBlock(n)&&bl.push(n)}return eb&&sb!=eb&&bl.push(eb),bl},getSelectedNodes:function(start,end){var startNode,endNode,node,self=this,nodes=[],rng=self.getRng();if(startNode=start||rng.startContainer,endNode=end||rng.endContainer,startNode&&nodes.push(startNode),startNode&&endNode&&startNode!=endNode){node=startNode;for(var walker=new TreeWalker(startNode,self.dom.getRoot());(node=walker.next())&&node!=endNode;)node.parentNode===self.dom.getRoot()&&nodes.push(node)}return endNode&&startNode!=endNode&&nodes.push(endNode),nodes},isForward:function(){var anchorRange,focusRange,dom=this.dom,sel=this.getSel();return!sel||null==sel.anchorNode||null==sel.focusNode||(anchorRange=dom.createRng(),anchorRange.setStart(sel.anchorNode,sel.anchorOffset),anchorRange.collapse(!0),focusRange=dom.createRng(),focusRange.setStart(sel.focusNode,sel.focusOffset),focusRange.collapse(!0),anchorRange.compareBoundaryPoints(anchorRange.START_TO_START,focusRange)<=0)},normalize:function(){function normalizeEndPoint(start){function hasBrBeforeAfter(node,left){for(var walker=new TreeWalker(node,dom.getParent(node.parentNode,dom.isBlock)||body);node=walker[left?"prev":"next"]();)if("BR"===node.nodeName)return!0}function findTextNodeRelative(left,startNode){var walker,lastInlineElement;for(startNode=startNode||container,walker=new TreeWalker(startNode,dom.getParent(startNode.parentNode,dom.isBlock)||body);node=walker[left?"prev":"next"]();){if(3===node.nodeType&&node.nodeValue.length>0)return container=node,offset=left?node.nodeValue.length:0,void(normalized=!0);if(dom.isBlock(node)||nonEmptyElementsMap[node.nodeName.toLowerCase()])return;lastInlineElement=node}collapsed&&lastInlineElement&&(container=lastInlineElement,normalized=!0,offset=0)}var container,offset,walker,node,nonEmptyElementsMap,dom=self.dom,body=dom.getRoot();if(container=rng[(start?"start":"end")+"Container"],offset=rng[(start?"start":"end")+"Offset"],nonEmptyElementsMap=dom.schema.getNonEmptyElements(),9===container.nodeType&&(container=dom.getRoot(),offset=0),container===body){if(start&&(node=container.childNodes[offset>0?offset-1:0],node&&(nonEmptyElementsMap[node.nodeName]||"TABLE"==node.nodeName)))return;if(container.hasChildNodes()&&(container=container.childNodes[Math.min(!start&&offset>0?offset-1:offset,container.childNodes.length-1)],offset=0,container.hasChildNodes()&&!/TABLE/.test(container.nodeName))){node=container,walker=new TreeWalker(container,body);do{if(3===node.nodeType&&node.nodeValue.length>0){offset=start?0:node.nodeValue.length,container=node,normalized=!0;break}if(nonEmptyElementsMap[node.nodeName.toLowerCase()]){offset=dom.nodeIndex(node),container=node.parentNode,"IMG"!=node.nodeName||start||offset++,normalized=!0;break}}while(node=start?walker.next():walker.prev())}}collapsed&&(3===container.nodeType&&0===offset&&findTextNodeRelative(!0),1===container.nodeType&&(node=container.childNodes[offset],!node||"BR"!==node.nodeName||hasBrBeforeAfter(node)||hasBrBeforeAfter(node,!0)||findTextNodeRelative(!0,container.childNodes[offset]))),start&&!collapsed&&3===container.nodeType&&offset===container.nodeValue.length&&findTextNodeRelative(!1),normalized&&rng["set"+(start?"Start":"End")](container,offset)}var rng,normalized,collapsed,self=this;tinymce.isIE||(rng=self.getRng(),collapsed=rng.collapsed,normalizeEndPoint(!0),collapsed||normalizeEndPoint(),normalized&&(collapsed&&rng.collapse(!0),self.setRng(rng,self.isForward())))},selectorChanged:function(selector,callback){var currentSelectors,self=this;return self.selectorChangedData||(self.selectorChangedData={},currentSelectors={},self.editor.onNodeChange.addToTop(function(ed,cm,node){var dom=self.dom,parents=dom.getParents(node,null,dom.getRoot()),matchedSelectors={};each(self.selectorChangedData,function(callbacks,selector){each(parents,function(node){if(dom.is(node,selector))return currentSelectors[selector]||(each(callbacks,function(callback){callback(!0,{node:node,selector:selector,parents:parents})}),currentSelectors[selector]=callbacks),matchedSelectors[selector]=callbacks,!1})}),each(currentSelectors,function(callbacks,selector){matchedSelectors[selector]||(delete currentSelectors[selector],each(callbacks,function(callback){callback(!1,{node:node,selector:selector,parents:parents})}))})})),self.selectorChangedData[selector]||(self.selectorChangedData[selector]=[]),self.selectorChangedData[selector].push(callback),self},scrollIntoView:function(elm,alignToTop){tinymce.dom.ScrollIntoView(this.editor,elm,alignToTop)},placeCaretAt:function(clientX,clientY){this.setRng(tinymce.dom.RangeUtils.getCaretRangeFromPoint(clientX,clientY,this.editor.getDoc()))},destroy:function(manual){var self=this;self.win=null,manual||tinymce.removeUnload(self.destroy)},_fixIESelection:function(){function rngFromPoint(x,y){var rng=body.createTextRange();try{rng.moveToPoint(x,y)}catch(ex){rng=null}return rng}function selectionChange(e){var pointRng;e.button?(pointRng=rngFromPoint(e.x,e.y),pointRng&&(pointRng.compareEndPoints("StartToStart",startRng)>0?pointRng.setEndPoint("StartToStart",startRng):pointRng.setEndPoint("EndToEnd",startRng),pointRng.select())):endSelection()}function endSelection(){var rng=doc.selection.createRange();startRng&&!rng.item&&0===rng.compareEndPoints("StartToEnd",rng)&&startRng.select(),dom.unbind(doc,"mouseup",endSelection),dom.unbind(doc,"mousemove",selectionChange),startRng=started=0}var started,startRng,htmlElm,dom=this.dom,doc=dom.doc,body=doc.body;doc.documentElement.unselectable=!0,dom.bind(doc,["mousedown","contextmenu"],function(e){if("HTML"===e.target.nodeName){if(started&&endSelection(),htmlElm=doc.documentElement,htmlElm.scrollHeight>htmlElm.clientHeight)return;started=1,startRng=rngFromPoint(e.x,e.y),startRng&&(dom.bind(doc,"mouseup",endSelection),dom.bind(doc,"mousemove",selectionChange),dom.win.focus(),startRng.select())}})}}}(tinymce),function(tinymce){tinymce.dom.Serializer=function(settings,dom,schema){function trimTrailingBr(rootNode){function isBr(node){return node&&"br"===node.name}var brNode1,brNode2;brNode1=rootNode.lastChild,isBr(brNode1)&&(brNode2=brNode1.prev,isBr(brNode2)&&(brNode1.remove(),brNode2.remove()))}var onPreProcess,onPostProcess,htmlParser,self=this,isIE=tinymce.isIE,each=tinymce.each;return settings.apply_source_formatting||(settings.indent=!1),dom=dom||tinymce.DOM,schema=schema||new tinymce.html.Schema(settings),settings.entity_encoding=settings.entity_encoding||"named",settings.remove_trailing_brs=!("remove_trailing_brs"in settings)||settings.remove_trailing_brs,onPreProcess=new tinymce.util.Dispatcher(self),onPostProcess=new tinymce.util.Dispatcher(self),htmlParser=new tinymce.html.DomParser(settings,schema),htmlParser.addAttributeFilter("data-mce-tabindex",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.attr("tabindex",node.attributes.map["data-mce-tabindex"]),node.attr(name,null)}),htmlParser.addAttributeFilter("src,href,style",function(nodes,name){for(var node,value,undef,i=nodes.length,internalName="data-mce-"+name,urlConverter=settings.url_converter,urlConverterScope=settings.url_converter_scope;i--;)node=nodes[i],value=node.attributes.map[internalName],value!==undef?(node.attr(name,value.length>0?value:null),node.attr(internalName,null)):(value=node.attributes.map[name],"style"===name?settings.validate_styles&&(value=dom.serializeStyle(dom.parseStyle(value),node.name)):urlConverter&&(value=urlConverter.call(urlConverterScope,value,name,node.name)),node.attr(name,value.length>0?value:null))}),htmlParser.addAttributeFilter("class",function(nodes){for(var node,value,i=nodes.length;i--;)node=nodes[i],value=node.attr("class"),value&&(value=node.attr("class").replace(/(?:^|\s)mce(-?)(Item[\w-]+|Selected)(?!\S)/gi,""),value=value.replace(/\s+/g," ").replace(/^\s*|\s*$/g,""),node.attr("class",value.length>0?value:null))}),htmlParser.addAttributeFilter("data-mce-type",function(nodes,name,args){for(var node,i=nodes.length;i--;)node=nodes[i],"temp"!==node.attributes.map["data-mce-type"]?"bookmark"!==node.attributes.map["data-mce-type"]||args.cleanup||node.remove():node.remove()}),htmlParser.addNodeFilter("noscript",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i].firstChild,node&&(node.value=tinymce.html.Entities.decode(node.value))}),htmlParser.addNodeFilter("script,style",function(nodes,name){function trim(value){return value.replace(/(<!--\[CDATA\[|\]\]-->)/g,"\n").replace(/^[\r\n]*|[\r\n]*$/g,"").replace(/^\s*((<!--)?(\s*\/\/)?\s*<!\[CDATA\[|(<!--\s*)?\/\*\s*<!\[CDATA\[\s*\*\/|(\/\/)?\s*<!--|\/\*\s*<!--\s*\*\/)\s*[\r\n]*/gi,"").replace(/\s*(\/\*\s*\]\]>\s*\*\/(-->)?|\s*\/\/\s*\]\]>(-->)?|\/\/\s*(-->)?|\]\]>|\/\*\s*-->\s*\*\/|\s*-->\s*)\s*$/g,"")}for(var node,value,type,i=nodes.length;i--;)node=nodes[i],value=node.firstChild?node.firstChild.value:"","script"===name?(type=node.attr("type"),type&&node.attr("type","mce-no/type"==type?null:type.replace(/^mce\-/,"")),value.length>0&&(node.firstChild.value=trim(value))):value.length>0&&(node.firstChild.value=trim(value));
}),htmlParser.addNodeFilter("#comment",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],0===node.value.indexOf("[CDATA[")?(node.name="#cdata",node.type=4,node.value=node.value.replace(/^\[CDATA\[|\]\]$/g,"")):0===node.value.indexOf("mce:protected ")&&(node.name="#text",node.type=3,node.raw=!0,node.value=unescape(node.value).substr(14))}),htmlParser.addNodeFilter("xml:namespace,input",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],7===node.type?node.remove():1===node.type&&("input"!==name||"type"in node.attributes.map||node.attr("type","text"))}),settings.fix_list_elements&&htmlParser.addNodeFilter("ul,ol",function(nodes){for(var node,parentNode,i=nodes.length;i--;)node=nodes[i],parentNode=node.parent,"ul"!==parentNode.name&&"ol"!==parentNode.name||node.prev&&"li"===node.prev.name&&node.prev.append(node)}),htmlParser.addAttributeFilter("data-mce-src,data-mce-href,data-mce-style,data-mce-selected,data-mce-expando,data-mce-type,data-mce-resize,data-mce-new",function(nodes,name){for(var i=nodes.length;i--;)nodes[i].attr(name,null)}),{schema:schema,addNodeFilter:htmlParser.addNodeFilter,addAttributeFilter:htmlParser.addAttributeFilter,onPreProcess:onPreProcess,onPostProcess:onPostProcess,serialize:function(node,args){var impl,doc,oldDoc,htmlSerializer,content,rootNode;return isIE&&dom.select("script,style,select,map").length>0?(content=node.innerHTML,node=node.cloneNode(!1),dom.setHTML(node,content)):node=node.cloneNode(!0),impl=document.implementation,impl.createHTMLDocument&&(doc=impl.createHTMLDocument(""),each("BODY"==node.nodeName?node.childNodes:[node],function(node){doc.body.appendChild(doc.importNode(node,!0))}),node="BODY"!=node.nodeName?doc.body.firstChild:doc.body,oldDoc=dom.doc,dom.doc=doc),args=args||{},args.format=args.format||"html",args.selection&&(args.forced_root_block=""),args.no_events||(args.node=node,onPreProcess.dispatch(self,args)),rootNode=htmlParser.parse(tinymce.trim(args.getInner?node.innerHTML:dom.getOuterHTML(node)),args),trimTrailingBr(rootNode),htmlSerializer=new tinymce.html.Serializer(settings,schema),args.content=htmlSerializer.serialize(rootNode),args.cleanup||(args.content=args.content.replace(/\uFEFF/g,"")),args.no_events||onPostProcess.dispatch(self,args),oldDoc&&(dom.doc=oldDoc),args.node=null,args.content},addRules:function(rules){schema.addValidElements(rules)},setRules:function(rules){schema.setValidElements(rules)}}}}(tinymce),function(tinymce){tinymce.dom.ScriptLoader=function(){function loadScript(url,callback){function done(){dom.remove(id),elm&&(elm.onreadystatechange=elm.onload=elm=null),callback()}function error(){"undefined"!=typeof console&&console.log&&console.log("Failed to load: "+url)}var elm,id,dom=tinymce.DOM;id=dom.uniqueId(),elm=document.createElement("script"),elm.setAttribute("data-cfasync",!1),elm.id=id,elm.type="text/javascript",elm.src=tinymce._addVer(url),tinymce.isIE&&!tinymce.isIE11||(elm.onload=done),elm.onerror=error,tinymce.isOpera||(elm.onreadystatechange=function(){var state=elm.readyState;"complete"!=state&&"loaded"!=state||done()}),(document.getElementsByTagName("head")[0]||document.body).appendChild(elm)}var undef,QUEUED=0,LOADING=1,LOADED=2,states={},queue=[],scriptLoadedCallbacks={},queueLoadedCallbacks=[],loading=0;this.isDone=function(url){return states[url]==LOADED},this.markDone=function(url){states[url]=LOADED},this.add=this.load=function(url,callback,scope){var state=states[url];state==undef&&(queue.push(url),states[url]=QUEUED),callback&&(scriptLoadedCallbacks[url]||(scriptLoadedCallbacks[url]=[]),scriptLoadedCallbacks[url].push({func:callback,scope:scope||this}))},this.loadQueue=function(callback,scope){this.loadScripts(queue,callback,scope)},this.loadScripts=function(scripts,callback,scope){function execScriptLoadedCallbacks(url){tinymce.each(scriptLoadedCallbacks[url],function(callback){callback.func.call(callback.scope)}),scriptLoadedCallbacks[url]=undef}var loadScripts;queueLoadedCallbacks.push({func:callback,scope:scope||this}),(loadScripts=function(){var loadingScripts=tinymce.grep(scripts);scripts.length=0,tinymce.each(loadingScripts,function(url){return states[url]==LOADED?void execScriptLoadedCallbacks(url):void(states[url]!=LOADING&&(states[url]=LOADING,loading++,loadScript(url,function(){states[url]=LOADED,loading--,execScriptLoadedCallbacks(url),loadScripts()})))}),loading||(tinymce.each(queueLoadedCallbacks,function(callback){callback.func.call(callback.scope)}),queueLoadedCallbacks.length=0)})()}},tinymce.ScriptLoader=new tinymce.dom.ScriptLoader}(tinymce),function(tinymce){tinymce.dom.StyleSheetLoader=function(document){function loadStylesheet(url,callback){function done(){complete||(complete=!0,elm&&(elm.onreadystatechange=elm.onload=elm=null),callback())}function error(){"undefined"!=typeof console&&console.log&&console.log("Failed to load: "+url),done()}function wait(testCallback,waitCallback){testCallback()||((new Date).getTime()-startTime<maxLoadTime?setTimeout(waitCallback):error())}function waitForLoaded(){wait(function(){for(var styleSheet,owner,styleSheets=document.styleSheets,i=styleSheets.length;i--;)if(styleSheet=styleSheets[i],owner=styleSheet.ownerNode?styleSheet.ownerNode:styleSheet.owningElement,owner&&owner.id===elm.id)return done(),!0},waitForLoaded)}var elm,id,startTime,complete,dom=tinymce.DOM;id=dom.uniqueId(),elm=document.createElement("link"),elm.rel="stylesheet",elm.type="text/css",elm.href=tinymce._addVer(url),elm.async=!1,elm.defer=!1,startTime=(new Date).getTime(),elm.setAttribute("data-cfasync",!1),elm.id=id,elm.onload=waitForLoaded,elm.onerror=error,(document.getElementsByTagName("head")[0]||document.body).appendChild(elm)}var undef,QUEUED=0,LOADING=1,LOADED=2,states={},queue=[],stylesheetLoadedCallbacks={},queueLoadedCallbacks=[],loading=0,maxLoadTime=5e3;this.isDone=function(url){return states[url]==LOADED},this.markDone=function(url){states[url]=LOADED},this.add=this.load=function(url,callback,scope){var state=states[url];state==undef&&(queue.push(url),states[url]=QUEUED),callback&&(stylesheetLoadedCallbacks[url]||(stylesheetLoadedCallbacks[url]=[]),stylesheetLoadedCallbacks[url].push({func:callback,scope:scope||this}))},this.loadQueue=function(callback,scope){this.loadStylesheets(queue,callback,scope)},this.loadStylesheets=function(stylesheets,callback,scope){function execstylesheetLoadedCallbacks(url){tinymce.each(stylesheetLoadedCallbacks[url],function(callback){callback.func.call(callback.scope)}),stylesheetLoadedCallbacks[url]=undef}var loadStylesheets;queueLoadedCallbacks.push({func:callback,scope:scope||this}),(loadStylesheets=function(){var loadingstylesheets=tinymce.grep(stylesheets);stylesheets.length=0,tinymce.each(loadingstylesheets,function(url){return states[url]==LOADED?void execstylesheetLoadedCallbacks(url):void(states[url]!=LOADING&&(states[url]=LOADING,loading++,loadStylesheet(url,function(){states[url]=LOADED,loading--,execstylesheetLoadedCallbacks(url),loadStylesheets()})))}),loading||(tinymce.each(queueLoadedCallbacks,function(callback){callback.func.call(callback.scope)}),queueLoadedCallbacks.length=0)})()},this.loadStylesheet=loadStylesheet},tinymce.StyleSheetLoader=new tinymce.dom.StyleSheetLoader}(tinymce),function(tinymce){function FocusManager(editorManager){function getActiveElement(){try{return document.activeElement}catch(ex){return document.body}}function createBookmark(dom,rng){if(rng&&rng.startContainer){if(!dom.isChildOf(rng.startContainer,dom.getRoot())||!dom.isChildOf(rng.endContainer,dom.getRoot()))return;return{startContainer:rng.startContainer,startOffset:rng.startOffset,endContainer:rng.endContainer,endOffset:rng.endOffset}}return rng}function bookmarkToRng(editor,bookmark){var rng;return bookmark.startContainer?(rng=editor.getDoc().createRange(),rng.setStart(bookmark.startContainer,bookmark.startOffset),rng.setEnd(bookmark.endContainer,bookmark.endOffset)):rng=bookmark,rng}function registerEvents(editor){editor.onSetContent.add(function(){editor.lastRng=null}),editor.onMouseDown.add(function(){editor.selection.lastFocusBookmark=null}),editor.onFocusIn.add(function(){var lastRng,focusedEditor=editorManager.focusedEditor;editor.selection.lastFocusBookmark&&(lastRng=bookmarkToRng(editor,editor.selection.lastFocusBookmark),editor.selection.lastFocusBookmark=null,editor.selection.setRng(lastRng)),focusedEditor!=editor&&(focusedEditor&&(focusedEditor.onBlur.dispatch(focusedEditor,{focusedEditor:editor}),focusedEditor.onDeactivate.dispatch(focusedEditor,editor)),editorManager.setActive(editor),editorManager.focusedEditor=editor,editor.onFocus.dispatch(editor,{blurredEditor:focusedEditor}),editor.onActivate.dispatch(editor,focusedEditor),editor.focus(!0)),editor.lastRng=null}),editor.onFocusOut.add(function(){setTimeout(function(){var focusedEditor=editorManager.focusedEditor;isUIElement(editor,getActiveElement())||focusedEditor!=editor||(editor.onBlur.dispatch(editor,{focusedEditor:null}),editorManager.focusedEditor=null,editor.selection&&(editor.selection.lastFocusBookmark=null))},10)}),documentFocusInHandler||(documentFocusInHandler=function(e){var target,activeEditor=editorManager.activeEditor;target=e.target,activeEditor&&target.ownerDocument===document&&(activeEditor.selection&&target!==activeEditor.getBody()&&isElementOutsideEditor(editor,target)&&(activeEditor.selection.lastFocusBookmark=createBookmark(activeEditor.dom,activeEditor.lastRng)),target===document.body||isUIElement(activeEditor,target)||editorManager.focusedEditor!==activeEditor||(activeEditor.onBlur.dispatch(editor,{focusedEditor:null}),editorManager.focusedEditor=null))},DOM.bind(document,"focusin",documentFocusInHandler))}function unregisterDocumentEvents(editor){editorManager.focusedEditor==editor&&(editorManager.focusedEditor=null),editorManager.activeEditor||(DOM.unbind(document,"selectionchange",selectionChangeHandler),DOM.unbind(document,"focusin",documentFocusInHandler),DOM.unbind(document,"mouseup",documentMouseUpHandler),selectionChangeHandler=documentFocusInHandler=documentMouseUpHandler=null)}editorManager.onAddEditor.add(function(mgr,editor){registerEvents(editor)}),editorManager.onRemoveEditor.add(function(mgr,editor){unregisterDocumentEvents(editor)})}var selectionChangeHandler,documentFocusInHandler,documentMouseUpHandler,DOM=tinymce.DOM,isUIElement=function(editor,elm){var customSelector=editor?editor.settings.custom_ui_selector:"",parent=DOM.getParent(elm,function(elm){return FocusManager.isEditorUIElement(elm)||!!customSelector&&editor.dom.is(elm,customSelector)});return null!==parent},isElementOutsideEditor=function(editor,target){return editor.dom.isChildOf(target,editor.getBody())===!1};FocusManager.isEditorUIElement=function(elm){return elm.className.toString().indexOf("mce")!==-1},tinymce.dom.FocusManager=FocusManager}(tinymce),function(tinymce){var Event=tinymce.dom.Event,each=tinymce.each;tinymce.create("tinymce.ui.KeyboardNavigation",{KeyboardNavigation:function(settings,dom){var itemFocussed,itemBlurred,rootKeydown,rootFocussed,focussedId,self=this,root=settings.root,items=settings.items,enableUpDown=settings.enableUpDown,enableLeftRight=settings.enableLeftRight||!settings.enableUpDown,excludeFromTabOrder=settings.excludeFromTabOrder;dom=dom||tinymce.DOM,itemFocussed=function(evt){focussedId=evt.target.id},itemBlurred=function(evt){dom.setAttrib(evt.target.id,"tabindex","-1")},rootFocussed=function(){var item=dom.get(focussedId);dom.setAttrib(item,"tabindex","0"),item.focus()},this.focus=function(){dom.get(focussedId).focus()},this.update=function(value){items=value,each(items,function(item,idx){var tabindex,elm;item.id||(item.id=dom.uniqueId("_mce_item_")),elm=dom.get(item.id),excludeFromTabOrder?(dom.bind(elm,"blur",itemBlurred),tabindex="-1"):tabindex=0===idx?"0":"-1",elm.setAttribute("tabindex",tabindex),dom.bind(elm,"focus",itemFocussed)})},this.destroy=function(){each(items,function(item){var elm=dom.get(item.id);dom.unbind(elm,"focus",itemFocussed),dom.unbind(elm,"blur",itemBlurred)});var rootElm=dom.get(root);dom.unbind(rootElm,"focus",rootFocussed),dom.unbind(rootElm,"keydown",rootKeydown),items=dom=root=this.focus=itemFocussed=itemBlurred=rootKeydown=rootFocussed=null,this.destroy=function(){}},this.moveFocus=function(dir,evt){var newFocus,idx=-1;focussedId&&(each(items,function(item,index){if(item.id===focussedId)return idx=index,!1}),idx+=dir,idx<0?idx=items.length-1:idx>=items.length&&(idx=0),newFocus=items[idx],dom.setAttrib(focussedId,"tabindex","-1"),dom.setAttrib(newFocus.id,"tabindex","0"),dom.get(newFocus.id).focus(),settings.actOnFocus&&settings.onAction(newFocus.id),evt&&Event.cancel(evt))},rootKeydown=function(evt){var DOM_VK_LEFT=37,DOM_VK_RIGHT=39,DOM_VK_UP=38,DOM_VK_DOWN=40,DOM_VK_ESCAPE=27,DOM_VK_ENTER=14,DOM_VK_RETURN=13,DOM_VK_SPACE=32;switch(evt.keyCode){case DOM_VK_LEFT:enableLeftRight&&(self.moveFocus(-1),Event.cancel(evt));break;case DOM_VK_RIGHT:enableLeftRight&&(self.moveFocus(1),Event.cancel(evt));break;case DOM_VK_UP:enableUpDown&&(self.moveFocus(-1),Event.cancel(evt));break;case DOM_VK_DOWN:enableUpDown&&(self.moveFocus(1),Event.cancel(evt));break;case DOM_VK_ESCAPE:settings.onCancel&&(settings.onCancel(),Event.cancel(evt));break;case DOM_VK_ENTER:case DOM_VK_RETURN:case DOM_VK_SPACE:settings.onAction&&(Event.cancel(evt),settings.onAction(evt,focussedId))}},this.update(items),items[0]&&(focussedId=items[0].id),dom.setAttrib(root,"tabindex","-1");var rootElm=dom.get(root);dom.bind(rootElm,"focus",rootFocussed),dom.bind(rootElm,"keydown",rootKeydown)}})}(tinymce),function(tinymce){var DOM=tinymce.DOM;tinymce.create("tinymce.ui.Control",{Control:function(id,settings,editor){this.id=id,this.settings=settings||{},this.rendered=!1,this.onRender=new tinymce.util.Dispatcher(this),this.classPrefix="mce",this.scope=this.settings.scope||this,this.disabled=0,this.active=0,this.editor=editor,this.name=this.settings.name||id},setAriaProperty:function(property,value){var element=DOM.get(this.id+"_aria")||DOM.get(this.id);element&&DOM.setAttrib(element,"aria-"+property,!!value)},focus:function(){DOM.get(this.id).focus()},setDisabled:function(state){state!=this.disabled&&(this.setAriaProperty("disabled",state),this.setState("Disabled",state),this.setState("Enabled",!state),this.disabled=state)},isDisabled:function(){return this.disabled},setActive:function(s){s!=this.active&&(this.setState("Active",s),this.active=s,this.setAriaProperty("pressed",s))},isActive:function(){return this.active},setState:function(c,s){var n=DOM.get(this.id);c=this.classPrefix+c,s?DOM.addClass(n,c):DOM.removeClass(n,c)},isRendered:function(){return this.rendered},renderHTML:function(){},renderTo:function(n){var frag=DOM.createFragment(this.renderHTML());n.appendChild(frag),this.postRender()},postRender:function(){var state;tinymce.is(this.disabled)&&(state=this.disabled,this.disabled=-1,this.setDisabled(state)),tinymce.is(this.active)&&(state=this.active,this.active=-1,this.setActive(state)),this._elm=DOM.get(this.id)},parent:function(ctrl){return ctrl?void(this._parent=ctrl):this._parent||null},remove:function(){this.destroy(),DOM.remove(this.id)},destroy:function(){tinymce.dom.Event.clear(this.id)}})}(tinymce),tinymce.create("tinymce.ui.Container:tinymce.ui.Control",{Container:function(id,settings,editor){var self=this;settings=settings||{},this._super(id,settings,editor),this.controls=[],this.lookup={},settings.controls&&tinymce.each(settings.controls,function(ctrl){self.add(ctrl)})},add:function(ctrl){return this.lookup[ctrl.id]=ctrl,this.controls.push(ctrl),ctrl.parent(this),ctrl},destroy:function(){var i;for(this._super(),i=0;i<this.controls.length;i++)this.controls[i].destroy();delete this.lookup[this.id]},get:function(id){return this.lookup[id]}}),function(tinymce){var dom=tinymce.DOM;tinymce.create("tinymce.ui.Form:tinymce.ui.Container",{renderHTML:function(){var i,html="",settings=this.settings;for(i=0;i<this.controls.length;i++){var ctrl=this.controls[i],s=ctrl.settings;html+='<div class="mceFormRow">',s.label&&(html+='<label for="'+ctrl.id+'">'+s.label+"</label>"),html+='\t<div class="mceFormControl">',html+=ctrl.renderHTML(),html+="\t</div>",html+="</div>"}return dom.createHTML("div",{id:this.id,class:"mceForm"+(settings.class?" "+settings.class:""),role:"group"},html)},submit:function(){var i,data={};for(i=0;i<this.controls.length;i++){var ctrl=this.controls[i];"function"==typeof ctrl.value&&(data[ctrl.name]=ctrl.value())}return data},update:function(data){var i;for(i=0;i<this.controls.length;i++){var ctrl=this.controls[i];data[ctrl.name]&&"function"==typeof ctrl.value&&ctrl.value(data[ctrl.name])}},empty:function(){var i;for(i=0;i<this.controls.length;i++)this.controls[i].remove();this.controls=[],this.lookup={}},add:function(ctrl){return!this.get(ctrl.id)&&this._super(ctrl)},postRender:function(){var i;for(this._super(),i=0;i<this.controls.length;i++)this.controls[i].postRender()}})}(tinymce),tinymce.create("tinymce.ui.Separator:tinymce.ui.Control",{Separator:function(id,s){this._super(id,s),this.classPrefix="mceSeparator",this.setDisabled(!0)},renderHTML:function(){return tinymce.DOM.createHTML("span",{class:this.classPrefix,role:"separator","aria-orientation":"vertical",tabindex:"-1"},"")}}),function(tinymce){tinymce.create("tinymce.ui.MenuItem:tinymce.ui.Control",{MenuItem:function(id,settings){this._super(id,settings)},setSelected:function(state){this.setState("Selected",state),this.setAriaProperty("checked",!!state),this.selected=state},isSelected:function(){return this.selected},postRender:function(){this._super(),tinymce.is(this.selected)&&this.setSelected(this.selected)}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,walk=tinymce.walk;tinymce.create("tinymce.ui.Menu:tinymce.ui.MenuItem",{Menu:function(id,settings){this._super(id,settings),this.items={},this.collapsed=!1,this.menuCount=0,this.onAddItem=new tinymce.util.Dispatcher(this)},expand:function(d){var self=this;d&&walk(self,function(o){o.expand&&o.expand()},"items",self),this.collapsed=!1},collapse:function(state){var self=this;state&&walk(self,function(menu){menu.collapse&&menu.collapse()},"items",self),this.collapsed=!0},isCollapsed:function(){return this.collapsed},add:function(menu){return menu.settings||(menu=new tinymce.ui.MenuItem(menu.id||DOM.uniqueId(),menu)),this.onAddItem.dispatch(this,menu),this.items[menu.id]=menu},addSeparator:function(){return this.add({separator:!0})},addMenu:function(menu){return menu.collapse||(menu=this.createMenu(menu)),this.menuCount++,this.add(menu)},hasMenus:function(){return 0!==this.menuCount},remove:function(menu){delete this.items[menu.id]},removeAll:function(){var self=this;walk(self,function(menu){menu.removeAll?menu.removeAll():menu.remove(),menu.destroy()},"items",self),this.items={}},createMenu:function(settings){var menu=new tinymce.ui.Menu(settings.id||DOM.uniqueId(),settings);return menu.onAddItem.add(this.onAddItem.dispatch,this.onAddItem),menu}})}(tinymce),function(tinymce){function escapeRegExChars(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")}function nodeIndex(nodes,node){for(var i=0;i<nodes.length;i++)if(nodes[i]===node)return i;return-1}var undef,DOM=tinymce.DOM,each=tinymce.each,Event=tinymce.dom.Event,specialKeyCodeMap={9:"tab",17:"ctrl",18:"alt",27:"esc",37:"left",39:"right",13:"enter",91:"cmd",38:"up",40:"down"};tinymce.create("tinymce.ui.DropMenu:tinymce.ui.Menu",{DropMenu:function(id,s){s=s||{},s.container=s.container||DOM.doc.body,s.offset_x=s.offset_x||0,s.offset_y=s.offset_y||0,s.vp_offset_x=s.vp_offset_x||0,s.vp_offset_y=s.vp_offset_y||0,this._super(id,s),this.onShowMenu=new tinymce.util.Dispatcher(this),this.onHideMenu=new tinymce.util.Dispatcher(this),this.onFilterInput=new tinymce.util.Dispatcher(this),this.classPrefix="mceMenu",this.selected=[]},createMenu:function(s){var m,self=this,cs=self.settings;return s.container=s.container||cs.container,s.parent=self,s.constrain=s.constrain||cs.constrain,s.class=s.class||cs.class,s.vp_offset_x=s.vp_offset_x||cs.vp_offset_x,s.vp_offset_y=s.vp_offset_y||cs.vp_offset_y,s.keyboard_focus=cs.keyboard_focus,m=new tinymce.ui.DropMenu(s.id||DOM.uniqueId(),s),m.onAddItem.add(self.onAddItem.dispatch,self.onAddItem),m},focus:function(){var self=this;self.keyboardNav&&self.keyboardNav.focus()},update:function(){var self=this,s=self.settings,m=DOM.get("menu_"+self.id);s.max_width&&DOM.setStyle(m,"width",s.max_width),s.max_height&&DOM.setStyle(m,"height",s.max_height)},scrollTo:function(el){var p=el.parentNode;p.scrollTop=el.offsetTop},deselectAll:function(){var self=this;each(self.items,function(item){item.setSelected(0)})},selectItem:function(item,state){var self=this;if(item.setSelected(state),state)self.selected.push(item);else{var idx=tinymce.inArray(self.selected,item);idx>=0&&self.selected.splice(idx,1)}return item},findItem:function(val){var found,self=this;return each(self.items,function(item){if(item.settings.title===val)return found=item,!1}),found},clearFilterInput:function(){var self=this,filter=DOM.get("menu_"+self.id+"_filter"),input=DOM.select("input","menu_"+self.id+"_filter_input")[0];filter&&(input.value="",input.focus(),self.clearFilteredItems())},showMenu:function(x,y,px,py){var co,w,h,mx,my,self=this,s=self.settings,vp=DOM.getViewPort(),ot=0,cp=self.classPrefix;if(self.collapse(1),!self.isMenuVisible&&(self.selected=[],self.rendered?co=DOM.get("menu_"+self.id):(co=DOM.add(self.settings.container,self.renderNode()),each(self.items,function(o){o.postRender()})),co)){if(DOM.show(co),self.update(),x+=s.offset_x||0,y+=s.offset_y||0,s.constrain&&(w=co.clientWidth-ot,h=co.clientHeight-ot,mx=vp.x+vp.w,my=vp.y+vp.h,x+s.vp_offset_x+w>mx&&(x=px?px-w:Math.max(0,mx-s.vp_offset_x-w)),y+s.vp_offset_y+h>my&&(y=py?py-h-8:Math.max(0,my-s.vp_offset_y-h))),DOM.setStyles(co,{left:x,top:y}),self.isMenuVisible=1,self.mouseClickFunc=Event.add(co,"click",function(e){var n;if(n=e.target,"INPUT"!=n.nodeName&&n&&(n=DOM.getParent(n,".mceMenuItem"))&&!DOM.hasClass(n,cp+"ItemSub")){var item=self.items[n.id];return!(!item||item.isDisabled()||(item.settings.onAction&&item.settings.onAction(e),item.settings.onclick&&(item.settings.onclick(e),self.close()),self.clearFilterInput(),1))}}),self.mouseOverFunc=Event.add(co,"mouseover",function(e){var m,r,n;if(n=e.target,n&&(n=DOM.getParent(n,".mceMenuItem"))){if(m=self.items[n.id],self.hasMenus()){if(self.lastMenu&&self.lastMenu.collapse(1),m.isDisabled())return;n&&DOM.hasClass(n,cp+"ItemSub")&&(r=DOM.getRect(n),m.showMenu(r.x+r.w-ot,r.y-ot,r.x),self.lastMenu=m)}m.settings.onmouseover&&m.settings.onmouseover(e)}}),Event.add(co,"keydown",self._keyDownHandler,self),s.filter&&Event.add(co,"keyup",self._keyUpHandler,self),self.onShowMenu.dispatch(self),each(self.items,function(o){o.selected&&tinymce.inArray(self.selected,o)===-1&&self.selected.push(o)}),self.selected.length){var el=DOM.get(self.selected[0].id);self.scrollTo(el)}else DOM.get("menu_"+self.id+"_items").scrollTop=0;if(s.keyboard_focus&&self._setupKeyboardNav(),s.filter){var input=DOM.select("input","menu_"+self.id+"_filter_input");input&&input[0].focus()}}},hideMenu:function(c){var e,self=this,co=DOM.get("menu_"+self.id);self.isMenuVisible&&(self.settings.filter&&self.clearFilterInput(!0),Event.remove(co,"click",self.mouseClickFunc),Event.remove(co,"keydown",self._keyDownHandler),Event.remove(co,"keyup",self._keyUpHandler),DOM.hide(co),self.isMenuVisible=0,c||self.collapse(1),e=DOM.get("menu_"+self.id),e&&DOM.removeClass(e.firstChild,self.classPrefix+"ItemActive"),self.onHideMenu.dispatch(self))},add:function(o){var co,self=this;return o=self._super(o),self.isRendered&&(co=DOM.get("menu_"+self.id+"_items"))&&self._add(co,o),o},collapse:function(d){this._super(d),this.hideMenu(1)},close:function(){for(var self=this,dm=self;dm;)dm.hideMenu&&dm.hideMenu(),dm=dm.settings.parent},remove:function(o){return DOM.remove(o.id),this.destroy(),this._super(o)},destroy:function(){var self=this,co=DOM.get("menu_"+self.id);self.keyboardNav&&self.keyboardNav.destroy(),Event.remove(co,"mouseover",self.mouseOverFunc),Event.remove(DOM.select("a",co),"focus",self.mouseOverFunc),Event.remove(co,"click",self.mouseClickFunc),Event.remove(co,"keyup",self._keyUpHandler),Event.remove(co,"keydown",self._keyDownHandler),DOM.remove(co)},renderNode:function(){var menu,items,self=this,s=self.settings;if(menu=DOM.create("div",{role:"menu",id:"menu_"+self.id,class:s.class+" "+self.classPrefix}),self.settings.parent&&DOM.setAttrib(menu,"aria-parent",self.settings.parent.id),s.filter){var filter=DOM.add(menu,"div",{id:"menu_"+self.id+"_filter",class:self.classPrefix+"Filter"},""),filterInput=DOM.add(filter,"div",{id:"menu_"+self.id+"_filter_input",class:self.classPrefix+"FilterInput"},'<input type="text" autocomplete="off" autocapitalize="off" spellcheck="false" placeholder="..." />');self.onHideMenu.add(function(){filterInput.firstChild.value=""})}return items=DOM.add(menu,"div",{role:"presentation",id:"menu_"+self.id+"_items",class:self.classPrefix+"Items"}),each(self.items,function(o){self._add(items,o)}),self.rendered=!0,menu},selectAndClear:function(value){var self=this;self.settings.onselect(value),self.clearFilterInput()},_setupKeyboardNav:function(){var contextMenu,menuItems,self=this;contextMenu=DOM.get("menu_"+self.id),menuItems=DOM.select('div[role="option"]',"menu_"+self.id),menuItems.splice(0,0,contextMenu),self.keyboardNav=new tinymce.ui.KeyboardNavigation({root:"menu_"+self.id,items:menuItems,onCancel:function(){self.hideMenu()},onAction:function(e,id){if(menuItems.length>1){if(e.target&&"INPUT"===e.target.nodeName){var val=e.target.value;if(""!==val){var item=self.findItem(val);item?id=item.id:(id=DOM.uniqueId(),item=self.add({id:id,role:"option",title:val,onclick:function(){self.selectAndClear(this.settings.value)}}))}e.target.value=""}}else self.settings.onselect&&self.settings.onselect(e.target),self.hideMenu();item=item||self.items[id],item&&item.settings.value&&self.selectAndClear(item.settings.value)},enableUpDown:!0}),contextMenu.focus()},_updateKeyboardNav:function(){var items=DOM.select('div[role="option"]:not(.mceMenuItemHidden)',this.id+"");this.keyboardNav.update(items)},clearFilteredItems:function(){each(this.items,function(o,id){DOM.removeClass(id,"mceMenuItemHidden")}),this.keyboardNav&&this._updateKeyboardNav()},filterItems:function(value){var self=this;if(""===value)return void self.clearFilteredItems();var matcher=new RegExp("^"+escapeRegExChars(value),"i");each(self.items,function(o,id){var state,s=o.settings;state=!value||value===undef||matcher.test(s.title),state?DOM.removeClass(id,"mceMenuItemHidden"):DOM.addClass(id,"mceMenuItemHidden")}),this._updateKeyboardNav()},_keyDownHandler:function(evt){var self=this,tabIndex=0;if(9==evt.keyCode){var nodes=DOM.select("input, button, select, textarea",DOM.get("menu_"+self.id));if(nodes=tinymce.grep(nodes,function(node){return!node.disabled&&!DOM.isHidden(node)&&node.getAttribute("tabindex")>=0}),!nodes.length)return;DOM.setAttrib(nodes,"tabindex",0),evt.shiftKey&&nodes.reverse();var endIndex=Math.max(0,nodes.length-1);tabIndex=nodeIndex(nodes,evt.target),tabIndex++,tabIndex=Math.max(tabIndex,0),tabIndex>endIndex&&(tabIndex=0),nodes[tabIndex].focus(),DOM.setAttrib(nodes[tabIndex],"tabindex",1),evt.preventDefault(),evt.stopImmediatePropagation()}},_keyUpHandler:function(evt){var self=this;if(evt.target&&"INPUT"===evt.target.nodeName){var input=evt.target;setTimeout(function(){if(32===evt.keyCode){var item=self.findItem(input.value);item&&self.selectItem(item),input.value=""}specialKeyCodeMap[evt.keyCode]||self.filterItems(input.value),self.onFilterInput.dispatch(self,evt)},0)}},_add:function(menu,o){var icon,s=o.settings,cp=this.classPrefix;if(s.separator)return void DOM.add(menu,"div",{id:o.id,class:cp+"Item "+cp+"ItemSeparator"});var item=DOM.add(menu,"div",{id:o.id,class:cp+"Item "+cp+"ItemEnabled",title:o.settings.title||"","aria-label":o.settings.title||""});if(s.html)DOM.addClass(item,"mceMenuHtml"),DOM.setHTML(item,s.html);else{DOM.setAttrib(item,"role","option"),!s.icon&&!s.icon_src||s.svg||s.image||(icon=DOM.add(item,"span",{class:"mceIcon"+(s.icon?" mce_"+s.icon:"")}),s.icon_src&&DOM.add(icon,"img",{src:s.icon_src}),DOM.addClass(item,"mceHasIcon")),s.image&&DOM.add(item,"span",{class:"mceImage",style:'background-image:url("'+s.image+'")'}),s.svg&&DOM.add(item,"span",{class:"mceIcon mceIconSvg"},s.svg);var txt=DOM.add(item,s.element||"span",{class:"mceText",role:"presentation"},o.settings.title);o.settings.style&&("function"==typeof o.settings.style&&(o.settings.style=o.settings.style()),DOM.setAttrib(txt,"style",o.settings.style)),s.parent&&(DOM.setAttrib(txt,"aria-haspopup","true"),DOM.setAttrib(txt,"aria-owns",o.id))}DOM.addClass(item,s.class),o.onmouseover&&Event.add(item,"mouseover",o.onmouseover),o.collapse&&DOM.addClass(item,cp+"ItemSub")}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event,Dispatcher=tinymce.util.Dispatcher;tinymce.create("tinymce.ui.Button:tinymce.ui.Control",{Button:function(id,s,ed){this._super(id,s,ed),this.classPrefix="mceButton",this.onPostRender=new Dispatcher(this)},renderHTML:function(){var h,l,cp=this.classPrefix,s=this.settings;return l=DOM.encode(s.label||""),h='<button type="button" id="'+this.id+'" class="'+cp+" "+s.class+(l?" "+cp+"Labeled":"")+'" title="'+DOM.encode(s.title)+'" aria-label="'+DOM.encode(s.title)+'">',s.class&&(s.class=" "+tinymce.trim(s.class)),s.icon=s.icon||"",s.image?h+='<span role="presentation" class="mceIcon mceIconImage'+s.class+'"><img class="mceIcon" src="'+s.image+'" alt="'+DOM.encode(s.title)+'" /></span>'+(l?'<span class="'+cp+'Label">'+l+"</span>":""):(s.icon&&(s.icon=" mce_"+s.icon),h+='<span role="presentation" class="mceIcon'+s.class+s.icon+'"></span>'+(l?'<span class="'+cp+'Label">'+l+"</span>":"")),h+="</button>"},postRender:function(){var imgBookmark,self=this,s=self.settings;tinymce.isIE&&self.editor&&Event.add(self.id,"mousedown",function(){var nodeName=self.editor.selection.getNode().nodeName;imgBookmark="IMG"===nodeName?self.editor.selection.getBookmark():null}),Event.add(self.id,"click",function(e){if(Event.cancel(e),!self.isDisabled())return tinymce.isIE&&self.editor&&null!==imgBookmark&&self.editor.selection.moveToBookmark(imgBookmark),s.onclick.call(s.scope,e)}),Event.add(self.id,"keydown",function(e){if(!self.isDisabled()&&e.keyCode==tinymce.VK.SPACEBAR)return Event.cancel(e),s.onclick.call(s.scope,e)}),this.rendered=!0,this.onPostRender.dispatch(this,DOM.get(this.id))}})}(tinymce),function(tinymce){var undef,DOM=tinymce.DOM,Event=tinymce.dom.Event,each=tinymce.each,Dispatcher=tinymce.util.Dispatcher,specialKeyCodeMap={9:"tab",17:"ctrl",18:"alt",27:"esc",37:"left",39:"right",13:"enter",91:"cmd",38:"up",40:"down"};tinymce.create("tinymce.ui.ListBox:tinymce.ui.Control",{ListBox:function(id,s,ed){this._super(id,s,ed),this.items=s.items||[],this.onChange=new Dispatcher(this),this.onPostRender=new Dispatcher(this),this.onAdd=new Dispatcher(this),this.onBeforeRenderMenu=new Dispatcher(this),this.onRenderMenu=new Dispatcher(this),this.classPrefix="mceListBox"},deselectAll:function(){var self=this;each(self.items,function(item){item.selected=!1}),self.menu&&self.menu.deselectAll()},select:function(values){var fv,self=this;return null==values||values==undef?this.selectByIndex(-1):values.length?(this.settings.multiple||this.deselectAll(),"function"==typeof values?(each(self.items,function(item,i){values(item.value)&&(self.selectByIndex(i),fv=!0)}),void(fv||self.selectByIndex(-1))):(tinymce.is(values,"string")&&(values=self.settings.multiple&&self.settings.seperator?values.split(self.settings.seperator):[values]),each(values,function(value){var i=self.findItem(value);i==-1&&self.settings.combobox&&(i=self.add(value,value)),self.selectByIndex(i)}),void(this.settings.combobox&&(this.clearComboBox(!0),this.settings.multiple&&each(this.items,function(item){item.selected&&self.addTag(item.value)}))))):(this.deselectAll(),this.selectByIndex(-1))},value:function(val){
return arguments.length?void this.select(val):(val=[],each(this.items,function(item){item.selected&&val.push(item.value)}),val.join(" ").trim())},selectByIndex:function(idx){var elm,item,self=this;elm=DOM.get(this.id+"_text"),item=this.items[idx],item?(item.selected=!item.selected,item.selected?this.selectedValue=item.value:this.selectedValue=null,this.settings.combobox||(DOM.setHTML(elm,DOM.encode(item.title)),DOM.removeClass(elm,"mceTitle"),DOM.setAttrib(this.id,"aria-valuenow",item.title)),self.menu&&self.menu.selectItem(self.menu.items[item.id],item.selected)):(DOM.setHTML(elm,DOM.encode(this.settings.title)),DOM.addClass(elm,"mceTitle"),this.selectedValue=null,DOM.setAttrib(this.id,"aria-valuenow",this.settings.title),self.settings.multiple&&self.deselectAll())},add:function(name,value,settings){if(settings=settings||{},this.findItem(value)==-1){settings=tinymce.extend(settings,{title:name,value:value});var len=this.items.push(settings);return this.onAdd.dispatch(this,settings),len-1}},findItem:function(value){for(var idx=-1,i=0,len=this.items.length;i<len;i++)this.items[i].value===value&&(idx=i);return idx},getLength:function(){return this.items.length},renderHTML:function(){var html="",prefix=this.classPrefix;if(this.settings.combobox){var inp=DOM.createHTML("input",{type:"text",id:this.id+"_input",tabindex:-1,autocomplete:"off",spellcheck:!1,autocapitalize:"off",class:"mceText",placeholder:"..."});html+=DOM.createHTML("div",{class:"mceComboBox"},inp)}else html+=DOM.createHTML("button",{type:"button",id:this.id+"_text",tabindex:-1,class:"mceText"},DOM.encode(this.settings.title));return html+=DOM.createHTML("button",{type:"button",id:this.id+"_open",tabindex:-1,class:"mceOpen"}),DOM.createHTML("div",{id:this.id,role:this.settings.combobox?"combobox":"listbox",tabindex:0,class:prefix+" "+this.settings.class,title:this.settings.title,"aria-label":this.settings.title,"aria-haspopup":"true","aria-expanded":!1},html)},clearComboBox:function(removetags){var self=this,input=DOM.get(self.id+"_input");input.value="",input.focus(),removetags&&DOM.remove(DOM.select(".mceButtonTag",this.id))},removeTag:function(btn){var self=this;each(self.items,function(item,i){item.value===btn.value&&(item.selected=!1,self.selectedValue==item.value&&(self.selectedValue=null))}),Event.clear(btn),DOM.remove(btn)},addTag:function(value){var btn,inp,self=this;inp=DOM.get(self.id+"_input"),btn=DOM.create("button",{class:"mceButton mceButtonTag",value:value},"<label>"+value+"</label>"),DOM.insertBefore(btn,inp),Event.add(btn,"click",function(evt){evt.preventDefault(),"LABEL"!=evt.target.nodeName&&self.removeTag(btn)})},showMenu:function(){var pos,menu,self=this,elm=DOM.get(this.id);this.isDisabled()||(this.isMenuRendered||(this.renderMenu(),this.isMenuRendered=!0),0!==this.items.length&&(pos=DOM.getPos(elm),menu=this.menu,menu.settings.offset_x=pos.x,menu.settings.offset_y=pos.y,this.settings.max_width||(menu.settings.max_width=elm.offsetWidth),each(this.items,function(item){menu.items[item.id]&&(menu.items[item.id].setSelected(0),(item.value===self.selectedValue||item.selected)&&menu.items[item.id].setSelected(1))}),menu.showMenu(0,elm.clientHeight,0,pos.y),Event.add(DOM.doc,"mousedown",this.hideMenu,this),DOM.addClass(this.id,this.classPrefix+"Selected"),this.setAriaProperty("expanded",!0)))},hideMenu:function(e){this.menu&&(!e||"mousedown"!=e.type||e.target.id!=this.id+"_text"&&e.target.id!=this.id+"_open")&&(e&&DOM.getParent(e.target,".mceMenu")||(DOM.removeClass(this.id,this.classPrefix+"Selected"),Event.remove(DOM.doc,"mousedown",this.hideMenu,this),this.menu.hideMenu()),this.setAriaProperty("expanded",!1))},renderMenu:function(){var menu,self=this;menu=this.settings.control_manager.createDropMenu(this.id+"_menu",{class:this.classPrefix+"Menu",max_width:this.settings.max_width||250,max_height:this.settings.max_height||"",filter:!!this.settings.filter,keyboard_focus:!0,onselect:function(value){self.settings.onselect(value)!==!1&&(self.select(value),menu.close())}}),menu.onHideMenu.add(function(){self.hideMenu(),self.settings.combobox&&(menu.clearFilteredItems(),self.focus())}),this.onBeforeRenderMenu.dispatch(this,menu),each(this.items,function(item){item.value===undef?menu.add({title:item.title,role:"option",onAction:function(e){self.settings.onselect("")!==!1&&self.select(""),menu.close()}}):(item.id=DOM.uniqueId(),item.role="option",item.onAction=function(e){self.settings.onselect(item.value)!==!1&&self.select(item.value),self.settings.multiple||self.settings.keepopen||menu.close()},menu.add(item))}),this.onRenderMenu.dispatch(this,menu),this.menu=menu},postRender:function(){var self=this;self.destroy(),Event.add(this.id,"click",function(evt){"INPUT"==evt.target.nodeName||DOM.hasClass(evt.target,"mceButtonTag")||(self.menu&&self.menu.isMenuVisible?self.hideMenu(evt):self.showMenu(evt),Event.cancel(evt))}),Event.add(this.id,"keydown",function(evt){"INPUT"!==evt.target.nodeName&&32==evt.keyCode&&(self.menu&&self.menu.isMenuVisible?self.hideMenu(evt):self.showMenu(evt),Event.cancel(evt))}),Event.add(this.id+"_input","keyup",function(evt){setTimeout(function(){var value=evt.target.value;return value?void(specialKeyCodeMap[evt.keyCode]||(self.menu&&self.menu.isMenuVisible||self.showMenu(),evt.target.focus(),self.menu.filterItems(value))):(Event.cancel(evt),void self.hideMenu())},0)}),Event.add(this.id+"_input","keydown",function(evt){switch(evt.keyCode){case 13:Event.cancel(evt),""===this.value?self.showMenu():(self.settings.onselect(this.value)!==!1&&self.select(this.value),self.hideMenu(),this.value="");break;case 40:case 38:self.showMenu(),Event.cancel(evt),self.menu.focus();break;case 8:if(this.value)return;var tags=DOM.select("button",evt.target.parentNode);if(tags.length){var tag=tags.pop(),val=tag.value;self.removeTag(tag),Event.cancel(evt),this.value=val,this.focus()}}}),Event.add(this.id,"focus",function(){this._focused||(this.keyDownHandler=Event.add(this.id,"keydown",function(e){40==e.keyCode&&(self.showMenu(),Event.cancel(e))}),this.keyPressHandler=Event.add(this.id,"keypress",function(e){var value;13==e.keyCode&&(value=self.selectedValue,self.selectedValue=null,Event.cancel(e),self.settings.onselect(value))})),this._focused=1}),Event.add(this.id,"blur",function(){Event.remove(this.id,"keydown",this.keyDownHandler),Event.remove(this.id,"keypress",this.keyPressHandler),this._focused=0}),this.onPostRender.dispatch(this,DOM.get(this.id)),this.rendered=!0},destroy:function(){this._super(),Event.clear(this.id+"_text"),Event.clear(this.id+"_open"),each(this.items,function(item){item.selected=!1}),this.selectedValue=null}})}(tinymce),function(tinymce){var undef,DOM=tinymce.DOM,Event=tinymce.dom.Event,each=tinymce.each;tinymce.create("tinymce.ui.NativeListBox:tinymce.ui.ListBox",{NativeListBox:function(id,settings){this._super(id,settings)},setDisabled:function(settings){DOM.get(this.id).disabled=settings,this.setAriaProperty("disabled",settings)},isDisabled:function(){return DOM.get(this.id).disabled},select:function(value){var fv,fn,self=this;return value==undef?this.selectByIndex(-1):(fn=value&&"function"==typeof value?value:function(val){return val==value},void(value!=this.selectedValue&&(each(this.items,function(o,i){if(fn(o.value))return fv=1,self.selectByIndex(i),!1}),fv||this.selectByIndex(-1))))},selectByIndex:function(idx){DOM.get(this.id).selectedIndex=idx+1,this.selectedValue=this.items[idx]?this.items[idx].value:null},add:function(name,value,attribs){var obj;attribs=attribs||{},attribs.value=value,this.isRendered()&&DOM.add(DOM.get(this.id),"option",attribs,name),obj={title:name,value:value,attribs:attribs},this.items.push(obj),this.onAdd.dispatch(this,obj)},getLength:function(){return this.items.length},renderHTML:function(){var html;return html=DOM.createHTML("option",{value:""},"-- "+this.settings.title+" --"),each(this.items,function(item){html+=DOM.createHTML("option",{value:item.value},item.title)}),html=DOM.createHTML("select",{id:this.id,class:"mceNativeListBox","aria-labelledby":this.id+"_aria"},html),html+=DOM.createHTML("span",{id:this.id+"_aria",style:"display: none"},this.settings.title)},postRender:function(){function onChange(e){var value=self.items[e.target.selectedIndex-1];value&&(value=value.value)&&(self.onChange.dispatch(self,value),self.settings.onselect&&self.settings.onselect(value))}var ch,self=this,changeListenerAdded=!0;this.rendered=!0,Event.add(this.id,"change",onChange),Event.add(this.id,"keydown",function(e){var blur,DOM_VK_UP=38,DOM_VK_DOWN=40,DOM_VK_RETURN=13,DOM_VK_SPACE=32;return Event.remove(self.id,"change",ch),changeListenerAdded=!1,blur=Event.add(this.id,"blur",function(){changeListenerAdded||(changeListenerAdded=!0,Event.add(self.id,"change",onChange),Event.remove(self.id,"blur",blur))}),e.keyCode==DOM_VK_RETURN||e.keyCode==DOM_VK_SPACE?(onChange(e),Event.cancel(e)):void(e.keyCode!=DOM_VK_DOWN&&e.keyCode!=DOM_VK_UP||e.stopImmediatePropagation())}),this.onPostRender.dispatch(this,DOM.get(this.id))}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event,Dispatcher=tinymce.util.Dispatcher;tinymce.create("tinymce.ui.TextBox:tinymce.ui.Control",{TextBox:function(id,s,ed){s=tinymce.extend({class:"",title:""},s),this._super(id,s,ed),this.onChange=new Dispatcher(this),this.onPostRender=new Dispatcher(this),this.classPrefix="mceTextBox"},value:function(val){return arguments.length?void DOM.setValue(this.id,val):DOM.getValue(this.id)},renderHTML:function(){var html="",prefix=this.classPrefix,s=this.settings,type=s.subtype?s.subtype:"text",attribs={type:type,id:this.id,class:prefix+" "+s.class,title:DOM.encode(s.title),tabindex:0,autofocus:!0};return attribs=tinymce.extend(attribs,s.attributes||{}),html+=s.multiline?DOM.createHTML("textarea",attribs):DOM.createHTML("input",attribs),s.button&&(html+=DOM.createHTML("button",{id:this.id+"_button",class:"mceButton",title:DOM.encode(s.button.label||"")},'<span role="presentation" class="mceIcon mce_'+s.button.icon+'"></span>')),html},postRender:function(){var self=this,s=this.settings;"undefined"!=typeof s.value&&this.value(s.value),s.onchange&&"function"==typeof s.onchange&&this.onChange.add(s.onchange),Event.add(this.id,"change",function(){self.onChange.dispatch(this,DOM.get(self.id))}),s.button&&Event.add(this.id+"_button","click",function(e){e.preventDefault(),s.button.click.apply(self)}),this.onPostRender.dispatch(this,DOM.get(this.id))},setDisabled:function(state){this._super(state),DOM.get(this.id).disabled=state},destroy:function(){this._super(),Event.clear(this.id)}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event;tinymce.create("tinymce.ui.UrlBox:tinymce.ui.TextBox",{UrlBox:function(id,s,ed){s.multiline=!1,s.onpick=s.onpick||function(){},s.class="mceUrlBox",this._super(id,s,ed)},renderHTML:function(){var html=this._super(),s=this.settings;if(s.picker){var icon=s.picker_icon||"file";html+='<button type="button" class="mceButton mceButtonPicker" id="'+this.id+'_picker" title="'+DOM.encode(s.picker_label||"")+'"><span role="presentation" class="mceIcon mce_'+icon+'"></span></button>'}if(s.upload){var accept=tinymce.map(s.upload_accept||[],function(val){return val.indexOf("/")==-1&&"."!=val.charAt(0)&&(val="."+val),val});html+='<a class="mceButton mceButtonUpload" role="button" aria-label="'+DOM.encode(s.upload_label||"")+'"><span role="presentation" class="mceIcon mce_upload"></span><span role="presentation" class="mceIcon mce_spinner"></span><input id="'+this.id+'_upload" type="file" aria-hidden="true" title="'+DOM.encode(s.upload_label||"")+'" accept="'+accept.join(",")+'" /></a>'}return html},setLoading:function(state){this.setAriaProperty("busy",state),this.setDisabled(state)},setDisabled:function(state){this._super(state),DOM.get(this.id+"_upload").disabled=state},postRender:function(){var self=this,s=this.settings;this._super(),s.picker&&(DOM.addClass(this.id,"mceUrlBoxPicker"),Event.add(this.id+"_picker","click",function(e){e.preventDefault(),s.onpick.call(self)})),s.upload&&(DOM.addClass(this.id,"mceUrlBoxUpload"),Event.add(this.id+"_upload","change",function(e){this.files&&this.files.length&&s.upload.call(self,e,this.files[0]),e.preventDefault()}),DOM.bind(this.id,"drag dragstart dragend dragover dragenter dragleave",function(e){e.preventDefault()}),DOM.bind(this.id,"dragover dragenter",function(){DOM.addClass(this.id,"mceUrlBoxUploadHover")}),DOM.bind(this.id,"dragleave",function(){DOM.removeClass(this.id,"mceUrlBoxUploadHover")}),DOM.bind(this.id,"drop",function(e){var dataTransfer=e.dataTransfer;if(dataTransfer&&dataTransfer.files&&dataTransfer.files.length){var file=dataTransfer.files[0];file&&s.upload.call(self,e,file)}e.preventDefault()}))}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event,each=tinymce.each,Dispatcher=tinymce.util.Dispatcher;tinymce.create("tinymce.ui.CheckBox:tinymce.ui.Control",{CheckBox:function(id,s,ed){this._super(id,s,ed),"undefined"==typeof s.value&&(s.value=""),this.onChange=new Dispatcher(this),this.onPostRender=new Dispatcher(this),this.classPrefix="mceCheckBox"},value:function(val){var elm=DOM.get(this.id);return arguments.length?void(elm.value=val):elm.checked?elm.value||1:""},checked:function(state){var elm=DOM.get(this.id);return arguments.length?void(this.isDisabled()||(this.setState("checked",!!state),elm.checked=!!state)):elm.checked},renderHTML:function(){var html="",prefix=this.classPrefix,s=this.settings;return html+='<input type="checkbox" id="'+this.id+'" value="'+s.value+'" class="'+prefix+" "+s.class+'" title="'+DOM.encode(s.title)+'"',s.attributes&&each(s.attributes,function(val,key){html+=" "+key+'="'+val+'"'}),html+=" />"},postRender:function(){var self=this,s=this.settings;s.onchange&&"function"==typeof s.onchange&&this.onChange.add(s.onchange),Event.add(this.id,"click",function(){self.checked(self.checked())}),Event.add(this.id,"change",function(){self.onChange.dispatch(this,DOM.get(self.id))}),this.onPostRender.dispatch(this,DOM.get(this.id))},setDisabled:function(state){this._super(state),DOM.get(this.id).disabled=state},destroy:function(){this._super(),Event.clear(this.id)}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event;tinymce.create("tinymce.ui.MenuButton:tinymce.ui.Button",{MenuButton:function(id,s,ed){this._super(id,s,ed),this.onRenderMenu=new tinymce.util.Dispatcher(this),s.menu_container=s.menu_container||DOM.doc.body},showMenu:function(){var pos,m,self=this,e=DOM.get(self.id);if(!self.isDisabled()){if(self.isMenuRendered||(self.renderMenu(),self.isMenuRendered=!0),self.isMenuVisible)return self.hideMenu();pos=DOM.getPos(e),m=self.menu,m.settings.offset_x=pos.x,m.settings.offset_y=pos.y,m.settings.vp_offset_x=pos.x,m.settings.vp_offset_y=pos.y,m.settings.keyboard_focus=self._focused,m.showMenu(0,e.firstChild.clientHeight),Event.add(DOM.doc,"mousedown",self.hideMenu,self),self.setState("Selected",1),self.isMenuVisible=1,self.setAriaProperty("expanded",!0)}},renderMenu:function(){var m,self=this;m=self.settings.control_manager.createDropMenu(self.id+"_menu",{class:this.classPrefix+"Menu",icons:self.settings.icons,max_width:this.settings.max_width,max_height:this.settings.max_height,keyboard_focus:!0,onselect:this.settings.onselect,title:this.settings.title}),m.onHideMenu.add(function(){self.hideMenu(),self.focus()}),self.onRenderMenu.dispatch(self,m),self.menu=m},hideMenu:function(e){var self=this;e&&"mousedown"==e.type&&DOM.getParent(e.target,function(e){return e.id===self.id||e.id===self.id+"_open"})||(e&&DOM.getParent(e.target,".mceMenu")||(self.setState("Selected",0),Event.remove(DOM.doc,"mousedown",self.hideMenu,self),self.menu&&self.menu.hideMenu()),self.isMenuVisible=0,self.setAriaProperty("expanded",!1))},postRender:function(){var self=this,s=self.settings;Event.add(self.id,"click",function(){self.isDisabled()||(s.onclick&&s.onclick(self.value),self.showMenu())})}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event;tinymce.create("tinymce.ui.SplitButton:tinymce.ui.MenuButton",{SplitButton:function(id,s,ed){this._super(id,s,ed),this.classPrefix="mceSplitButton"},renderHTML:function(){var icon,html="",self=this,s=self.settings;return icon=s.image?DOM.createHTML("img ",{src:s.image,role:"presentation",class:"mceAction "+s.class}):DOM.createHTML("span",{class:"mceAction "+s.class,role:"presentation"}),html+=DOM.createHTML("button",{type:"button",id:self.id+"_action",tabindex:"-1",class:"mceText "+s.class,title:s.title},icon),html+=DOM.createHTML("button",{type:"button",id:self.id+"_open",tabindex:"-1",class:"mceOpen "+s.class,title:s.title}),DOM.createHTML("div",{id:self.id,role:"button",tabindex:0,class:"mceSplitButton "+s.class,title:s.title,"aria-label":s.title,"aria-haspopup":"true","aria-expanded":!1},html)},postRender:function(){var activate,self=this,s=self.settings;s.onclick?(activate=function(evt){self.isDisabled()||(s.onclick(self.value),Event.cancel(evt),self.hideMenu())},Event.add(self.id+"_action","click",activate),Event.add(self.id,["click","keydown"],function(evt){var DOM_VK_DOWN=40;32!==evt.keyCode&&13!==evt.keyCode&&14!==evt.keyCode||evt.altKey||evt.ctrlKey||evt.metaKey?"click"!==evt.type&&evt.keyCode!==DOM_VK_DOWN||(self.showMenu(),Event.cancel(evt)):(activate(),Event.cancel(evt))})):Event.add(self.id+"_action","click",function(evt){self.showMenu(),Event.cancel(evt)}),Event.add(self.id+"_open","click",function(evt){self.showMenu(),Event.cancel(evt)}),Event.add([self.id,self.id+"_open"],"focus",function(){self._focused=1}),Event.add([self.id,self.id+"_open"],"blur",function(){self._focused=0}),this.rendered=!0},destroy:function(){this._super(),Event.clear(this.id+"_action"),Event.clear(this.id+"_open"),Event.clear(this.id)}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event,is=tinymce.is,each=tinymce.each;tinymce.create("tinymce.ui.ColorSplitButton:tinymce.ui.SplitButton",{ColorSplitButton:function(id,settings,editor){this._super(id,settings,editor),this.settings=tinymce.extend({colors:"000000,993300,333300,003300,003366,000080,333399,333333,800000,FF6600,808000,008000,008080,0000FF,666699,808080,FF0000,FF9900,99CC00,339966,33CCCC,3366FF,800080,999999,FF00FF,FFCC00,FFFF00,00FF00,00FFFF,00CCFF,993366,FFFFFF,FF99CC,FFCC99,FFFF99,CCFFCC,CCFFFF,99CCFF,CC99FF",grid_width:8,default_color:"#888888"},settings||{}),this.onShowMenu=new tinymce.util.Dispatcher(this),this.onHideMenu=new tinymce.util.Dispatcher(this),this.value=settings.default_color},showMenu:function(){var elm,pos,self=this;if(!this.isDisabled()){if(this.isMenuRendered||(this.renderMenu(),this.isMenuRendered=!0),this.isMenuVisible)return this.hideMenu();elm=DOM.get(this.id),DOM.show(this.id+"_menu"),DOM.addClass(elm,"mceSplitButtonSelected"),pos=DOM.getPos(elm),DOM.setStyles(this.id+"_menu",{left:pos.x,top:pos.y+elm.firstChild.clientHeight}),elm=0,Event.add(DOM.doc,"mousedown",this.hideMenu,this),this.onShowMenu.dispatch(this),this._focused&&(this._keyHandler=Event.add(this.id+"_menu","keydown",function(e){27==e.keyCode&&this.hideMenu()}),DOM.select("button",this.id+"_menu")[0].focus()),this.keyboardNav=new tinymce.ui.KeyboardNavigation({root:this.id+"_menu",items:DOM.select("button",this.id+"_menu"),onCancel:function(){self.hideMenu(),self.focus()}}),this.keyboardNav.focus(),this.isMenuVisible=1}},hideMenu:function(e){var self=this;if(this.isMenuVisible){if(e&&"mousedown"==e.type){var parent=DOM.getParent(e.target,function(elm){return elm.id===self.id+"_open"});if(parent)return}e&&DOM.getParent(e.target,".mceSplitButtonMenu")||(DOM.removeClass(this.id,"mceSplitButtonSelected"),Event.remove(DOM.doc,"mousedown",this.hideMenu,this),Event.remove(this.id+"_menu","keydown",this._keyHandler),DOM.hide(this.id+"_menu")),this.isMenuVisible=0,this.onHideMenu.dispatch(),this.keyboardNav.destroy()}},renderMenu:function(){var menu,node,list,self=this,settings=this.settings;return list=DOM.add(settings.menu_container,"div",{role:"listbox",id:this.id+"_menu",class:"mceMenu mceSplitButtonMenu "+settings.menu_class}),menu=DOM.add(list,"div",{role:"presentation",class:"mceColorSplitMenu "+settings.class}),each(is(settings.colors,"array")?settings.colors:settings.colors.split(","),function(color){color=color.replace(/^#/,"");var val="#"+color;0==color.indexOf("--")&&(val="var("+color+")");var args={style:{backgroundColor:val},title:self.editor.getLang("colors."+color,val),"data-mce-color":val,class:"mceColorButton"};args.role="option",node=DOM.add(menu,"button",args)}),node=DOM.add(menu,"button",{title:this.editor.getLang("advanced.no_color","No Colour"),"data-mce-color":"",role:"option",class:"mceRemoveColor"},"&cross;"),settings.more_colors_func&&(node=DOM.add(menu,"button",{role:"option",id:this.id+"_more",class:"mceMoreColors"},settings.more_colors_title),Event.add(node,"click",function(e){return settings.more_colors_func.call(settings.more_colors_scope||self),self.hideMenu(),Event.cancel(e)})),DOM.addClass(menu,"mceColorSplitMenu"),Event.add(this.id+"_menu","mousedown",function(e){return Event.cancel(e)}),Event.add(this.id+"_menu","click",function(e){var elm=DOM.getParent(e.target,"button",menu),color=elm.getAttribute("data-mce-color");return elm&&"button"==elm.nodeName.toLowerCase()&&"undefined"!=typeof color&&self.setColor(color),!1}),list},setColor:function(color){this.displayColor(color),this.hideMenu(),this.settings.onselect(color)},displayColor:function(color){DOM.setStyle(this.id+"_preview","backgroundColor",color),this.value=color},postRender:function(){this._super(),DOM.add(this.id+"_action","span",{id:this.id+"_preview",role:"presentation",class:"mceColorPreview"}),DOM.setStyle(this.id+"_preview","backgroundColor",this.value)},destroy:function(){this._super(),Event.clear(this.id+"_menu"),Event.clear(this.id+"_more"),DOM.remove(this.id+"_menu"),this.keyboardNav&&this.keyboardNav.destroy()}})}(tinymce),function(tinymce){var dom=tinymce.DOM,each=tinymce.each,Event=tinymce.dom.Event;tinymce.create("tinymce.ui.ToolbarGroup:tinymce.ui.Container",{renderHTML:function(){var html=[],controls=this.controls,each=tinymce.each;each(controls,function(toolbar){html.push(toolbar.renderHTML())});var group=dom.create("div",{id:this.id,role:"group",class:this.settings.class?this.classPrefix+this.settings.class:""},html.join(""));return dom.getOuterHTML(group)},focus:function(){dom.get(this.id).focus()},postRender:function(){var editor=this.editor,settings=this.settings,id=this.id,items=[];each(this.controls,function(toolbar){each(toolbar.controls,function(control){control.id&&items.push(control)})}),this.keyNav=new tinymce.ui.KeyboardNavigation({root:id,items:items,onCancel:function(){tinymce.isWebKit&&dom.get(editor.id+"_ifr").focus(),editor.focus()},excludeFromTabOrder:!settings.tab_focus_toolbar})},destroy:function(){this._super(),this.keyNav.destroy(),Event.clear(this.id)}})}(tinymce),function(tinymce){var dom=tinymce.DOM;tinymce.create("tinymce.ui.Toolbar:tinymce.ui.Container",{renderHTML:function(){var i,html="",settings=this.settings,controls=settings.controls||this.controls;for(i=0;i<controls.length;i++)html+=controls[i].renderHTML();return this.controls=controls,dom.createHTML("div",{id:this.id,class:"mceToolbarRow"+(settings.class?" "+settings.class:""),role:"group"},html)}})}(tinymce),function(tinymce){var dom=tinymce.DOM;tinymce.create("tinymce.ui.Layout:tinymce.ui.Container",{renderHTML:function(){var i,html="",settings=this.settings,controls=settings.controls||this.controls;for(i=0;i<controls.length;i++)html+=controls[i].renderHTML();return this.controls=controls,dom.createHTML("div",{id:this.id,class:"mceFlexLayout "+(settings.class?" "+settings.class:""),role:"group"},html)}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event,each=tinymce.each,Dispatcher=tinymce.util.Dispatcher;tinymce.create("tinymce.ui.Panel:tinymce.ui.Container",{Panel:function(id,s,ed){this._super(id,s,ed),this.settings=s=tinymce.extend({content:"",buttons:[]},this.settings),this.editor=ed,this.classPrefix="mcePanel",this.onRenderPanel=new Dispatcher(this)},showPanel:function(elm){var pos,x,y,mx,my,w,h,vp,panel,self=this,s=this.settings;if(this.storeSelection(),self.isPanelRendered||self.renderPanel(),self.isPanelVisible)return self.hidePanel();if(vp=DOM.getViewPort(),panel=DOM.get(self.id)){if(DOM.show(panel),s.url){var iframe=DOM.get(self.id+"_iframe");iframe.src=s.url}pos=DOM.getPos(elm),w=panel.clientWidth,h=panel.clientHeight,mx=vp.x+vp.w,my=vp.y+vp.h,x+w>mx&&(x=Math.max(0,mx-w)),y+h>my&&(y=Math.max(0,my-h)),x=pos.x,y=pos.y,DOM.setStyles(self.id,{left:x,top:y+elm.clientHeight+5,zIndex:2e5}),self.isPanelVisible=1,Event.add(DOM.doc,"mousedown",function(e){DOM.getParents(e.target,".mcePanel").length||self.hidePanel()})}},storeSelection:function(){tinymce.isIE&&(this.editor.focus(),this.bookmark=this.editor.selection.getBookmark(1))},restoreSelection:function(){this.bookmark&&(this.editor.selection.moveToBookmark(this.bookmark),this.editor.focus()),this.bookmark=0},renderPanel:function(){var self=this,s=this.settings,prefix=this.classPrefix,panel=DOM.add(DOM.doc.body,"div",{role:"presentation",id:self.id,class:s.class||"defaultSkin",style:"position:absolute;left:0;top:-1000px;"});panel=DOM.add(panel,"div",{class:prefix});var content=DOM.add(panel,"div",{class:prefix+"Content"});s.width&&DOM.setStyle(panel,"width",s.width);var html=[];if(s.html&&("string"==typeof s.html?html.push(s.html):html.push(DOM.createHTML(s.html))),s.controls&&each(s.controls,function(ctrl){html.push(ctrl.renderHTML()),ctrl.postRender(),setTimeout(function(){ctrl.controls&&each(ctrl.controls,function(c){c.postRender()})},0)}),DOM.setHTML(content,html.join("")),s.url&&DOM.add(content,"iframe",{id:self.id+"_iframe",src:s.url,style:{border:0,width:"100%",height:"100%"},onload:function(){self.isPanelRendered=!0,self.onRenderPanel.dispatch(self)}}),s.buttons.length){var footer=DOM.add(panel,"div",{class:prefix+"Footer"});each(s.buttons,function(o){var btn=DOM.add(footer,"button",{type:"button",class:"mceButton",id:self.id+"_button_"+o.id},o.title||"");o.classes&&DOM.addClass(btn,o.classes),o.onclick&&Event.add(btn,"click",function(e){e.preventDefault(),self.restoreSelection();var s=o.onclick.call(o.scope||self,e);s&&self.hidePanel()})})}var navItems=tinymce.grep(DOM.select("input, select, button, textarea",panel),function(elm){return elm.getAttribute("tabindex")>=0&&elm.className.indexOf("Disabled")===-1});return navItems.length&&Event.add(panel,"keydown",function(e){9===e.keyCode&&e.target===navItems[navItems.length-1]&&(e.preventDefault(),navItems[0].focus())}),Event.add(panel,"keyup",function(e){13===e.keyCode&&self.settings.onsubmit&&(e.preventDefault(),self.settings.onsubmit())}),s.url||(self.isPanelRendered=!0,self.onRenderPanel.dispatch(self)),panel},hidePanel:function(){var self=this;DOM.hide(self.id),self.isPanelVisible=0},setButtonDisabled:function(button,state){var id=this.id+"_button_"+button;state?DOM.addClass(id,"disabled"):DOM.removeClass(id,"disabled")},setButtonLabel:function(button,label){DOM.setHTML(this.id+"_button_"+button,label)},destroy:function(){this._super(),Event.clear(this.id),DOM.remove(this.id)}})}(tinymce),function(){var DOM=tinymce.DOM,Event=tinymce.dom.Event,Delay=tinymce.util.Delay;tinymce.create("tinymce.ui.ContextPanel:tinymce.ui.Panel",{ContextPanel:function(id,s,ed){this._super(id,s,ed),this.settings=s=tinymce.extend({content:"",buttons:[]},this.settings),this.editor=ed},renderPanel:function(){var self=this;this._super(),DOM.addClass(DOM.select(".mcePanel",DOM.get(this.id)),"mceContextPanel");var scrollFunc=Delay.debounce(function(){self.isPanelVisible&&self.positionPanel()},60);self.scrollFunc=Event.add(this.editor.getWin(),"scroll",scrollFunc),this.editor.onHide.add(function(){self.hidePanel()})},showPanel:function(elm){this._super(elm),this.target=elm,this.positionPanel()},positionPanel:function(){var x,y,pos,w,self=this,panel=DOM.get(self.id);if(panel){var elm=this.target,offset=DOM.getRect(this.editor.getContentAreaContainer());if(DOM.removeClass(panel,"mceArrowDown"),pos=DOM.getPos(elm),pos.y<0)return void self.hidePanel();var win=this.editor.getWin(),sy=win.scrollY,wh=sy+win.innerHeight;if(pos.y>wh-elm.clientHeight)return void self.hidePanel();DOM.show(panel),self.isPanelVisible=1,x=pos.x+offset.x+elm.clientWidth/2,y=pos.y+offset.y,w=panel.clientWidth,x-=w/2,y=y+elm.clientHeight+10,y>offset.y+offset.h&&(y-=elm.clientHeight+panel.clientHeight+10,DOM.addClass(panel,"mceArrowDown")),DOM.setStyles(self.id,{left:x,top:y,zIndex:2e5})}},destroy:function(){Event.remove(this.editor.getWin(),"scroll",self.scrollFunc),this._super()}})}(),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event,Dispatcher=tinymce.util.Dispatcher;tinymce.create("tinymce.ui.PanelButton:tinymce.ui.Button",{PanelButton:function(id,s,ed){this._super(id,s,ed),this.settings=s=tinymce.extend({},this.settings),this.editor=ed,this.classPrefix="mcePanelButton",this.onShowPanel=new Dispatcher(this),this.onHidePanel=new Dispatcher(this),this.onRenderPanel=new Dispatcher(this)},showPanel:function(){var self=this;if(!self.isDisabled()){var elm=DOM.get(this.id);self.panel.showPanel(elm),self.onShowPanel.dispatch(self),self.setState("Selected",1),self.setAriaProperty("expanded",!0)}},hidePanel:function(e){var self=this;self.panel&&(e&&"mousedown"==e.type&&DOM.getParent(e.target,function(e){return e.id===self.id||e.id===self.id+"_open"})||e&&DOM.getParent(e.target,".mcePanel")||(self.setState("Selected",0),Event.remove(DOM.doc,"mousedown",self.hidePanel,self),self.panel.hidePanel(),self.onHidePanel.dispatch(self),self.setAriaProperty("expanded",!1)))},postRender:function(){var self=this,s=self.settings;DOM.addClass(self.id,"mceButton"),Event.add(self.id,"click",function(evt){self.isDisabled()||(s.onclick&&s.onclick(self.value),self.showPanel()),Event.cancel(evt)}),Event.add(self.id,"focus",function(){self._focused=1}),Event.add(self.id,"blur",function(){self._focused=0}),self.panel||(self.panel=self.editor.controlManager.createPanel(self.id+"_panel",self.settings),self.editor.onMouseDown.add(self.hidePanel,self)),self.panel.onRenderPanel.add(function(){self.onRenderPanel.dispatch(self)}),self.setAriaProperty("expanded",!1)},restoreSelection:function(){self.panel&&self.panel.restoreSelection()},destroy:function(){this._super(),Event.clear(this.id+"_panel"),DOM.remove(this.id+"_panel")}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event;tinymce.create("tinymce.ui.PanelSplitButton:tinymce.ui.PanelButton",{PanelSplitButton:function(id,s,ed){this._super(id,s,ed)},renderHTML:function(){var icon,html="",self=this,s=self.settings;return icon=s.image?DOM.createHTML("img ",{src:s.image,role:"presentation",class:"mceAction "+s.class}):DOM.createHTML("span",{class:"mceAction "+s.class,role:"presentation"}),html+=DOM.createHTML("button",{id:self.id+"_action",tabindex:"-1",class:"mceText "+s.class,title:s.title},icon),html+=DOM.createHTML("button",{id:self.id+"_open",tabindex:"-1",class:"mceOpen "+s.class,title:s.title}),DOM.createHTML("div",{id:self.id,role:"button",tabindex:0,class:"mceSplitButton "+s.class,title:s.title,"aria-label":s.title,"aria-haspopup":"true"},html)},postRender:function(){var self=this,s=self.settings,activate=function(evt){self.isDisabled()||(s.onclick(self.value),Event.cancel(evt))};Event.add(self.id+"_action","click",activate),Event.add(self.id,["click","keydown"],function(evt){var DOM_VK_DOWN=40;32!==evt.keyCode&&13!==evt.keyCode&&14!==evt.keyCode||evt.altKey||evt.ctrlKey||evt.metaKey?"click"!==evt.type&&evt.keyCode!==DOM_VK_DOWN||(self.showPanel(),Event.cancel(evt)):(activate(),Event.cancel(evt))}),Event.add(self.id+"_open","click",function(evt){self.showPanel(),Event.cancel(evt)}),Event.add([self.id,self.id+"_open"],"focus",function(){self._focused=1}),Event.add([self.id,self.id+"_open"],"blur",function(){self._focused=0}),self.panel||(self.panel=new tinymce.ui.Panel(self.id+"_panel",self.settings,self.editor)),self.panel.onRenderPanel.add(function(){
self.onRenderPanel.dispatch(self),DOM.addClass(self.id+"_panel","mcePanelSplitButton")})}})}(tinymce),function(tinymce){var Dispatcher=tinymce.util.Dispatcher;tinymce.create("tinymce.ui.ButtonDialog:tinymce.ui.PanelButton",{ButtonDialog:function(id,s,ed){s.content&&(s.html=s.content),s.buttons&&tinymce.each(s.buttons,function(btn){btn.onclick=btn.click||function(){}}),this.onShowDialog=new Dispatcher(this),this.onHideDialog=new Dispatcher(this),this._super(id,s,ed)},showDialog:function(){this.showPanel(),this.onShowDialog.dispatch(this)},hideDialog:function(e){this.hidePanel(e),this.onHideDialog.dispatch(this)}})}(tinymce),function(tinymce){var DOM=tinymce.DOM,count=0;tinymce.create("tinymce.ui.RepeatableItem:tinymce.ui.Container",{RepeatableItem:function(id,settings){this._super(id,settings);var id=settings.controls[0].id+"_"+count++;delete this.lookup[id],this.controls[0].id=id},renderHTML:function(){var html="";return html+=this.controls[0].renderHTML(),html+='<button class="mceButton"><span role="presentation" class="mceIcon mce_plus"></span><span role="presentation" class="mceIcon mce_trash"></span></button>',DOM.createHTML("div",{id:this.id,class:"mceRepeatableItem mceForm mceFormRow"},html)},value:function(value){return arguments.length?(Array.isArray(value)&&(value=value.shift()),this.controls[0].value(value),this):this.controls[0].value()}})}(tinymce),function(tinymce){var dom=tinymce.DOM,each=tinymce.each,count=0;tinymce.create("tinymce.ui.Repeatable:tinymce.ui.Container",{renderHTML:function(){var i,settings=this.settings,html="",controls=this.controls;for(i=0;i<controls.length;i++)html+=controls[i].renderHTML();return dom.createHTML("div",{id:this.id,class:"mceForm mceRepeatable"+(settings.class?" "+settings.class:""),role:"group"},html)},value:function(values){var i,self=this,controls=this.controls;if(arguments.length){for(i=0;i<controls.length;i++)controls[i].value(values.shift());return each(values,function(val){self.addItem(val)}),this}var values=[];for(i=0;i<this.controls.length;i++){var value=this.controls[i].value();value&&(values=values.concat(value))}return values},getItemControl:function(){var settings=this.settings,item=settings.item||{type:"TextBox",settings:{}},cls=tinymce.ui[item.type||"TextBox"];return new cls(this.id+"_item_"+item.id,item.settings||{},this.editor)},addItem:function(value){var self=this,item=this.getItemControl(),ctrl=new tinymce.ui.RepeatableItem(self.id+"_item_"+count++,{controls:[item]});return self.add(ctrl),ctrl.renderTo(dom.get(self.id)),value&&ctrl.value(value),ctrl},postRender:function(){var self=this,elm=dom.get(this.id);dom.bind(elm,"click",function(e){e.preventDefault();var btn=dom.getParent(e.target,"button");if(btn){var ctrlElm=btn.parentNode,index=dom.nodeIndex(ctrlElm);0==index?self.addItem():self.get(ctrlElm.id).remove()}}),this.addItem()},destroy:function(){this._super(),this.controls=[]}})}(tinymce),function(tinymce){var each=tinymce.each;tinymce.create("tinymce.ui.CustomValue:tinymce.ui.Form",{CustomValue:function(id,settings,ed){settings=tinymce.extend(settings,{class:"mceFormRow"}),this._super(id,settings,ed);var name=new tinymce.ui.TextBox(this.id+"_name",{name:"name",label:ed.getLang("label_name","Name"),attributes:{autocomplete:!1}}),value=new tinymce.ui.TextBox(this.id+"_value",{name:"value",label:ed.getLang("label_value","Value"),attributes:{autocomplete:!1}});settings.values&&settings.values.length&&(name=new tinymce.ui.ListBox(this.id+"_name",{name:"name",label:ed.getLang("label_name","Name"),combobox:!0}),each(settings.values,function(val){name.add(val,val)})),this.add(name),this.add(value)},renderHTML:function(){for(var self=this,i=0;i<this.controls.length;i++){var ctrl=this.controls[i];ctrl.id=self.id+"_"+ctrl.name}return this._super()},value:function(values){if(arguments.length){if("object"!=typeof values)return this;for(var key in values)this.controls[0].value(key),this.controls[1].value(values[key]);return this}var key=this.controls[0].value();if(key){var data={};return data[key]=this.controls[1].value(),data}return""}})}(tinymce),function(tinymce){var Dispatcher=tinymce.util.Dispatcher;tinymce.AddOnManager=function(){var self=this;self.items=[],self.urls={},self.lookup={},self.onAdd=new Dispatcher(self)},tinymce.AddOnManager.prototype={get:function(n){return this.lookup[n]?this.lookup[n].instance:void 0},dependencies:function(n){var result;return this.lookup[n]&&(result=this.lookup[n].dependencies),result||[]},requireLangPack:function(n){var s=tinymce.settings;s&&s.language&&s.language_load!==!1&&tinymce.ScriptLoader.add(this.urls[n]+"/langs/"+s.language+".js")},add:function(id,o,dependencies){return this.items.push(o),this.lookup[id]={instance:o,dependencies:dependencies},this.onAdd.dispatch(this,id,o),o},createUrl:function(baseUrl,dep){return"object"==typeof dep?dep:{prefix:baseUrl.prefix,resource:dep,suffix:baseUrl.suffix}},addComponents:function(pluginName,scripts){var pluginUrl=this.urls[pluginName];tinymce.each(scripts,function(script){tinymce.ScriptLoader.add(pluginUrl+"/"+script)})},load:function(n,u,cb,s){function loadDependencies(){var dependencies=self.dependencies(n);tinymce.each(dependencies,function(dep){var newUrl=self.createUrl(u,dep);self.load(newUrl.resource,newUrl,void 0,void 0)}),cb&&(s?cb.call(s):cb.call(tinymce.ScriptLoader))}var self=this,url=u;self.urls[n]||("object"==typeof u&&(url=u.prefix+u.resource+u.suffix),0!==url.indexOf("/")&&url.indexOf("://")==-1&&(url=tinymce.baseURL+"/"+url),self.urls[n]=url.substring(0,url.lastIndexOf("/")),self.lookup[n]?loadDependencies():tinymce.ScriptLoader.add(url,loadDependencies,s))}},tinymce.PluginManager=new tinymce.AddOnManager,tinymce.ThemeManager=new tinymce.AddOnManager}(tinymce),function(tinymce){function removeEditorFromList(targetEditor){var EditorManager=tinymce.EditorManager,editors=EditorManager.editors,oldEditors=editors;return editors=tinymce.grep(editors,function(editor){return targetEditor!==editor}),EditorManager.activeEditor===targetEditor&&(EditorManager.activeEditor=editors.length>0?editors[0]:null),EditorManager.focusedEditor===targetEditor&&(EditorManager.focusedEditor=null),oldEditors.length!==editors.length}function purgeDestroyedEditor(editor){return editor&&editor.initialized&&!(editor.getContainer()||editor.getBody()).parentNode&&(removeEditorFromList(editor),editor.remove(),editor=null),editor}var undef,each=tinymce.each,extend=tinymce.extend,DOM=tinymce.DOM,Event=tinymce.dom.Event,explode=tinymce.explode,Dispatcher=tinymce.util.Dispatcher,instanceCounter=0;tinymce.documentBaseURL=window.location.href.replace(/[\?#].*$/,"").replace(/[\/\\][^\/]+$/,""),/[\/\\]$/.test(tinymce.documentBaseURL)||(tinymce.documentBaseURL+="/"),tinymce.baseURL=new tinymce.util.URI(tinymce.documentBaseURL).toAbsolute(tinymce.baseURL),tinymce.baseURI=new tinymce.util.URI(tinymce.baseURL),tinymce.onBeforeUnload=new Dispatcher(tinymce),Event.add(window,"beforeunload",function(e){tinymce.onBeforeUnload.dispatch(tinymce,e)}),tinymce.onAddEditor=new Dispatcher(tinymce),tinymce.onRemoveEditor=new Dispatcher(tinymce),tinymce.EditorManager=extend(tinymce,{editors:[],i18n:{},activeEditor:null,init:function(settings){function createId(elm){var id=elm.id;return id||(id=elm.name,id=id&&!DOM.get(id)?elm.name:DOM.uniqueId(),elm.setAttribute("id",id)),id}function execCallback(name){var callback=settings[name];if(callback)return callback.apply(self,Array.prototype.slice.call(arguments,2))}function hasClass(elm,className){return className.constructor===RegExp?className.test(elm.className):DOM.hasClass(elm,className)}function findTargets(settings){var l,targets=[];if(settings.types)return each(settings.types,function(type){targets=targets.concat(DOM.select(type.selector))}),targets;if(settings.selector)return DOM.select(settings.selector);if(settings.target)return[settings.target];switch(settings.mode){case"exact":l=settings.elements||"",l.length>0&&each(explode(l),function(id){var elm;(elm=DOM.get(id))?targets.push(elm):each(document.forms,function(f){each(f.elements,function(e){e.name===id&&(id="mce_editor_"+instanceCounter++,DOM.setAttrib(e,"id",id),targets.push(e))})})});break;case"textareas":case"specific_textareas":each(DOM.select("textarea"),function(elm){settings.editor_deselector&&hasClass(elm,settings.editor_deselector)||settings.editor_selector&&!hasClass(elm,settings.editor_selector)||targets.push(elm)})}return targets}function initEditors(){function createEditor(id,settings,targetElm){var editor=new tinymce.Editor(id,settings,self);editors.push(editor),editor.onInit.add(function(){++initCount===targets.length}),editor.targetElm=editor.targetElm||targetElm,editor.render()}var targets,initCount=0,editors=[];DOM.unbind(window,"ready",initEditors),execCallback("onpageload"),targets=DOM.unique(findTargets(settings)),each(targets,function(elm){purgeDestroyedEditor(self.get(elm.id))}),targets=tinymce.grep(targets,function(elm){return!self.get(elm.id)}),0===targets.length||each(targets,function(elm){createEditor(createId(elm),settings,elm)})}var self=this;self.settings=settings,DOM.bind(window,"ready",initEditors)},get:function(id){return id===undef?this.editors:this.editors.hasOwnProperty(id)?this.editors[id]:undef},getInstanceById:function(id){return this.get(id)},add:function(editor){var self=this,editors=self.editors;return editors[editor.id]=editor,editors.push(editor),self.setActive(editor),self.onAddEditor.dispatch(self,editor),editor},remove:function(editor){var i,editors=this.editors;if(!editor)return null;if(!editors[editor.id])return null;for(delete editors[editor.id],i=0;i<editors.length;i++)if(editors[i]==editor){editors.splice(i,1);break}return this.activeEditor==editor&&this.setActive(editors[0]),editor.destroy(),this.onRemoveEditor.dispatch(this,editor),editor},execCommand:function(c,u,v){var win,ed=this.get(v);switch(c){case"mceFocus":return ed.focus(),!0;case"mceAddEditor":case"mceAddControl":return this.get(v)||new tinymce.Editor(v,this.settings).render(),!0;case"mceAddFrameControl":return win=v.window,win.tinyMCE=tinyMCE,win.tinymce=tinymce,tinymce.DOM.doc=win.document,tinymce.DOM.win=win,ed=new tinymce.Editor(v.element_id,v),ed.render(),v.page_window=null,!0;case"mceRemoveEditor":case"mceRemoveControl":return ed&&ed.remove(),!0;case"mceToggleEditor":return ed?(ed.isHidden()?ed.show():ed.hide(),!0):(this.execCommand("mceAddControl",0,v),!0)}return!!this.activeEditor&&this.activeEditor.execCommand(c,u,v)},execInstanceCommand:function(id,c,u,v){var ed=this.get(id);return!!ed&&ed.execCommand(c,u,v)},triggerSave:function(){each(this.editors,function(e){e.save()})},addI18n:function(p,o){var i18n=this.i18n;tinymce.is(p,"string")?each(o,function(o,k){i18n[p+"."+k]=o}):each(p,function(o,lc){each(o,function(o,g){each(o,function(o,k){"common"===g?i18n[lc+"."+k]=o:i18n[lc+"."+g+"."+k]=o})})})},setActive:function(editor){this.selectedInstance=this.activeEditor=editor}}),tinymce.FocusManager=new tinymce.dom.FocusManager(tinymce.EditorManager)}(tinymce),function(tinymce){function nodeChanged(ed,e){timer&&clearTimeout(timer),65==e.keyCode&&tinymce.VK.metaKeyPressed(e)||ed.selection.normalize(),ed.nodeChanged()}function isSameElementPath(ed,startElm){var i,currentPath;if(currentPath=ed.dom.getParents(startElm,"*",ed.getBody()),currentPath.reverse(),currentPath.length===lastPath.length){for(i=currentPath.length;i>=0&&currentPath[i]===lastPath[i];i--);if(i===-1)return lastPath=currentPath,!0}return lastPath=currentPath,!1}var timer,lastPath=[];tinymce.NodeChange=function(editor){editor.onSelectionChange.add(function(ed,e){var startElm=ed.selection.getStart(!0);lastPath=[startElm],!isSameElementPath(ed,startElm)&&ed.dom.isChildOf(startElm,ed.getBody())&&nodeChanged(ed,e)}),editor.onMouseUp.add(function(ed,e){e.isDefaultPrevented()||("IMG"==ed.selection.getNode().nodeName?timer=setTimeout(function(){nodeChanged(ed,e)},0):nodeChanged(ed,e))}),this.nodeChanged=function(args){var node,root,parents,selection=editor.selection;editor.initialized&&selection&&!editor.settings.disable_nodechange&&!editor.readonly&&(root=editor.getBody(),node=selection.getStart(!0)||root,node.ownerDocument==editor.getDoc()&&editor.dom.isChildOf(node,root)||(node=root),(1!==node.nodeType||node.getAttribute("data-mce-bogus"))&&(node=node.parentNode),parents=[],editor.dom.getParent(node,function(node){return node===root||void parents.push(node)}),args=args||{},args.element=node,args.parents=parents,args.contenteditable=!node.hasAttribute("contenteditable")||tinymce.dom.NodeType.isContentEditableTrue(node),editor.onNodeChange.dispatch(editor,args?args.controlManager||editor.controlManager:editor.controlManager,node,selection.isCollapsed(),args))}}}(tinymce),function(tinymce){var getContentEditableHost=function(editor,node){return editor.dom.getParent(node,function(node){return"true"===editor.dom.getContentEditable(node)})},normalizeSelection=function(editor){editor.selection.normalize()},focusBody=function(body){if(body.setActive)try{body.setActive()}catch(ex){body.focus()}else body.focus()},focusEditor=function(editor){var contentEditableHost,rng;editor.getDoc();var body=editor.getBody(),contentEditable=editor.settings.content_editable,selection=editor.selection;return rng=selection.getRng(),rng.item&&rng.item(0),contentEditableHost=getContentEditableHost(editor,selection.getNode()),editor.dom.contains(body,contentEditableHost)?(focusBody(contentEditableHost),normalizeSelection(editor),void activateEditor(editor)):(contentEditable||editor.getWin().focus(),void((tinymce.isGecko||contentEditable)&&(contentEditable&&document.activeElement!==body&&editor.selection.setRng(editor.lastRng),focusBody(body),normalizeSelection(editor))))},activateEditor=function(editor){tinymce.setActive(editor)},focus=function(editor,skipFocus){editor.removed||(skipFocus?activateEditor(editor):focusEditor(editor))};tinymce.EditorFocus={focus:focus}}(tinymce),function(tinymce){var DOM=tinymce.DOM,Event=tinymce.dom.Event,extend=tinymce.extend,each=tinymce.each,isGecko=tinymce.isGecko,isIE=tinymce.isIE,is=tinymce.is,ThemeManager=tinymce.ThemeManager,PluginManager=tinymce.PluginManager,EditorFocus=tinymce.EditorFocus,explode=tinymce.explode;tinymce.Editor=function(id,settings){var self=this,TRUE=!0;self.settings=settings=extend({id:id,language:"en",theme:"advanced",skin:"modern",delta_width:0,delta_height:0,popup_css:"",plugins:"",document_base_url:tinymce.documentBaseURL,add_form_submit_trigger:TRUE,submit_patch:TRUE,add_unload_trigger:TRUE,convert_urls:TRUE,relative_urls:TRUE,remove_script_host:TRUE,table_inline_editing:!1,object_resizing:TRUE,accessibility_focus:TRUE,doctype:"<!DOCTYPE html>",visual:TRUE,font_size_style_values:"xx-small,x-small,small,medium,large,x-large,xx-large",font_size_legacy_values:"xx-small,small,medium,large,x-large,xx-large,300%",apply_source_formatting:TRUE,directionality:"ltr",forced_root_block:"p",hidden_input:TRUE,padd_empty_editor:TRUE,render_ui:TRUE,indentation:"30px",fix_table_elements:TRUE,inline_styles:TRUE,convert_fonts_to_spans:TRUE,indent:"simple",indent_before:"p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr,section,article,hgroup,aside,figure,option,optgroup,datalist",indent_after:"p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr,section,article,hgroup,aside,figure,option,optgroup,datalist",validate:TRUE,entity_encoding:"named",url_converter:self.convertURL,url_converter_scope:self,validate_styles:TRUE},settings),self.id=self.editorId=id,self.isNotDirty=!1,self.plugins={},self.documentBaseURI=new tinymce.util.URI(settings.document_base_url||tinymce.documentBaseURL,{base_uri:tinymce.baseURI}),self.baseURI=tinymce.baseURI,self.contentCSS=[],self.contentStyles=[],self.setupEvents(),self.execCommands={},self.queryStateCommands={},self.queryValueCommands={},self.execCallback("setup",self)},tinymce.Editor.prototype={render:function(){function loadScripts(){s.language&&s.language_load!==!1&&sl.add(tinymce.baseURL+"/langs/"+s.language+".js"),s.theme&&"function"!=typeof s.theme&&"-"!=s.theme.charAt(0)&&!ThemeManager.urls[s.theme]&&ThemeManager.load(s.theme,"themes/"+s.theme+"/editor_template"+tinymce.suffix+".js"),each(explode(s.plugins),function(p){if(p&&!PluginManager.urls[p])if("-"==p.charAt(0)){p=p.substr(1,p.length);var dependencies=PluginManager.dependencies(p);each(dependencies,function(dep){var defaultSettings={prefix:"plugins/",resource:dep,suffix:"/editor_plugin"+tinymce.suffix+".js"};dep=PluginManager.createUrl(defaultSettings,dep),PluginManager.load(dep.resource,dep)})}else PluginManager.load(p,{prefix:"plugins/",resource:p,suffix:"/editor_plugin"+tinymce.suffix+".js"})}),each(s.external_plugins,function(url,name){PluginManager.load(name,url),s.plugins+=","+name}),sl.loadQueue(function(){self.removed||self.init()})}var self=this,s=self.settings,id=self.id,sl=tinymce.ScriptLoader;return Event.domLoaded?(tinymce.settings=s,void(self.getElement()&&(tinymce.isIDevice&&!tinymce.isIOS5||(!/TEXTAREA|INPUT/i.test(self.getElement().nodeName)&&s.hidden_input&&DOM.getParent(id,"form")&&DOM.insertAfter(DOM.create("input",{type:"hidden",name:id}),id),s.content_editable||(self.orgVisibility=self.getElement().style.visibility,self.getElement().style.visibility="hidden"),tinymce.WindowManager&&(self.windowManager=new tinymce.WindowManager(self)),"xml"==s.encoding&&self.onGetContent.add(function(ed,o){o.save&&(o.content=DOM.encode(o.content))}),s.add_form_submit_trigger&&self.onSubmit.addToTop(function(){self.initialized&&(self.save(),self.isNotDirty=1)}),s.add_unload_trigger&&(self._beforeUnload=tinymce.onBeforeUnload.add(function(){!self.initialized||self.destroyed||self.isHidden()||self.save({format:"raw",no_events:!0})})),tinymce.addUnload(self.destroy,self),s.submit_patch&&self.onBeforeRenderUI.add(function(){var n=self.getElement().form;n&&(n._mceOldSubmit||(n.submit.nodeType||n.submit.length||(self.formElement=n,n._mceOldSubmit=n.submit,n.submit=function(){return tinymce.triggerSave(),self.isNotDirty=1,self.formElement._mceOldSubmit(self.formElement)}),n=null))}),loadScripts())))):void Event.add(window,"ready",function(){self.render()})},init:function(){function initPlugin(p){var po,c=PluginManager.get(p),u=PluginManager.urls[p]||tinymce.documentBaseURL.replace(/\/$/,"");c&&tinymce.inArray(initializedPlugins,p)===-1&&(each(PluginManager.dependencies(p),function(dep){initPlugin(dep)}),po=new c(self,u),self.plugins[p]=po,po.init&&(po.init(self,u),initializedPlugins.push(p)))}var w,h,mh,o,url,bi,bc,re,self=this,s=self.settings,e=self.getElement(),initializedPlugins=[];if(tinymce.add(self),s.aria_label=s.aria_label||DOM.getAttrib(e,"aria-label",self.getLang("aria.rich_text_area")),s.theme&&("function"!=typeof s.theme?(s.theme=s.theme.replace(/-/,""),o=ThemeManager.get(s.theme),self.theme=new o,self.theme.init&&self.theme.init(self,ThemeManager.urls[s.theme]||tinymce.documentBaseURL.replace(/\/$/,""))):self.theme=s.theme),each(explode(s.plugins.replace(/\-/g,"")),initPlugin),self.controlManager=new tinymce.ControlManager(self),self.onBeforeRenderUI.dispatch(self,self.controlManager),s.render_ui&&self.theme&&(self.orgDisplay=e.style.display,"function"!=typeof s.theme?(w=s.width,h=s.height||e.style.height||e.offsetHeight,mh=s.min_height||100,re=/^[0-9\.]+(|px)$/i,re.test(""+w)&&(w=Math.max(parseInt(w,10)+(o.deltaWidth||0),100)),re.test(""+h)&&(h=Math.max(parseInt(h,10)+(o.deltaHeight||0),mh)),o=self.theme.renderUI({targetNode:e,width:w,height:h,deltaWidth:s.delta_width,deltaHeight:s.delta_height}),w&&DOM.setStyles(o.sizeContainer||o.editorContainer,{width:w}),h=(o.iframeHeight||h)+("number"==typeof h?o.deltaHeight||0:""),h<mh&&(h=mh)):(o=s.theme(self,e),o.editorContainer.nodeType&&(o.editorContainer=o.editorContainer.id=o.editorContainer.id||self.id+"_parent"),o.iframeContainer.nodeType&&(o.iframeContainer=o.iframeContainer.id=o.iframeContainer.id||self.id+"_iframecontainer"),h=o.iframeHeight||e.offsetHeight,isIE&&(self.onInit.add(function(ed){ed.dom.bind(ed.getBody(),"beforedeactivate keydown keyup",function(){ed.bookmark=ed.selection.getBookmark(1)})}),self.onNodeChange.add(function(ed){document.activeElement.id==ed.id+"_ifr"&&(ed.bookmark=ed.selection.getBookmark(1))}))),self.editorContainer=o.editorContainer),s.content_css&&each(explode(s.content_css),function(u){self.contentCSS.push(self.documentBaseURI.toAbsolute(u))}),s.content_style&&self.contentStyles.push(s.content_style),s.content_editable)return e=o=null,self.initContentBody();document.domain&&location.hostname!=document.domain&&(tinymce.relaxedDomain=document.domain),self.iframeHTML=s.doctype+'<html dir="'+s.directionality+'"><head xmlns="http://www.w3.org/1999/xhtml">',s.document_base_url!=tinymce.documentBaseURL&&(self.iframeHTML+='<base href="'+self.documentBaseURI.getURI()+'" />'),self.iframeHTML+='<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />',bi=s.body_id||"tinymce",bi.indexOf("=")!=-1&&(bi=self.getParam("body_id","","hash"),bi=bi[self.id]||bi),bc=s.body_class||"",bc.indexOf("=")!=-1&&(bc=self.getParam("body_class","","hash"),bc=bc[self.id]||""),self.iframeHTML+='</head><body id="'+bi+'" class="mceContentBody '+bc+'"><br></body></html>',tinymce.relaxedDomain&&(url='javascript:(function(){document.open();document.domain="'+document.domain+'";var ed = window.parent.tinymce.get("'+self.id+'");document.write(ed.iframeHTML);document.close();ed.initContentBody();})()');var ifr=DOM.add(o.iframeContainer,"iframe",{id:self.id+"_ifr",frameBorder:"0",allowTransparency:"true",title:s.aria_label,style:{height:h}});ifr.onload=function(){ifr.onload=null,self.onLoad.dispatch()},DOM.setAttrib(ifr,"src",url||'javascript:""'),self.contentAreaContainer=o.iframeContainer,o.editorContainer&&(DOM.get(o.editorContainer).style.display=self.orgDisplay),e.style.visibility=self.orgVisibility,DOM.get(self.id).style.display="none",DOM.setAttrib(self.id,"aria-hidden",!0),tinymce.relaxedDomain&&url||self.initContentBody(),e=o=null},initContentBody:function(){function initEditor(){self.initialized=!0,self.onInit.dispatch(self),self.execCallback("setupcontent_callback",self.id,body,doc),self.execCallback("init_instance_callback",self),self.focus(!0),self.nodeChanged({initial:!0}),settings.auto_focus&&setTimeout(function(){var ed=tinymce.get(settings.auto_focus);ed.selection.select(ed.getBody(),1),ed.selection.collapse(1),ed.getBody().focus(),ed.getWin().focus()},100)}var body,contentCssText,self=this,settings=self.settings,targetElm=DOM.get(self.id),doc=self.getDoc();isIE&&tinymce.relaxedDomain||settings.content_editable||(doc.open(),doc.write(self.iframeHTML),doc.close(),tinymce.relaxedDomain&&(doc.domain=tinymce.relaxedDomain)),settings.content_editable&&(DOM.addClass(targetElm,"mceContentBody"),self.contentDocument=doc=settings.content_document||document,self.contentWindow=settings.content_window||window,self.bodyElement=targetElm,settings.content_document=settings.content_window=null),body=self.getBody(),body.disabled=!0,settings.readonly||(body.contentEditable=self.getParam("content_editable_state",!0)),body.disabled=!1,self.schema=new tinymce.html.Schema(settings),self.dom=new tinymce.dom.DOMUtils(doc,{keep_values:!0,url_converter:self.convertURL,url_converter_scope:self,hex_colors:settings.force_hex_style_colors,class_filter:settings.class_filter,update_styles:!0,root_element:settings.content_editable?self.id:null,schema:self.schema}),self.parser=new tinymce.html.DomParser(settings,self.schema),self.parser.addAttributeFilter("src,href,style",function(nodes,name){for(var node,value,internalName,i=nodes.length,dom=self.dom;i--;)node=nodes[i],value=node.attr(name),internalName="data-mce-"+name,node.attributes.map[internalName]||("style"===name?(settings.validate_styles&&(value=dom.serializeStyle(dom.parseStyle(value),node.name)),node.attr(internalName,value)):node.attr(internalName,self.convertURL(value,name,node.name)))}),self.parser.addNodeFilter("script",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],node.attr("type","mce-"+(node.attr("type")||"text/javascript"))}),self.parser.addNodeFilter("#cdata",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],node.type=8,node.name="#comment",node.value="[CDATA["+node.value+"]]"}),self.parser.addNodeFilter("p,h1,h2,h3,h4,h5,h6,div",function(nodes){for(var node,i=nodes.length,nonEmptyElements=self.schema.getNonEmptyElements();i--;)node=nodes[i],node.isEmpty(nonEmptyElements)&&(node.empty().append(new tinymce.html.Node("br",1)).shortEnded=!0)}),self.serializer=new tinymce.dom.Serializer(settings,self.dom,self.schema),self.selection=new tinymce.dom.Selection(self.dom,self.getWin(),self.serializer,self),self.formatter=new tinymce.Formatter(self),self.undoManager=new tinymce.UndoManager(self),self.forceBlocks=new tinymce.ForceBlocks(self),self.enterKey=new tinymce.EnterKey(self),self._nodeChangeDispatcher=new tinymce.NodeChange(self),self.editorCommands=new tinymce.EditorCommands(self),self._selectionOverrides=new tinymce.SelectionOverrides(self),self.onExecCommand.add(function(editor,command){/^(FontName|FontSize)$/.test(command)||self.nodeChanged()}),self.serializer.onPreProcess.add(function(se,o){return self.onPreProcess.dispatch(self,o,se)}),self.serializer.onPostProcess.add(function(se,o){return self.onPostProcess.dispatch(self,o,se)}),self.onPreInit.dispatch(self),settings.browser_spellcheck||settings.gecko_spellcheck||(doc.body.spellcheck=!1),settings.readonly||self.bindNativeEvents(),self.controlManager.onPostRender.dispatch(self,self.controlManager),self.onPostRender.dispatch(self),self.quirks=tinymce.util.Quirks(self),settings.directionality&&(body.dir=settings.directionality),settings.nowrap&&(body.style.whiteSpace="nowrap"),settings.protect&&self.onBeforeSetContent.add(function(ed,o){each(settings.protect,function(pattern){o.content=o.content.replace(pattern,function(str){return"<!--mce:protected "+escape(str)+"-->"})})}),self.onSetContent.add(function(){self.addVisual(self.getBody())}),settings.padd_empty_editor&&self.onPostProcess.add(function(ed,o){o.content=o.content.replace(/^(<p[^>]*>(&nbsp;|&#160;|\s|\u00a0|)<\/p>[\r\n]*|<br \/>[\r\n]*)$/,"")}),self.load({initial:!0,format:"html"}),self.startContent=self.getContent({format:"raw"}),self.contentStyles.length>0&&(contentCssText="",each(self.contentStyles,function(style){contentCssText+=style+"\r\n"}),self.dom.addStyle(contentCssText));var styleLoader=new tinymce.dom.StyleSheetLoader(self.getDoc());each(self.contentCSS,function(url){styleLoader.add(url)}),styleLoader.loadQueue(function(){initEditor()}),targetElm=doc=body=null},focus:function(skip_focus){EditorFocus.focus(this,skip_focus)},execCallback:function(n){var s,self=this,f=self.settings[n];if(f)return self.callbackLookup&&(s=self.callbackLookup[n])&&(f=s.func,s=s.scope),is(f,"string")&&(s=f.replace(/\.\w+$/,""),s=s?tinymce.resolve(s):0,f=tinymce.resolve(f),self.callbackLookup=self.callbackLookup||{},self.callbackLookup[n]={func:f,scope:s}),f.apply(s||self,Array.prototype.slice.call(arguments,1))},translate:function(s){var c=this.settings.language||"en",i18n=tinymce.i18n;return s?i18n[c+"."+s]||s.replace(/\{\#([^\}]+)\}/g,function(a,b){return i18n[c+"."+b]||"{#"+b+"}"}):""},getLang:function(n,dv){return tinymce.i18n[(this.settings.language||"en")+"."+n]||(is(dv)?dv:"{#"+n+"}")},getParam:function(n,dv,ty){var o,tr=tinymce.trim,v=is(this.settings[n])?this.settings[n]:dv;return"hash"===ty?(o={},is(v,"string")?each(v.indexOf("=")>0?v.split(/[;,](?![^=;,]*(?:[;,]|$))/):v.split(","),function(v){v=v.split("="),v.length>1?o[tr(v[0])]=tr(v[1]):o[tr(v[0])]=tr(v)}):o=v,o):v},nodeChanged:function(args){this._nodeChangeDispatcher.nodeChanged(args)},addButton:function(name,settings){var self=this;self.buttons=self.buttons||{},self.buttons[name]=settings},addCommand:function(name,callback,scope){this.execCommands[name]={func:callback,scope:scope||this}},addQueryStateHandler:function(name,callback,scope){this.queryStateCommands[name]={func:callback,scope:scope||this}},addQueryValueHandler:function(name,callback,scope){this.queryValueCommands[name]={func:callback,scope:scope||this}},queryCommandSupported:function(cmd){return this.editorCommands.queryCommandSupported(cmd)},addShortcut:function(pattern,desc,cmdFunc,scope){function parseShortcut(pattern){var id,key,shortcut={};each(explode(pattern,"+"),function(value){value in modifierNames?shortcut[value]=!0:/^[0-9]{2,}$/.test(value)?shortcut.keyCode=parseInt(value,10):(shortcut.charCode=value.charCodeAt(0),shortcut.keyCode=keyCodeLookup[value]||value.toUpperCase().charCodeAt(0))}),id=[shortcut.keyCode];for(key in modifierNames)shortcut[key]?id.push(key):shortcut[key]=!1;return shortcut.id=id.join(","),shortcut.access&&(shortcut.alt=!0,tinymce.isMac?shortcut.ctrl=!0:shortcut.shift=!0),shortcut.meta&&(tinymce.isMac?shortcut.meta=!0:(shortcut.ctrl=!0,shortcut.meta=!1)),shortcut}function createShortcut(pattern,desc,cmdFunc,scope){var shortcuts;return shortcuts=tinymce.map(explode(pattern,">"),parseShortcut),shortcuts[shortcuts.length-1]=extend(shortcuts[shortcuts.length-1],{func:cmdFunc,scope:scope||self}),extend(shortcuts[0],{desc:self.translate(desc),subpatterns:shortcuts.slice(1)})}var self=this;if(self.settings.custom_shortcuts===!1)return!1;self.shortcuts=self.shortcuts||{};var cmd,keyCodeLookup={f9:120,f10:121,f11:122},modifierNames=tinymce.makeMap("alt,ctrl,shift,meta,access");return cmd=cmdFunc,"string"==typeof cmdFunc?cmdFunc=function(){self.execCommand(cmd,!1,null)}:tinymce.isArray(cmd)&&(cmdFunc=function(){self.execCommand(cmd[0],cmd[1],cmd[2])}),each(explode(tinymce.trim(pattern.toLowerCase())),function(pattern){var shortcut=createShortcut(pattern,desc,cmdFunc,scope);self.shortcuts[shortcut.id]=shortcut}),!0},execCommand:function(cmd,ui,val,a){var o,st,self=this,s=0;return/^(mceAddUndoLevel|mceEndUndoLevel|mceBeginUndoLevel|mceRepaint|SelectAll)$/.test(cmd)||a&&a.skip_focus||self.focus(),a=extend({},a),self.onBeforeExecCommand.dispatch(self,cmd,ui,val,a),!a.terminate&&(self.execCallback("execcommand_callback",self.id,self.selection.getNode(),cmd,ui,val)?(self.onExecCommand.dispatch(self,cmd,ui,val,a),!0):(o=self.execCommands[cmd],o&&(st=o.func.call(o.scope,ui,val),st!==!0)?(self.onExecCommand.dispatch(self,cmd,ui,val,a),st):(each(self.plugins,function(p){if(p.execCommand&&p.execCommand(cmd,ui,val))return self.onExecCommand.dispatch(self,cmd,ui,val,a),s=1,!1}),!!s||(self.theme&&self.theme.execCommand&&self.theme.execCommand(cmd,ui,val)?(self.onExecCommand.dispatch(self,cmd,ui,val,a),!0):self.editorCommands.execCommand(cmd,ui,val)?(self.onExecCommand.dispatch(self,cmd,ui,val,a),!0):(self.getDoc().execCommand(cmd,ui,val),void self.onExecCommand.dispatch(self,cmd,ui,val,a))))))},queryCommandState:function(cmd){var o,s,self=this;if(!self._isHidden()){if(o=self.queryStateCommands[cmd],o&&(s=o.func.call(o.scope),s!==!0))return s;if(o=self.editorCommands.queryCommandState(cmd),o!==-1)return o;try{return this.getDoc().queryCommandState(cmd)}catch(ex){}}},queryCommandValue:function(c){var o,s,self=this;if(!self._isHidden()){if(o=self.queryValueCommands[c],o&&(s=o.func.call(o.scope),s!==!0))return s;if(o=self.editorCommands.queryCommandValue(c),is(o))return o;try{return this.getDoc().queryCommandValue(c)}catch(ex){}}},show:function(){var self=this;DOM.show(self.getContainer()),DOM.hide(self.id),self.load(),self.onShow.dispatch(self)},hide:function(){var self=this,doc=self.getDoc();isIE&&doc&&doc.execCommand("SelectAll"),self.save(),DOM.hide(self.getContainer()),DOM.setStyle(self.id,"display",self.orgDisplay),self.onHide.dispatch(self)},isHidden:function(){return!DOM.isHidden(this.id)},setProgressState:function(b,ti,o){return this.onSetProgressState.dispatch(this,b,ti,o),b},load:function(o){var h,self=this,e=self.getElement();if(e)return o=o||{},o.load=!0,h=self.setContent(is(e.value)?e.value:e.innerHTML,o),o.element=e,o.no_events||self.onLoadContent.dispatch(self,o),o.element=e=null,h},save:function(o){var h,f,self=this,e=self.getElement();
if(e&&self.initialized)return o=o||{},o.save=!0,o.element=e,h=o.content=self.getContent(o),o.no_events||self.onSaveContent.dispatch(self,o),h=o.content,/TEXTAREA|INPUT/i.test(e.nodeName)?e.value=h:(e.innerHTML=h,f=DOM.getParent(self.id,"form"),f&&each(f.elements,function(e){if(e.name==self.id)return e.value=h,!1})),o.element=e=null,h},setContent:function(content,args){var forcedRootBlockName,self=this,body=self.getBody();return args=args||{},args.format=args.format||"html",args.set=!0,args.content=content,args.no_events||self.onBeforeSetContent.dispatch(self,args),content=args.content,0===content.length||/^\s+$/.test(content)?(forcedRootBlockName=self.settings.forced_root_block,forcedRootBlockName&&self.schema.isValidChild(body.nodeName.toLowerCase(),forcedRootBlockName.toLowerCase())?content=isIE?"<"+forcedRootBlockName+"></"+forcedRootBlockName+">":"<"+forcedRootBlockName+'><br data-mce-bogus="1"></'+forcedRootBlockName+">":isIE||(content='<br data-mce-bogus="1">'),self.dom.setHTML(body,content),self.onSetContent.dispatch(self,args)):("raw"!==args.format&&(content=new tinymce.html.Serializer({},self.schema).serialize(self.parser.parse(content))),args.content=tinymce.trim(content),self.dom.setHTML(body,args.content),args.no_events||self.onSetContent.dispatch(self,args)),args.content},getSelection:function(){return this.selection.getContent()},getContent:function(args){var content,self=this,body=self.getBody();return args=args||{},args.format=args.format||"html",args.get=!0,args.getInner=!0,args.no_events||self.onBeforeGetContent.dispatch(self,args),content="raw"==args.format?body.innerHTML:"text"==args.format?body.innerText||body.textContent:self.serializer.serialize(body,args),"text"!=args.format?args.content=tinymce.trim(content):args.content=content,args.no_events||self.onGetContent.dispatch(self,args),args.content},isDirty:function(){var self=this;return tinymce.trim(self.startContent)!==tinymce.trim(self.getContent({format:"raw"}))&&!self.isNotDirty},getContainer:function(){var self=this;return self.container||(self.container=DOM.get(self.editorContainer||self.id+"_parent")),self.container},getContentAreaContainer:function(){return this.contentAreaContainer},getElement:function(){return DOM.get(this.settings.content_element||this.id)},getWin:function(){var elm,self=this;return self.contentWindow||(elm=DOM.get(self.id+"_ifr"),elm&&(self.contentWindow=elm.contentWindow)),self.contentWindow},getDoc:function(){var win,self=this;return self.contentDocument||(win=self.getWin(),win&&(self.contentDocument=win.document)),self.contentDocument},getBody:function(){return this.bodyElement||this.getDoc().body},convertURL:function(url,name,elm){var self=this,settings=self.settings;return settings.urlconverter_callback?self.execCallback("urlconverter_callback",url,elm,!0,name):!settings.convert_urls||elm&&"LINK"==elm.nodeName||0===url.indexOf("file:")?url:settings.relative_urls?self.documentBaseURI.toRelative(url):url=self.documentBaseURI.toAbsolute(url,settings.remove_script_host)},addVisual:function(elm){var cls,self=this,settings=self.settings,dom=self.dom;elm=elm||self.getBody(),is(self.hasVisual)||(self.hasVisual=settings.visual),self.hasVisual?dom.addClass(self.getBody(),"mce-visualaid"):dom.removeClass(self.getBody(),"mce-visualaid"),each(dom.select("table,a",elm),function(elm){var value;switch(elm.nodeName){case"TABLE":return cls=settings.visual_table_class||"mce-item-table",value=dom.getAttrib(elm,"border"),void(value&&"0"!=value||(self.hasVisual?dom.addClass(elm,cls):dom.removeClass(elm,cls)));case"A":return void(dom.getAttrib(elm,"href",!1)||(value=dom.getAttrib(elm,"name")||elm.id,cls="mce-item-anchor",value&&(self.hasVisual?dom.addClass(elm,cls):dom.removeClass(elm,cls))))}}),self.onVisualAid.dispatch(self,elm,self.hasVisual)},remove:function(){var self=this,elm=self.getContainer(),doc=self.getDoc();self.removed||(self.removed=1,isIE&&doc&&doc.execCommand("SelectAll"),self.save(),DOM.setStyle(self.id,"display",self.orgDisplay),self.getBody().onload=null,self.settings.content_editable||(Event.unbind(self.getWin()),Event.unbind(self.getDoc())),Event.unbind(self.getBody()),Event.clear(elm),self.execCallback("remove_instance_callback",self),self.onRemove.dispatch(self),self.onExecCommand.listeners=[],self._selectionOverrides.destroy(),tinymce.remove(self),DOM.remove(elm))},destroy:function(s){var self=this;self.destroyed||(isGecko&&(Event.unbind(self.getDoc()),Event.unbind(self.getWin()),Event.unbind(self.getBody())),s||(tinymce.removeUnload(self.destroy),tinymce.onBeforeUnload.remove(self._beforeUnload),self.theme&&self.theme.destroy&&self.theme.destroy(),self.controlManager.destroy(),self.selection.destroy(),self.dom.destroy()),self.formElement&&(self.formElement.submit=self.formElement._mceOldSubmit,self.formElement._mceOldSubmit=null),self.contentAreaContainer=self.formElement=self.container=self.settings.content_element=self.bodyElement=self.contentDocument=self.contentWindow=null,self.selection&&(self.selection=self.selection.win=self.selection.dom=self.selection.dom.doc=null),self.destroyed=1)},setMode:function(disabled){var body=self.getBody();body.contentEditable=disabled,body.disabled=disabled},_isHidden:function(){var s;return isGecko?(s=this.selection.getSel(),!s||!s.rangeCount||0===s.rangeCount):0}}}(tinymce),function(tinymce){var each=tinymce.each;tinymce.Editor.prototype.setupEvents=function(){var self=this,settings=self.settings;each(["onPreInit","onBeforeRenderUI","onPostRender","onLoad","onInit","onRemove","onActivate","onDeactivate","onShow","onHide","onClick","onEvent","onMouseUp","onMouseDown","onDblClick","onKeyDown","onKeyUp","onKeyPress","onContextMenu","onSubmit","onReset","onPaste","onCut","onCopy","onPreProcess","onPostProcess","onBeforeSetContent","onBeforeGetContent","onSetContent","onGetContent","onLoadContent","onSaveContent","onNodeChange","onChange","onBeforeExecCommand","onExecCommand","onUndo","onRedo","onVisualAid","onSetProgressState","onSetAttrib","onSelectionChange","onBlur","onFocus","onFocusIn","onFocusOut"],function(name){self[name]=new tinymce.util.Dispatcher(self)}),settings.cleanup_callback&&(self.onBeforeSetContent.add(function(ed,o){o.content=ed.execCallback("cleanup_callback","insert_to_editor",o.content,o)}),self.onPreProcess.add(function(ed,o){o.set&&ed.execCallback("cleanup_callback","insert_to_editor_dom",o.node,o),o.get&&ed.execCallback("cleanup_callback","get_from_editor_dom",o.node,o)}),self.onPostProcess.add(function(ed,o){o.set&&(o.content=ed.execCallback("cleanup_callback","insert_to_editor",o.content,o)),o.get&&(o.content=ed.execCallback("cleanup_callback","get_from_editor",o.content,o))}))},tinymce.Editor.prototype.bindNativeEvents=function(){function eventHandler(evt,args){self.removed||self.onEvent.dispatch(self,evt,args)!==!1&&self[nativeToDispatcherMap[evt.fakeType||evt.type]].dispatch(self,evt,args)}function getFocusTarget(){return settings.content_editable?self.getBody():tinymce.isGecko?self.getDoc():self.getWin()}function hasModifier(e){return e.altKey||e.ctrlKey||e.metaKey}function isFunctionKey(e){return"keydown"===e.type&&e.keyCode>=112&&e.keyCode<=123}function matchShortcut(e,shortcut){return!!shortcut&&shortcut.ctrl==e.ctrlKey&&shortcut.meta==e.metaKey&&shortcut.alt==e.altKey&&shortcut.shift==e.shiftKey&&!!(e.keyCode==shortcut.keyCode||e.charCode&&e.charCode==shortcut.charCode)&&(e.preventDefault(),!0)}function executeShortcutAction(shortcut){return shortcut.func?shortcut.func.call(shortcut.scope):null}function handleShortcut(e){!hasModifier(e)&&!isFunctionKey(e)||e.isDefaultPrevented()||(each(self.shortcuts,function(shortcut){if(matchShortcut(e,shortcut))return pendingPatterns=shortcut.subpatterns.slice(0),"keydown"==e.type&&executeShortcutAction(shortcut),!0}),matchShortcut(e,pendingPatterns[0])&&(1===pendingPatterns.length&&"keydown"==e.type&&executeShortcutAction(pendingPatterns[0]),pendingPatterns.shift()))}var nativeToDispatcherMap,self=this,settings=self.settings,dom=self.dom;nativeToDispatcherMap={mouseup:"onMouseUp",mousedown:"onMouseDown",click:"onClick",keyup:"onKeyUp",keydown:"onKeyDown",keypress:"onKeyPress",submit:"onSubmit",reset:"onReset",contextmenu:"onContextMenu",dblclick:"onDblClick",paste:"onPaste",cut:"onCut",copy:"onCopy",selectionchange:"onSelectionChange",focusin:"onFocusIn",focusout:"onFocusOut"},each(nativeToDispatcherMap,function(dispatcherName,nativeName){var root=settings.content_editable?self.getBody():self.getDoc();switch(nativeName){case"contextmenu":dom.bind(root,nativeName,eventHandler);break;case"paste":case"cut":case"copy":dom.bind(self.getBody(),nativeName,eventHandler);break;case"submit":case"reset":dom.bind(self.getElement().form||tinymce.DOM.getParent(self.id,"form"),nativeName,eventHandler);break;default:dom.bind(root,nativeName,eventHandler)}}),dom.bind(getFocusTarget(),"focus",function(){self.focus(!0)}),self.onReset.add(function(){self.setContent(self.startContent,{format:"raw"})});var pendingPatterns=[];self.onKeyUp.add(function(ed,e){handleShortcut(e)}),self.onKeyPress.add(function(ed,e){handleShortcut(e)}),self.onKeyDown.add(function(ed,e){handleShortcut(e)})}}(tinymce),function(tinymce){var CaretWalker=tinymce.caret.CaretWalker,CaretPosition=tinymce.caret.CaretPosition,isListFragment=function(fragment){var firstChild=fragment.firstChild,lastChild=fragment.lastChild;return firstChild&&"meta"===firstChild.name&&(firstChild=firstChild.next),lastChild&&"mce_marker"===lastChild.attr("id")&&(lastChild=lastChild.prev),!(!firstChild||firstChild!==lastChild||"ul"!==firstChild.name&&"ol"!==firstChild.name)},cleanupDomFragment=function(domFragment){var firstChild=domFragment.firstChild,lastChild=domFragment.lastChild;return firstChild&&"META"===firstChild.nodeName&&firstChild.parentNode.removeChild(firstChild),lastChild&&"mce_marker"===lastChild.id&&lastChild.parentNode.removeChild(lastChild),domFragment},toDomFragment=function(dom,serializer,fragment){var html=serializer.serialize(fragment),domFragment=dom.createFragment(html);return cleanupDomFragment(domFragment)},listItems=function(elm){return tinymce.grep(elm.childNodes,function(child){return"LI"===child.nodeName})},isEmpty=function(elm){return!elm.firstChild},trimListItems=function(elms){return elms.length>0&&isEmpty(elms[elms.length-1])?elms.slice(0,-1):elms},getParentLi=function(dom,node){var parentBlock=dom.getParent(node,dom.isBlock);return parentBlock&&"LI"===parentBlock.nodeName?parentBlock:null},isParentBlockLi=function(dom,node){return!!getParentLi(dom,node)},getSplit=function(parentNode,rng){var beforeRng=rng.cloneRange(),afterRng=rng.cloneRange();return beforeRng.setStartBefore(parentNode),afterRng.setEndAfter(parentNode),[beforeRng.cloneContents(),afterRng.cloneContents()]},findFirstIn=function(node,rootNode){var caretPos=CaretPosition.before(node),caretWalker=new CaretWalker(rootNode),newCaretPos=caretWalker.next(caretPos);return newCaretPos?newCaretPos.toRange():null},findLastOf=function(node,rootNode){var caretPos=CaretPosition.after(node),caretWalker=new CaretWalker(rootNode),newCaretPos=caretWalker.prev(caretPos);return newCaretPos?newCaretPos.toRange():null},insertMiddle=function(target,elms,rootNode,rng){var parts=getSplit(target,rng),parentElm=target.parentNode;return parentElm.insertBefore(parts[0],target),tinymce.each(elms,function(li){parentElm.insertBefore(li,target)}),parentElm.insertBefore(parts[1],target),parentElm.removeChild(target),findLastOf(elms[elms.length-1],rootNode)},insertBefore=function(target,elms,rootNode){var parentElm=target.parentNode;return tinymce.each(elms,function(elm){parentElm.insertBefore(elm,target)}),findFirstIn(target,rootNode)},insertAfter=function(target,elms,rootNode,dom){return dom.insertAfter(elms.reverse(),target),findLastOf(elms[0],rootNode)},insertAtCaret=function(serializer,dom,rng,fragment){var domFragment=toDomFragment(dom,serializer,fragment),liTarget=getParentLi(dom,rng.startContainer),liElms=trimListItems(listItems(domFragment.firstChild)),BEGINNING=1,END=2,rootNode=dom.getRoot(),isAt=function(location){var caretPos=CaretPosition.fromRangeStart(rng),caretWalker=new CaretWalker(dom.getRoot()),newPos=location===BEGINNING?caretWalker.prev(caretPos):caretWalker.next(caretPos);return!newPos||getParentLi(dom,newPos.getNode())!==liTarget};return isAt(BEGINNING)?insertBefore(liTarget,liElms,rootNode):isAt(END)?insertAfter(liTarget,liElms,rootNode,dom):insertMiddle(liTarget,liElms,rootNode,rng)};tinymce.InsertList={isListFragment:isListFragment,insertAtCaret:insertAtCaret,isParentBlockLi:isParentBlockLi,trimListItems:trimListItems,listItems:listItems}}(tinymce),function(tinymce){var CaretWalker=tinymce.caret.CaretWalker,CaretPosition=tinymce.caret.CaretPosition,NodeType=tinymce.dom.NodeType,Serializer=tinymce.html.Serializer,InsertList=tinymce.InsertList,isTableCell=NodeType.matchNodeNames("td th"),validInsertion=function(editor,value,parentNode){if("all"===parentNode.getAttribute("data-mce-bogus"))parentNode.parentNode.insertBefore(editor.dom.createFragment(value),parentNode);else{var node=parentNode.firstChild,node2=parentNode.lastChild;!node||node===node2&&"BR"===node.nodeName?editor.dom.setHTML(parentNode,value):editor.selection.setContent(value)}},insertHtmlAtCaret=function(editor,value,details){function trimOrPaddLeftRight(html){function hasSiblingText(siblingName){return container[siblingName]&&3==container[siblingName].nodeType}var rng,container,offset;return rng=selection.getRng(!0),container=rng.startContainer,offset=rng.startOffset,3==container.nodeType&&(offset>0?html=html.replace(/^&nbsp;/," "):hasSiblingText("previousSibling")||(html=html.replace(/^ /,"&nbsp;")),offset<container.length?html=html.replace(/&nbsp;(<br>|)$/," "):hasSiblingText("nextSibling")||(html=html.replace(/(&nbsp;| )(<br>|)$/,"&nbsp;"))),html}function trimNbspAfterDeleteAndPaddValue(){var rng,container,offset;rng=selection.getRng(!0),container=rng.startContainer,offset=rng.startOffset,3==container.nodeType&&rng.collapsed&&"\xa0"===container.data[offset]&&(container.deleteData(offset,1),/[\u00a0| ]$/.test(value)||(value+=" "))}function reduceInlineTextElements(){if(merge){var root=editor.getBody();tinymce.each(dom.select("*[data-mce-fragment]"),function(node){for(var testNode=node.parentNode;testNode&&testNode!=root;testNode=testNode.parentNode)textInlineElements[node.nodeName.toLowerCase()]&&testNode===node&&dom.remove(node,!0)})}}function markFragmentElements(fragment){for(var node=fragment;node=node.walk();)1===node.type&&node.attr("data-mce-fragment","1")}function umarkFragmentElements(elm){tinymce.each(elm.getElementsByTagName("*"),function(elm){elm.removeAttribute("data-mce-fragment")})}function isPartOfFragment(node){return!!node.getAttribute("data-mce-fragment")}function canHaveChildren(node){return node&&!editor.schema.getShortEndedElements()[node.nodeName]}function moveSelectionToMarker(marker){function getContentEditableFalseParent(node){for(var root=editor.getBody();node&&node!==root;node=node.parentNode)if("false"===editor.dom.getContentEditable(node))return node;return null}function findNextCaretRng(rng){var caretPos=CaretPosition.fromRangeStart(rng),caretWalker=new CaretWalker(editor.getBody());if(caretPos=caretWalker.next(caretPos))return caretPos.toRange()}var parentEditableFalseElm,parentBlock,nextRng;if(marker){if(selection.scrollIntoView(marker),parentEditableFalseElm=getContentEditableFalseParent(marker))return dom.remove(marker),void selection.select(parentEditableFalseElm);rng=dom.createRng(),node=marker.previousSibling,node&&3==node.nodeType?(rng.setStart(node,node.nodeValue.length),node2=marker.nextSibling,node2&&3==node2.nodeType&&(node.appendData(node2.data),node2.parentNode.removeChild(node2))):(rng.setStartBefore(marker),rng.setEndBefore(marker)),parentBlock=dom.getParent(marker,dom.isBlock),dom.remove(marker),parentBlock&&dom.isEmpty(parentBlock)&&(dom.empty(parentBlock),rng.setStart(parentBlock,0),rng.setEnd(parentBlock,0),isTableCell(parentBlock)||isPartOfFragment(parentBlock)||!(nextRng=findNextCaretRng(rng))?dom.add(parentBlock,dom.create("br",{"data-mce-bogus":"1"})):(rng=nextRng,dom.remove(parentBlock))),selection.setRng(rng)}}var parser,serializer,parentNode,rootNode,fragment,args,marker,rng,node,node2,bookmarkHtml,merge,textInlineElements=editor.schema.getTextInlineElements(),selection=editor.selection,dom=editor.dom;/^ | $/.test(value)&&(value=trimOrPaddLeftRight(value)),parser=editor.parser,merge=details.merge,serializer=new Serializer({validate:editor.settings.validate},editor.schema),bookmarkHtml='<span id="mce_marker" data-mce-type="bookmark">&#xFEFF;&#x200B;</span>',args={content:value,format:"html",selection:!0},selection.onBeforeSetContent.dispatch(selection,args),value=args.content,value.indexOf("{$caret}")==-1&&(value+="{$caret}"),value=value.replace(/\{\$caret\}/,bookmarkHtml),rng=selection.getRng();var caretElement=rng.startContainer||(rng.parentElement?rng.parentElement():null),body=editor.getBody();caretElement===body&&selection.isCollapsed()&&dom.isBlock(body.firstChild)&&canHaveChildren(body.firstChild)&&dom.isEmpty(body.firstChild)&&(rng=dom.createRng(),rng.setStart(body.firstChild,0),rng.setEnd(body.firstChild,0),selection.setRng(rng)),selection.isCollapsed()||(editor.selection.setRng(editor.selection.getRng()),editor.getDoc().execCommand("Delete",!1,null),trimNbspAfterDeleteAndPaddValue()),parentNode=selection.getNode();var parserArgs={context:parentNode.nodeName.toLowerCase(),data:details.data};if(fragment=parser.parse(value,parserArgs),details.paste===!0&&InsertList.isListFragment(fragment)&&InsertList.isParentBlockLi(dom,parentNode))return rng=InsertList.insertAtCaret(serializer,dom,editor.selection.getRng(!0),fragment),editor.selection.setRng(rng),void editor.onSetContent.dispatch(editor,args);if(markFragmentElements(fragment),node=fragment.lastChild,"mce_marker"==node.attr("id"))for(marker=node,node=node.prev;node;node=node.walk(!0))if(3==node.type||!dom.isBlock(node.name)){editor.schema.isValidChild(node.parent.name,"span")&&node.parent.insert(marker,node,"br"===node.name);break}if(editor._selectionOverrides.showBlockCaretContainer(parentNode),parserArgs.invalid){for(selection.setContent(bookmarkHtml,{no_events:!0}),parentNode=selection.getNode(),rootNode=editor.getBody(),9==parentNode.nodeType?parentNode=node=rootNode:node=parentNode;node!==rootNode;)parentNode=node,node=node.parentNode;value=parentNode==rootNode?rootNode.innerHTML:dom.getOuterHTML(parentNode),value=serializer.serialize(parser.parse(value.replace(/<span (id="mce_marker"|id=mce_marker).+?<\/span>/i,function(){return serializer.serialize(fragment)}))),parentNode==rootNode?dom.setHTML(rootNode,value):dom.setOuterHTML(parentNode,value)}else value=serializer.serialize(fragment),validInsertion(editor,value,parentNode);reduceInlineTextElements(),moveSelectionToMarker(dom.get("mce_marker")),umarkFragmentElements(editor.getBody()),selection.onSetContent.dispatch(selection,args),editor.addVisual()},processValue=function(value){var details;return"string"!=typeof value?(details=tinymce.extend({paste:value.paste,data:{paste:value.paste}},value),{content:value.content,details:details}):{content:value,details:{}}},insertAtCaret=function(editor,value){var result=processValue(value);insertHtmlAtCaret(editor,result.content,result.details)};tinymce.InsertContent={insertAtCaret:insertAtCaret}}(tinymce),function(tinymce){var undef,each=tinymce.each,TRUE=!0,FALSE=!1,TreeWalker=tinymce.dom.TreeWalker;tinymce.EditorCommands=function(editor){function execCommand(command,ui,value){var func;return command=command.toLowerCase(),func=commands.exec[command],func?(func(command,ui,value),TRUE):FALSE}function queryCommandState(command){var func;return command=command.toLowerCase(),func=commands.state[command],func?func(command):-1}function queryCommandValue(command){var func;return command=command.toLowerCase(),func=commands.value[command],func?func(command):FALSE}function addCommands(command_list,type){type=type||"exec",each(command_list,function(callback,command){each(command.toLowerCase().split(","),function(command){commands[type][command]=callback})})}function queryCommandSupported(command){if(command=command.toLowerCase(),commands.exec[command])return!0;try{return editor.getDoc().queryCommandSupported(command)}catch(ex){}return!1}function execNativeCommand(command,ui,value){return ui===undef&&(ui=FALSE),value===undef&&(value=null),editor.getDoc().execCommand(command,ui,value)}function isFormatMatch(name){return formatter.match(name)}function toggleFormat(name,value){formatter.toggle(name,value?{value:value}:undef)}function storeSelection(type){bookmark=selection.getBookmark(type)}function restoreSelection(){selection.moveToBookmark(bookmark)}var bookmark,dom=editor.dom,selection=editor.selection,commands={state:{},exec:{},value:{}},settings=editor.settings,formatter=editor.formatter;tinymce.extend(this,{execCommand:execCommand,queryCommandState:queryCommandState,queryCommandValue:queryCommandValue,addCommands:addCommands,queryCommandSupported:queryCommandSupported}),addCommands({"mceResetDesignMode,mceBeginUndoLevel":function(){},"mceEndUndoLevel,mceAddUndoLevel":function(){editor.undoManager.add()},"Cut,Copy,Paste":function(command){try{execNativeCommand(command)}catch(ex){}},unlink:function(){if(selection.isCollapsed()){var elm=editor.dom.getParent(selection.getStart(),"a");return void(elm&&editor.dom.remove(elm,!0))}formatter.remove("link")},"JustifyLeft,JustifyCenter,JustifyRight,JustifyFull":function(command){var align=command.substring(7);each("left,center,right,full".split(","),function(name){align!=name&&formatter.remove("align"+name)}),toggleFormat("align"+align),execCommand("mceRepaint")},"InsertUnorderedList,InsertOrderedList":function(command){var listElm,listParent;execNativeCommand(command),listElm=dom.getParent(selection.getNode(),"ol,ul"),listElm&&(listParent=listElm.parentNode,/^(H[1-6]|P|ADDRESS|PRE)$/.test(listParent.nodeName)&&(storeSelection(),dom.split(listParent,listElm),restoreSelection()))},"Bold,Italic,Underline,Strikethrough,Superscript,Subscript":function(command){toggleFormat(command)},"ForeColor,HiliteColor,FontName":function(command,ui,value){toggleFormat(command,value)},FontSize:function(command,ui,value){var fontClasses,fontSizes;value>=1&&value<=7&&(fontSizes=tinymce.explode(settings.font_size_style_values),fontClasses=tinymce.explode(settings.font_size_classes),value=fontClasses?fontClasses[value-1]||value:fontSizes[value-1]||value),toggleFormat(command,value)},ApplyFormat:function(command,ui,value){formatter.apply(value.name,value.args||{},value.node||null)},RemoveFormat:function(command,ui,value){value=value||{name:command},formatter.remove(value.name,value.args||{},value.node||null)},ToggleFormat:function(command,ui,value){value=value||{name:command},formatter.toggle(value.name,value.args||{},value.node||null)},mceBlockQuote:function(){toggleFormat("blockquote")},FormatBlock:function(command,ui,value){return toggleFormat(value||"p")},mceCleanup:function(){var bookmark=selection.getBookmark();editor.setContent(editor.getContent({cleanup:TRUE}),{cleanup:TRUE}),selection.moveToBookmark(bookmark)},mceRemoveNode:function(command,ui,value){var node=value||selection.getNode();node!=editor.getBody()&&(storeSelection(),editor.dom.remove(node,TRUE),restoreSelection())},mceSelectNodeDepth:function(command,ui,value){var counter=0;value=parseInt(value,10),dom.getParent(selection.getNode(),function(node){if(1==node.nodeType&&counter++==value)return selection.select(node),FALSE},editor.getBody())},mceSelectNode:function(command,ui,value){selection.select(value)},mceInsertContent:function(command,ui,value){tinymce.InsertContent.insertAtCaret(editor,value)},mceInsertRawHTML:function(command,ui,value){selection.setContent("tiny_mce_marker"),editor.setContent(editor.getContent().replace(/tiny_mce_marker/g,function(){return value}))},mceToggleFormat:function(command,ui,value){toggleFormat(value)},mceSetContent:function(command,ui,value){editor.setContent(value)},"Indent,Outdent":function(command){var intentValue,indentUnit,value;intentValue=settings.indentation,indentUnit=/[a-z%]+$/i.exec(intentValue),intentValue=parseInt(intentValue,10),queryCommandState("InsertUnorderedList")||queryCommandState("InsertOrderedList")?execNativeCommand(command):(settings.forced_root_block||dom.getParent(selection.getNode(),dom.isBlock)||formatter.apply("div"),each(selection.getSelectedBlocks(),function(element){if("LI"!=element.nodeName){var indentStyleName=editor.getParam("indent_use_margin",!1)?"margin":"padding";indentStyleName+="rtl"==dom.getStyle(element,"direction",!0)?"Right":"Left","outdent"==command?(value=Math.max(0,parseInt(element.style[indentStyleName]||0,10)-intentValue),dom.setStyle(element,indentStyleName,value?value+indentUnit:"")):(value=parseInt(element.style[indentStyleName]||0,10)+intentValue+indentUnit,dom.setStyle(element,indentStyleName,value))}}))},mceRepaint:function(){if(tinymce.isGecko)try{storeSelection(TRUE),selection.getSel()&&selection.getSel().selectAllChildren(editor.getBody()),selection.collapse(TRUE),restoreSelection()}catch(ex){}},InsertHorizontalRule:function(){editor.execCommand("mceInsertContent",!1,"<hr />")},mceToggleVisualAid:function(){editor.hasVisual=!editor.hasVisual,editor.addVisual()},mceReplaceContent:function(command,ui,value){editor.execCommand("mceInsertContent",!1,value.replace(/\{\$selection\}/g,selection.getContent({format:"text"})))},mceInsertLink:function(command,ui,value){var anchor;"string"==typeof value&&(value={href:value}),anchor=dom.getParent(selection.getNode(),"a"),value.href=value.href.replace(" ","%20"),anchor&&value.href||formatter.remove("link"),value.href&&formatter.apply("link",value,anchor)},selectAll:function(){var root=dom.getRoot(),rng=dom.createRng();selection.getRng().setStart?(rng=dom.createRng(),rng.setStart(root,0),rng.setEnd(root,root.childNodes.length),selection.setRng(rng)):(rng=selection.getRng(),rng.item||(rng.moveToElementText(root),rng.select()))},delete:function(){execNativeCommand("Delete");var body=editor.getBody();dom.isEmpty(body)&&(editor.setContent(""),body.firstChild&&dom.isBlock(body.firstChild)?editor.selection.setCursorLocation(body.firstChild,0):editor.selection.setCursorLocation(body,0))},mceNewDocument:function(){editor.setContent("")},InsertLineBreak:function(command,ui,value){function hasRightSideContent(){for(var node,walker=new TreeWalker(container,parentBlock),nonEmptyElementsMap=editor.schema.getNonEmptyElements();node=walker.next();)if(nonEmptyElementsMap[node.nodeName.toLowerCase()]||node.length>0)return!0}var brElm,extraBr,marker,evt=value,rng=selection.getRng(!0);new tinymce.dom.RangeUtils(dom).normalize(rng);var offset=rng.startOffset,container=rng.startContainer;if(1==container.nodeType&&container.hasChildNodes()){var isAfterLastNodeInContainer=offset>container.childNodes.length-1;container=container.childNodes[Math.min(offset,container.childNodes.length-1)]||container,offset=isAfterLastNodeInContainer&&3==container.nodeType?container.nodeValue.length:0}var parentBlock=dom.getParent(container,dom.isBlock),containerBlock=parentBlock?dom.getParent(parentBlock.parentNode,dom.isBlock):null,containerBlockName=containerBlock?containerBlock.nodeName.toUpperCase():"",isControlKey=evt&&evt.ctrlKey;return"LI"!=containerBlockName||isControlKey||(parentBlock=containerBlock),container&&3==container.nodeType&&offset>=container.nodeValue.length&&(hasRightSideContent()||(brElm=dom.create("br"),rng.insertNode(brElm),rng.setStartAfter(brElm),rng.setEndAfter(brElm),extraBr=!0)),brElm=dom.create("br"),rng.insertNode(brElm),marker=dom.create("span",{},"&nbsp;"),brElm.parentNode.insertBefore(marker,brElm),selection.scrollIntoView(marker),dom.remove(marker),extraBr?(rng.setStartBefore(brElm),rng.setEndBefore(brElm)):(rng.setStartAfter(brElm),rng.setEndAfter(brElm)),selection.setRng(rng),editor.undoManager.add(),TRUE}}),addCommands({"JustifyLeft,JustifyCenter,JustifyRight,JustifyFull":function(command){var name="align"+command.substring(7),node=selection.getNode(),nodes=selection.isCollapsed()?[dom.getParent(node,dom.isBlock)]:selection.getSelectedBlocks();"FIGCAPTION"==node.nodeName&&(nodes=[node]);var matches=tinymce.map(nodes,function(node){return!!formatter.matchNode(node,name)});return tinymce.inArray(matches,TRUE)!==-1},"Bold,Italic,Underline,Strikethrough,Superscript,Subscript":function(command){return isFormatMatch(command)},mceBlockQuote:function(){return isFormatMatch("blockquote")},Outdent:function(){var node;if(settings.inline_styles){if((node=dom.getParent(selection.getStart(),dom.isBlock))&&parseInt(node.style.paddingLeft,10)>0)return TRUE;if((node=dom.getParent(selection.getEnd(),dom.isBlock))&&parseInt(node.style.paddingLeft,10)>0)return TRUE}return queryCommandState("InsertUnorderedList")||queryCommandState("InsertOrderedList")||!settings.inline_styles&&!!dom.getParent(selection.getNode(),"BLOCKQUOTE")},"InsertUnorderedList,InsertOrderedList":function(command){var list=dom.getParent(selection.getNode(),"ul,ol,dl");return list&&("insertunorderedlist"===command&&"UL"===list.tagName||"insertorderedlist"===command&&"OL"===list.tagName)}},"state"),addCommands({"FontSize,FontName":function(command){var parent,value=0;return(parent=dom.getParent(selection.getNode(),"span"))&&(value="fontsize"==command?parent.style.fontSize:parent.style.fontFamily.replace(/, /g,",").replace(/[\'\"]/g,"").toLowerCase()),value}},"value"),addCommands({Undo:function(){editor.undoManager.undo()},Redo:function(){editor.undoManager.redo()}})}}(tinymce),function(tinymce){var Dispatcher=tinymce.util.Dispatcher;tinymce.UndoManager=function(editor){function getContent(){return tinymce.trim(editor.getContent({format:"raw",no_events:1}).replace(/<span[^>]+data-mce-bogus[^>]+>[\u200B\uFEFF]+<\/span>/g,""))}function addNonTypingUndoLevel(){um.typing=!1,um.add()}var um,beforeBookmark,onBeforeAdd,onAdd,onUndo,onRedo,index=0,data=[];return onBeforeAdd=new Dispatcher(um),onAdd=new Dispatcher(um),onUndo=new Dispatcher(um),onRedo=new Dispatcher(um),onAdd.add(function(undoman,level){if(undoman.hasUndo())return editor.onChange.dispatch(editor,level,undoman)}),onUndo.add(function(undoman,level){return editor.onUndo.dispatch(editor,level,undoman)}),onRedo.add(function(undoman,level){return editor.onRedo.dispatch(editor,level,undoman)}),editor.onInit.add(function(){um.add()}),editor.onBeforeExecCommand.add(function(ed,cmd,ui,val,args){"Undo"==cmd||"Redo"==cmd||"mceRepaint"==cmd||args&&args.skip_undo||um.beforeChange()}),editor.onExecCommand.add(function(ed,cmd,ui,val,args){"Undo"==cmd||"Redo"==cmd||"mceRepaint"==cmd||args&&args.skip_undo||um.add()}),editor.onSaveContent.add(addNonTypingUndoLevel),editor.dom.bind(editor.dom.getRoot(),"dragend",addNonTypingUndoLevel),editor.dom.bind(editor.getBody(),"focusout",function(){!editor.removed&&um.typing&&addNonTypingUndoLevel()}),editor.onKeyUp.add(function(editor,e){var keyCode=e.keyCode;e.isDefaultPrevented()||(keyCode>=33&&keyCode<=36||keyCode>=37&&keyCode<=40||45==keyCode||13==keyCode||e.ctrlKey)&&addNonTypingUndoLevel()}),editor.onKeyDown.add(function(editor,e){var keyCode=e.keyCode;if(!e.isDefaultPrevented()){if(keyCode>=33&&keyCode<=36||keyCode>=37&&keyCode<=40||45==keyCode)return void(um.typing&&addNonTypingUndoLevel());var modKey=e.ctrlKey&&!e.altKey||e.metaKey;!(keyCode<16||keyCode>20)||224===keyCode||91===keyCode||um.typing||modKey||(um.beforeChange(),um.typing=!0,um.add())}}),editor.onMouseDown.add(function(){um.typing&&addNonTypingUndoLevel()}),editor.addShortcut("meta+z","","Undo"),editor.addShortcut("meta+y,meta+shift+z","","Redo"),um={data:data,typing:!1,onBeforeAdd:onBeforeAdd,onAdd:onAdd,onUndo:onUndo,onRedo:onRedo,beforeChange:function(){beforeBookmark=editor.selection.getBookmark(2,!0)},add:function(level){var i,lastLevel,settings=editor.settings;if(level=level||{},level.content=getContent(),um.onBeforeAdd.dispatch(um,level),lastLevel=data[index],lastLevel&&lastLevel.content==level.content)return null;
if(data[index]&&(data[index].beforeBookmark=beforeBookmark),settings.custom_undo_redo_levels&&data.length>settings.custom_undo_redo_levels){for(i=0;i<data.length-1;i++)data[i]=data[i+1];data.length--,index=data.length}return level.bookmark=editor.selection.getBookmark(2,!0),index<data.length-1&&(data.length=index+1),data.push(level),index=data.length-1,um.onAdd.dispatch(um,level),editor.isNotDirty=0,level},undo:function(){var level;return um.typing&&(um.add(),um.typing=!1),index>0&&(level=data[--index],editor.setContent(level.content,{format:"raw"}),editor.selection.moveToBookmark(level.beforeBookmark),um.onUndo.dispatch(um,level)),level},redo:function(){var level;return index<data.length-1&&(level=data[++index],editor.setContent(level.content,{format:"raw"}),editor.selection.moveToBookmark(level.bookmark),um.onRedo.dispatch(um,level)),level},clear:function(){data=[],index=0,um.typing=!1},hasUndo:function(){return index>0||this.typing},hasRedo:function(){return index<data.length-1&&!this.typing}}}}(tinymce),tinymce.ForceBlocks=function(editor){function addRootBlocks(){var rng,startContainer,startOffset,endContainer,endOffset,rootBlockNode,tempNode,wrapped,restoreSelection,tmpRng,rootNodeName,forcedRootBlock,node=selection.getStart(),rootNode=editor.getBody(),offset=-16777215;if(forcedRootBlock=settings.forced_root_block,node&&1===node.nodeType&&forcedRootBlock&&!node.getAttribute("data-mce-type")){for(;node&&node!=rootNode;){if(blockElements[node.nodeName])return;node=node.parentNode}if(rng=selection.getRng(),rng.setStart){startContainer=rng.startContainer,startOffset=rng.startOffset,endContainer=rng.endContainer,endOffset=rng.endOffset;try{restoreSelection=editor.getDoc().activeElement===rootNode}catch(ex){}}else rng.item&&(node=rng.item(0),rng=editor.getDoc().body.createTextRange(),rng.moveToElementText(node)),restoreSelection=rng.parentElement().ownerDocument===editor.getDoc(),tmpRng=rng.duplicate(),tmpRng.collapse(!0),startOffset=tmpRng.move("character",offset)*-1,tmpRng.collapsed||(tmpRng=rng.duplicate(),tmpRng.collapse(!1),endOffset=tmpRng.move("character",offset)*-1-startOffset);for(node=rootNode.firstChild,rootNodeName=rootNode.nodeName.toLowerCase();node;)if((3===node.nodeType||1==node.nodeType&&!blockElements[node.nodeName])&&schema.isValidChild(rootNodeName,forcedRootBlock.toLowerCase())){if(3===node.nodeType&&0===node.nodeValue.length){tempNode=node,node=node.nextSibling,dom.remove(tempNode);continue}rootBlockNode||(rootBlockNode=dom.create(forcedRootBlock,editor.settings.forced_root_block_attrs),node.parentNode.insertBefore(rootBlockNode,node),wrapped=!0),tempNode=node,node=node.nextSibling,rootBlockNode.appendChild(tempNode)}else rootBlockNode=null,node=node.nextSibling;if(wrapped&&restoreSelection){if(rng.setStart)rng.setStart(startContainer,startOffset),rng.setEnd(endContainer,endOffset),selection.setRng(rng);else try{rng=editor.getDoc().body.createTextRange(),rng.moveToElementText(rootNode),rng.collapse(!0),rng.moveStart("character",startOffset),endOffset>0&&rng.moveEnd("character",endOffset),rng.select()}catch(ex){}editor.nodeChanged()}}}var settings=editor.settings,dom=editor.dom,selection=editor.selection,schema=editor.schema,blockElements=schema.getBlockElements();settings.forced_root_block&&(editor.onKeyUp.add(addRootBlocks),editor.onNodeChange.add(addRootBlocks))},function(tinymce){var Event=tinymce.dom.Event,each=tinymce.each,extend=tinymce.extend,PreviewCss=tinymce.util.PreviewCss;tinymce.ControlManager=function(ed,s){var self=this;s=s||{},self.editor=ed,self.controls={},self.onAdd=new tinymce.util.Dispatcher(self),self.onPostRender=new tinymce.util.Dispatcher(self),self.prefix=s.prefix||ed.id+"_",self._cls={},self.classPrefix="mce",self.onPostRender.add(function(){each(self.controls,function(c){c.postRender()})})},tinymce.ControlManager.prototype={get:function(id){return this.controls[this.prefix+id]||this.controls[id]},setActive:function(id,s){var c=this.get(id);return c&&c.setActive(s),c},setDisabled:function(id,s){var c=this.get(id);return c&&c.setDisabled(s),c},add:function(c){var self=this;return c&&(self.controls[c.id]=c,self.onAdd.dispatch(c,self)),c},createControl:function(name){var ctrl,i,l,factories,self=this,editor=self.editor;for(self.controlFactories||(self.controlFactories=[],each(editor.plugins,function(plugin){plugin.createControl&&self.controlFactories.push(plugin)})),factories=self.controlFactories,i=0,l=factories.length;i<l;i++)if(ctrl=factories[i].createControl(name,self))return self.add(ctrl);return"|"===name||"separator"===name?self.createSeparator():editor.buttons&&(ctrl=editor.buttons[name])?self.createButton(name,ctrl):self.add(ctrl)},createDropMenu:function(id,s,cc){var c,bm,cls,self=this,ed=self.editor;return s=extend({class:"mceDropDown",constrain:ed.settings.constrain_menus},s),s.class+=" "+(ed.settings.skin_class||"mceDefaultSkin"),id.indexOf(self.prefix)==-1&&(id=self.prefix+id),cls=cc||self._cls.dropmenu||tinymce.ui.DropMenu,c=self.controls[id]=new cls(id,s),c.onAddItem.add(function(c,o){var s=o.settings;s.title&&(s.title=ed.getLang(s.title,s.title)),!s.onclick&&s.cmd&&(s.onclick=function(){ed.execCommand(s.cmd,s.ui||!1,s.value)})}),tinymce.isIE&&(c.onShowMenu.add(function(){ed.focus(),bm=ed.selection.getBookmark(1)}),c.onHideMenu.add(function(){bm&&(ed.selection.moveToBookmark(bm),bm=0)})),ed.onRemove.add(function(){c.destroy()}),self.add(c)},createListBox:function(id,s,cc){var c,cls,self=this,ed=self.editor;return(c=self.get(id))?c:(s.title=ed.translate(s.title),s.scope=s.scope||ed,s.onselect||(s.onselect=function(v){return!!s.cmd&&void ed.execCommand(s.cmd,s.ui||!1,v||s.value)}),s=extend({title:s.title,class:"mce_"+id,scope:s.scope,control_manager:self},s),id=self.prefix+id,cls=cc||self._cls.listbox||tinymce.ui.ListBox,c=new cls(id,s,ed),self.controls[id]=c,tinymce.isWebKit&&c.onPostRender.add(function(c,n){Event.add(n,"mousedown",function(){ed.bookmark=ed.selection.getBookmark(1)}),Event.add(n,"focus",function(){ed.selection.moveToBookmark(ed.bookmark),ed.bookmark=null})}),c.hideMenu&&ed.onMouseDown.add(c.hideMenu,c),self.add(c))},createStylesBox:function(id,s,cc){function loadClasses(ctrl){Array.isArray(ed.settings.importcss_classes)&&(ctrl.hasClasses||(each(ed.settings.importcss_classes,function(item){var selector=/^(?:([a-z0-9\-_]+))?(\.[a-z0-9_\-\.]+)$/i.exec(item.selector||item);if(selector&&!selector[1]){var classes=selector[2].substr(1).split(".");each(classes,function(cls){ctrl.add(cls,cls,{style:function(){return item.style||PreviewCss.getCssText(ed,{classes:cls})}})}),PreviewCss.reset()}}),Array.isArray(ed.settings.importcss_classes)&&(ctrl.hasClasses=!0)))}var self=this,ed=self.editor;s=tinymce.extend({max_height:384,combobox:!0,multiple:!0,seperator:" "},s||{});var c=this.createListBox(id,s,cc);return c.onPostRender.add(function(c,n){loadClasses(c)}),c},createButton:function(id,s,cc){var c,cls,self=this,ed=self.editor;return self.get(id)?null:(s.title=ed.translate(s.title),s.label=ed.translate(s.label),s.scope=s.scope||ed,s.onclick||s.menu_button||(s.onclick=function(){ed.execCommand(s.cmd,s.ui||!1,s.value)}),s=extend({title:s.title,class:"mce_"+id,scope:s.scope,control_manager:self},s),id=self.prefix+id,s.menu_button?(cls=cc||self._cls.menubutton||tinymce.ui.MenuButton,c=new cls(id,s,ed),ed.onMouseDown.add(c.hideMenu,c)):(cls=self._cls.button||tinymce.ui.Button,c=new cls(id,s,ed)),self.add(c))},createMenuButton:function(id,s,cc){return s=s||{},s.menu_button=1,this.createButton(id,s,cc)},createSplitButton:function(id,s,cc){var c,cls,self=this,ed=self.editor;return self.get(id)?null:(s.title=ed.translate(s.title),s.scope=s.scope||ed,!s.onclick&&s.cmd&&(s.onclick=function(v){ed.execCommand(s.cmd,s.ui||!1,v||s.value)}),!s.onselect&&s.cmd&&(s.onselect=function(v){ed.execCommand(s.cmd,s.ui||!1,v||s.value)}),s=extend({title:s.title,class:"mce_"+id,scope:s.scope,control_manager:self},s),id=self.prefix+id,cls=cc||self._cls.splitbutton||tinymce.ui.SplitButton,c=self.add(new cls(id,s,ed)),ed.onMouseDown.add(c.hideMenu,c),c.onRenderMenu.add(function(e,m){m.onHideMenu.add(function(){ed.nodeChanged(),ed.focus()})}),self.add(c))},createColorSplitButton:function(id,s,cc){var c,cls,bm,self=this,ed=self.editor;return self.get(id)?null:(s.title=ed.translate(s.title),s.scope=s.scope||ed,s.onclick||(s.onclick=function(v){tinymce.isIE&&(bm=ed.selection.getBookmark(1)),ed.execCommand(s.cmd,s.ui||!1,v||s.value)}),s.onselect||(s.onselect=function(v){ed.execCommand(s.cmd,s.ui||!1,v||s.value)}),s=extend({title:s.title,class:"mce_"+id,menu_class:ed.settings.skin_class||"mceDefaultSkin",scope:s.scope,more_colors_title:ed.getLang("more_colors")},s),id=self.prefix+id,cls=cc||self._cls.colorsplitbutton||tinymce.ui.ColorSplitButton,c=new cls(id,s,ed),ed.onMouseDown.add(c.hideMenu,c),ed.onRemove.add(function(){c.destroy()}),c.onShowMenu.add(function(){bm=ed.selection.getBookmark(1)}),c.onHideMenu.add(function(){bm&&(ed.selection.moveToBookmark(bm),bm=0)}),self.add(c))},createTextBox:function(id,s,cc){var c,cls,self=this,ed=self.editor;return id=self.prefix+id,(c=self.get(id))?c:(s.title=ed.translate(s.title),s.label=ed.translate(s.label),s.scope=s.scope||ed,s=extend({title:s.title,class:"mce_"+id,scope:s.scope,control_manager:self},s),cls=cc||tinymce.ui.TextBox,c=new cls(id,s,ed),self.add(c))},createUrlBox:function(id,s){var ed=this.editor;return s.upload_label=ed.getLang(s.upload_label,"Upload"),s.picker_label=ed.getLang(s.picker_label,"Browse"),this.createTextBox(id,s,tinymce.ui.UrlBox)},createCheckBox:function(id,s){var c,cls,self=this,ed=self.editor;return(c=self.get(id))?c:(s.title=ed.translate(s.title),s.label=ed.translate(s.label),s.scope=s.scope||ed,s=extend({title:s.title,class:"mce_"+id,scope:s.scope,control_manager:self},s),id=self.prefix+id,cls=tinymce.ui.CheckBox,c=new cls(id,s,ed),self.add(c))},createCustomValue:function(id,s){var c,self=this,ed=self.editor;return id=self.prefix+id,c=new tinymce.ui.CustomValue(id,s,ed),self.add(c)},createRepeatable:function(id,s){var c,cls,self=this,ed=self.editor;return id=self.prefix+id,(c=self.get(id))?c:(s.scope=s.scope||ed,s=extend({class:"mce_"+id,scope:s.scope,control_manager:self},s),cls=tinymce.ui.Repeatable,c=new cls(id,s,ed),self.add(c))},createPanel:function(id,s,cc){var c,cls,self=this,ed=self.editor;return s.class+=" "+(ed.settings.skin_class||"mceDefaultSkin"),cls=cc||self._cls.panel||tinymce.ui.Panel,c=new cls(id,s,self.editor),self.get(id)?null:self.add(c)},createContextPanel:function(id,s){var cc=tinymce.ui.ContextPanel;return this.createPanel(id,s,cc)},createToolbar:function(id,s,cc){var c,cls,self=this;return id=self.prefix+id,cls=cc||self._cls.toolbar||tinymce.ui.Toolbar,c=new cls(id,s,self.editor),self.get(id)?null:self.add(c)},createToolbarGroup:function(id,s,cc){var c,cls,self=this;return id=self.prefix+id,cls=cc||this._cls.toolbarGroup||tinymce.ui.ToolbarGroup,c=new cls(id,s,self.editor),self.get(id)?null:self.add(c)},createLayout:function(id,s,cc){var c,cls,self=this;return id=self.prefix+id,cls=cc||self._cls.layout||tinymce.ui.Layout,c=new cls(id,s,self.editor),self.get(id)?null:self.add(c)},createForm:function(id,s){var c,cls,self=this;return id=self.prefix+id,cls=tinymce.ui.Form,c=new cls(id,s,self.editor),self.add(c)},createSeparator:function(cc){var cls=cc||this._cls.separator||tinymce.ui.Separator;return new cls},setControlType:function(n,c){return this._cls[n.toLowerCase()]=c},destroy:function(){each(this.controls,function(c){c.destroy()}),this.controls=null}}}(tinymce),function(tinymce){function ucfirst(s){return s.substring(0,1).toUpperCase()+s.substring(1)}function updateWithTouchData(e){var keys,i;if(e.changedTouches)for(keys="screenX screenY pageX pageY clientX clientY".split(" "),i=0;i<keys.length;i++)e[keys[i]]=e.changedTouches[0][keys[i]]}var DOM=tinymce.DOM,Event=tinymce.dom.Event,each=tinymce.each,Dispatcher=tinymce.util.Dispatcher;tinymce.create("tinymce.WindowManager",{WindowManager:function(ed){this.editor=ed,this.onOpen=new Dispatcher(this),this.onClose=new Dispatcher(this),this.params={},this.features={},this.zIndex=700002,this.count=0,this.windows={}},createInstance:function(cl,a,b,c,d,e){var fn=tinymce.resolve(cl);return new fn(a,b,c,d,e)},open:function(f,p){function nodeIndex(nodes,node){for(var i=0;i<nodes.length;i++)if(nodes[i]===node)return i;return-1}var id,win,url,self=this,ed=self.editor,dw=0,dh=0;f=f||{},p=p||{},f.type||(self.bookmark=ed.selection.getBookmark(1)),id=DOM.uniqueId("mce_window_"),f.width=parseInt(f.width||0,10),f.height=parseInt(f.height||0,10),p.mce_window_id=id,self.features=f,self.params=p,self.onOpen.dispatch(self,f,p);var html='<div class="mceModalBody" id="'+id+'" dir="'+ed.settings.skin_directionality+'">   <div class="mceModalContainer">       <div class="mceModalHeader" id="'+id+'_header">           <h5 class="mceModalTitle" id="'+id+'_title">'+(f.title||"")+'</h5>           <button class="mceModalClose" type="button" title="'+ed.getLang("close","Close")+'"></button>       </div>       <div class="mceModalContent" id="'+id+'_content"></div>   </div></div>',modal=DOM.select(".mceModal");if(modal.length||(modal=DOM.add(DOM.doc.body,"div",{class:ed.settings.skin_class+" mceModal",role:"dialog","aria-labelledby":id+"_title"},""),f.overlay!==!1&&DOM.add(modal,"div",{class:"mceModalOverlay"})),DOM.add(modal,"div",{class:"mceModalFrame",id:id+"_frame"},html),f.fixed?(DOM.addClass(modal,"mceModalFixed"),Event.add(id,"blur",function(){self.close(null,id)})):DOM.addClass(DOM.select(".mceModalHeader",modal),"mceModalMove"),f.buttons=f.buttons||[],url=f.url||f.file){f.addver!==!1&&(url=tinymce._addVer(url)),DOM.addClass(id,"mceLoading"),DOM.addClass(id+"_content","mceModalContentIframe");var iframe=DOM.add(id+"_content","iframe",{id:id+"_ifr",src:'javascript:""',frameBorder:0,"aria-label":"Dialog Content Iframe"});DOM.setAttrib(iframe,"src",url),Event.add(iframe,"load",function(){DOM.removeClass(id,"mceLoading")})}else f.type&&DOM.addClass(id,"mceModal"+ucfirst(f.type)),f.buttons.length||f.buttons.push({id:"cancel",title:self.editor.getLang("cancel","Cancel"),onclick:function(e){Event.cancel(e),self.close(null,id)}}),f.content&&("string"==typeof f.content&&DOM.setHTML(id+"_content","<form>"+f.content.replace("\n","")+"</form>"),f.content.nodeType&&DOM.add(id+"_content",DOM.create("form",{},f.content))),f.items&&(tinymce.is(f.items,"array")||(f.items=[f.items]),each(f.items,function(ctrl){var form=DOM.add(id+"_content","form");ctrl.renderTo(form),self.onClose.add(function(e,win){win.id==id&&ctrl.destroy()})})),Event.add(id,"keydown",function(e){var tabIndex=0;if(9===e.keyCode){var nodes=DOM.select("input, button, select, textarea, .mceListBox",DOM.get(id));if(nodes=tinymce.grep(nodes,function(node){return!node.disabled&&!DOM.isHidden(node)&&node.getAttribute("tabindex")>=0}),!nodes.length)return;DOM.setAttrib(nodes,"tabindex",0),e.shiftKey&&nodes.reverse();var endIndex=Math.max(0,nodes.length-1),tabIndex=nodeIndex(nodes,e.target);tabIndex++,tabIndex=Math.max(tabIndex,0),tabIndex>endIndex&&(tabIndex=0),nodes[tabIndex].focus(),DOM.setAttrib(nodes[tabIndex],"tabindex",1),e.preventDefault(),e.stopImmediatePropagation()}});return f.buttons.length&&(DOM.add(DOM.select(".mceModalContainer",id),"div",{class:"mceModalFooter",id:id+"_footer"}),each(f.buttons,function(button){"cancel"===button.id&&(button.onclick=function(e){self.close(null,id)});var attribs={id:id+"_"+button.id,class:"mceButton",type:"button"};button.autofocus&&(attribs.autofocus=!0),button.title=button.title||"OK";var btn=DOM.add(id+"_footer","button",attribs,button.title);button.icon&&DOM.add(btn,"span",{class:"mceIcon mce_"+button.icon,role:"presentation"}),each(tinymce.explode(button.classes),function(cls){DOM.addClass(btn,"mceButton"+ucfirst(cls))}),button.onclick&&Event.add(btn,"click",function(e){Event.cancel(e),button.onclick.call(self,e)}),button.onsubmit&&Event.add(btn,"click",function(e){Event.cancel(e),button.onsubmit.call(self,e),e.cancelSubmit||self.close(null,id)})})),Event.add(id,"keydown",function(evt){if(27===evt.keyCode)return self.close(null,id),evt.preventDefault(),void evt.stopImmediatePropagation();if(13===evt.keyCode){if(evt.target){if("TEXTAREA"===evt.target.nodeName)return;"BUTTON"===evt.target.nodeName&&Event.fire(evt.target,"click")}evt.preventDefault(),evt.stopImmediatePropagation()}}),Event.add(DOM.select("button.mceModalClose",DOM.get(id)),"click",function(evt){self.close(null,id),evt.preventDefault(),evt.stopImmediatePropagation()}),f.type||(dh+=DOM.get(id+"_header").clientHeight),f.size?DOM.addClass(id,f.size):(f.width&&DOM.setStyle(id,"width",f.width+dw),f.height&&DOM.setStyle(id,"height",f.height+dh)),f.fixed||Event.add(DOM.win,"resize orientationchange",function(){DOM.get(id)&&self.position(id)}),Event.add(id,"mousedown",function(e){var n=e.target;if(!/(input|select|textarea|button|label)/i.test(n.nodeName)&&(self.focus(id),!DOM.hasClass(n,".mceModalClose")&&!f.fixed))return DOM.hasClass(n,"mceModalMove")||DOM.hasClass(n.parentNode,"mceModalMove")?self._startDrag(id,e,"Move"):void 0}),self.windows[id]=win={id:id,features:f,elm:DOM.get(id),moveTo:function(x,y){return self.moveTo(id,x,y)},close:function(){return self.close(null,id)},focus:function(){return self.focus(id)}},f.open&&"function"==typeof f.open&&f.open.call(win||self,win),DOM.setAttrib(id,"aria-hidden","false"),self.position(id),self.focus(id),self.count++,win},close:function(win,id){var id,self=this;if(id=self._findId(id||win),win=self.windows[id]||self._frontWindow(),!win)return!1;self.count--,0===self.count&&(DOM.remove(DOM.select(".mceModal")),DOM.setAttrib(DOM.doc.body,"aria-hidden","false"),self.editor.focus()),self.onClose.dispatch(self,win);var f=win.features||{};if(f.close&&"function"==typeof f.close&&f.close.call(win||self,win),Event.clear(id),Event.clear(id+"_ifr"),DOM.setAttrib(id+"_ifr","src",'javascript:""'),DOM.remove(id+"_frame"),DOM.remove(id),delete this.windows[id],self.count>0){var fw=this._frontWindow();fw&&fw.focus()}return!0},setTitle:function(win,title){var elm,id;id=this._findId(win),elm=DOM.get(id+"_title"),elm&&!elm.innerHTML&&(elm.innerHTML=DOM.encode(title))},confirm:function(txt,cb,s){var self=this;self.open({title:"",type:"confirm",buttons:[{title:self.editor.getLang("no","No"),id:"cancel"},{title:self.editor.getLang("yes","Yes"),id:"ok",classes:"primary",autofocus:!0,onsubmit:function(s){cb&&cb.call(s||self,s)}}],content:"<p>"+DOM.encode(self.editor.getLang(txt,txt))+"</p>"})},alert:function(txt,cb,s){var self=this;self.open({title:"",type:"alert",buttons:[{title:self.editor.getLang("cancel","Cancel"),id:"cancel"},{title:self.editor.getLang("ok","Ok"),id:"ok",classes:"primary",autofocus:!0,onsubmit:function(s){cb&&cb.call(s||self,s)}}],content:"<p>"+DOM.encode(self.editor.getLang(txt,txt))+"</p>"})},prompt:function(txt,cb,s){var self=this,html='<div class="mceModalRow">   <div class="mceModalControl">       <input type="text" id="'+self.editor.id+'_prompt_input" autofocus />   </div></div>';self.open({title:"",type:"prompt",buttons:[{title:self.editor.getLang("cancel","Cancel"),id:"cancel"},{title:self.editor.getLang("ok","Ok"),id:"ok",classes:"primary",autofocus:!0,onsubmit:function(){var value=DOM.getValue(self.editor.id+"_prompt_input");cb&&cb.call(s||self,value)}}],content:html})},resizeBy:function(dw,dh,id){},moveTo:function(id,x,y){DOM.setStyles(id,{left:x,top:y})},position:function(id){var p=DOM.getRect(id),vp=DOM.getViewPort(),top=Math.round(Math.max(vp.y+10,vp.y+vp.h/2-p.h/2)),left=Math.round(Math.max(vp.x+10,vp.x+vp.w/2-p.w/2));DOM.setStyles(id,{left:left,top:top})},focus:function(id){var win=this.windows[id];if(win)if(win.zIndex=this.zIndex++,DOM.setStyle(id+"_frame","zIndex",win.zIndex),DOM.removeClass(this.lastId,"mceFocus"),DOM.addClass(id+"_frame","mceFocus"),this.lastId=id+"_frame",DOM.get(id).focus(),DOM.get(id+"_ifr"))DOM.get(id+"_ifr").focus();else{var nodes=DOM.select("input, select, button, textarea",DOM.get(id));nodes[0].focus();for(var i=0;i<nodes.length;i++){var node=nodes[i];if(node.getAttribute("tabindex")>=0&&node.getAttribute("autofocus")){node.focus();break}}}},_startDrag:function(id,se,ac){function end(){Event.remove(d,"mouseup touchend",mu),Event.remove(d,"mousemove touchmove",mm),DOM.removeClass(id,"dragging")}var mu,mm,sx,sy,d=DOM.doc;if(DOM.hasClass(id,"dragging"))return void end();updateWithTouchData(se);var p=DOM.getRect(id),vp=DOM.getViewPort();vp.w-=2,vp.h-=2,DOM.addClass(id,"dragging"),sx=se.screenX,sy=se.screenY,mu=Event.add(d,"mouseup touchend",function(e){return updateWithTouchData(e),end(),Event.cancel(e)}),mm=Event.add(d,"mousemove touchmove",function(e){var x,y;updateWithTouchData(e),x=e.screenX-sx,y=e.screenY-sy;var dx=Math.max(p.x+x,10),dy=Math.max(p.y+y,10);return DOM.setStyles(id,{left:dx,top:dy}),Event.cancel(e)})},_frontWindow:function(){var fw,ix=0;return tinymce.each(this.windows,function(win){win.zIndex>ix&&(fw=win,ix=win.zIndex)}),fw},_findId:function(w){var self=this;return"string"==typeof w?w:(each(self.windows,function(wo){var ifr=DOM.get(wo.id+"_ifr");if(ifr&&w==ifr.contentWindow)return w=wo.id,!1}),w)}})}(tinymce),function(tinymce){tinymce.Formatter=function(ed){function isTextBlock(name){return name.nodeType&&(name=name.nodeName),!!ed.schema.getTextBlockElements()[name.toLowerCase()]}function isShortEnded(node){return!!ed.schema.getShortEndedElements()[node.nodeName.toLowerCase()]}function isTableCell(node){return/^(TH|TD)$/.test(node.nodeName)}function isInlineBlock(node){return node&&/^(IMG)$/.test(node.nodeName)}function getParents(node,selector){return dom.getParents(node,selector,dom.getRoot())}function isCaretNode(node){return 1===node.nodeType&&"_mce_caret"===node.id}function isBogusBr(node){return"BR"==node.nodeName&&node.getAttribute("data-mce-bogus")&&!node.nextSibling}function isFigure(node){return getParents(node,"FIGURE")&&"FIGURE"!=node.nodeName}function defaultFormats(){register({valigntop:[{selector:"td,th",styles:{verticalAlign:"top"}}],valignmiddle:[{selector:"td,th",styles:{verticalAlign:"middle"}}],valignbottom:[{selector:"td,th",styles:{verticalAlign:"bottom"}}],alignleft:[{selector:"figure,figcaption,p,h1,h2,h3,h4,h5,h6,td,th,tr,div,ul,ol,li",styles:{textAlign:"left"},defaultBlock:"div",inherit:!1},{selector:"figure[data-mce-image]",collapsed:!1,ceFalseOverride:!0,styles:{float:"left"}},{selector:"img,table",collapsed:!1,styles:{float:"left"}}],aligncenter:[{selector:"figure,figcaption,p,h1,h2,h3,h4,h5,h6,td,th,tr,div,ul,ol,li",styles:{textAlign:"center"},defaultBlock:"div",inherit:!1},{selector:"figure[data-mce-image]",collapsed:!1,ceFalseOverride:!0,styles:{marginLeft:"auto",marginRight:"auto",display:"table"}},{selector:"img",collapsed:!1,styles:{display:"block",marginLeft:"auto",marginRight:"auto"}},{selector:"table",collapsed:!1,styles:{marginLeft:"auto",marginRight:"auto"}}],alignright:[{selector:"figure,figcaption,p,h1,h2,h3,h4,h5,h6,td,th,tr,div,ul,ol,li",styles:{textAlign:"right"},defaultBlock:"div",inherit:!1},{selector:"figure[data-mce-image]",collapsed:!1,ceFalseOverride:!0,styles:{float:"right"}},{selector:"img,table",collapsed:!1,styles:{float:"right"}}],alignfull:[{selector:"figure,figcaption,p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li",styles:{textAlign:"justify"},defaultBlock:"div",inherit:!1}],bold:[{inline:"strong",remove:"all"},{inline:"span",styles:{fontWeight:"bold"}},{inline:"b",remove:"all"}],italic:[{inline:"em",remove:"all"},{inline:"span",styles:{fontStyle:"italic"}},{inline:"i",remove:"all"}],underline:[{inline:"span",styles:{textDecoration:"underline"},exact:!0},{inline:"u",remove:"all"}],strikethrough:[{inline:"span",styles:{textDecoration:"line-through"},exact:!0},{inline:"strike",remove:"all"}],forecolor:{inline:"span",styles:{color:"%value"},links:!0,remove_similar:!0},hilitecolor:{inline:"span",styles:{backgroundColor:"%value"},links:!0,remove_similar:!0},fontname:{inline:"span",styles:{fontFamily:"%value"}},fontsize:{inline:"span",styles:{fontSize:"%value"}},fontsize_class:{inline:"span",attributes:{class:"%value"}},blockquote:{block:"blockquote",wrapper:1,remove:"all"},subscript:{inline:"sub"},superscript:{inline:"sup"},code:{inline:"code"},link:{inline:"a",selector:"a",remove:"all",split:!0,deep:!0,onmatch:function(){return!0},onformat:function(elm,fmt,vars){each(vars,function(value,key){dom.setAttrib(elm,key,value)})}},removeformat:[{selector:"b,strong,em,i,font,u,strike,sub,sup,dfn,code,samp,kbd,var,cite,mark,q,del,ins",remove:"all",split:!0,expand:!1,block_expand:!0,deep:!0},{selector:"span",attributes:["style","class"],remove:"empty",split:!0,expand:!1,deep:!0},{selector:"*",attributes:["style","class"],split:!1,expand:!1,deep:!0}]}),each("p h1 h2 h3 h4 h5 h6 div address pre div code samp dt dd dl".split(/\s/),function(name){register(name,{block:name,remove:"all"})}),register(ed.settings.formats)}function addKeyboardShortcuts(){ed.addShortcut("meta+b","bold_desc","Bold"),ed.addShortcut("meta+i","italic_desc","Italic"),ed.addShortcut("meta+u","underline_desc","Underline");for(var i=1;i<=6;i++)ed.addShortcut("access+"+i,"",["FormatBlock",!1,"h"+i]);ed.addShortcut("access+7","",["FormatBlock",!1,"p"]),ed.addShortcut("access+8","",["FormatBlock",!1,"div"]),ed.addShortcut("access+9","",["FormatBlock",!1,"address"])}function get(name){return name?formats[name]:formats}function register(name,format){if(name)if("string"!=typeof name)each(name,function(format,name){register(name,format)});else if(format=format.length?format:[format],each(format,function(format){format.deep===undef&&(format.deep=!format.selector),format.split===undef&&(format.split=!format.selector||format.inline),format.remove===undef&&format.selector&&!format.inline&&(format.remove="none"),format.selector&&format.inline&&(format.mixed=!0,format.block_expand=!0),"string"==typeof format.classes&&(format.classes=format.classes.split(/\s+/))}),formats[name]){var current=formats[name];current=current.length?current:[current],formats[name]=current.concat(format)}else formats[name]=format}function unregister(name){return name&&formats[name]&&delete formats[name],formats}function matchesUnInheritedFormatSelector(node,name){var formatList=get(name);if(formatList)for(var i=0;i<formatList.length;i++)if(formatList[i].inherit===!1&&formatList[i].selector&&dom.is(node,formatList[i].selector))return!0;return!1}function getTextDecoration(node){var decoration;return ed.dom.getParent(node,function(n){return decoration=ed.dom.getStyle(n,"text-decoration"),decoration&&"none"!==decoration}),decoration}function processUnderlineAndColor(node){var textDecoration;1===node.nodeType&&node.parentNode&&1===node.parentNode.nodeType&&(textDecoration=getTextDecoration(node.parentNode),ed.dom.getStyle(node,"color")&&textDecoration?ed.dom.setStyle(node,"text-decoration",textDecoration):ed.dom.getStyle(node,"text-decoration")===textDecoration&&ed.dom.setStyle(node,"text-decoration",null))}function apply(name,vars,node){function setElementFormat(elm,fmt){if(fmt=fmt||format,elm){if(each(fmt.styles,function(value,name){dom.setStyle(elm,name,replaceVars(value,vars))}),fmt.styles){var styleVal=dom.serializeStyle(dom.parseStyle(elm.style.cssText),elm.nodeName);styleVal&&elm.setAttribute("data-mce-style",styleVal)}each(fmt.attributes,function(value,name){dom.setAttrib(elm,name,replaceVars(value,vars))}),each(fmt.classes,function(value){value=replaceVars(value,vars),dom.hasClass(elm,value)||dom.addClass(elm,value)}),fmt.onformat&&fmt.onformat(elm,fmt,vars,node)}}function applyNodeStyle(formatList,node){var found=!1;return!!format.selector&&(each(formatList,function(format){if(!("collapsed"in format&&format.collapsed!==isCollapsed))return!dom.is(node,format.selector)||isCaretNode(node)||isBogusBr(node)?void 0:(setElementFormat(node,format),found=!0,!1)}),found)}function adjustSelectionToVisibleSelection(){function findSelectionEnd(start,end){var walker=new TreeWalker(end);for(node=walker.prev2();node;node=walker.prev2()){if(3==node.nodeType&&node.data.length>0)return node;if(node.childNodes.length>1||node==start||"BR"==node.tagName)return node}}var rng=selection.getRng(),start=rng.startContainer,end=rng.endContainer;if(start!=end&&0===rng.endOffset){var newEnd=findSelectionEnd(start,end),endOffset=3==newEnd.nodeType?newEnd.data.length:newEnd.childNodes.length;rng.setEnd(newEnd,endOffset)}return rng}function applyRngStyle(rng,bookmark,node_specific){var wrapName,wrapElm,newWrappers=[],contentEditable=!0;wrapName=format.inline||format.block,wrapElm=dom.create(wrapName),setElementFormat(wrapElm),rangeUtils.walk(rng,function(nodes){function process(node){function isBOM(node){return!node_specific&&3===node.nodeType&&1===node.nodeValue.length&&65279===node.nodeValue.charCodeAt(0)}var nodeName,parentName,found,hasContentEditableState,lastContentEditable;if(!isBogusBr(node)&&!isBookmarkNode(node))return lastContentEditable=contentEditable,nodeName=node.nodeName.toLowerCase(),parentName=node.parentNode.nodeName.toLowerCase(),1===node.nodeType&&getContentEditable(node)&&(lastContentEditable=contentEditable,contentEditable="true"===getContentEditable(node),hasContentEditableState=!isShortEnded(node)),format.wrapper&&matchNode(node,name,vars)?void(currentWrapElm=0):contentEditable&&!hasContentEditableState&&format.block&&!format.wrapper&&isTextBlock(nodeName)&&isValidChild(parentName,wrapName)?(node=dom.rename(node,wrapName),setElementFormat(node),newWrappers.push(node),void(currentWrapElm=0)):format.selector&&(found=applyNodeStyle(formatList,node),!format.inline||found)?void(currentWrapElm=0):void(!contentEditable||hasContentEditableState||!isValidChild(wrapName,nodeName)||!isValidChild(parentName,wrapName)||isBOM(node)||isCaretNode(node)||isBogusBr(node)||isBookmarkNode(node)||format.inline&&isBlock(node)?(currentWrapElm=0,each(tinymce.grep(node.childNodes),process),hasContentEditableState&&(contentEditable=lastContentEditable),currentWrapElm=0):(currentWrapElm||(currentWrapElm=dom.clone(wrapElm,FALSE),node.parentNode.insertBefore(currentWrapElm,node),newWrappers.push(currentWrapElm)),currentWrapElm.appendChild(node)))}var currentWrapElm;each(nodes,process)}),format.links!==!0&&format.wrap_links!==!1||each(newWrappers,function(node){function process(node){"A"===node.nodeName&&setElementFormat(node,format),each(tinymce.grep(node.childNodes),process)}process(node)}),each(newWrappers,function(node){function getChildCount(node){var count=0;return each(node.childNodes,function(node){isWhiteSpaceNode(node)||isBookmarkNode(node)||count++}),count}function getChildElementNode(root){var child=!1;return each(root.childNodes,function(node){if(isElementNode(node))return child=node,!1}),child}function mergeStyles(node){var child,clone;return child=getChildElementNode(node),child&&!isBookmarkNode(child)&&matchName(child,format)&&(clone=dom.clone(child,FALSE),setElementFormat(clone),dom.replace(clone,node,TRUE),dom.remove(child,1)),clone||node}var childCount;if(childCount=getChildCount(node),(newWrappers.length>1||!isBlock(node))&&0===childCount)return void dom.remove(node,1);if(format.inline||format.wrapper){if(format.exact||1!==childCount||(node=mergeStyles(node)),each(formatList,function(format){each(dom.select(format.inline,node),function(child){isBookmarkNode(child)||removeFormat(format,vars,child,format.exact?child:null)})}),matchNode(node.parentNode,name,vars))return dom.remove(node,1),node=0,TRUE;format.merge_with_parents&&dom.getParent(node.parentNode,function(parent){if(matchNode(parent,name,vars))return dom.remove(node,1),node=0,TRUE}),node&&format.merge_siblings!==!1&&(node=mergeSiblings(getNonWhiteSpaceSibling(node),node),node=mergeSiblings(node,getNonWhiteSpaceSibling(node,TRUE)))}})}var bookmark,rng,formatList=get(name),format=formatList[0],isCollapsed=!node&&selection.isCollapsed();if("false"!==getContentEditable(selection.getNode())){if(format)if(node&&node.parentNode)node.nodeType?applyNodeStyle(formatList,node)||(rng=dom.createRng(),rng.setStartBefore(node),rng.setEndAfter(node),applyRngStyle(expandRng(rng,formatList),null,!0)):applyRngStyle(node,null,!0);else if(isCollapsed&&format.inline&&!dom.select("td.mceSelected,th.mceSelected,div.mceSelected").length)performCaretAction("apply",name,vars);else{
var curSelNode=selection.getNode();forcedRootBlock||!formatList[0].defaultBlock||dom.getParent(curSelNode,dom.isBlock)||apply(formatList[0].defaultBlock),selection.setRng(adjustSelectionToVisibleSelection()),bookmark=selection.getBookmark(),applyRngStyle(expandRng(selection.getRng(TRUE),formatList)),format.styles&&(format.styles.color||format.styles.textDecoration)&&(tinymce.walk(curSelNode,processUnderlineAndColor,"childNodes"),processUnderlineAndColor(curSelNode)),selection.moveToBookmark(bookmark),moveStart(selection.getRng(TRUE)),ed.nodeChanged()}}else{node=selection.getNode();for(var i=0,l=formatList.length;i<l;i++)if(formatList[i].ceFalseOverride&&formatList[i].selector&&dom.is(node,formatList[i].selector))return setElementFormat(node,formatList[i]),!0}}function remove(name,vars,node,similar){function process(node){var children,i,l;if(1===node.nodeType&&getContentEditable(node)&&(contentEditable="true"===getContentEditable(node)),children=tinymce.grep(node.childNodes),contentEditable||format.ceFalseOverride||isFigure(node))for(i=0,l=formatList.length;i<l&&!removeFormat(formatList[i],vars,node,node);i++);if(format.deep&&children.length)for(i=0,l=children.length;i<l;i++)process(children[i])}function findFormatRoot(container){var formatRoot;return each(getParents(container.parentNode).reverse(),function(parent){var format;formatRoot||"_start"==parent.id||"_end"==parent.id||(format=matchNode(parent,name,vars,similar),format&&format.split!==!1&&(formatRoot=parent))}),formatRoot}function wrapAndSplit(formatRoot,container,target,split){var parent,clone,lastClone,firstClone,i,formatRootParent;if(formatRoot){for(formatRootParent=formatRoot.parentNode,parent=container.parentNode;parent&&parent!=formatRootParent;parent=parent.parentNode){for(clone=dom.clone(parent,FALSE),i=0;i<formatList.length;i++)if(removeFormat(formatList[i],vars,clone,clone)){clone=0;break}clone&&(lastClone&&clone.appendChild(lastClone),firstClone||(firstClone=clone),lastClone=clone)}!split||format.mixed&&isBlock(formatRoot)||(container=dom.split(formatRoot,container)),lastClone&&(target.parentNode.insertBefore(lastClone,target),firstClone.appendChild(target))}return container}function splitToFormatRoot(container){return wrapAndSplit(findFormatRoot(container),container,container,!0)}function unwrap(start){var node=dom.get(start?"_start":"_end"),out=node[start?"firstChild":"lastChild"];return isBookmarkNode(out)&&(out=out[start?"firstChild":"lastChild"]),3==out.nodeType&&0===out.data.length&&(out=start?node.previousSibling||node.nextSibling:node.nextSibling||node.previousSibling),dom.remove(node,!0),out}function removeRngStyle(rng){var startContainer,endContainer,commonAncestorContainer=rng.commonAncestorContainer;if(rng=expandRng(rng,formatList,TRUE),format.split){if(startContainer=getContainer(rng,TRUE),endContainer=getContainer(rng),startContainer!=endContainer){if(commonAncestorContainer&&/^T(HEAD|BODY|FOOT|R)$/.test(commonAncestorContainer.nodeName)&&/^(TH|TD)$/.test(endContainer.nodeName)&&endContainer.firstChild&&(endContainer=endContainer.firstChild||endContainer),dom.isChildOf(startContainer,endContainer)&&!isBlock(endContainer)&&!isTableCell(startContainer)&&!isTableCell(endContainer))return startContainer=wrap(startContainer,"span",{id:"_start","data-mce-type":"bookmark"}),splitToFormatRoot(startContainer),void(startContainer=unwrap(TRUE));startContainer=wrap(startContainer,"span",{id:"_start","data-mce-type":"bookmark"}),endContainer=wrap(endContainer,"span",{id:"_end","data-mce-type":"bookmark"}),splitToFormatRoot(startContainer),splitToFormatRoot(endContainer),startContainer=unwrap(TRUE),endContainer=unwrap()}else startContainer=endContainer=splitToFormatRoot(startContainer);rng.startContainer=startContainer.parentNode?startContainer.parentNode:startContainer,rng.startOffset=nodeIndex(startContainer),rng.endContainer=endContainer.parentNode?endContainer.parentNode:endContainer,rng.endOffset=nodeIndex(endContainer)+1}rangeUtils.walk(rng,function(nodes){each(nodes,function(node){process(node),1===node.nodeType&&"underline"===ed.dom.getStyle(node,"text-decoration")&&node.parentNode&&"underline"===getTextDecoration(node.parentNode)&&removeFormat({deep:!1,exact:!0,inline:"span",styles:{textDecoration:"underline"}},null,node)})})}var bookmark,rng,formatList=get(name),format=formatList[0],contentEditable=!0;if(node)return void(node.nodeType?(rng=dom.createRng(),rng.setStartBefore(node),rng.setEndAfter(node),removeRngStyle(rng)):removeRngStyle(node));if("false"!==getContentEditable(selection.getNode()))selection.isCollapsed()&&format.inline&&!dom.select("td.mceSelected,th.mceSelected,div.mceSelected").length?performCaretAction("remove",name,vars,similar):(bookmark=selection.getBookmark(),removeRngStyle(selection.getRng(TRUE)),selection.moveToBookmark(bookmark),format.inline&&match(name,vars,selection.getStart())&&moveStart(selection.getRng(!0)),ed.nodeChanged());else{node=selection.getNode();for(var i=0,l=formatList.length;i<l&&(!formatList[i].ceFalseOverride||!removeFormat(formatList[i],vars,node,node));i++);}}function toggle(name,vars,node){var fmt=get(name);!match(name,vars,node)||"toggle"in fmt[0]&&!fmt[0].toggle?apply(name,vars,node):remove(name,vars,node)}function matchNode(node,name,vars,similar){function matchItems(node,format,item_name){var key,value,i,items=format[item_name];if(format.onmatch)return format.onmatch(node,format,item_name);if(items)if(items.length===undef){for(key in items)if(items.hasOwnProperty(key)){if(value="attributes"===item_name?dom.getAttrib(node,key):getStyle(node,key),similar&&!value&&!format.exact)return;if((!similar||format.exact)&&!isEq(value,normalizeStyleValue(replaceVars(items[key],vars),key)))return}}else for(i=0;i<items.length;i++)if("attributes"===item_name?dom.getAttrib(node,items[i]):getStyle(node,items[i]))return format;return format}var format,i,classes,formatList=get(name);if(formatList&&node)for(i=0;i<formatList.length;i++)if(format=formatList[i],matchName(node,format)&&matchItems(node,format,"attributes")&&matchItems(node,format,"styles")){if(classes=format.classes)for(i=0;i<classes.length;i++)if(!dom.hasClass(node,classes[i]))return;return format}}function match(name,vars,node){function matchParents(node){var root=dom.getRoot();return node!==root&&(node=dom.getParent(node,function(node){return!!matchesUnInheritedFormatSelector(node,name)||node.parentNode===root||!!matchNode(node,name,vars,!0)}),matchNode(node,name,vars))}var startNode;return node?matchParents(node):(node=selection.getNode(),matchParents(node)?TRUE:(startNode=selection.getStart(),startNode!=node&&matchParents(startNode)?TRUE:FALSE))}function matchAll(names,vars){var startElement,matchedFormatNames=[],checkedMap={};return startElement=selection.getStart(),dom.getParent(startElement,function(node){var i,name;for(i=0;i<names.length;i++)name=names[i],!checkedMap[name]&&matchNode(node,name,vars)&&(checkedMap[name]=!0,matchedFormatNames.push(name))},dom.getRoot()),matchedFormatNames}function canApply(name){var startNode,parents,i,x,selector,formatList=get(name);if(formatList)for(startNode=selection.getStart(),parents=getParents(startNode),x=formatList.length-1;x>=0;x--){if(selector=formatList[x].selector,!selector||formatList[x].defaultBlock)return TRUE;for(i=parents.length-1;i>=0;i--)if(dom.is(parents[i],selector))return TRUE}return FALSE}function formatChanged(formats,callback,similar){var currentFormats;return formatChangeData||(formatChangeData={},currentFormats={},ed.onNodeChange.addToTop(function(ed,cm,node){var parents=getParents(node),matchedFormats={};parents=tinymce.grep(parents,function(node){return 1==node.nodeType&&!node.getAttribute("data-mce-bogus")}),each(formatChangeData,function(callbacks,format){each(parents,function(node){return matchNode(node,format,{},callbacks.similar)?(currentFormats[format]||(each(callbacks,function(callback){callback(!0,{node:node,format:format,parents:parents})}),currentFormats[format]=callbacks),matchedFormats[format]=callbacks,!1):!matchesUnInheritedFormatSelector(node,format)&&void 0})}),each(currentFormats,function(callbacks,format){matchedFormats[format]||(delete currentFormats[format],each(callbacks,function(callback){callback(!1,{node:node,format:format,parents:parents})}))})})),each(formats.split(","),function(format){formatChangeData[format]||(formatChangeData[format]=[],formatChangeData[format].similar=similar),formatChangeData[format].push(callback)}),this}function matchName(node,format){return isEq(node,format.inline)?TRUE:isEq(node,format.block)?TRUE:format.selector?1==node.nodeType&&dom.is(node,format.selector):void 0}function isEq(str1,str2){return str1=str1||"",str2=str2||"",str1=""+(str1.nodeName||str1),str2=""+(str2.nodeName||str2),str1.toLowerCase()==str2.toLowerCase()}function isElementNode(node){return!(1!=node.nodeType||isBookmarkNode(node)||isWhiteSpaceNode(node)||isCaretNode(node)||isBogusBr(node))}function getStyle(node,name){return normalizeStyleValue(dom.getStyle(node,name),name)}function normalizeStyleValue(value,name){return"color"!=name&&"backgroundColor"!=name||(value=dom.toHex(value)),"fontWeight"==name&&700==value&&(value="bold"),"fontFamily"==name&&(value=value.replace(/[\'\"]/g,"").replace(/,\s+/g,",")),""+value}function replaceVars(value,vars){return"string"!=typeof value?value=value(vars):vars&&(value=value.replace(/%(\w+)/g,function(str,name){return vars[name]||str})),value}function isWhiteSpaceNode(node){return node&&3===node.nodeType&&/^([\t \r\n]+|)$/.test(node.nodeValue)}function wrap(node,name,attrs){var wrapper=dom.create(name,attrs);return node.parentNode.insertBefore(wrapper,node),wrapper.appendChild(node),wrapper}function expandRng(rng,format,remove){function findParentContainer(start){var container,parent,sibling,siblingName,root;if(container=parent=start?startContainer:endContainer,siblingName=start?"previousSibling":"nextSibling",root=dom.getRoot(),3==container.nodeType&&!isWhiteSpaceNode(container)&&(start?startOffset>0:endOffset<container.nodeValue.length))return container;for(;;){if(!format[0].block_expand&&isBlock(parent))return parent;for(sibling=parent[siblingName];sibling;sibling=sibling[siblingName])if(!(isBookmarkNode(sibling)||isWhiteSpaceNode(sibling)||isBogusBr(sibling)||isCaretNode(sibling)))return parent;if(parent==root||parent.parentNode==root){container=parent;break}parent=parent.parentNode}return container}function findLeaf(node,offset){for(offset===undef&&(offset=3===node.nodeType?node.length:node.childNodes.length);node&&node.hasChildNodes();)node=node.childNodes[offset],node&&(offset=3===node.nodeType?node.length:node.childNodes.length);return{node:node,offset:offset}}function findParentContentEditable(node){for(var parent=node;parent;){if(1===parent.nodeType&&getContentEditable(parent))return"false"===getContentEditable(parent)?parent:node;parent=parent.parentNode}return node}function findWordEndPoint(container,offset,start){function findSpace(node,offset){var pos,pos2,str=node.nodeValue;return"undefined"==typeof offset&&(offset=start?str.length:0),start?(pos=str.lastIndexOf(" ",offset),pos2=str.lastIndexOf("\xa0",offset),pos=pos>pos2?pos:pos2,pos===-1||remove||pos++):(pos=str.indexOf(" ",offset),pos2=str.indexOf("\xa0",offset),pos=pos!==-1&&(pos2===-1||pos<pos2)?pos:pos2),pos}var walker,node,pos,lastTextNode;if(3===container.nodeType){if(pos=findSpace(container,offset),pos!==-1)return{container:container,offset:pos};lastTextNode=container}for(walker=new TreeWalker(container,dom.getParent(container,isBlock)||ed.getBody());node=walker[start?"prev":"next"]();)if(3===node.nodeType){if(lastTextNode=node,pos=findSpace(node),pos!==-1)return{container:node,offset:pos}}else if(isBlock(node))break;if(lastTextNode)return offset=start?0:lastTextNode.length,{container:lastTextNode,offset:offset}}function findSelectorEndPoint(container,sibling_name){var parents,i,y,curFormat;for(3==container.nodeType&&0===container.nodeValue.length&&container[sibling_name]&&(container=container[sibling_name]),parents=getParents(container),i=0;i<parents.length;i++)for(y=0;y<format.length;y++)if(curFormat=format[y],!("collapsed"in curFormat&&curFormat.collapsed!==rng.collapsed)&&dom.is(parents[i],curFormat.selector))return parents[i];return container}function findBlockEndPoint(container,sibling_name){var node,root=dom.getRoot();if(format[0].wrapper||(node=dom.getParent(container,format[0].block,root)),node||(node=dom.getParent(3==container.nodeType?container.parentNode:container,function(node){return node!=root&&isTextBlock(node)})),node&&format[0].wrapper&&(node=getParents(node,"ul,ol,dl").reverse()[0]||node),!node)for(node=container;node[sibling_name]&&!isBlock(node[sibling_name])&&(node=node[sibling_name],!isEq(node,"br")););return node||container}var lastIdx,leaf,endPoint,startContainer=rng.startContainer,startOffset=rng.startOffset,endContainer=rng.endContainer,endOffset=rng.endOffset;if(1==startContainer.nodeType&&startContainer.hasChildNodes()&&(lastIdx=startContainer.childNodes.length-1,startContainer=startContainer.childNodes[startOffset>lastIdx?lastIdx:startOffset],startContainer&&3==startContainer.nodeType&&(startOffset=0)),1==endContainer.nodeType&&endContainer.hasChildNodes()&&(lastIdx=endContainer.childNodes.length-1,endContainer=endContainer.childNodes[endOffset>lastIdx?lastIdx:endOffset-1],endContainer&&3==endContainer.nodeType&&(endOffset=endContainer.nodeValue.length)),startContainer=findParentContentEditable(startContainer),endContainer=findParentContentEditable(endContainer),(isBookmarkNode(startContainer.parentNode)||isBookmarkNode(startContainer))&&(startContainer=isBookmarkNode(startContainer)?startContainer:startContainer.parentNode,startContainer=startContainer.nextSibling||startContainer,3==startContainer.nodeType&&(startOffset=0)),(isBookmarkNode(endContainer.parentNode)||isBookmarkNode(endContainer))&&(endContainer=isBookmarkNode(endContainer)?endContainer:endContainer.parentNode,endContainer=endContainer.previousSibling||endContainer,3==endContainer.nodeType&&(endOffset=endContainer.length)),format[0].inline&&(rng.collapsed&&(endPoint=findWordEndPoint(startContainer,startOffset,!0),endPoint&&(startContainer=endPoint.container,startOffset=endPoint.offset),endPoint=findWordEndPoint(endContainer,endOffset),endPoint&&(endContainer=endPoint.container,endOffset=endPoint.offset)),leaf=findLeaf(endContainer,endOffset),leaf.node)){for(;leaf.node&&0===leaf.offset&&leaf.node.previousSibling;)leaf=findLeaf(leaf.node.previousSibling);leaf.node&&leaf.offset>0&&3===leaf.node.nodeType&&" "===leaf.node.nodeValue.charAt(leaf.offset-1)&&leaf.offset>1&&(endContainer=leaf.node,endContainer.splitText(leaf.offset-1))}return(format[0].inline||format[0].block_expand)&&(format[0].inline&&3==startContainer.nodeType&&0!==startOffset||isBlock(startContainer)||(startContainer=findParentContainer(!0)),format[0].inline&&3==endContainer.nodeType&&endOffset!==endContainer.nodeValue.length||isBlock(endContainer)||(endContainer=findParentContainer())),format[0].selector&&format[0].expand!==FALSE&&!format[0].inline&&(startContainer=findSelectorEndPoint(startContainer,"previousSibling"),endContainer=findSelectorEndPoint(endContainer,"nextSibling")),(format[0].block||format[0].selector)&&(startContainer=findBlockEndPoint(startContainer,"previousSibling"),endContainer=findBlockEndPoint(endContainer,"nextSibling"),format[0].block&&(isBlock(startContainer)||(startContainer=findParentContainer(!0)),isBlock(endContainer)||(endContainer=findParentContainer()))),1==startContainer.nodeType&&(startOffset=nodeIndex(startContainer),startContainer=startContainer.parentNode),1==endContainer.nodeType&&(endOffset=nodeIndex(endContainer)+1,endContainer=endContainer.parentNode),{startContainer:startContainer,startOffset:startOffset,endContainer:endContainer,endOffset:endOffset}}function isColorFormatAndAnchor(node,format){return format.links&&"A"==node.tagName}function removeFormat(format,vars,node,compare_node){var i,attrs,stylesModified;if(!matchName(node,format)&&!isColorFormatAndAnchor(node,format))return FALSE;if(format.onremove&&format.onremove(node,format,vars,node),"all"!=format.remove)for(each(format.styles,function(value,name){value=normalizeStyleValue(replaceVars(value,vars),name),"number"==typeof name&&(name=value,compare_node=0),(format.remove_similar||!compare_node||isEq(getStyle(compare_node,name),value))&&dom.setStyle(node,name,""),stylesModified=1}),stylesModified&&""===dom.getAttrib(node,"style")&&(node.removeAttribute("style"),node.removeAttribute("data-mce-style")),each(format.attributes,function(value,name){var valueOut;if(value=replaceVars(value,vars),"number"==typeof name&&(name=value,compare_node=0),!compare_node||isEq(dom.getAttrib(compare_node,name),value)){if("class"==name&&(value=dom.getAttrib(node,name),value&&(valueOut="",each(value.split(/\s+/),function(cls){/mce\w+/.test(cls)&&(valueOut+=(valueOut?" ":"")+cls)}),valueOut)))return void dom.setAttrib(node,name,valueOut);"class"==name&&node.removeAttribute("className"),MCE_ATTR_RE.test(name)&&node.removeAttribute("data-mce-"+name),node.removeAttribute(name)}}),each(format.classes,function(value){value=replaceVars(value,vars),compare_node&&!dom.hasClass(compare_node,value)||dom.removeClass(node,value)}),attrs=dom.getAttribs(node),i=0;i<attrs.length;i++){var attrName=attrs[i].nodeName;if(0!==attrName.indexOf("_")&&0!==attrName.indexOf("data-"))return FALSE}return"none"!=format.remove?(removeNode(node,format),TRUE):void 0}function removeNode(node,format){function find(node,next,inc){return node=getNonWhiteSpaceSibling(node,next,inc),!node||"BR"==node.nodeName||isBlock(node)}var rootBlockElm,parentNode=node.parentNode;format.block&&(forcedRootBlock?parentNode==dom.getRoot()&&(format.list_block&&isEq(node,format.list_block)||each(tinymce.grep(node.childNodes),function(node){isValidChild(forcedRootBlock,node.nodeName.toLowerCase())?rootBlockElm?rootBlockElm.appendChild(node):(rootBlockElm=wrap(node,forcedRootBlock),dom.setAttribs(rootBlockElm,ed.settings.forced_root_block_attrs)):rootBlockElm=0})):isBlock(node)&&!isBlock(parentNode)&&(find(node,FALSE)||find(node.firstChild,TRUE,1)||node.insertBefore(dom.create("br"),node.firstChild),find(node,TRUE)||find(node.lastChild,FALSE,1)||node.appendChild(dom.create("br")))),format.selector&&format.inline&&!isEq(format.inline,node)||dom.remove(node,1)}function getNonWhiteSpaceSibling(node,next,inc){if(node)for(next=next?"nextSibling":"previousSibling",node=inc?node:node[next];node;node=node[next])if(1==node.nodeType||!isWhiteSpaceNode(node))return node}function isBookmarkNode(node){return node&&1==node.nodeType&&"bookmark"==node.getAttribute("data-mce-type")}function mergeSiblings(prev,next){function compareElements(node1,node2){function getAttribs(node){var attribs={};return each(dom.getAttribs(node),function(attr){var name=attr.nodeName.toLowerCase();0!==name.indexOf("_")&&"style"!==name&&(attribs[name]=dom.getAttrib(node,name))}),attribs}function compareObjects(obj1,obj2){var value,name;for(name in obj1)if(obj1.hasOwnProperty(name)){if(value=obj2[name],value===undef)return FALSE;if(obj1[name]!=value)return FALSE;delete obj2[name]}for(name in obj2)if(obj2.hasOwnProperty(name))return FALSE;return TRUE}return node1.nodeName!=node2.nodeName?FALSE:compareObjects(getAttribs(node1),getAttribs(node2))&&compareObjects(dom.parseStyle(dom.getAttrib(node1,"style")),dom.parseStyle(dom.getAttrib(node2,"style")))?TRUE:FALSE}function findElementSibling(node,sibling_name){for(sibling=node;sibling;sibling=sibling[sibling_name]){if(3==sibling.nodeType&&0!==sibling.nodeValue.length)return node;if(1==sibling.nodeType&&!isBookmarkNode(sibling))return sibling}return node}var sibling,tmpSibling;if(prev&&next&&(prev=findElementSibling(prev,"previousSibling"),next=findElementSibling(next,"nextSibling"),compareElements(prev,next))){for(sibling=prev.nextSibling;sibling&&sibling!=next;)tmpSibling=sibling,sibling=sibling.nextSibling,prev.appendChild(tmpSibling);return dom.remove(next),each(tinymce.grep(next.childNodes),function(node){prev.appendChild(node)}),prev}return next}function getContainer(rng,start){var container,offset,lastIdx;return container=rng[start?"startContainer":"endContainer"],offset=rng[start?"startOffset":"endOffset"],1==container.nodeType&&(lastIdx=container.childNodes.length-1,!start&&offset&&offset--,container=container.childNodes[offset>lastIdx?lastIdx:offset]),3===container.nodeType&&start&&offset>=container.nodeValue.length&&(container=new TreeWalker(container,ed.getBody()).next()||container),3!==container.nodeType||start||0!==offset||(container=new TreeWalker(container,ed.getBody()).prev()||container),container}function performCaretAction(type,name,vars,similar){function createCaretContainer(fill){var caretContainer=dom.create("span",{id:caretContainerId,"data-mce-bogus":!0,style:debug?"color:red":""});return fill&&caretContainer.appendChild(ed.getDoc().createTextNode(INVISIBLE_CHAR)),caretContainer}function isCaretContainerEmpty(node,nodes){for(;node;){if(3===node.nodeType&&node.nodeValue!==INVISIBLE_CHAR||node.childNodes.length>1)return!1;nodes&&1===node.nodeType&&nodes.push(node),node=node.firstChild}return!0}function getParentCaretContainer(node){for(;node;){if(node.id===caretContainerId)return node;node=node.parentNode}}function findFirstTextNode(node){var walker;if(node)for(walker=new TreeWalker(node,node),node=walker.current();node;node=walker.next())if(3===node.nodeType)return node}function removeCaretContainer(node,move_caret){var child,rng;if(node)rng=selection.getRng(!0),isCaretContainerEmpty(node)?(move_caret!==!1&&(rng.setStartBefore(node),rng.setEndBefore(node)),dom.remove(node)):(child=findFirstTextNode(node),child.nodeValue.charAt(0)===INVISIBLE_CHAR&&(child.deleteData(0,1),rng.startContainer==child&&rng.startOffset>0&&rng.setStart(child,rng.startOffset-1),rng.endContainer==child&&rng.endOffset>0&&rng.setEnd(child,rng.endOffset-1)),dom.remove(node,1)),selection.setRng(rng);else if(node=getParentCaretContainer(selection.getStart()),!node)for(;node=dom.get(caretContainerId);)removeCaretContainer(node,!1)}function applyCaretFormat(){var rng,caretContainer,textNode,offset,bookmark,container,text;rng=selection.getRng(!0),offset=rng.startOffset,container=rng.startContainer,text=container.nodeValue,caretContainer=getParentCaretContainer(selection.getStart()),caretContainer&&(textNode=findFirstTextNode(caretContainer)),text&&offset>0&&offset<text.length&&/\w/.test(text.charAt(offset))&&/\w/.test(text.charAt(offset-1))?(bookmark=selection.getBookmark(),rng.collapse(!0),rng=expandRng(rng,get(name)),rng=rangeUtils.split(rng),apply(name,vars,rng),selection.moveToBookmark(bookmark)):(caretContainer&&textNode.nodeValue===INVISIBLE_CHAR?apply(name,vars,caretContainer):(caretContainer=createCaretContainer(!0),textNode=caretContainer.firstChild,rng.insertNode(caretContainer),offset=1,apply(name,vars,caretContainer)),selection.setCursorLocation(textNode,offset))}function removeCaretFormat(){var container,offset,bookmark,hasContentAfter,node,formatNode,i,caretContainer,rng=selection.getRng(!0),parents=[];for(container=rng.startContainer,offset=rng.startOffset,node=container,3==container.nodeType&&(offset!=container.nodeValue.length&&(hasContentAfter=!0),node=node.parentNode);node;){if(matchNode(node,name,vars,similar)){formatNode=node;break}node.nextSibling&&(hasContentAfter=!0),parents.push(node),node=node.parentNode}if(formatNode)if(hasContentAfter)bookmark=selection.getBookmark(),rng.collapse(!0),rng=expandRng(rng,get(name),!0),rng=rangeUtils.split(rng),remove(name,vars,rng),selection.moveToBookmark(bookmark);else{for(caretContainer=createCaretContainer(),node=caretContainer,i=parents.length-1;i>=0;i--)node.appendChild(dom.clone(parents[i],!1)),node=node.firstChild;node.appendChild(dom.doc.createTextNode(INVISIBLE_CHAR)),node=node.firstChild;var block=dom.getParent(formatNode,isTextBlock);block&&dom.isEmpty(block)?formatNode.parentNode.replaceChild(caretContainer,formatNode):dom.insertAfter(caretContainer,formatNode),selection.setCursorLocation(node,1),dom.isEmpty(formatNode)&&dom.remove(formatNode)}}function unmarkBogusCaretParents(){var caretContainer;caretContainer=getParentCaretContainer(selection.getStart()),caretContainer&&!dom.isEmpty(caretContainer)&&tinymce.walk(caretContainer,function(node){1!=node.nodeType||node.id===caretContainerId||dom.isEmpty(node)||dom.setAttrib(node,"data-mce-bogus",null)},"childNodes")}var caretContainerId="_mce_caret",debug=ed.settings.caret_debug;ed._hasCaretEvents||(ed.onBeforeGetContent.addToTop(function(){var i,nodes=[];if(isCaretContainerEmpty(getParentCaretContainer(selection.getStart()),nodes))for(i=nodes.length;i--;)dom.setAttrib(nodes[i],"data-mce-bogus","1")}),tinymce.each("onMouseUp onKeyUp".split(" "),function(name){ed[name].addToTop(function(){removeCaretContainer(),unmarkBogusCaretParents()})}),ed.onKeyDown.addToTop(function(ed,e){var keyCode=e.keyCode;(8==keyCode&&selection.isCollapsed()||37==keyCode||39==keyCode)&&removeCaretContainer(getParentCaretContainer(selection.getStart())),unmarkBogusCaretParents()}),selection.onSetContent.add(unmarkBogusCaretParents),ed._hasCaretEvents=!0),"apply"==type?applyCaretFormat():removeCaretFormat()}function moveStart(rng){var isAtEndOfText,walker,node,nodes,container=rng.startContainer,offset=rng.startOffset;if((rng.startContainer!=rng.endContainer||!isInlineBlock(rng.startContainer.childNodes[rng.startOffset]))&&(3==container.nodeType&&offset>=container.nodeValue.length&&(offset=nodeIndex(container),container=container.parentNode,isAtEndOfText=!0),1==container.nodeType))for(nodes=container.childNodes,container=nodes[Math.min(offset,nodes.length-1)],walker=new TreeWalker(container,dom.getParent(container,dom.isBlock)),(offset>nodes.length-1||isAtEndOfText)&&walker.next(),node=walker.current();node;node=walker.next())if(3==node.nodeType&&!isWhiteSpaceNode(node))return rng.setStart(node,0),void selection.setRng(rng)}var formatChangeData,undef,formats={},each=tinymce.each,dom=ed.dom,selection=ed.selection,TreeWalker=tinymce.dom.TreeWalker,rangeUtils=new tinymce.dom.RangeUtils(dom),isValidChild=ed.schema.isValidChild,isBlock=dom.isBlock,forcedRootBlock=ed.settings.forced_root_block,nodeIndex=dom.nodeIndex,INVISIBLE_CHAR="\ufeff",MCE_ATTR_RE=/^(src|href|style)$/,FALSE=!1,TRUE=!0,getContentEditable=dom.getContentEditable;tinymce.extend(this,{get:get,register:register,unregister:unregister,apply:apply,remove:remove,toggle:toggle,match:match,matchAll:matchAll,matchNode:matchNode,canApply:canApply,formatChanged:formatChanged}),defaultFormats(),addKeyboardShortcuts()}}(tinymce),tinymce.onAddEditor.add(function(tinymce,ed){function replaceWithSpan(node,styles){tinymce.each(styles,function(value,name){value&&dom.setStyle(node,name,value)}),dom.rename(node,"span")}function convert(editor,params){dom=editor.dom,settings.convert_fonts_to_spans&&tinymce.each(dom.select("font,u,strike",params.node),function(node){filters[node.nodeName.toLowerCase()](ed.dom,node)})}var filters,fontSizes,dom,settings=ed.settings;settings.inline_styles&&(fontSizes=tinymce.explode(settings.font_size_legacy_values),filters={font:function(dom,node){replaceWithSpan(node,{backgroundColor:node.style.backgroundColor,color:node.color,fontFamily:node.face,fontSize:fontSizes[parseInt(node.size,10)-1]})},u:function(dom,node){replaceWithSpan(node,{textDecoration:"underline"})},strike:function(dom,node){replaceWithSpan(node,{textDecoration:"line-through"})}},ed.onPreProcess.add(convert),ed.onSetContent.add(convert),ed.onInit.add(function(){ed.selection.onSetContent.add(convert)}))}),function(tinymce){var TreeWalker=tinymce.dom.TreeWalker,RangeUtils=tinymce.dom.RangeUtils;tinymce.EnterKey=function(editor){function handleEnterKey(evt){function canSplitBlock(node){return node&&dom.isBlock(node)&&!/^(TD|TH|CAPTION|FORM)$/.test(node.nodeName)&&!/^(fixed|absolute)/i.test(node.style.position)&&"true"!==dom.getContentEditable(node)&&!node.hasAttribute("data-mce-type")}function isTableCell(node){return node&&/^(TD|TH|CAPTION)$/.test(node.nodeName)}function isBogus(node){return!!node&&1===node.nodeType&&node.hasAttribute("data-mce-bogus")}function trimBogusBr(elm){var brs=elm.getElementsByTagName("br"),lastBr=brs[brs.length-1];isBogus(lastBr)&&lastBr.parentNode.removeChild(lastBr)}function isCaretContainerBlock(node){return node&&3===node.nodeType&&(node=node.parentNode),!!node&&1===node.nodeType&&node.hasAttribute("data-mce-caret")}function showCaretContainerBlock(caretContainer){return caretContainer&&caretContainer.hasAttribute("data-mce-caret")?(trimBogusBr(caretContainer),caretContainer.removeAttribute("data-mce-caret"),caretContainer.removeAttribute("data-mce-bogus"),caretContainer.removeAttribute("style"),caretContainer.removeAttribute("_moz_abspos"),caretContainer):null}function renderBlockOnIE(block){var oldRng;dom.isBlock(block)&&(oldRng=selection.getRng(),block.appendChild(dom.create("span",null,"\xa0")),selection.select(block),block.lastChild.outerHTML="",selection.setRng(oldRng))}function trimInlineElementsOnLeftSideOfBlock(block){var i,node=block,firstChilds=[];if(node){for(;node=node.firstChild;){if(dom.isBlock(node))return;1!=node.nodeType||nonEmptyElementsMap[node.nodeName.toLowerCase()]||firstChilds.push(node)}for(i=firstChilds.length;i--;)node=firstChilds[i],!node.hasChildNodes()||node.firstChild==node.lastChild&&""===node.firstChild.nodeValue?dom.remove(node):"A"==node.nodeName&&" "===(node.innerText||node.textContent)&&dom.remove(node)}}function moveToCaretPosition(root){function firstNonWhiteSpaceNodeSibling(node){for(;node;){if(1==node.nodeType||3==node.nodeType&&node.data&&/[\r\n\s]/.test(node.data))return node;node=node.nextSibling}}var walker,node,rng,tempElm,lastNode=root;if(root){if(isIE&&parentBlock&&parentBlock.firstChild&&parentBlock.firstChild==parentBlock.lastChild&&"BR"==parentBlock.firstChild.tagName&&dom.remove(parentBlock.firstChild),/^(LI|DT|DD)$/.test(root.nodeName)){var firstChild=firstNonWhiteSpaceNodeSibling(root.firstChild);firstChild&&/^(UL|OL|DL)$/.test(firstChild.nodeName)&&root.insertBefore(dom.doc.createTextNode("\xa0"),root.firstChild)}if(rng=dom.createRng(),isIE||root.normalize(),root.hasChildNodes()){for(walker=new TreeWalker(root,root);node=walker.current();){if(3==node.nodeType){rng.setStart(node,0),rng.setEnd(node,0);break}if(moveCaretBeforeOnEnterElementsMap[node.nodeName.toLowerCase()]){rng.setStartBefore(node),rng.setEndBefore(node);break}lastNode=node,node=walker.next()}node||(rng.setStart(lastNode,0),rng.setEnd(lastNode,0))}else"BR"==root.nodeName?root.nextSibling&&dom.isBlock(root.nextSibling)?((!documentMode||documentMode<9)&&(tempElm=dom.create("br"),root.parentNode.insertBefore(tempElm,root)),rng.setStartBefore(root),rng.setEndBefore(root)):(rng.setStartAfter(root),rng.setEndAfter(root)):(rng.setStart(root,0),rng.setEnd(root,0));selection.setRng(rng),dom.remove(tempElm),selection.scrollIntoView(root)}}function setForcedBlockAttrs(node){var forcedRootBlockName=settings.forced_root_block;forcedRootBlockName&&forcedRootBlockName.toLowerCase()===node.tagName.toLowerCase()&&dom.setAttribs(node,settings.forced_root_block_attrs)}function emptyBlock(elm){elm.innerHTML=isIE?"":'<br data-mce-bogus="1">'}function createNewBlock(name){var block,clonedNode,caretNode,node=container,textInlineElements=schema.getTextInlineElements();if(name||"TABLE"==parentBlockName?(block=dom.create(name||newBlockName),setForcedBlockAttrs(block)):block=settings.keep_attributes?parentBlock.cloneNode(!1):dom.create(parentBlock.nodeName),caretNode=block,settings.keep_styles!==!1)do if(textInlineElements[node.nodeName]){if("_mce_caret"==node.id)continue;clonedNode=node.cloneNode(!1),dom.setAttrib(clonedNode,"id",""),block.hasChildNodes()?(clonedNode.appendChild(block.firstChild),block.appendChild(clonedNode)):(caretNode=clonedNode,block.appendChild(clonedNode))}while(node=node.parentNode);return isIE||(caretNode.innerHTML='<br data-mce-bogus="1">'),block}function isCaretAtStartOrEndOfBlock(start){
var walker,node,name;if(3==container.nodeType&&(start?offset>0:offset<container.nodeValue.length))return!1;if(container.parentNode==parentBlock&&isAfterLastNodeInContainer&&!start)return!0;if(start&&1==container.nodeType&&container==parentBlock.firstChild)return!0;if("TABLE"===container.nodeName||container.previousSibling&&"TABLE"==container.previousSibling.nodeName)return isAfterLastNodeInContainer&&!start||!isAfterLastNodeInContainer&&start;for(walker=new TreeWalker(container,parentBlock),3==container.nodeType&&(start&&0===offset?walker.prev():start||offset!=container.nodeValue.length||walker.next());node=walker.current();){if(1===node.nodeType){if(!node.getAttribute("data-mce-bogus")&&(name=node.nodeName.toLowerCase(),nonEmptyElementsMap[name]&&"br"!==name))return!1}else if(3===node.nodeType&&!/^[ \t\r\n]*$/.test(node.nodeValue))return!1;start?walker.prev():walker.next()}return!0}function wrapSelfAndSiblingsInDefaultBlock(container,offset){var newBlock,parentBlock,startNode,node,next,rootBlockName,blockName=newBlockName||"P";if(parentBlock=dom.getParent(container,dom.isBlock),!parentBlock||!canSplitBlock(parentBlock)){if(parentBlock=parentBlock||editableRoot,rootBlockName=parentBlock==editableRoot||isTableCell(parentBlock)?parentBlock.nodeName.toLowerCase():parentBlock.parentNode.nodeName.toLowerCase(),!parentBlock.hasChildNodes())return newBlock=dom.create(blockName),setForcedBlockAttrs(newBlock),parentBlock.appendChild(newBlock),rng.setStart(newBlock,0),rng.setEnd(newBlock,0),newBlock;for(node=container;node.parentNode!=parentBlock;)node=node.parentNode;for(;node&&!dom.isBlock(node);)startNode=node,node=node.previousSibling;if(startNode&&schema.isValidChild(rootBlockName,blockName.toLowerCase())){for(newBlock=dom.create(blockName),setForcedBlockAttrs(newBlock),startNode.parentNode.insertBefore(newBlock,startNode),node=startNode;node&&!dom.isBlock(node);)next=node.nextSibling,newBlock.appendChild(node),node=next;rng.setStart(container,offset),rng.setEnd(container,offset)}}return container}function handleEmptyListItem(){function isFirstOrLastLi(first){for(var node=containerBlock[first?"firstChild":"lastChild"];node&&1!=node.nodeType;)node=node[first?"nextSibling":"previousSibling"];return node===parentBlock}function getContainerBlock(){var containerBlockParent=containerBlock.parentNode;return/^(LI|DT|DD)$/.test(containerBlockParent.nodeName)?containerBlockParent:containerBlock}if(containerBlock!=editor.getBody()){var containerBlockParentName=containerBlock.parentNode.nodeName;/^(OL|UL|LI)$/.test(containerBlockParentName)&&(newBlockName="LI"),newBlock=newBlockName?createNewBlock(newBlockName):dom.create("BR"),isFirstOrLastLi(!0)&&isFirstOrLastLi()?"LI"==containerBlockParentName?dom.insertAfter(newBlock,getContainerBlock()):dom.replace(newBlock,containerBlock):isFirstOrLastLi(!0)?"LI"==containerBlockParentName?(dom.insertAfter(newBlock,getContainerBlock()),newBlock.appendChild(dom.doc.createTextNode(" ")),newBlock.appendChild(containerBlock)):containerBlock.parentNode.insertBefore(newBlock,containerBlock):isFirstOrLastLi()?(dom.insertAfter(newBlock,getContainerBlock()),renderBlockOnIE(newBlock)):(containerBlock=getContainerBlock(),tmpRng=rng.cloneRange(),tmpRng.setStartAfter(parentBlock),tmpRng.setEndAfter(containerBlock),fragment=tmpRng.extractContents(),"LI"==newBlockName&&"LI"==fragment.firstChild.nodeName?(newBlock=fragment.firstChild,dom.insertAfter(fragment,containerBlock)):(dom.insertAfter(fragment,containerBlock),dom.insertAfter(newBlock,containerBlock))),dom.remove(parentBlock),moveToCaretPosition(newBlock),undoManager.add()}}function insertBr(){editor.execCommand("InsertLineBreak",!1,evt)}function trimLeadingLineBreaks(node){do 3===node.nodeType&&(node.nodeValue=node.nodeValue.replace(/^[\r\n]+/,"")),node=node.firstChild;while(node)}function getEditableRoot(node){var parent,editableRoot,root=dom.getRoot();for(root=dom.get(editor.settings.editable_root)||root,parent=node;parent&&parent!==root&&"false"!==dom.getContentEditable(parent);)"true"===dom.getContentEditable(parent)&&(editableRoot=parent),parent=parent.parentNode;return parent!==root?editableRoot:root}function addBrToBlockIfNeeded(block){var lastChild;isIE||(block.normalize(),lastChild=block.lastChild,lastChild&&!/^(left|right)$/gi.test(dom.getStyle(lastChild,"float",!0))||dom.add(block,"br"))}function insertNewBlockAfter(){newBlock=/^(H[1-6]|PRE|FIGURE)$/.test(parentBlockName)&&"HGROUP"!=containerBlockName?createNewBlock(newBlockName):createNewBlock(),settings.end_container_on_empty_block&&canSplitBlock(containerBlock)&&dom.isEmpty(parentBlock)?newBlock=dom.split(containerBlock,parentBlock):dom.insertAfter(newBlock,parentBlock),moveToCaretPosition(newBlock)}var tmpRng,editableRoot,container,offset,parentBlock,documentMode,shiftKey,newBlock,fragment,containerBlock,parentBlockName,containerBlockName,newBlockName,isAfterLastNodeInContainer,rng=selection.getRng(!0);if(rng=selection.getRng(!0),!evt.isDefaultPrevented()){if(!rng.collapsed)return void editor.execCommand("Delete");if(new RangeUtils(dom).normalize(rng),container=rng.startContainer,offset=rng.startOffset,newBlockName=settings.forced_root_block||"p",settings.force_block_newlines===!1&&(newBlockName=""),newBlockName=newBlockName?newBlockName.toUpperCase():"",documentMode=dom.doc.documentMode,shiftKey=evt.shiftKey,1==container.nodeType&&container.hasChildNodes()&&(isAfterLastNodeInContainer=offset>container.childNodes.length-1,container=container.childNodes[Math.min(offset,container.childNodes.length-1)]||container,offset=isAfterLastNodeInContainer&&3==container.nodeType?container.nodeValue.length:0),editableRoot=getEditableRoot(container)){if(undoManager.beforeChange(),(newBlockName&&!shiftKey||!newBlockName&&shiftKey)&&(container=wrapSelfAndSiblingsInDefaultBlock(container,offset)),parentBlock=dom.getParent(container,dom.isBlock),containerBlock=parentBlock?dom.getParent(parentBlock.parentNode,dom.isBlock):null,parentBlockName=parentBlock?parentBlock.nodeName.toUpperCase():"",containerBlockName=containerBlock?containerBlock.nodeName.toUpperCase():"","LI"!=containerBlockName||evt.ctrlKey||(parentBlock=containerBlock,parentBlockName=containerBlockName),/^(LI|DT|DD)$/.test(parentBlockName)){if(!newBlockName&&shiftKey)return void insertBr();if(dom.isEmpty(parentBlock))return void handleEmptyListItem()}if("PRE"==parentBlockName&&settings.br_in_pre!==!1){if(!shiftKey)return void insertBr()}else if(!newBlockName&&!shiftKey&&"LI"!=parentBlockName||newBlockName&&shiftKey)return void insertBr();newBlockName&&parentBlock===editor.getBody()||(newBlockName=newBlockName||"P",isCaretContainerBlock(parentBlock)?(newBlock=showCaretContainerBlock(parentBlock),dom.isEmpty(parentBlock)&&emptyBlock(parentBlock),moveToCaretPosition(newBlock)):isCaretAtStartOrEndOfBlock()?insertNewBlockAfter():isCaretAtStartOrEndOfBlock(!0)?(newBlock=parentBlock.parentNode.insertBefore(createNewBlock(),parentBlock),renderBlockOnIE(newBlock),moveToCaretPosition(parentBlock)):(tmpRng=rng.cloneRange(),tmpRng.setEndAfter(parentBlock),fragment=tmpRng.extractContents(),trimLeadingLineBreaks(fragment),newBlock=fragment.firstChild,dom.insertAfter(fragment,parentBlock),trimInlineElementsOnLeftSideOfBlock(newBlock),addBrToBlockIfNeeded(parentBlock),dom.isEmpty(parentBlock)&&emptyBlock(parentBlock),!newBlock||dom.isEmpty(newBlock)?(dom.remove(newBlock),insertNewBlockAfter()):moveToCaretPosition(newBlock),newBlock.normalize()),dom.setAttrib(newBlock,"id",""),editor.onNewBlock.dispatch(editor,newBlock),undoManager.add())}}}var dom=editor.dom,selection=editor.selection,settings=editor.settings,undoManager=editor.undoManager,schema=editor.schema,nonEmptyElementsMap=schema.getNonEmptyElements(),moveCaretBeforeOnEnterElementsMap=schema.getMoveCaretBeforeOnEnterElements(),isIE=tinymce.isIE&&tinymce.isIE<11;editor.onNewBlock=new tinymce.util.Dispatcher,editor.onKeyDown.add(function(ed,evt){13==evt.keyCode&&handleEnterKey(evt)!==!1&&evt.preventDefault()})}}(tinymce),function(tinymce){function getVisualCaretPosition(walkFn,caretPosition){for(;caretPosition=walkFn(caretPosition);)if(caretPosition.isVisible())return caretPosition;return caretPosition}function setEditorTimeout(editor,callback,time){return setTimeout(function(){editor.removed||callback()},time)}var CaretWalker=tinymce.caret.CaretWalker,CaretPosition=tinymce.caret.CaretPosition,CaretContainer=tinymce.caret.CaretContainer,CaretUtils=tinymce.caret.CaretUtils,CaretContainerRemove=tinymce.caret.CaretContainerRemove,FakeCaret=tinymce.caret.FakeCaret,LineWalker=tinymce.caret.LineWalker,LineUtils=tinymce.caret.LineUtils,NodeType=tinymce.dom.NodeType,RangeUtils=tinymce.dom.RangeUtils,VK=tinymce.VK,Fun=tinymce.util.Fun,Arr=tinymce.util.Arr,Dispatcher=tinymce.util.Dispatcher,curry=Fun.curry,isContentEditableTrue=NodeType.isContentEditableTrue,isContentEditableFalse=NodeType.isContentEditableFalse,isElement=NodeType.isElement,isAfterContentEditableFalse=CaretUtils.isAfterContentEditableFalse,isBeforeContentEditableFalse=CaretUtils.isBeforeContentEditableFalse,getSelectedNode=RangeUtils.getSelectedNode;tinymce.SelectionOverrides=function(editor){function isFakeSelectionElement(elm){return editor.dom.hasClass(elm,"mce-offscreen-selection")}function getRealSelectionElement(){var container=editor.dom.get(realSelectionId);return container?container.getElementsByTagName("*")[0]:container}function isBlock(node){return editor.dom.isBlock(node)}function setRange(range){range&&editor.selection.setRng(range)}function getRange(){return editor.selection.getRng()}function scrollIntoView(node,alignToTop){editor.selection.scrollIntoView(node,alignToTop)}function showCaret(direction,node,before){var evt={target:node,direction:direction,before:before};return editor.onShowCaret.dispatch(editor,evt),evt.target?(scrollIntoView(node,direction===-1),fakeCaret.show(before,node)):null}function selectNode(node){var evt={target:node};return editor.onBeforeObjectSelected.dispatch(editor,evt),evt.target?getNodeRange(node):null}function getNodeRange(node){var rng=node.ownerDocument.createRange();return rng.selectNode(node),rng}function isMoveInsideSameBlock(fromCaretPosition,toCaretPosition){var inSameBlock=CaretUtils.isInSameBlock(fromCaretPosition,toCaretPosition);return!(inSameBlock||!NodeType.isBr(fromCaretPosition.getNode()))||inSameBlock}function getNormalizedRangeEndPoint(direction,range){return range=CaretUtils.normalizeRange(direction,rootNode,range),direction==-1?CaretPosition.fromRangeStart(range):CaretPosition.fromRangeEnd(range)}function isRangeInCaretContainerBlock(range){return CaretContainer.isCaretContainerBlock(range.startContainer)}function moveToCeFalseHorizontally(direction,getNextPosFn,isBeforeContentEditableFalseFn,range){var node,caretPosition,peekCaretPosition,rangeIsInContainerBlock;return!range.collapsed&&(node=getSelectedNode(range),isContentEditableFalse(node))?showCaret(direction,node,direction==-1):(rangeIsInContainerBlock=isRangeInCaretContainerBlock(range),caretPosition=getNormalizedRangeEndPoint(direction,range),isBeforeContentEditableFalseFn(caretPosition)?selectNode(caretPosition.getNode(direction==-1)):(caretPosition=getNextPosFn(caretPosition))?isBeforeContentEditableFalseFn(caretPosition)?showCaret(direction,caretPosition.getNode(direction==-1),1==direction):(peekCaretPosition=getNextPosFn(caretPosition),isBeforeContentEditableFalseFn(peekCaretPosition)&&isMoveInsideSameBlock(caretPosition,peekCaretPosition)?showCaret(direction,peekCaretPosition.getNode(direction==-1),1==direction):rangeIsInContainerBlock?renderRangeCaret(caretPosition.toRange()):null):rangeIsInContainerBlock?range:null)}function moveToCeFalseVertically(direction,walkerFn,range){var caretPosition,linePositions,nextLinePositions,closestNextLineRect,caretClientRect,clientX,dist1,dist2,contentEditableFalseNode;if(contentEditableFalseNode=getSelectedNode(range),caretPosition=getNormalizedRangeEndPoint(direction,range),linePositions=walkerFn(rootNode,LineWalker.isAboveLine(1),caretPosition),nextLinePositions=Arr.filter(linePositions,LineWalker.isLine(1)),caretClientRect=Arr.last(caretPosition.getClientRects()),isBeforeContentEditableFalse(caretPosition)&&(contentEditableFalseNode=caretPosition.getNode()),isAfterContentEditableFalse(caretPosition)&&(contentEditableFalseNode=caretPosition.getNode(!0)),!caretClientRect)return null;if(clientX=caretClientRect.left,closestNextLineRect=LineUtils.findClosestClientRect(nextLinePositions,clientX),closestNextLineRect&&isContentEditableFalse(closestNextLineRect.node))return dist1=Math.abs(clientX-closestNextLineRect.left),dist2=Math.abs(clientX-closestNextLineRect.right),showCaret(direction,closestNextLineRect.node,dist1<dist2);if(contentEditableFalseNode){var caretPositions=LineWalker.positionsUntil(direction,rootNode,LineWalker.isAboveLine(1),contentEditableFalseNode);if(closestNextLineRect=LineUtils.findClosestClientRect(Arr.filter(caretPositions,LineWalker.isLine(1)),clientX))return renderRangeCaret(closestNextLineRect.position.toRange());if(closestNextLineRect=Arr.last(Arr.filter(caretPositions,LineWalker.isLine(0))))return renderRangeCaret(closestNextLineRect.position.toRange())}}function exitPreBlock(direction,range){function createTextBlock(){var textBlock=editor.dom.create(editor.settings.forced_root_block);return textBlock.innerHTML='<br data-mce-bogus="1">',textBlock}var pre,caretPos,newBlock;if(range.collapsed&&editor.settings.forced_root_block){if(pre=editor.dom.getParent(range.startContainer,"PRE"),!pre)return;caretPos=1==direction?getNextVisualCaretPosition(CaretPosition.fromRangeStart(range)):getPrevVisualCaretPosition(CaretPosition.fromRangeStart(range)),caretPos||(newBlock=createTextBlock(),1==direction?editor.dom.insertAfter(newBlock,pre):editor.dom.insertBefore(newBlock,pre),editor.selection.select(newBlock,!0),editor.selection.collapse())}}function moveH(direction,getNextPosFn,isBeforeContentEditableFalseFn,range){var newRange;return(newRange=moveToCeFalseHorizontally(direction,getNextPosFn,isBeforeContentEditableFalseFn,range))?newRange:(newRange=exitPreBlock(direction,range),newRange?newRange:null)}function moveV(direction,walkerFn,range){var newRange;return(newRange=moveToCeFalseVertically(direction,walkerFn,range))?newRange:(newRange=exitPreBlock(direction,range),newRange?newRange:null)}function getBlockCaretContainer(){return editor.dom.select("*[data-mce-caret]")[0]}function showBlockCaretContainer(blockCaretContainer){blockCaretContainer.hasAttribute("data-mce-caret")&&(CaretContainer.showCaretContainerBlock(blockCaretContainer),setRange(getRange()),scrollIntoView(blockCaretContainer[0]))}function renderCaretAtRange(range){var caretPosition,ceRoot;return range=CaretUtils.normalizeRange(1,rootNode,range),caretPosition=CaretPosition.fromRangeStart(range),isContentEditableFalse(caretPosition.getNode())?showCaret(1,caretPosition.getNode(),!caretPosition.isAtEnd()):isContentEditableFalse(caretPosition.getNode(!0))?showCaret(1,caretPosition.getNode(!0),!1):(ceRoot=editor.dom.getParent(caretPosition.getNode(),Fun.or(isContentEditableFalse,isContentEditableTrue)),isContentEditableFalse(ceRoot)?showCaret(1,ceRoot,!1):null)}function renderRangeCaret(range){var caretRange;return range&&range.collapsed?(caretRange=renderCaretAtRange(range),caretRange?caretRange:range):range}function deleteContentEditableNode(node){var nextCaretPosition,prevCaretPosition,prevCeFalseElm,nextElement;return isContentEditableFalse(node)?(isContentEditableFalse(node.previousSibling)&&(prevCeFalseElm=node.previousSibling),prevCaretPosition=getPrevVisualCaretPosition(CaretPosition.before(node)),prevCaretPosition||(nextCaretPosition=getNextVisualCaretPosition(CaretPosition.after(node))),nextCaretPosition&&isElement(nextCaretPosition.getNode())&&(nextElement=nextCaretPosition.getNode()),CaretContainerRemove.remove(node.previousSibling),CaretContainerRemove.remove(node.nextSibling),editor.dom.remove(node),editor.dom.isEmpty(editor.getBody())?(editor.setContent(""),void editor.focus()):prevCeFalseElm?CaretPosition.after(prevCeFalseElm).toRange():nextElement?CaretPosition.before(nextElement).toRange():prevCaretPosition?prevCaretPosition.toRange():nextCaretPosition?nextCaretPosition.toRange():null):null}function isTextBlock(node){var textBlocks=editor.schema.getTextBlockElements();return node.nodeName in textBlocks}function isEmpty(elm){return editor.dom.isEmpty(elm)}function mergeTextBlocks(direction,fromCaretPosition,toCaretPosition){var fromBlock,toBlock,node,ceTarget,dom=editor.dom;if(fromBlock=dom.getParent(fromCaretPosition.getNode(),dom.isBlock),toBlock=dom.getParent(toCaretPosition.getNode(),dom.isBlock),direction===-1){if(ceTarget=toCaretPosition.getNode(!0),isAfterContentEditableFalse(toCaretPosition)&&isBlock(ceTarget))return isTextBlock(fromBlock)?(isEmpty(fromBlock)&&dom.remove(fromBlock),CaretPosition.after(ceTarget).toRange()):deleteContentEditableNode(toCaretPosition.getNode(!0))}else if(ceTarget=fromCaretPosition.getNode(),isBeforeContentEditableFalse(fromCaretPosition)&&isBlock(ceTarget))return isTextBlock(toBlock)?(isEmpty(toBlock)&&dom.remove(toBlock),CaretPosition.before(ceTarget).toRange()):deleteContentEditableNode(fromCaretPosition.getNode());if(fromBlock===toBlock||!isTextBlock(fromBlock)||!isTextBlock(toBlock))return null;for(;node=fromBlock.firstChild;)toBlock.appendChild(node);return editor.dom.remove(fromBlock),toCaretPosition.toRange()}function backspaceDelete(direction,beforeFn,afterFn,range){var node,caretPosition,peekCaretPosition,newCaretPosition;return range.collapsed?(caretPosition=getNormalizedRangeEndPoint(direction,range),afterFn(caretPosition)&&CaretContainer.isCaretContainerBlock(range.startContainer)?(newCaretPosition=direction==-1?caretWalker.prev(caretPosition):caretWalker.next(caretPosition),newCaretPosition?renderRangeCaret(newCaretPosition.toRange()):range):beforeFn(caretPosition)?renderRangeCaret(deleteContentEditableNode(caretPosition.getNode(direction==-1))):(peekCaretPosition=direction==-1?caretWalker.prev(caretPosition):caretWalker.next(caretPosition),beforeFn(peekCaretPosition)?direction===-1?mergeTextBlocks(direction,caretPosition,peekCaretPosition):mergeTextBlocks(direction,peekCaretPosition,caretPosition):void 0)):(node=getSelectedNode(range),isContentEditableFalse(node)?renderRangeCaret(deleteContentEditableNode(node)):null)}function registerEvents(){function override(evt,moveFn){if(evt.isDefaultPrevented()===!1){var range=moveFn(getRange());range&&(evt.preventDefault(),setRange(range))}}function getContentEditableRoot(node){for(var root=editor.getBody();node&&node!=root;){if(isContentEditableTrue(node)||isContentEditableFalse(node))return node;node=node.parentNode}return null}function handleTouchSelect(editor){var moved=!1;editor.dom.bind(editor.getBody(),"touchstart",function(){moved=!1}),editor.dom.bind(editor.getBody(),"touchmove",function(){moved=!0}),editor.dom.bind(editor.getBody(),"touchend",function(e){var contentEditableRoot=getContentEditableRoot(e.target);contentEditableRoot&&(isContentEditableFalse(contentEditableRoot)&&(moved||(e.preventDefault(),setContentEditableSelection(selectNode(contentEditableRoot)))),editor.onContentEditableSelect.dispatch(editor,e))})}function paddEmptyContentEditableArea(){var br,ceRoot=getContentEditableRoot(editor.selection.getNode());isContentEditableTrue(ceRoot)&&isBlock(ceRoot)&&editor.dom.isEmpty(ceRoot)&&(br=editor.dom.create("br",{"data-mce-bogus":"1"}),editor.dom.empty(ceRoot),editor.dom.add(ceRoot,br),editor.selection.setRng(CaretPosition.before(br).toRange()))}function handleBlockContainer(e){var blockCaretContainer=getBlockCaretContainer();if(blockCaretContainer)return"compositionstart"==e.type?(e.preventDefault(),e.stopPropagation(),void showBlockCaretContainer(blockCaretContainer)):void(CaretContainer.hasContent(blockCaretContainer)&&showBlockCaretContainer(blockCaretContainer))}function handleEmptyBackspaceDelete(e){var prevent;switch(e.keyCode){case VK.DELETE:prevent=paddEmptyContentEditableArea();break;case VK.BACKSPACE:prevent=paddEmptyContentEditableArea()}prevent&&e.preventDefault()}var right=curry(moveH,1,getNextVisualCaretPosition,isBeforeContentEditableFalse),left=curry(moveH,-1,getPrevVisualCaretPosition,isAfterContentEditableFalse),deleteForward=curry(backspaceDelete,1,isBeforeContentEditableFalse,isAfterContentEditableFalse),backspace=curry(backspaceDelete,-1,isAfterContentEditableFalse,isBeforeContentEditableFalse),up=curry(moveV,-1,LineWalker.upUntil),down=curry(moveV,1,LineWalker.downUntil);editor.onMouseUp.add(function(){var range=getRange();range.collapsed&&setRange(renderCaretAtRange(range))}),editor.onClick.add(function(editor,e){var contentEditableRoot;contentEditableRoot=getContentEditableRoot(e.target),contentEditableRoot&&(isContentEditableFalse(contentEditableRoot)&&(e.preventDefault(),editor.focus()),isContentEditableTrue(contentEditableRoot)&&editor.dom.isChildOf(contentEditableRoot,editor.selection.getNode())&&removeContentEditableSelection())}),editor.onNewBlock.add(function(){removeContentEditableSelection(),hideFakeCaret()}),editor.onBlur.add(function(){removeContentEditableSelection(),hideFakeCaret()});var hasNormalCaretPosition=function(elm){var caretWalker=new CaretWalker(elm);if(!elm.firstChild)return!1;var startPos=CaretPosition.before(elm.firstChild),newPos=caretWalker.next(startPos);return newPos&&!isBeforeContentEditableFalse(newPos)&&!isAfterContentEditableFalse(newPos)},isInSameBlock=function(node1,node2){var block1=editor.dom.getParent(node1,editor.dom.isBlock),block2=editor.dom.getParent(node2,editor.dom.isBlock);return block1===block2},isContentKey=function(e){return!(e.keyCode>=112&&e.keyCode<=123)},hasBetterMouseTarget=function(targetNode,caretNode){var targetBlock=editor.dom.getParent(targetNode,editor.dom.isBlock),caretBlock=editor.dom.getParent(caretNode,editor.dom.isBlock);return targetBlock&&!isInSameBlock(targetBlock,caretBlock)&&hasNormalCaretPosition(targetBlock)};handleTouchSelect(editor),editor.onMouseDown.add(function(editor,e){var contentEditableRoot;if(contentEditableRoot=getContentEditableRoot(e.target))isContentEditableFalse(contentEditableRoot)?(e.preventDefault(),setContentEditableSelection(selectNode(contentEditableRoot))):editor.selection.isCollapsed()||editor.selection.placeCaretAt(e.clientX,e.clientY),editor.onContentEditableSelect.dispatch(editor,e);else{removeContentEditableSelection(),hideFakeCaret();var caretInfo=LineUtils.closestCaret(rootNode,e.clientX,e.clientY);caretInfo&&(hasBetterMouseTarget(e.target,caretInfo.node)||(e.preventDefault(),editor.getBody().focus(),setRange(showCaret(1,caretInfo.node,caretInfo.before))))}}),editor.onKeyDown.add(function(editor,e){if(!VK.modifierPressed(e))switch(e.keyCode){case VK.RIGHT:override(e,right);break;case VK.DOWN:override(e,down);break;case VK.LEFT:override(e,left);break;case VK.UP:override(e,up);break;case VK.DELETE:override(e,deleteForward);break;case VK.BACKSPACE:override(e,backspace);break;default:isContentEditableFalse(editor.selection.getNode())&&isContentKey(e)&&e.preventDefault()}}),editor.dom.bind(editor.getBody(),"keyup compositionstart",function(e){handleBlockContainer(e),handleEmptyBackspaceDelete(e)},!0),editor.onCut.add(function(){var node=editor.selection.getNode();isContentEditableFalse(node)&&setEditorTimeout(editor,function(){setRange(renderRangeCaret(deleteContentEditableNode(node)))})}),editor.selection.onGetSelectionRange.add(function(sel,e){var rng=e.range;if(selectedContentEditableNode){if(!selectedContentEditableNode.parentNode)return void(selectedContentEditableNode=null);rng=rng.cloneRange(),rng.selectNode(selectedContentEditableNode),e.range=rng}}),editor.selection.onSetSelectionRange.add(function(sel,e){var rng;rng=setContentEditableSelection(e.range),rng&&(e.range=rng)}),editor.selection.onAfterSetSelectionRange.add(function(sel,e){var rng=e.range;isRangeInCaretContainer(rng)||hideFakeCaret(),rng.startContainer.parentNode!=rootNode&&(isFakeSelectionElement(rng.startContainer.parentNode)||removeContentEditableSelection())}),editor.dom.bind(editor.getBody(),"focus",function(){setEditorTimeout(editor,function(){editor.selection.setRng(renderRangeCaret(editor.selection.getRng()))},0)}),editor.onCopy.add(function(editor,e){var clipboardData=e.clipboardData;if(!e.isDefaultPrevented()&&clipboardData){var realSelectionElement=getRealSelectionElement();realSelectionElement&&(e.preventDefault(),clipboardData.clearData(),clipboardData.setData("text/html",realSelectionElement.outerHTML),clipboardData.setData("text/plain",realSelectionElement.outerText))}})}function isWithinCaretContainer(node){return CaretContainer.isCaretContainer(node)||CaretContainer.startsWithCaretContainer(node)||CaretContainer.endsWithCaretContainer(node)}function isRangeInCaretContainer(rng){return isWithinCaretContainer(rng.startContainer)||isWithinCaretContainer(rng.endContainer)}function setContentEditableSelection(range){var node,$realSelectionContainer,sel,startContainer,startOffset,endOffset,caretPosition,targetClone,dom=editor.dom;if(!range)return null;if(range.collapsed){if(!isRangeInCaretContainer(range)){if(caretPosition=getNormalizedRangeEndPoint(1,range),isContentEditableFalse(caretPosition.getNode()))return showCaret(1,caretPosition.getNode(),!caretPosition.isAtEnd());if(isContentEditableFalse(caretPosition.getNode(!0)))return showCaret(1,caretPosition.getNode(!0),!1)}return null}if(startContainer=range.startContainer,startOffset=range.startOffset,endOffset=range.endOffset,3==startContainer.nodeType&&0==startOffset&&isContentEditableFalse(startContainer.parentNode)&&(startContainer=startContainer.parentNode,startOffset=dom.nodeIndex(startContainer),startContainer=startContainer.parentNode),1!=startContainer.nodeType)return null;if(endOffset==startOffset+1&&(node=startContainer.childNodes[startOffset]),!isContentEditableFalse(node))return null;targetClone=node.cloneNode(!0);var evt={node:node,target:targetClone};return editor.onObjectSelected.dispatch(editor,evt),0==!evt.isDefaultPrevented?null:($realSelectionContainer=dom.get(realSelectionId),$realSelectionContainer||($realSelectionContainer=dom.create("div",{"data-mce-bogus":"all",class:"mce-offscreen-selection",id:realSelectionId}),dom.add(editor.getBody(),$realSelectionContainer)),range=dom.createRng(),dom.empty($realSelectionContainer),$realSelectionContainer.appendChild(document.createTextNode("\xa0")),$realSelectionContainer.appendChild(targetClone),$realSelectionContainer.appendChild(document.createTextNode("\xa0")),range.setStart($realSelectionContainer.firstChild,1),range.setEnd($realSelectionContainer.lastChild,0),dom.setStyle($realSelectionContainer,"top",dom.getPos(node,editor.getBody()).y),$realSelectionContainer.focus(),sel=editor.selection.getSel(),sel.removeAllRanges(),sel.addRange(range),dom.setAttrib(dom.select("*[data-mce-selected]"),"data-mce-selected",null),node.setAttribute("data-mce-selected",1),selectedContentEditableNode=node,hideFakeCaret(),range)}function removeContentEditableSelection(){selectedContentEditableNode&&(selectedContentEditableNode.removeAttribute("data-mce-selected"),editor.dom.remove(realSelectionId),selectedContentEditableNode=null)}function destroy(){fakeCaret.destroy(),selectedContentEditableNode=null}function hideFakeCaret(){fakeCaret.hide()}var selectedContentEditableNode,rootNode=editor.getBody(),caretWalker=new CaretWalker(rootNode),getNextVisualCaretPosition=curry(getVisualCaretPosition,caretWalker.next),getPrevVisualCaretPosition=curry(getVisualCaretPosition,caretWalker.prev),fakeCaret=new FakeCaret(editor.getBody(),isBlock),realSelectionId="sel-"+editor.dom.uniqueId();return editor.onShowCaret=new Dispatcher,editor.onBeforeObjectSelected=new Dispatcher,editor.onObjectSelected=new Dispatcher,editor.onContentEditableSelect=new Dispatcher,registerEvents(),{showBlockCaretContainer:showBlockCaretContainer,hideFakeCaret:hideFakeCaret,destroy:destroy}}}(tinymce),function(){function validateContent(ed,content){var args={no_events:!0,format:"raw"},settings={};if(extend(settings,ed.settings),args.content=content,ed.settings.validate){args.format="html",args.load=!0,ed.onBeforeGetContent.dispatch(ed,args),settings.verify_html=!1,settings.forced_root_block=!1,settings.validate=!0;var parser=new DomParser(settings,ed.schema),serializer=new HtmlSerializer(settings,ed.schema);args.content=serializer.serialize(parser.parse(args.content),args),args.get=!0,ed.onPostProcess.dispatch(ed,args),content=args.content}return content}var Entities=tinymce.html.Entities,each=tinymce.each,extend=tinymce.extend,DomParser=tinymce.html.DomParser,HtmlSerializer=tinymce.html.Serializer,Dispatcher=tinymce.util.Dispatcher;tinymce.PluginManager.add("core",function(ed,url){function isEmpty(){return"TEXTAREA"===elm.nodeName?""==elm.value:""==elm.innerHTML}function insertContent(value){return value=Entities.decode(value),value&&("TEXTAREA"===elm.nodeName?elm.value=value:elm.innerHTML=value),!0}function isFakeRoot(node){return node&&1==node.nodeType&&node.hasAttribute("data-mce-root")}function fakeRootBlock(){ed.settings.editable_root="rootblock",ed.onPreInit.add(function(){function isEmptyRoot(node){return/^(&nbsp;|&#160;|\s|\u00a0|)$/.test(node.innerHTML)}var selection=ed.selection,dom=ed.dom;ed.schema.addValidElements("#mce:root[id|data-mce-root]"),ed.schema.children["mce:root"]=ed.schema.children.body,ed.schema.children.body["mce:root"]={},ed.serializer.addAttributeFilter("data-mce-root",function(nodes){for(var i=nodes.length;i--;)nodes[i].unwrap()}),ed.serializer.addAttributeFilter("data-mce-bogus",function(nodes){for(var i=nodes.length;i--;)nodes[i].remove()}),ed.onBeforeSetContent.add(function(editor,o){o.content||(o.content='<br data-mce-bogus="1">'),o.content='<mce:root id="'+ed.settings.editable_root+'" data-mce-root="1">'+o.content+"</mce:root>"}),ed.onSetContent.add(function(ed,o){var rng,root=dom.get(ed.settings.editable_root);root&&(isEmptyRoot(root)&&(root.innerHTML='<br data-mce-bogus="1">'),rng=dom.createRng(),rng.setStart(root,0),rng.setEnd(root,0),selection.setRng(rng))}),ed.onSaveContent.add(function(ed,o){"&nbsp;"===o.content&&(o.content="")}),ed.undoManager.onBeforeAdd.add(function(um,level){var container=ed.dom.create("div",{},level.content);isFakeRoot(container.firstChild)&&(level.content=container.firstChild.innerHTML)})})}var store;ed.onUpdateMedia=new Dispatcher,ed.onWfEditorSave=new Dispatcher;var contentLoaded=!1,elm=ed.getElement(),startup_content_html=ed.settings.startup_content_html||"";ed.onBeforeRenderUI.add(function(){if(startup_content_html&&elm&&!contentLoaded&&isEmpty())return contentLoaded=!0,insertContent(startup_content_html)}),ed.onKeyUp.add(function(ed,e){var quoted="&ldquo;{$selection}&rdquo;";"de"==ed.settings.language&&(quoted="&bdquo;{$selection}&ldquo;"),("'"===e.key||'"'==e.key)&&e.shiftKey&&e.ctrlKey&&(ed.undoManager.add(),ed.execCommand("mceReplaceContent",!1,quoted))}),ed.onExecCommand.add(function(ed,cmd,ui,val,args){"Undo"!=cmd&&"Redo"!=cmd&&"mceReApply"!=cmd&&"mceRepaint"!=cmd&&(store={cmd:cmd,ui:ui,value:val,args:args})}),ed.addShortcut("ctrl+alt+z","","mceReApply"),ed.addCommand("mceReApply",function(){if(store&&store.cmd)return ed.execCommand(store.cmd,store.ui,store.value,store.args)}),ed.onPreInit.add(function(){ed.onUpdateMedia.add(function(ed,o){function updateSrcSet(elm,o){var srcset=elm.getAttribute("srcset");if(srcset){for(var sets=srcset.split(","),i=0;i<sets.length;i++){var values=sets[i].trim().split(" ");o.before==values[0]&&(values[0]=o.after),sets[i]=values.join(" ")}elm.setAttribute("srcset",sets.join(","))}}o.before&&o.after&&(each(ed.dom.select("img,poster"),function(elm){var src=elm.getAttribute("src"),val=src.substring(0,src.indexOf("?"));if(val==o.before){var after=o.after,stamp="?"+(new Date).getTime();src.indexOf("?")!==-1&&after.indexOf("?")===-1&&(after+=stamp),ed.dom.setAttribs(elm,{src:after,"data-mce-src":o.after})}elm.getAttribute("srcset")&&updateSrcSet(elm,o)}),each(ed.dom.select("a[href]"),function(elm){
var href=ed.dom.getAttrib(elm,"href");href==o.before&&ed.dom.setAttribs(elm,{href:o.after,"data-mce-href":o.after})}))}),ed.onWfEditorSave.add(function(ed,o){o.content=validateContent(ed,o.content)})}),0==ed.settings.forced_root_block&&0!=ed.settings.editable_root&&fakeRootBlock(),tinymce.util.isFakeRoot=isFakeRoot})}(),function(){tinymce.create("tinymce.plugins.HelpPlugin",{init:function(ed,url){this.editor=ed,ed.addCommand("mceHelp",function(){ed.windowManager.open({title:ed.getLang("dlg.help","Help"),url:ed.getParam("site_url")+"index.php?option=com_jce&task=plugin.display&plugin=help&lang="+ed.getParam("language")+"&section=editor&category=editor&article=about",size:"mce-modal-landscape-full"})}),ed.addButton("help",{title:"dlg.help",cmd:"mceHelp"})}}),tinymce.PluginManager.add("help",tinymce.plugins.HelpPlugin)}(),function(){var AutoLinkPattern=/^(https?:\/\/|ssh:\/\/|ftp:\/\/|file:\/|www\.|(?:mailto:)?[A-Z0-9._%+\-]+@)(.+)$/i;tinymce.create("tinymce.plugins.AutolinkPlugin",{init:function(ed,url){var self=this;(ed.getParam("autolink_url",!0)||ed.getParam("autolink_email",!0))&&(ed.settings.autolink_pattern&&(AutoLinkPattern=ed.settings.autolink_pattern),ed.onAutoLink=new tinymce.util.Dispatcher(this),ed.onKeyDown.addToTop(function(ed,e){if(13==e.keyCode)return self.handleEnter(ed)}),tinymce.isIE||(ed.onKeyPress.add(function(ed,e){if(41==e.which)return self.handleEclipse(ed)}),ed.onKeyUp.add(function(ed,e){if(32==e.keyCode)return self.handleSpacebar(ed)})))},handleEclipse:function(ed){this.parseCurrentLine(ed,-1,"(",!0)},handleSpacebar:function(ed){this.parseCurrentLine(ed,0,"",!0)},handleEnter:function(ed){this.parseCurrentLine(ed,-1,"",!1)},parseCurrentLine:function(editor,endOffset,delimiter){function scopeIndex(container,index){if(index<0&&(index=0),3==container.nodeType){var len=container.data.length;index>len&&(index=len)}return index}function setStart(container,offset){1!=container.nodeType||container.hasChildNodes()?rng.setStart(container,scopeIndex(container,offset)):rng.setStartBefore(container)}function setEnd(container,offset){1!=container.nodeType||container.hasChildNodes()?rng.setEnd(container,scopeIndex(container,offset)):rng.setEndAfter(container)}var rng,end,start,endContainer,bookmark,text,matches,prev,len,rngText;if("A"!=editor.selection.getNode().tagName){if(rng=editor.selection.getRng(!0).cloneRange(),rng.startOffset<5){if(prev=rng.endContainer.previousSibling,!prev){if(!rng.endContainer.firstChild||!rng.endContainer.firstChild.nextSibling)return;prev=rng.endContainer.firstChild.nextSibling}if(len=prev.length,setStart(prev,len),setEnd(prev,len),rng.endOffset<5)return;end=rng.endOffset,endContainer=prev}else{if(endContainer=rng.endContainer,3!=endContainer.nodeType&&endContainer.firstChild){for(;3!=endContainer.nodeType&&endContainer.firstChild;)endContainer=endContainer.firstChild;3==endContainer.nodeType&&(setStart(endContainer,0),setEnd(endContainer,endContainer.nodeValue.length))}end=1==rng.endOffset?2:rng.endOffset-1-endOffset}start=end;do setStart(endContainer,end>=2?end-2:0),setEnd(endContainer,end>=1?end-1:0),end-=1,rngText=rng.toString();while(" "!=rngText&&""!==rngText&&160!=rngText.charCodeAt(0)&&end-2>=0&&rngText!=delimiter);if(rng.toString()==delimiter||160==rng.toString().charCodeAt(0)?(setStart(endContainer,end),setEnd(endContainer,start),end+=1):0===rng.startOffset?(setStart(endContainer,0),setEnd(endContainer,start)):(setStart(endContainer,end),setEnd(endContainer,start)),text=rng.toString(),"."==text.charAt(text.length-1)&&setEnd(endContainer,start-1),text=rng.toString(),matches=text.match(AutoLinkPattern)){if("www."==matches[1]?matches[1]="https://www.":/@$/.test(matches[1])&&!/^mailto:/.test(matches[1])&&(matches[1]="mailto:"+matches[1]),matches[1].indexOf("http")!==-1&&!editor.getParam("autolink_url",!0))return;if(matches[1].indexOf("mailto:")!==-1&&!editor.getParam("autolink_email",!0))return;bookmark=editor.selection.getBookmark(),editor.selection.setRng(rng),editor.execCommand("createlink",!1,matches[1]+matches[2]);var node=editor.selection.getNode();editor.settings.default_link_target&&editor.dom.setAttrib(node,"target",editor.settings.default_link_target),editor.onAutoLink.dispatch(editor,{node:node}),editor.selection.moveToBookmark(bookmark),editor.nodeChanged()}}}}),tinymce.PluginManager.add("autolink",tinymce.plugins.AutolinkPlugin)}(),function(){function split(str,delim){return str.split(delim||",")}var each=tinymce.each,Node=tinymce.html.Node,tags=["a","abbr","acronym","address","applet","area","article","aside","audio","b","base","basefont","bdi","bdo","bgsound","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","command","content","data","datalist","dd","del","details","dfn","dialog","dir","div","dl","dt","element","em","embed","fieldset","figcaption","figure","font","footer","form","frame","frameset","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","image","img","input","ins","isindex","kbd","keygen","label","legend","li","link","listing","main","map","mark","marquee","menu","menuitem","meta","meter","multicol","nav","nobr","noembed","noframes","noscript","object","ol","optgroup","option","output","p","param","picture","plaintext","pre","progress","q","rp","rt","rtc","ruby","s","samp","script","section","select","shadow","slot","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","title","tr","track","tt","u","ul","var","video","wbr","xmp"],fontIconRe=/<([a-z0-9]+)([^>]+)class="([^"]*)(glyph|uk-)?(fa|icon)-([\w-]+)([^"]*)"([^>]*)><\/\1>/gi,paddedRx=/<(p|h1|h2|h3|h4|h5|h6|pre|div|address|caption)\b([^>]+)>(&nbsp;|\u00a0)<\/\1>/gi;tinymce.create("tinymce.plugins.CleanupPlugin",{init:function(ed,url){var self=this;this.editor=ed,ed.settings.verify_html===!1&&(ed.settings.validate=!1),ed.onPreInit.add(function(){function removeEventAttributes(){each(ed.schema.elements,function(elm){return!elm.attributesOrder||0===elm.attributesOrder.length||void each(elm.attributes,function(obj,name){0===name.indexOf("on")&&(delete elm.attributes[name],elm.attributesOrder.splice(tinymce.inArray(elm,elm.attributesOrder,name),1))})})}function attrFilter(value,expr,check){return expr?"="===expr?value===check:"*="===expr?value.indexOf(check)>=0:"~="===expr?(" "+value+" ").indexOf(" "+check+" ")>=0:"!="===expr?value!=check:"^="===expr?0===value.indexOf(check):"$="===expr&&value.substr(value.length-check.length)===check:!!check}function replaceAttributeValue(nodes,name,expr,check){for(var node,i=nodes.length;i--;){node=nodes[i];var value=node.attr(name);value&&(expr&&!attrFilter(value,expr,check)||(node.attr(name,null),"src"!==name&&"href"!==name&&"style"!==name||node.attr("data-mce-"+name,null),"a"!==node.name||node.attributes.length||node.unwrap()))}}if(ed.serializer.addAttributeFilter("data-mce-caret",function(nodes,name,args){for(var i=nodes.length;i--;)nodes[i].remove()}),ed.settings.remove_trailing_brs===!1&&ed.serializer.addAttributeFilter("data-mce-bogus",function(nodes,name,args){for(var node,textNode,i=nodes.length;i--;)node=nodes[i],"br"===node.name&&(node.prev||node.next?node.remove():(textNode=new Node("#text",3),textNode.value="\xa0",node.replace(textNode)))}),ed.serializer.addAttributeFilter("data-mce-tmp",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.attr("data-mce-tmp",null)}),ed.parser.addAttributeFilter("data-mce-tmp",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.attr("data-mce-tmp",null)}),ed.settings.verify_html!==!1){ed.settings.allow_event_attributes||removeEventAttributes();var elements=ed.schema.elements;each(split("ol ul sub sup blockquote font table tbody tr strong b"),function(name){elements[name]&&(elements[name].removeEmpty=!1)}),ed.getParam("pad_empty_tags",!0)||each(elements,function(v,k){v.paddEmpty&&(v.paddEmpty=!1)}),ed.getParam("table_pad_empty_cells",!0)||(elements.th.paddEmpty=!1,elements.td.paddEmpty=!1),each(elements,function(v,k){return 0==k.indexOf("mce:")||void(tinymce.inArray(tags,k)===-1&&ed.schema.addCustomElements(k))})}if(ed.settings.verify_html!==!1){var invalidAttribValue=ed.getParam("invalid_attribute_values","");invalidAttribValue&&each(tinymce.explode(invalidAttribValue),function(item){var matches=/([a-z0-9\*]+)\[([a-z0-9-]+)([\^\$\!~\*]?=)?["']?([^"']+)?["']?\]/i.exec(item);if(matches&&5==matches.length){var tag=matches[1],attrib=matches[2],expr=matches[3],value=matches[4];!attrib||expr||value||(expr=""),"undefined"!=typeof expr&&("*"==tag?(ed.parser.addAttributeFilter(attrib,function(nodes,name){replaceAttributeValue(nodes,name,expr,value)}),ed.serializer.addAttributeFilter(attrib,function(nodes,name){replaceAttributeValue(nodes,name,expr,value)})):(ed.parser.addNodeFilter(tag,function(nodes,name){replaceAttributeValue(nodes,attrib,expr,value)}),ed.serializer.addNodeFilter(tag,function(nodes,name){replaceAttributeValue(nodes,attrib,expr,value)})))}})}ed.serializer.addNodeFilter(ed.settings.invalid_elements,function(nodes,name){var node,i=nodes.length;if(ed.schema.isValidChild("body",name))for(;i--;)node=nodes[i],node.remove()}),ed.parser.addNodeFilter(ed.settings.invalid_elements,function(nodes,name){var node,i=nodes.length;if(ed.schema.isValidChild("body",name))for(;i--;)node=nodes[i],"span"===name&&node.attr("data-mce-type")||node.unwrap()}),ed.parser.addNodeFilter("a,i,span,li",function(nodes,name){for(var node,cls,i=nodes.length;i--;)node=nodes[i],cls=node.attr("class")||"li"===name,cls&&!node.firstChild&&(node.attr("data-mce-empty","1"),node.append(new Node("#text","3")).value="\xa0")}),ed.serializer.addAttributeFilter("data-mce-empty",function(nodes,name){for(var node,fc,i=nodes.length;i--;)node=nodes[i],fc=node.firstChild,node.attr("data-mce-empty",null),!fc||"\xa0"!==fc.value&&"&nbsp;"!==fc.value||fc.remove()}),ed.parser.addAttributeFilter("onclick,ondblclick,onmousedown,onmouseup",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.attr("data-mce-"+name,node.attr(name)),node.attr(name,"return false;")}),ed.serializer.addAttributeFilter("data-mce-onclick,data-mce-ondblclick,data-mce-onmousedown,data-mce-onmouseup",function(nodes,name){for(var node,k,i=nodes.length;i--;)node=nodes[i],k=name.replace("data-mce-",""),node.attr(k,node.attr(name)),node.attr(name,null)}),ed.serializer.addNodeFilter("br",function(nodes,name){var node,i=nodes.length;if(i)for(;i--;)node=nodes[i],node.parent&&"body"===node.parent.name&&!node.prev&&node.remove()}),ed.parser.addNodeFilter("br",function(nodes,name){var node,i=nodes.length;if(i)for(;i--;)node=nodes[i],node.parent&&"body"===node.parent.name&&!node.prev&&node.remove()})}),ed.settings.verify_html===!1&&ed.addCommand("mceCleanup",function(){var bm,s=ed.settings,se=ed.selection;bm=se.getBookmark();var content=ed.getContent({cleanup:!0});s.verify_html=!0;var schema=new tinymce.html.Schema(s);content=new tinymce.html.Serializer({validate:!0},schema).serialize(new tinymce.html.DomParser({validate:!0,allow_event_attributes:!!ed.settings.allow_event_attributes},schema).parse(content)),ed.setContent(content,{cleanup:!0}),se.moveToBookmark(bm)}),ed.onBeforeSetContent.add(function(ed,o){if(o.content=o.content.replace(/^<br>/,""),o.content=self.convertFromGeshi(o.content),ed.settings.validate&&ed.getParam("invalid_attributes")){var s=ed.getParam("invalid_attributes","");o.content=o.content.replace(new RegExp("<([^>]+)("+s.replace(/,/g,"|")+')="([^"]+)"([^>]*)>',"gi"),function(){var args=arguments,tag=args[1],attribs=args[args.length-3]||"";return"<"+tag+attribs+">"})}o.content=o.content.replace(fontIconRe,'<$1$2class="$3$4$5-$6$7"$8 data-mce-empty="1">&nbsp;</$1>'),o.content=o.content.replace(/<(a|i|span)\b([^>]+)><\/\1>/gi,'<$1$2 data-mce-empty="1">&nbsp;</$1>'),o.content=o.content.replace(/<li><\/li>/,'<li data-mce-empty="1">&nbsp;</li>')}),ed.onPostProcess.add(function(ed,o){o.set&&(o.content=self.convertFromGeshi(o.content)),o.get&&(o.content=self.convertToGeshi(o.content),o.content=o.content.replace(/<a([^>]*)class="jce(box|popup|lightbox|tooltip|_tooltip)"([^>]*)><\/a>/gi,""),o.content=o.content.replace(/<span class="jce(box|popup|lightbox|tooltip|_tooltip)">(.*?)<\/span>/gi,"$2"),o.content=o.content.replace(/_mce_(src|href|style|coords|shape)="([^"]+)"\s*?/gi,""),ed.settings.validate===!1&&(o.content=o.content.replace(/<body([^>]*)>([\s\S]*)<\/body>/,"$2"),ed.getParam("remove_tag_padding")||(o.content=o.content.replace(/<(p|h1|h2|h3|h4|h5|h6|th|td|pre|div|address|caption)\b([^>]*)><\/\1>/gi,"<$1$2>&nbsp;</$1>"))),ed.getParam("table_pad_empty_cells",!0)||(o.content=o.content.replace(/<(th|td)([^>]*)>(&nbsp;|\u00a0)<\/\1>/gi,"<$1$2></$1>")),o.content=o.content.replace(/<(a|i|span)([^>]+)>(&nbsp;|\u00a0)<\/\1>/gi,function(match,tag,attribs){return attribs=attribs.replace('data-mce-empty="1"',""),"<"+tag+" "+tinymce.trim(attribs)+"></"+tag+">"}),o.content=o.content.replace(/<li data-mce-empty="1">(&nbsp;|\u00a0)<\/li>/gi,"<li></li>"),ed.getParam("remove_div_padding")&&(o.content=o.content.replace(/<div([^>]*)>(&nbsp;|\u00a0)<\/div>/g,"<div$1></div>")),ed.getParam("pad_empty_tags",!0)===!1&&(o.content=o.content.replace(paddedRx,"<$1$2></$1>")),ed.getParam("keep_nbsp",!0)&&"raw"===ed.settings.entity_encoding&&(o.content=o.content.replace(/\u00a0/g,"&nbsp;")),o.content=o.content.replace(/(uk|v|ng|data)-([\w-]+)=""(\s|>)/gi,"$1-$2$3"),ed.settings.padd_empty_editor&&(o.content=o.content.replace(/^(<div>(&nbsp;|&#160;|\s|\u00a0|)<\/div>[\r\n]*|<br(\s*\/)?>[\r\n]*)$/,"")),o.content=o.content.replace(/<hr(.*)class="system-pagebreak"(.*?)\/?>/gi,'<hr$1class="system-pagebreak"$2/>'),o.content=o.content.replace(/<hr id="system-readmore"(.*?)>/gi,'<hr id="system-readmore" />'))}),ed.onSaveContent.add(function(ed,o){if(ed.getParam("cleanup_pluginmode")){var entities={"&#39;":"'","&amp;":"&","&quot;":'"',"&apos;":"'"};o.content=o.content.replace(/&(#39|apos|amp|quot);/gi,function(a){return entities[a]})}}),ed.addButton("cleanup",{title:"advanced.cleanup_desc",cmd:"mceCleanup"})},convertFromGeshi:function(h){return h=h.replace(/<pre xml:lang="([^"]+)"([^>]*)>(.*?)<\/pre>/g,function(a,b,c,d){var attr="";return c&&/\w/.test(c)&&(attr=c.split(" ").join(" data-geshi-")),'<pre data-geshi-lang="'+b+'"'+attr+">"+d+"</pre>"})},convertToGeshi:function(h){return h=h.replace(/<pre([^>]+)data-geshi-lang="([^"]+)"([^>]*)>(.*?)<\/pre>/g,function(a,b,c,d,e){var s=b+d;return s=s.replace(/data-geshi-/gi,"").replace(/\s+/g," ").replace(/\s$/,""),'<pre xml:lang="'+c+'"'+s+">"+e+"</pre>"})}}),tinymce.PluginManager.add("cleanup",tinymce.plugins.CleanupPlugin)}(),function(){function createTextNode(value,raw){var text=new Node("#text",3);return text.raw=raw!==!1,text.value=value,text}function isOnlyChild(node){var parent=node.parent,child=parent.firstChild,count=0;if(child)do{if(1===child.type){if(child.attributes.map["data-mce-type"]||child.attributes.map["data-mce-bogus"])continue;if(child===node)continue;count++}8===child.type&&count++,3!==child.type||/^[ \t\r\n]*$/.test(child.value)||count++}while(child=child.next);return 0===count}var each=tinymce.each,Node=tinymce.html.Node,VK=tinymce.VK,DomParser=tinymce.html.DomParser,Serializer=tinymce.html.Serializer,SaxParser=tinymce.html.SaxParser;tinymce.create("tinymce.plugins.CodePlugin",{init:function(ed,url){function processOnInsert(value,node){if(/\{.+\}/gi.test(value)&&ed.settings.code_protect_shortcode){var tagName;value=processShortcode(value,tagName)}return ed.settings.code_allow_custom_xml&&(value=processXML(value)),/<(\?|script|style)/.test(value)&&(value=value.replace(/<(script|style)([^>]*?)>([\s\S]*?)<\/\1>/gi,function(match,type){return ed.getParam("code_allow_"+type)?(match=match.replace(/<br[^>]*?>/gi,"\n"),createCodePre(match,type)):""}),value=processPhp(value)),value}function processShortcode(html,tagName){return html.indexOf("{")===-1?html:"{"==html.charAt(0)&&html.length<3?html:(html.indexOf("{/source}")!=-1&&(html=processSourcerer(html)),tagName=tagName||"span",html.replace(/(?:(<(code|pre|samp|span)[^>]*(data-mce-type="code")?>)?)(?:\{)([\w-]+)(.*?)(?:\/?\})(?:([\s\S]+?)\{\/\4\})?/g,function(match){return"<"===match.charAt(0)?match:createShortcodePre(match,tagName)}))}function processSourcerer(html){return html.indexOf("{/source}")===-1?html:html.replace(/(?:(<(code|pre|samp|span)[^>]*(data-mce-type="code")?>|")?)\{source(.*?)\}([\s\S]+?)\{\/source\}/g,function(match){return"<"===match.charAt(0)||'"'===match.charAt(0)?match:(match=ed.dom.decode(match),'<pre data-mce-code="shortcode" data-mce-label="sourcerer">'+ed.dom.encode(match)+"</pre>")})}function processPhp(content){return ed.settings.code_allow_php?(content=content.replace(/\="([^"]+?)"/g,function(a,b){return b=b.replace(/<\?(php)?(.+?)\?>/gi,function(x,y,z){return"[php:start]"+ed.dom.encode(z)+"[php:end]"}),'="'+b+'"'}),/<textarea/.test(content)&&(content=content.replace(/<textarea([^>]*)>([\s\S]*?)<\/textarea>/gi,function(a,b,c){return c=c.replace(/<\?(php)?(.+?)\?>/gi,function(x,y,z){return"[php:start]"+ed.dom.encode(z)+"[php:end]"}),"<textarea"+b+">"+c+"</textarea>"})),content=content.replace(/<([^>]+)<\?(php)?(.+?)\?>([^>]*?)>/gi,function(a,b,c,d,e){return" "!==b.charAt(b.length)&&(b+=" "),"<"+b+'data-mce-php="'+d+'" '+e+">"}),content=content.replace(/<\?(php)?([\s\S]+?)\?>/gi,function(match){return match=match.replace(/\n/g,"<br />"),createCodePre(match,"php","span")})):content.replace(/<\?(php)?([\s\S]*?)\?>/gi,"")}function isInvalidElement(name){var invalid_elements=ed.settings.invalid_elements.split(",");return tinymce.inArray(invalid_elements,name)!==-1}function isXmlElement(name){return!htmlSchema.isValid(name)&&!isInvalidElement(name)}function validateXml(xml){function isValid(tag,attr){return!!isXmlElement(tag)||ed.schema.isValid(tag,attr)}var html=[];return new SaxParser({start:function(name,attrs,empty){if(isValid(name)){html.push("<",name);var attr;if(attrs)for(var i=0,len=attrs.length;i<len;i++)attr=attrs[i],isValid(name,attr.name)&&(ed.settings.allow_event_attributes!==!0&&0===attr.name.indexOf("on")||html.push(" ",attr.name,'="',ed.dom.encode(""+attr.value,!0),'"'));empty?html[html.length]=" />":html[html.length]=">"}},text:function(value){value.length>0&&(html[html.length]=value)},end:function(name){isValid(name)&&html.push("</",name,">")},cdata:function(text){html.push("<![CDATA[",text,"]]>")},comment:function(text){html.push("<!--",text,"-->")}},xmlSchema).parse(xml),html.join("")}function processXML(content){return content.replace(/<([a-z0-9\-_\:\.]+)(?:[^>]*?)\/?>((?:[\s\S]*?)<\/\1>)?/gi,function(match,tag){return"svg"===tag&&ed.settings.code_allow_svg_in_xml===!1?match:"math"===tag&&ed.settings.code_allow_mathml_in_xml===!1?match:isXmlElement(tag)?(ed.settings.code_validate_xml!==!1&&(match=validateXml(match)),createCodePre(match,"xml")):match})}function createShortcodePre(data,tag){return data=ed.dom.decode(data),data=data.replace(/[\n\r]/gi,"<br />"),ed.dom.createHTML(tag||"pre",{"data-mce-code":"shortcode","data-mce-type":"code"},ed.dom.encode(data))}function createCodePre(data,type,tag){return code_blocks===!1?(data=data.replace(/<br[^>]*?>/gi,"\n"),ed.dom.createHTML("img",{src:"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7","data-mce-resize":"false","data-mce-code":type||"script","data-mce-type":"placeholder","data-mce-value":escape(data)})):ed.dom.createHTML(tag||"pre",{"data-mce-code":type||"script","data-mce-type":"code"},ed.dom.encode(data))}function handleEnterInPre(ed,node,before){var parents=ed.dom.getParents(node,blockElements.join(",")),newBlockName=ed.settings.forced_root_block||"p";ed.settings.force_block_newlines===!1&&(newBlockName="br");var block=parents.shift();if(block!==ed.getBody()){var elm=ed.dom.create(newBlockName,{},"\xa0");before?block.parentNode.insertBefore(elm,block):ed.dom.insertAfter(elm,block);var rng=ed.selection.getRng();rng.setStart(elm,0),rng.setEnd(elm,0),ed.selection.setRng(rng),ed.selection.scrollIntoView(elm)}}this.editor=ed,this.url=url;var blockElements=[],htmlSchema=new tinymce.html.Schema({schema:"mixed",invalid_elements:ed.settings.invalid_elements}),xmlSchema=new tinymce.html.Schema({verify_html:!1}),code_blocks=ed.settings.code_use_blocks!==!1;ed.settings.code_allow_script&&(ed.settings.allow_script_urls=!0),ed.addCommand("InsertShortCode",function(ui,html){return ed.settings.code_protect_shortcode&&(html=processShortcode(html,"pre"),tinymce.is(html)&&ed.execCommand("mceReplaceContent",!1,html)),!1}),ed.onKeyDown.add(function(ed,e){var node;e.keyCode==VK.ENTER&&(node=ed.selection.getNode(),"SPAN"===node.nodeName&&node.getAttribute("data-mce-code")&&(handleEnterInPre(ed,node),e.preventDefault())),e.keyCode==VK.UP&&e.altKey&&(node=ed.selection.getNode(),"PRE"==node.nodeName&&(handleEnterInPre(ed,node,!0),e.preventDefault())),9!=e.keyCode||VK.metaKeyPressed(e)||(node=ed.selection.getNode(),"PRE"===node.nodeName&&node.getAttribute("data-mce-code")&&(ed.selection.setContent("\t",{no_events:!0}),e.preventDefault())),e.keyCode!==VK.BACKSPACE&&e.keyCode!==VK.DELETE||(node=ed.selection.getNode(),"SPAN"===node.nodeName&&node.getAttribute("data-mce-code")&&"placeholder"===node.getAttribute("data-mce-type")&&(ed.undoManager.add(),ed.dom.remove(node),e.preventDefault()))}),ed.onPreInit.add(function(){function isCodePlaceholder(node){return"SPAN"===node.nodeName&&node.getAttribute("data-mce-code")&&"placeholder"==node.getAttribute("data-mce-type")}ed.settings.content_css!==!1&&ed.dom.loadCSS(url+"/css/content.css"),ed.dom.bind(ed.getDoc(),"keyup click",function(e){var node=e.target,sel=ed.selection.getNode();return ed.dom.removeClass(ed.dom.select(".mce-item-selected"),"mce-item-selected"),node===ed.getBody()&&isCodePlaceholder(sel)?void(sel.parentNode!==node||sel.nextSibling||ed.dom.insertAfter(ed.dom.create("br",{"data-mce-bogus":1}),sel)):void(isCodePlaceholder(node)&&(e.preventDefault(),e.stopImmediatePropagation(),ed.selection.select(node),window.setTimeout(function(){ed.dom.addClass(node,"mce-item-selected")},10),e.preventDefault()))});var ctrl=ed.controlManager.get("formatselect");ctrl&&each(["script","style","php","shortcode","xml"],function(key){var title=ed.getLang("code."+key,key);return"shortcode"===key&&ed.settings.code_protect_shortcode?(ctrl.add(title,key,{class:"mce-code-"+key}),ed.formatter.register("shortcode",{block:"pre",attributes:{"data-mce-code":"shortcode"}}),!0):("xml"===key&&(ed.settings.code_allow_xml=!!ed.settings.code_allow_custom_xml),void(ed.getParam("code_allow_"+key)&&code_blocks&&(ctrl.add(title,key,{class:"mce-code-"+key}),ed.formatter.register(key,{block:"pre",attributes:{"data-mce-code":key},onformat:function(elm,fmt,vars){each(ed.dom.select("br",elm),function(br){ed.dom.replace(ed.dom.doc.createTextNode("\n"),br)})}}))))}),each(ed.schema.getBlockElements(),function(block,blockName){blockElements.push(blockName)}),ed.plugins.textpattern&&ed.settings.code_protect_shortcode&&(ed.plugins.textpattern.addPattern({start:"{",end:"}",cmd:"InsertShortCode",remove:!0}),ed.plugins.textpattern.addPattern({start:" {",end:"}",format:"inline-shortcode",remove:!1})),ed.formatter.register("inline-shortcode",{inline:"span",attributes:{"data-mce-code":"shortcode"}}),ed.selection.onSetContent.add(function(sel,o){each(ed.dom.select("pre[data-mce-code]",ed.getBody()),function(elm){var p=ed.dom.getParent(elm,"p");p&&1===p.childNodes.length&&ed.dom.remove(p,1)})}),ed.parser.addNodeFilter("script,style,noscript",function(nodes){for(var node,i=nodes.length;i--;){var node=nodes[i],type=node.attr("type");if(type&&node.attr("type","mce-no/type"==type?null:type.replace(/^mce\-/,"")),node.firstChild&&(node.firstChild.value=node.firstChild.value.replace(/<span([^>]+)>([\s\S]+?)<\/span>/gi,function(match,attr,content){return attr.indexOf("data-mce-code")===-1?match:ed.dom.decode(content)})),code_blocks){value=new Serializer({validate:!1}).serialize(node),value=tinymce.trim(value);var pre=new Node("pre",1);pre.attr({"data-mce-code":node.name});var text=createTextNode(value,!1);pre.append(text),node.replace(pre)}else{var value="";node.firstChild&&(value=tinymce.trim(node.firstChild.value));var placeholder=Node.create("img",{src:"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7","data-mce-code":node.name,"data-mce-type":"placeholder","data-mce-resize":"false",title:ed.dom.encode(value)});each(node.attributes,function(attr){placeholder.attr("data-mce-p-"+attr.name,attr.value)}),value&&placeholder.attr("data-mce-value",escape(value)),node.replace(placeholder)}}}),ed.parser.addAttributeFilter("data-mce-code",function(nodes,name){function isBody(parent){return"body"===parent.name}function isValidCode(type){return"shortcode"===type||"php"===type}function isBlockNode(node){return tinymce.inArray(blockElements,node.name)!=-1}function isInlineNode(node){return!("span"!=node.name||(!node.next||"#text"!=node.next.type&&isBlockNode(node.next))&&(!node.prev||"#text"!=node.prev.type&&isBlockNode(node.prev)))}for(var node,parent,i=nodes.length;i--;)if(node=nodes[i],parent=node.parent,"placeholder"!=node.attr("data-mce-type")&&isValidCode(node.attr(name))){var value=node.firstChild.value;if(value&&(node.firstChild.value=value.replace(/<br[\s\/]*>/g,"\n")),parent){if(parent.attr(name)){node.unwrap();continue}if(isBody(parent)||isOnlyChild(node)||!isInlineNode(node))node.name="pre";else if("span"==node.name&&node===parent.lastChild){var nbsp=createTextNode("\xa0");parent.append(nbsp)}}}}),ed.serializer.addAttributeFilter("data-mce-code",function(nodes,name){function isXmlNode(node){return!/(shortcode|php)/.test(node.attr("data-mce-code"))}for(var node,child,i=nodes.length;i--;){var root_block=!1;node=nodes[i];var type=node.attr(name);if("img"!==node.name){if(node.isEmpty()&&node.remove(),"xml"!==type){"script"!==type&&"style"!==type||(root_block=type);var child=node.firstChild,newNode=node.clone(!0),text="";if(child)do if(isXmlNode(node)){var value="br"==child.name?"\n":child.value;value&&(text+=value)}while(child=child.next);if(text){newNode.empty();var parser=new DomParser({validate:!1});"script"!==type&&"style"!==type||parser.addNodeFilter(type,function(items,name){for(var n=items.length;n--;){var item=items[n];each(item.attributes,function(attr){return!attr||void(ed.schema.isValid(name,attr.name)===!1&&item.attr(attr.name,null))})}});var fragment=parser.parse(text,{forced_root_block:root_block});newNode.append(fragment)}if(node.replace(newNode),"shortcode"===type&&"pre"===newNode.name){var newline=createTextNode("\n");newNode.append(newline),newNode.unwrap()}}}else{var elm=new Node(type,1);for(var key in node.attributes.map){var val=node.attributes.map[key];key.indexOf("data-mce-p-")!==-1?key=key.substr(11):val=null,elm.attr(key,val)}var value=node.attr("data-mce-value");if(value){var text=createTextNode(unescape(value));"php"==type||"shortcode"==type?elm=text:elm.append(text)}node.replace(elm)}}}),ed.plugins.clipboard&&ed.onGetClipboardContent.add(function(ed,content){var value,text=content["text/plain"]||"";if(text=tinymce.trim(text)){var node=ed.selection.getNode();if(node&&"PRE"===node.nodeName)return;value=processOnInsert(text),value!==text&&(content["text/plain"]="",content["text/html"]=content["x-tinymce/html"]=value)}})}),ed.onInit.add(function(){ed.theme&&ed.theme.onResolveName&&ed.theme.onResolveName.add(function(theme,o){var node=o.node;node.getAttribute("data-mce-code")&&(o.name=node.getAttribute("data-mce-code"))})}),ed.onBeforeSetContent.addToTop(function(ed,o){ed.settings.code_protect_shortcode&&o.content.indexOf('data-mce-code="shortcode"')===-1&&(o.content=processShortcode(o.content)),ed.settings.code_allow_custom_xml&&o.content&&o.load&&(o.content=processXML(o.content)),/<(\?|script|style)/.test(o.content)&&(ed.settings.code_allow_script||(o.content=o.content.replace(/<script[^>]*>([\s\S]*?)<\/script>/gi,"")),ed.settings.code_allow_style||(o.content=o.content.replace(/<style[^>]*>([\s\S]*?)<\/style>/gi,"")),o.content=processPhp(o.content))}),ed.onPostProcess.add(function(ed,o){o.get&&(/(data-mce-php|\[php:start\])/.test(o.content)&&(o.content=o.content.replace(/({source})?\[php:\s?start\](.*?)\[php:\s?end\]/g,function(match,pre,code){return(pre||"")+"<?php"+ed.dom.decode(code)+"?>"}),o.content=o.content.replace(/<textarea([^>]*)>([\s\S]*?)<\/textarea>/gi,function(a,b,c){return/&lt;\?php/.test(c)&&(c=ed.dom.decode(c)),"<textarea"+b+">"+c+"</textarea>"}),o.content=o.content.replace(/data-mce-php="([^"]+?)"/g,function(a,b){return"<?php"+ed.dom.decode(b)+"?>"})),ed.settings.code_protect_shortcode&&(o.content=o.content.replace(/\{([\s\S]+?)\}/gi,function(match,content){return"{"+ed.dom.decode(content)+"}"}),o.content=o.content.replace(/\{source([^\}]*?)\}([\s\S]+?)\{\/source\}/gi,function(match,start,content){return"{source"+start+"}"+ed.dom.decode(content)+"{/source}"}),o.content=o.content.replace(/\{([\w-]+)(.*?)\}([\s\S]+)\{\/\1\}/gi,function(match,start,attr,content){return"{"+start+attr+"}"+ed.dom.decode(content)+"{/"+start+"}"})),o.content=o.content.replace(/<(pre|span)([^>]+?)>([\s\S]*?)<\/\1>/gi,function(match,tag,attr,content){if(attr.indexOf("data-mce-code")===-1)return match;content=tinymce.trim(content),content=ed.dom.decode(content);var node=ed.dom.create("div",{},match),elm=node.firstChild,type=elm.getAttribute("data-mce-code");return"script"!=type&&(content=content.replace(/<br[^>]*?>/gi,"\n")),"php"==type&&(content=content.replace(/<\?(php)?/gi,"").replace(/\?>/g,""),content="<?php\n"+tinymce.trim(content)+"\n?>"),content}),o.content=o.content.replace(/<!--mce:protected ([\s\S]+?)-->/gi,function(match,content){return unescape(content)}))})}}),tinymce.PluginManager.add("code",tinymce.plugins.CodePlugin)}(),function(){var each=tinymce.each;tinymce.PluginManager.add("effects",function(ed,url){function cleanEventAttribute(val){return val?val.replace(/^\s*this.src\s*=\s*\'([^\']+)\';?\s*$/,"$1").replace(/^\s*|\s*$/g,""):""}function bindMouseoverEvent(ed){each(ed.dom.select("img"),function(elm){var src=elm.getAttribute("src"),mouseover=elm.getAttribute("data-mouseover"),mouseout=elm.getAttribute("data-mouseout");return elm.onmouseover=elm.onmouseout=null,!(src&&mouseover&&mouseout)||(elm.onmouseover=function(){elm.setAttribute("src",elm.getAttribute("data-mouseover"))},void(elm.onmouseout=function(){elm.setAttribute("src",elm.getAttribute("data-mouseout")||src)}))})}ed.onPreInit.add(function(){ed.onBeforeSetContent.add(function(ed,o){if(o.content.indexOf("onmouseover=")!==-1){var div=ed.dom.create("div",{},o.content);each(ed.dom.select("img[onmouseover]",div),function(node){var mouseover=node.getAttribute("onmouseover"),mouseout=node.getAttribute("onmouseout");if(!mouseover||0!==mouseover.indexOf("this.src"))return!0;if(mouseover=cleanEventAttribute(mouseover),node.removeAttribute("onmouseover"),!mouseover)return!0;if(node.setAttribute("data-mouseover",mouseover),mouseout&&0===mouseout.indexOf("this.src")){if(mouseout=cleanEventAttribute(mouseout),node.removeAttribute("onmouseout"),!mouseout)return;node.setAttribute("data-mouseout",mouseout)}}),o.content=div.innerHTML}}),ed.parser.addAttributeFilter("onmouseover",function(nodes){for(var i=nodes.length;i--;){var node=nodes[i];if("img"===node.name){var mouseover=node.attr("onmouseover"),mouseout=node.attr("onmouseout");mouseover&&0===mouseover.indexOf("this.src")&&(mouseover=cleanEventAttribute(mouseover),node.attr("data-mouseover",mouseover),node.attr("onmouseover",null),mouseout&&0===mouseout.indexOf("this.src")&&(mouseout=cleanEventAttribute(mouseout),node.attr("data-mouseout",mouseout),node.attr("onmouseout",null)))}}}),ed.serializer.addAttributeFilter("data-mouseover",function(nodes){for(var i=nodes.length;i--;){var node=nodes[i];if("img"===node.name){var mouseover=node.attr("data-mouseover"),mouseout=node.attr("data-mouseout");mouseover=cleanEventAttribute(mouseover),node.attr("data-mouseover",null),node.attr("data-mouseout",null),mouseover&&(node.attr("onmouseover","this.src='"+mouseover+"';"),
mouseout=cleanEventAttribute(mouseout),mouseout&&node.attr("onmouseout","this.src='"+mouseout+"';"))}}}),ed.selection.onSetContent.add(function(){bindMouseoverEvent(ed)}),ed.onSetContent.add(function(){bindMouseoverEvent(ed)}),ed.onUpdateMedia.add(function(ed,o){bindMouseoverEvent(ed),o.before&&o.after&&each(ed.dom.select("img[data-mouseover]"),function(elm){var mouseover=elm.getAttribute("data-mouseover"),mouseout=elm.getAttribute("data-mouseout");return!mouseover||(mouseover==o.before&&elm.setAttribute("data-mouseover",o.after),void(mouseout==o.before&&elm.setAttribute("data-mouseout",o.after)))})})})})}(),function(){var VK=tinymce.VK,each=tinymce.each,blocks=[];tinymce.create("tinymce.plugins.FormatPlugin",{init:function(ed,url){function addSoftHyphenShortcut(){ed.addCommand("mceSoftHyphen",function(){ed.execCommand("mceInsertContent",!1,ed.plugins.visualchars&&ed.plugins.visualchars.state?'<span data-mce-bogus="1" class="mce-item-hidden mce-item-shy">&shy;</span>':"&shy;")});var keyCode=189;tinymce.isGecko&&(keyCode=173),ed.addShortcut("ctrl+shift+"+keyCode,"softhyphen.desc","mceSoftHyphen")}var self=this;this.editor=ed,ed.addButton("italic",{title:"advanced.italic_desc",onclick:function(e){e.preventDefault(),ed.focus(),e.shiftKey?ed.formatter.toggle("italic-i"):ed.formatter.toggle("italic"),ed.undoManager.add()}}),ed.addShortcut("meta+shift+i","italic.desc",function(){ed.formatter.apply("italic-i")}),addSoftHyphenShortcut(),ed.onPreInit.add(function(ed){each(ed.schema.getBlockElements(),function(v,k){return!!/\W/.test(k)||void blocks.push(k.toLowerCase())}),ed.formatter.register("aside",{block:"aside",remove:"all",wrapper:!0}),ed.formatter.register("p",{block:"p",remove:"all"}),ed.formatter.register("div",{block:"div",onmatch:!!ed.settings.forced_root_block&&function(){return!1}}),ed.formatter.register("div_container",{block:"div",wrapper:!0,onmatch:!!ed.settings.forced_root_block&&function(){return!1}}),ed.formatter.register("span",{inline:"span",remove:"all",onmatch:function(){return!1}}),ed.formatter.register("section",{block:"section",remove:"all",wrapper:!0,merge_siblings:!1}),ed.formatter.register("article",{block:"article",remove:"all",wrapper:!0,merge_siblings:!1}),ed.formatter.register("footer",{block:"footer",remove:"all",wrapper:!0,merge_siblings:!1}),ed.formatter.register("header",{block:"header",remove:"all",wrapper:!0,merge_siblings:!1}),ed.formatter.register("nav",{block:"nav",remove:"all",wrapper:!0,merge_siblings:!1}),ed.formatter.register("code",{inline:"code",remove:"all"}),ed.formatter.register("samp",{inline:"samp",remove:"all"}),ed.formatter.register("blockquote",{block:"blockquote",wrapper:1,remove:"all",merge_siblings:!1}),ed.formatter.register("italic-i",{inline:"i",remove:"all"})}),ed.settings.removeformat=[{selector:"b,strong,em,i,font,u,strike,sub,sup,dfn,code,samp,kbd,var,cite,mark,q,footer",remove:"all",split:!0,expand:!1,block_expand:!0,deep:!0}],ed.onKeyDown.add(function(ed,e){e.keyCode!==VK.ENTER&&e.keyCode!==VK.UP&&e.keyCode!==VK.DOWN||!e.altKey||self._clearBlocks(ed,e)}),ed.onKeyUp.addToTop(function(ed,e){if(e.keyCode===VK.ENTER){var n=ed.selection.getNode();"DIV"===n.nodeName&&ed.settings.force_block_newlines&&(ed.settings.keep_styles===!1&&ed.dom.removeAllAttribs(n),ed.formatter.apply("p"))}}),ed.onBeforeExecCommand.add(function(ed,cmd,ui,v,o){var p,se=ed.selection,n=se.getNode();switch(cmd){case"FormatBlock":if(!v){if(o.terminate=!0,n===ed.getBody())return;if(ed.undoManager.add(),p=ed.dom.getParent(n,blocks.join(","))||""){var name=p.nodeName.toLowerCase();ed.formatter.get(name)&&ed.formatter.remove(name)}var cm=ed.controlManager.get("formatselect");cm&&cm.select(p)}"dt"!==v&&"dd"!==v||(n&&!ed.dom.getParent(n,"dl")&&ed.execCommand("InsertDefinitionList"),"dt"===v&&"DD"===n.nodeName&&ed.dom.rename(n,"DT"),"dd"===v&&"DT"===n.nodeName&&ed.dom.rename(n,"DD"),o.terminate=!0);break;case"RemoveFormat":v||ed.dom.isBlock(n)||(cm=ed.controlManager.get("styleselect"),cm&&cm.selectedValue&&ed.execCommand("mceToggleFormat",!1,cm.selectedValue))}}),ed.onExecCommand.add(function(ed,cmd,ui,v,o){var se=ed.selection,n=se.getNode();switch(cmd){case"mceToggleFormat":"dt"!==v&&"dd"!==v||"DL"===n.nodeName&&0===ed.dom.select("dt,dd",n).length&&ed.formatter.remove("dl")}})},_clearBlocks:function(ed,e){var p,n=ed.selection.getNode();if(p=ed.dom.getParents(n,blocks.join(",")),p&&p.length>1){var tag=ed.getParam("forced_root_block","p");tag||(tag=ed.getParam("force_block_newlines")?"p":"br"),e.preventDefault();var block=p[p.length-1];if(block===ed.getBody())return;var el=ed.dom.create(tag,{},"\xa0");e.keyCode===VK.ENTER||e.keyCode===VK.DOWN?ed.dom.insertAfter(el,block):ed.dom.insertBefore(el,block),ed.selection.select(el),ed.selection.collapse(1)}}}),tinymce.PluginManager.add("format",tinymce.plugins.FormatPlugin)}(),function(){function toAbsolute(u,p){return u.replace(/url\(["']?(.+?)["']?\)/gi,function(a,b){return b.indexOf("://")<0?'url("'+p+b+'")':a})}function isEditorContentCss(url){return url.indexOf("/tiny_mce/")!==-1&&url.indexOf("content.css")!==-1}function cleanSelectorText(selectorText){var selector=/^(?:([a-z0-9\-_]+))?(\.[a-z0-9_\-\.]+)$/i.exec(selectorText);if(!selector)return"";var elementName=selector[1];return"body"!==elementName?selector[2].substr(1).split(".").join(" "):""}function getRGBA(val){if(!rgba[val]){var values,match,r=0,b=0,g=0,a=1;if(val.indexOf("#")!==-1)val=val.substr(1),3===val.length&&(val+=val),r=parseInt(val.substring(0,2),16),g=parseInt(val.substring(2,4),16),b=parseInt(val.substring(4,6),16),val.length>6&&(a=parseInt(val.substring(6,8),16),a=+(a/255).toFixed(2));else{val=val.replace(/\s/g,"");var match=/^(?:rgb|rgba)\(([^\)]*)\)$/.exec(val);match&&(values=match[1].split(",").map(function(x,i){return parseFloat(x)})),values&&(r=values[0],g=values[1],b=values[2],4===values.length&&(a=values[3]||1))}rgba[val]={r:r,g:g,b:b,a:a}}return rgba[val]}function getLuminance(val){if(!luma[val]){var RsRGB,GsRGB,BsRGB,R,G,B,col=getRGBA(val);RsRGB=col.r/255,GsRGB=col.g/255,BsRGB=col.b/255,R=RsRGB<=.03928?RsRGB/12.92:Math.pow((RsRGB+.055)/1.055,2.4),G=GsRGB<=.03928?GsRGB/12.92:Math.pow((GsRGB+.055)/1.055,2.4),B=BsRGB<=.03928?BsRGB/12.92:Math.pow((BsRGB+.055)/1.055,2.4),luma[val]=.2126*R+.7152*G+.0722*B}return luma[val]}function isReadable(color1,color2,wcag2,limit){var l1=getLuminance(color1),l2=getLuminance(color2),lvl=(Math.max(l1,l2)+.05)/(Math.min(l1,l2)+.05);return wcag2=wcag2||4.5,limit=limit||21,lvl>=parseFloat(wcag2)&&lvl<parseFloat(limit)}var each=tinymce.each,DOM=tinymce.DOM,PreviewCss=tinymce.util.PreviewCss,rgba={},luma={};tinymce.create("tinymce.plugins.ImportCSS",{init:function(ed,url){this.editor=ed;var self=this;ed.onImportCSS=new tinymce.util.Dispatcher,ed.onImportCSS.add(function(){tinymce.is(ed.settings.importcss_classes)||self.get()}),ed.onInit.add(function(){ed.onImportCSS.dispatch(),"auto"!==ed.settings.content_style_reset||ed.dom.hasClass(ed.getBody(),"mceContentReset")||self._setHighContrastMode(),self._setGuideLinesColor()}),ed.onFocus.add(function(ed){ed._hasGuidelines||self._setGuideLinesColor()})},_setHighContrastMode:function(){var ed=this.editor,bodybg=ed.dom.getStyle(ed.getBody(),"background-color",!0),color=ed.dom.getStyle(ed.getBody(),"color",!0);if(bodybg&&color){var hex=ed.dom.toHex(bodybg);hex==ed.dom.toHex(color)&&"#000000"===hex||isReadable(color,bodybg,3)||ed.dom.addClass(ed.getBody(),"mceContentReset")}},_setGuideLinesColor:function(){var ed=this.editor,gray=["#000000","#080808","#101010","#181818","#202020","#282828","#303030","#383838","#404040","#484848","#505050","#585858","#606060","#686868","#696969","#707070","#787878","#808080","#888888","#909090","#989898","#a0a0a0","#a8a8a8","#a9a9a9","#b0b0b0","#b8b8b8","#bebebe","#c0c0c0","#c8c8c8","#d0d0d0","#d3d3d3","#d8d8d8","#dcdcdc","#e0e0e0","#e8e8e8","#f0f0f0","#f5f5f5","#f8f8f8","#ffffff"],blue=["#0d47a1","#1565c0","#1976d2","#1e88e5","#2196f3","#42a5f5","#64b5f6","#90caf9","#bbdefb","#e3f2fd"],guidelines="#787878",control="#1e88e5",controlbg="#b4d7ff",placeholder="#efefef",bodybg=ed.dom.getStyle(ed.getBody(),"background-color",!0),color=ed.dom.getStyle(ed.getBody(),"color",!0);if(bodybg){ed._hasGuidelines=!0;for(var i=0;i<gray.length;i++)if(isReadable(gray[i],bodybg,4.5,5)){if(ed.dom.toHex(color)===ed.dom.toHex(gray[i]))continue;guidelines=gray[i];break}for(var i=0;i<blue.length;i++)if(isReadable(blue[i],bodybg,4.5,5)){control=blue[i];break}if(guidelines||control){var css=":root{";guidelines&&(css+="--mce-guidelines: "+guidelines+";"),css+="--mce-placeholder: "+placeholder+";",control&&(css+="--mce-control-selection: "+control+";",css+="--mce-control-selection-bg: "+controlbg+";"),css+="}",ed.dom.addStyle(css)}}},get:function(){function isAllowedStylesheet(href){var styleselect=ed.getParam("styleselect_stylesheets");return!styleselect||("undefined"!=typeof filtered[href]?filtered[href]:(filtered[href]=href.indexOf(styleselect)!==-1,filtered[href]))}function isBodyClass(value){return!!bodyRx&&bodyRx.test(value)}function isValidStyle(value){return/\.[\w\-]+$/.test(value)}function parseCSS(stylesheet){each(stylesheet.imports,function(r){if(r.href.indexOf("://fonts.googleapis.com")>0){var v="@import url("+r.href+");";return void(self.fontface.indexOf(v)===-1&&self.fontface.unshift(v))}parseCSS(r)});try{if(rules=stylesheet.cssRules||stylesheet.rules,href=stylesheet.href,!href)return;if(isEditorContentCss(href))return;href=href.substr(0,href.lastIndexOf("/")+1),ed.hasStyleSheets=!0}catch(e){}each(rules,function(r){switch(r.type||1){case 1:if(!isAllowedStylesheet(stylesheet.href))return!0;r.selectorText&&each(r.selectorText.split(","),function(v){v=v.trim(),0!=v.indexOf(".mce")&&v.indexOf(".mce-")===-1&&(isBodyClass(v)||isValidStyle(v)&&classes.push(v))});break;case 3:if(r.href.indexOf("//fonts.googleapis.com")>0){var v="@import url("+r.href+");";fontface.indexOf(v)===-1&&fontface.unshift(v)}r.href.indexOf("//")===-1&&parseCSS(r.styleSheet);break;case 5:if(r.cssText&&/(fontawesome|glyphicons|icomoon)/i.test(r.cssText)===!1){var v=toAbsolute(r.cssText,href);fontface.indexOf(v)===-1&&fontface.push(v)}}})}var self=this,ed=this.editor,doc=ed.getDoc(),href="",rules=[],fonts=!1,fontface=[],filtered={},classes=[],bodyRx=!!ed.settings.body_class&&new RegExp(".("+ed.settings.body_class.split(" ").join("|")+")");if(!classes.length)try{each(doc.styleSheets,function(styleSheet){parseCSS(styleSheet)})}catch(ex){}if(!fontface.length&&!fonts)try{var head=DOM.doc.getElementsByTagName("head")[0],style=DOM.create("style",{type:"text/css"}),css=self.fontface.join("\n");if(style.styleSheet){var setCss=function(){try{style.styleSheet.cssText=css}catch(e){}};style.styleSheet.disabled?setTimeout(setCss,10):setCss()}else style.appendChild(DOM.doc.createTextNode(css));head.appendChild(style),fonts=!0}catch(e){}if(classes.length)return classes=classes.filter(function(val,ind,arr){return arr.indexOf(val)===ind}),ed.getParam("styleselect_sort",1)&&classes.sort(),ed.settings.importcss_classes=tinymce.map(classes,function(val){var cls=cleanSelectorText(val),style=PreviewCss.getCssText(ed,{classes:cls.split(" ")});return{selector:val,class:cls,style:style}}),PreviewCss.reset(),ed.settings.importcss_classes}}),tinymce.PluginManager.add("importcss",tinymce.plugins.ImportCSS)}(),function(){tinymce.create("tinymce.plugins.ColorPicker",{init:function(ed,url){this.editor=ed,ed.addCommand("mceColorPicker",function(ui,v){ed.windowManager.open({url:ed.getParam("site_url")+"index.php?option=com_jce&task=plugin.display&plugin=colorpicker",width:365,height:320,close_previous:!1},{input_color:v.color,func:v.func})})}}),tinymce.PluginManager.add("colorpicker",tinymce.plugins.ColorPicker)}(),function(){var each=tinymce.each,JSON=tinymce.util.JSON,RangeUtils=tinymce.dom.RangeUtils,Uuid=tinymce.util.Uuid;tinymce.PluginManager.add("upload",function(ed,url){function cancel(){ed.dom.bind(ed.getBody(),"dragover",function(e){var dataTransfer=e.dataTransfer;dataTransfer&&dataTransfer.files&&dataTransfer.files.length&&e.preventDefault()}),ed.dom.bind(ed.getBody(),"drop",function(e){var dataTransfer=e.dataTransfer;dataTransfer&&dataTransfer.files&&dataTransfer.files.length&&e.preventDefault()})}function uploadHandler(file,success,failure,progress){var xhr,formData;success=success||noop,failure=failure||noop,progress=progress||noop;var args={method:"upload",id:Uuid.uuid("wf_"),inline:1,name:file.filename},url=file.upload_url;url+="&"+ed.settings.query,xhr=new XMLHttpRequest,xhr.open("POST",url),xhr.upload.onprogress=function(e){progress(e.loaded/e.total*100)},xhr.onerror=function(){failure("Image upload failed due to a XHR Transport error. Code: "+xhr.status)},xhr.onload=function(){var json;return xhr.status<200||xhr.status>=300?void failure("HTTP Error: "+xhr.status):(json=JSON.parse(xhr.responseText),json||failure("Invalid JSON response!"),json.error||!json.result?void failure(json.error.message||"Invalid JSON response!"):void success(json.result))},formData=new FormData,each(args,function(value,name){formData.append(name,value)}),formData.append("file",file,file.name),xhr.send(formData)}function addFile(file){if(/\.(php([0-9]*)|phtml|pl|py|jsp|asp|htm|html|shtml|sh|cgi)\./i.test(file.name))return ed.windowManager.alert(ed.getLang("upload.file_extension_error","File type not supported")),!1;if(each(plugins,function(plg){if(!file.upload_url){var url=plg.getUploadURL(file);if(url)return file.upload_url=url,file.uploader=plg,!1}}),file.upload_url){if(tinymce.is(file.uploader.getUploadConfig,"function")){var config=file.uploader.getUploadConfig(),name=file.target_name||file.name;if(file.filename=name.replace(/[\+\\\/\?\#%&<>"\'=\[\]\{\},;@\^\(\)\xa3\u20ac$~]/g,""),!new RegExp(".("+config.filetypes.join("|")+")$","i").test(file.name))return ed.windowManager.alert(ed.getLang("upload.file_extension_error","File type not supported")),!1;if(file.size){var max=parseInt(config.max_size,10)||1024;if(file.size>1024*max)return ed.windowManager.alert(ed.getLang("upload.file_size_error","File size exceeds maximum allowed size")),!1}}if(!file.marker&&ed.settings.upload_use_placeholder!==!1){var uid=Uuid.uuid("wf-tmp-");ed.execCommand("mceInsertContent",!1,'<span data-mce-marker="1" id="'+uid+'">\ufeff</span>',{skip_undo:1});var w,h,n=ed.dom.get(uid);/image\/(gif|png|jpeg|jpg)/.test(file.type)&&file.size?(w=h=Math.round(Math.sqrt(file.size)),w=Math.max(300,w),h=Math.max(300,h),ed.dom.setStyles(n,{width:w,height:h}),ed.dom.addClass(n,"mce-item-upload")):ed.setProgressState(!0),file.marker=n}return files.push(file),!0}return ed.windowManager.alert(ed.getLang("upload.file_extension_error","File type not supported")),!1}function createUploadMarker(node){var styles,src=node.attr("src")||"",style={},cls=[];if(!node.attr("alt")&&!/data:image/.test(src)){var alt=src.substring(src.length,src.lastIndexOf("/")+1);node.attr("alt",alt)}node.attr("style")&&(style=ed.dom.styles.parse(node.attr("style"))),node.attr("hspace")&&(style["margin-left"]=style["margin-right"]=node.attr("hspace")),node.attr("vspace")&&(style["margin-top"]=style["margin-bottom"]=node.attr("vspace")),node.attr("align")&&(style.float=node.attr("align")),node.attr("class")&&(cls=node.attr("class").replace(/\s*upload-placeholder\s*/,"").split(" ")),cls.push("mce-item-upload"),cls.push("mce-item-upload-marker"),"media"===node.name&&(node.name="img",node.shortEnded=!0),node.attr({src:"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",class:tinymce.trim(cls.join(" "))});var tmp=ed.dom.create("span",{style:style}),styles=ed.dom.getAttrib(tmp,"style");styles&&node.attr({style:styles,"data-mce-style":styles})}function selectAndInsert(file,data){var marker=file.marker,uploader=file.uploader;ed.selection.select(marker);var elm=uploader.insertUploadedFile(data);if(elm){if("object"==typeof elm&&elm.nodeType){if(ed.dom.hasClass(marker,"mce-item-upload-marker")){var styles=ed.dom.getAttrib(marker,"data-mce-style"),w=marker.width||0,h=marker.height||0;styles&&(styles=ed.dom.styles.parse(styles),styles.width&&(w=styles.width,delete styles.width),styles.height&&(h=styles.height,delete styles.height),ed.dom.setStyles(elm,styles)),w&&ed.dom.setAttrib(elm,"width",w),h&&(w&&(h=""),ed.dom.setAttrib(elm,"height",h))}ed.undoManager.add(),ed.dom.replace(elm,marker)}return ed.nodeChanged(),!0}}function bindUploadMarkerEvents(marker){function removeUpload(){dom.setStyles("wf_upload_button",{top:"",left:"",display:"none",zIndex:""})}var dom=tinymce.DOM;ed.onNodeChange.add(removeUpload),ed.dom.bind(ed.getWin(),"scroll",removeUpload);var input=dom.get("wf_upload_input"),btn=dom.get("wf_upload_button");btn||(btn=dom.add(dom.doc.body,"div",{id:"wf_upload_button",class:"btn",role:"button",title:ed.getLang("upload.button_description","Click to upload a file")},'<label for="wf_upload_input"><span class="icon-upload"></span>&nbsp;'+ed.getLang("upload.label","Upload")+"</label>"),input=dom.add(btn,"input",{type:"file",id:"wf_upload_input"})),ed.dom.bind(marker,"mouseover",function(e){if(!ed.dom.getAttrib(marker,"data-mce-selected")){var vp=ed.dom.getViewPort(ed.getWin()),p1=dom.getRect(ed.getContentAreaContainer()),p2=ed.dom.getRect(marker);if(!(vp.y>p2.y+p2.h/2-25||vp.y<p2.y+p2.h/2+25-p1.h)){var x=Math.max(p2.x-vp.x,0)+p1.x,y=Math.max(p2.y-vp.y,0)+p1.y-Math.max(vp.y-p2.y,0),zIndex="mce_fullscreen"==ed.id?dom.get("mce_fullscreen_container").style.zIndex:0;dom.setStyles("wf_upload_button",{top:y+p2.h/2-16,left:x+p2.w/2-50,display:"block",zIndex:zIndex+1}),dom.setStyles("wf_select_button",{top:y+p2.h/2-16,left:x+p2.w/2-50,display:"block",zIndex:zIndex+1}),input.onchange=function(){if(input.files){var file=input.files[0];file&&(file.marker=marker,addFile(file)&&(each(["width","height"],function(key){ed.dom.setStyle(marker,key,ed.dom.getAttrib(marker,key))}),file.marker=ed.dom.rename(marker,"span"),uploadFile(file),removeUpload()))}}}}}),ed.dom.bind(marker,"mouseout",function(e){!e.relatedTarget&&e.clientY>0||removeUpload()})}function removeFile(file){for(var i=0;i<files.length;i++)files[i]===file&&files.splice(i,1);files.splice(tinymce.inArray(files,file),1)}function uploadFile(file){uploadHandler(file,function(response){var files=response.files||[],item=files.length?files[0]:{};if(file.uploader){var obj=tinymce.extend({type:file.type,name:file.name},item);selectAndInsert(file,obj)}removeFile(file),file.marker&&ed.dom.remove(file.marker),ed.setProgressState(!1)},function(message){ed.windowManager.alert(message),removeFile(file),file.marker&&ed.dom.remove(file.marker),ed.setProgressState(!1)},function(value){file.marker&&ed.dom.setAttrib(file.marker,"data-progress",value)})}var plugins=[],files=[];ed.onPreInit.add(function(){function isMediaPlaceholder(node){if("media"===node.name)return!0;if("img"===node.name){if(node.attr("data-mce-upload-marker"))return!0;var cls=node.attr("class");if(cls&&cls.indexOf("upload-placeholder")!=-1)return!0}return!1}function bindUploadEvents(ed){each(ed.dom.select(".mce-item-upload-marker",ed.getBody()),function(n){0==plugins.length?ed.dom.remove(n):bindUploadMarkerEvents(n)})}each(ed.plugins,function(plg,name){if(tinymce.is(plg.getUploadConfig,"function")){var data=plg.getUploadConfig();data.inline&&data.filetypes&&plugins.push(plg)}}),ed.onBeforeSetContent.add(function(ed,o){o.content=o.content.replace(/<\/media>/g,"&nbsp;</media>")}),ed.onPostProcess.add(function(ed,o){o.content=o.content.replace(/(&nbsp;|\u00a0)<\/media>/g,"</media>")}),ed.schema.addCustomElements("~media[type|width|height|class|style|title|*]"),ed.settings.compress.css||ed.dom.loadCSS(url+"/css/content.css"),ed.serializer.addAttributeFilter("data-mce-marker",function(nodes,name,args){for(var i=nodes.length;i--;)nodes[i].remove()}),ed.parser.addNodeFilter("img,media",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],isMediaPlaceholder(node)&&(0==plugins.length?node.remove():createUploadMarker(node))}),ed.serializer.addNodeFilter("img",function(nodes){for(var node,cls,i=nodes.length;i--;)node=nodes[i],cls=node.attr("class"),cls&&/mce-item-upload-marker/.test(cls)&&(cls=cls.replace(/(?:^|\s)(mce-item-)(?!)(upload|upload-marker|upload-placeholder)(?!\S)/g,""),node.attr({"data-mce-src":"",src:"",class:tinymce.trim(cls)}),node.name="media",node.shortEnded=!1,node.attr("alt",null))}),ed.selection.onSetContent.add(function(){bindUploadEvents(ed)}),ed.onSetContent.add(function(){bindUploadEvents(ed)}),ed.onFullScreen&&ed.onFullScreen.add(function(editor){bindUploadEvents(editor)})}),ed.onInit.add(function(){function cancelEvent(e){e.preventDefault(),e.stopPropagation()}return 0==plugins.length?void cancel():(ed.theme&&ed.theme.onResolveName&&ed.theme.onResolveName.add(function(theme,o){var n=o.node;n&&"IMG"===n.nodeName&&/mce-item-upload/.test(n.className)&&(o.name="placeholder")}),ed.dom.bind(ed.getBody(),"dragover",function(e){e.dataTransfer.dropEffect=tinymce.VK.metaKeyPressed(e)?"copy":"move"}),void ed.dom.bind(ed.getBody(),"drop",function(e){var rng,dataTransfer=e.dataTransfer;dataTransfer&&dataTransfer.files&&dataTransfer.files.length&&(each(dataTransfer.files,function(file){rng||(rng=RangeUtils.getCaretRangeFromPoint(e.clientX,e.clientY,ed.getDoc()),rng&&ed.selection.setRng(rng)),addFile(file)}),cancelEvent(e)),files.length&&each(files,function(file){uploadFile(file)}),tinymce.isGecko&&"IMG"==e.target.nodeName&&cancelEvent(e)}))});var noop=function(){};return{plugins:plugins,upload:uploadHandler}})}(),function(){var VK=tinymce.VK,Node=tinymce.html.Node,each=tinymce.each,blocks=[];tinymce.create("tinymce.plugins.Figure",{init:function(ed,url){this.editor=ed,ed.onPreInit.add(function(ed){ed.parser.addNodeFilter("figure",function(nodes,name){for(var node,i=nodes.length;i--;){if(node=nodes[i],0===node.getAll("figcaption").length){var figcaption=new Node("figcaption",1);figcaption.attr("data-mce-empty",ed.getLang("figcaption.default","Write a caption...")),figcaption.attr("contenteditable",!0),node.append(figcaption)}node.attr("data-mce-image","1"),node.attr("contenteditable","false"),each(node.getAll("img"),function(img){img.attr("data-mce-contenteditable","true")}),ed.settings.figure_data_attribute!==!1&&node.attr("data-wf-figure","1")}}),ed.parser.addNodeFilter("figcaption",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.firstChild||node.attr("data-mce-empty",ed.getLang("figcaption.default","Write a caption...")),node.attr("contenteditable","true")}),ed.serializer.addNodeFilter("figure",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.attr("contenteditable",null),each(node.getAll("img"),function(img){img.attr("data-mce-contenteditable",null)})}),ed.serializer.addNodeFilter("figcaption",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.firstChild?node.attr("contenteditable",null):node.remove()}),ed.serializer.addAttributeFilter("data-mce-image",function(nodes,name){for(var node,i=nodes.length;i--;)node=nodes[i],node.attr(name,null)}),each(ed.schema.getBlockElements(),function(v,k){return!!/\W/.test(k)||void blocks.push(k.toLowerCase())}),ed.formatter.register("figure",{block:"figure",remove:"all",ceFalseOverride:!0,deep:!1,onformat:function(elm,fmt,vars,node){vars=vars||{},ed.dom.select("img,video,iframe",elm)&&(ed.dom.setAttribs(elm,{"data-mce-image":1,contenteditable:!1}),ed.dom.setAttrib(ed.dom.select("img",elm),"data-mce-contenteditable","true"),ed.dom.add(elm,"figcaption",{"data-mce-empty":ed.getLang("figcaption.default","Write a caption..."),contenteditable:!0},vars.caption||""),ed.settings.figure_data_attribute!==!1&&ed.dom.setAttribs(elm,{"data-wf-figure":"1"}))},onremove:function(node){ed.dom.remove(ed.dom.select("figcaption",node)),ed.dom.remove(ed.dom.getParent("figure",node),1)}}),ed.onBeforeExecCommand.add(function(ed,cmd,ui,v,o){var se=ed.selection,n=se.getNode();switch(cmd){case"JustifyRight":case"JustifyLeft":case"JustifyCenter":if(n&&ed.dom.is(n,"img,span[data-mce-object]")){var parent=ed.dom.getParent(n,"FIGURE");parent&&(se.select(parent),ed.execCommand(cmd,!1),o.terminate=!0)}}}),ed.onKeyDown.add(function(ed,e){var isDelete,rng,container,offset,collapsed;if(isDelete=e.keyCode==VK.DELETE,!e.isDefaultPrevented()&&(isDelete||e.keyCode==VK.BACKSPACE)&&!VK.modifierPressed(e)&&(rng=ed.selection.getRng(),container=rng.startContainer,offset=rng.startOffset,collapsed=rng.collapsed,container=ed.dom.getParent(container,"FIGURE"))){var node=ed.selection.getNode();if("IMG"===node.nodeName)return ed.dom.remove(container),ed.nodeChanged(),void e.preventDefault();if("FIGCAPTION"!=node.nodeName||node.nodeValue&&0!==node.nodeValue.length||0!==node.childNodes.length||e.preventDefault(),3===node.nodeType&&!collapsed&&!offset){var figcaption=ed.dom.getParent(node,"FIGCAPTION");if(figcaption){for(;figcaption.firstChild;)figcaption.removeChild(figcaption.firstChild);e.preventDefault()}}}})})}}),tinymce.PluginManager.add("figure",tinymce.plugins.Figure)}(),function(){tinymce.create("tinymce.plugins.UiPlugin",{init:function(ed,url){}}),tinymce.PluginManager.add("ui",tinymce.plugins.UiPlugin)}(),function(){var DOM=tinymce.DOM;tinymce.PluginManager.add("noneditable",function(editor){function hasClass(checkClassName){return function(node){return(" "+node.attr("class")+" ").indexOf(checkClassName)!==-1}}function isNonEditable(node){return node.attr?node.hasClass(nonEditClass):DOM.hasClass(node,nonEditClass)}function isEditable(node){return node.attr?node.hasClass(editClass):DOM.hasClass(node,editClass)}function convertRegExpsToNonEditable(e){function replaceMatchWithSpan(match){var args=arguments,index=args[args.length-2],prevChar=index>0?content.charAt(index-1):"";if('"'===prevChar)return match;if(">"===prevChar){var findStartTagIndex=content.lastIndexOf("<",index);if(findStartTagIndex!==-1){var tagHtml=content.substring(findStartTagIndex,index);if(tagHtml.indexOf('contenteditable="false"')!==-1)return match}}return'<span class="'+cls+'" data-mce-content="'+editor.dom.encode(args[0])+'">'+editor.dom.encode("string"==typeof args[1]?args[1]:args[0])+"</span>"}var i=nonEditableRegExps.length,content=e.content,cls=tinymce.trim(nonEditClass);if("raw"!=e.format){for(;i--;)content=content.replace(nonEditableRegExps[i],replaceMatchWithSpan);e.content=content}}var nonEditableRegExps,contentEditableAttrName="contenteditable",editClass=tinymce.trim(editor.getParam("noneditable_editable_class","mceEditable")),nonEditClass=tinymce.trim(editor.getParam("noneditable_noneditable_class","mceNonEditable")),hasEditClass=hasClass(editClass),hasNonEditClass=hasClass(nonEditClass);return nonEditableRegExps=editor.getParam("noneditable_regexp"),nonEditableRegExps&&!nonEditableRegExps.length&&(nonEditableRegExps=[nonEditableRegExps]),editor.onPreInit.add(function(){editor.formatter.register("noneditable",{block:"div",wrapper:!0,onformat:function(elm,fmt,vars){tinymce.each(vars,function(value,key){editor.dom.setAttrib(elm,key,value)})}}),nonEditableRegExps&&editor.onBeforeSetContent.add(function(ed,e){convertRegExpsToNonEditable(e)}),editor.parser.addAttributeFilter("class",function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],hasEditClass(node)?node.attr(contentEditableAttrName,"true"):hasNonEditClass(node)&&node.attr(contentEditableAttrName,"false")}),editor.serializer.addAttributeFilter(contentEditableAttrName,function(nodes){for(var node,i=nodes.length;i--;)node=nodes[i],(hasEditClass(node)||hasNonEditClass(node))&&(nonEditableRegExps&&node.attr("data-mce-content")?(node.name="#text",node.type=3,node.raw=!0,node.value=node.attr("data-mce-content")):node.attr(contentEditableAttrName,null))})}),{isNonEditable:isNonEditable,isEditable:isEditable}})}(),function(){var DOM=tinymce.DOM;tinymce.create("tinymce.plugins.BrandingPlugin",{init:function(ed,url){ed.settings.branding!==!1&&(ed.onPostRender.add(function(){var container=ed.getContentAreaContainer();DOM.insertAfter(DOM.create("div",{class:"mceBranding"},'Powered by JCE Core. <span id="mceBrandingMessage"></span><a href="https://www.joomlacontenteditor.net/purchase" target="_blank" title="Get JCE Pro">JCE Pro</a>'),container)}),ed.onNodeChange.add(function(ed,cm,n,co){var container=ed.getContentAreaContainer(),msg="Get more features with ";"IMG"===n.nodeName&&(msg="Image resizing, thumbnails and editing in "),ed.dom.is(n,".mce-item-media")&&(msg="Upload and manage audio and video with "),DOM.setHTML(DOM.get("mceBrandingMessage",container),msg)}))}}),tinymce.PluginManager.add("branding",tinymce.plugins.BrandingPlugin)}(),function(){function isSupportedImage(value){return/\.(jpg|jpeg|png|gif|webp|avif)$/.test(value)}function getImageExtension(value){return isSupportedImage(value)?value.substring(value.length,value.lastIndexOf(".")+1):""}function uploadHandler(settings,blobInfo,success,failure,progress){var xhr,formData;xhr=new XMLHttpRequest,xhr.open("POST",settings.url),xhr.upload.onprogress=function(e){progress(e.loaded/e.total*100)},xhr.onerror=function(){failure("Image upload failed due to a XHR Transport error. Code: "+xhr.status)},xhr.onload=function(){var json;return xhr.status<200||xhr.status>=300?void failure("HTTP Error: "+xhr.status):(json=JSON.parse(xhr.responseText),!json||json.error?void failure(json.error.message||"Invalid JSON response!"):json.result&&json.result.files?void success(json.result.files[0]):void failure(json.error.message||"Invalid JSON response!"))},formData=new FormData,formData.append("file",blobInfo.blob(),blobInfo.filename()),each(settings,function(value,name){return"url"==name||"multipart"==name||void formData.append(name,value)}),xhr.send(formData)}function imageToBlobInfo(blobCache,img,resolve,reject){var base64,blobInfo;return 0===img.src.indexOf("blob:")?(blobInfo=blobCache.getByUri(img.src),void(blobInfo?resolve({image:img,blobInfo:blobInfo}):Conversions.uriToBlob(img.src).then(function(blob){Conversions.blobToDataUri(blob).then(function(dataUri){base64=Conversions.parseDataUri(dataUri).data,blobInfo=blobCache.create(uniqueId(),blob,base64),blobCache.add(blobInfo),resolve({image:img,blobInfo:blobInfo})})},function(err){reject(err)}))):(base64=Conversions.parseDataUri(img.src).data,blobInfo=blobCache.findFirst(function(cachedBlobInfo){return cachedBlobInfo.base64()===base64}),void(blobInfo?resolve({image:img,blobInfo:blobInfo}):Conversions.uriToBlob(img.src).then(function(blob){blobInfo=blobCache.create(uniqueId(),blob,base64),blobCache.add(blobInfo),resolve({image:img,blobInfo:blobInfo})},function(err){reject(err)})))}var each=tinymce.each,BlobCache=tinymce.file.BlobCache,Conversions=tinymce.file.Conversions,Uuid=tinymce.util.Uuid,DOM=tinymce.DOM,count=0,uniqueId=function(prefix){return(prefix||"blobid")+count++};tinymce.PluginManager.add("blobupload",function(ed,url){function findMarker(marker){var found;return each(ed.dom.select("img[src]"),function(image){if(image.src==marker.src)return found=image,!1}),found}function removeMarker(marker){each(ed.dom.select("img[src]"),function(image){if(image.src==marker.src){ed.selection.select(image),ed.execCommand("mceRemoveNode");var node=ed.selection.getNode();"P"==node.nodeName&&ed.dom.isEmpty(node)&&ed.dom.add(node,"br",{"data-mce-bogus":1})}})}function processImages(images){var cachedPromises={},promises=tinymce.map(images,function(img){var newPromise;return cachedPromises[img.src]?new Promise(function(resolve){cachedPromises[img.src].then(function(imageInfo){return"string"==typeof imageInfo?imageInfo:void resolve({image:img,blobInfo:imageInfo.blobInfo})})}):(newPromise=new Promise(function(resolve,reject){imageToBlobInfo(BlobCache,img,resolve,reject)}).then(function(result){return delete cachedPromises[result.image.src],result}).catch(function(error){return delete cachedPromises[img.src],error}),cachedPromises[img.src]=newPromise,newPromise)});return Promise.all(promises)}function uploadPastedImage(marker,blobInfo){return new Promise(function(resolve,reject){if(!uploaders.length)return removeMarker(marker),resolve();var html='<div class="mceForm"><p>'+ed.getLang("upload.name_description","Please supply a name for this file")+'</p><div class="mceModalRow">   <label for="'+ed.id+'_blob_input">'+ed.getLang("dlg.name","Name")+'</label>   <div class="mceModalControl mceModalControlAppend">       <input type="text" id="'+ed.id+'_blob_input" autofocus />       <select id="'+ed.id+'_blob_mimetype">           <option value="jpeg">jpeg</option>           <option value="png">png</option>       </select>   </div></div><div class="mceModalRow">   <label for="'+ed.id+'_blob_input">'+ed.getLang("dlg.quality","Quality")+'</label>   <div class="mceModalControl">       <select id="'+ed.id+'_blob_quality" class="mce-flex-25">           <option value="100">100</option>           <option value="90">90</option>           <option value="80">80</option>           <option value="70">70</option>           <option value="60">60</option>           <option value="50">50</option>           <option value="40">40</option>           <option value="30">30</option>           <option value="20">20</option>           <option value="10">10</option>       </select>       <span role="presentation">%</span>   </div></div></div>',win=ed.windowManager.open({
title:ed.getLang("dlg.name","Name"),content:html,size:"mce-modal-landscape-small",buttons:[{title:ed.getLang("cancel","Cancel"),id:"cancel"},{title:ed.getLang("submit","Submit"),id:"submit",onclick:function(e){var filename=DOM.getValue(ed.id+"_blob_input");if(!filename)return removeMarker(marker),resolve();if(filename=filename.replace(/[\+\\\/\?\#%&<>"\'=\[\]\{\},;@\^\(\)\xa3\u20ac$~]/g,""),/\.(php([0-9]*)|phtml|pl|py|jsp|asp|htm|html|shtml|sh|cgi)\b/i.test(filename))return ed.windowManager.alert(ed.getLang("upload.file_extension_error","File type not supported")),removeMarker(marker),resolve();var url,uploader;if(each(uploaders,function(instance){if(!url&&(url=instance.getUploadURL({name:blobInfo.filename()})))return uploader=instance,!1}),!url)return removeMarker(marker),resolve();var ext=getImageExtension(blobInfo.filename())||"jpeg",quality=DOM.getValue(ed.id+"_blob_quality")||100,mimetype=DOM.getValue(ed.id+"_blob_mimetype")||ext,props={method:"upload",id:Uuid.uuid("wf_"),inline:1,name:filename,url:url+"&"+ed.settings.query,mimetype:"image/"+mimetype,quality:quality},images=tinymce.grep(ed.dom.select("img[src]"),function(image){return image.src==marker.src});ed.setProgressState(!0),uploadHandler(props,blobInfo,function(data){data.marker=images[0];var elm=uploader.insertUploadedFile(data);return elm&&(ed.undoManager.add(),ed.dom.replace(elm,images[0]),ed.selection.select(elm)),ed.setProgressState(!1),win.close(),resolve()},function(error){return ed.windowManager.alert(error),ed.setProgressState(!1),resolve()},function(){})},classes:"primary"}],open:function(){window.setTimeout(function(){DOM.get(ed.id+"_blob_input").focus()},10)},close:function(){return removeMarker(marker),resolve()}})})}var uploaders=[];ed.onPreInit.add(function(){each(ed.plugins,function(plg,name){if(tinymce.is(plg.getUploadConfig,"function")){var data=plg.getUploadConfig();data.inline&&data.filetypes&&uploaders.push(plg)}})}),ed.onInit.add(function(){ed.plugins.clipboard&&ed.onPasteBeforeInsert.add(function(ed,o){var transparentSrc="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",node=ed.dom.create("div",0,o.content),images=tinymce.grep(ed.dom.select("img[src]",node),function(img){var src=img.getAttribute("src");return!(img.hasAttribute("data-mce-bogus")||img.hasAttribute("data-mce-placeholder")||img.hasAttribute("data-mce-upload-marker")||!src||src==transparentSrc||0!==src.indexOf("blob:")&&0!==src.indexOf("data:"))});if(images.length){var promises=[];processImages(images).then(function(result){each(result,function(item){"string"!=typeof item&&(ed.selection.select(findMarker(item.image)),ed.selection.scrollIntoView(),promises.push(uploadPastedImage(item.image,item.blobInfo)))})}),Promise.all(promises).then()}})})})}()}();