var RSFirewallPassword = {
	addEvent: function(el, ev, func) {
		// el - element
		// ev - event
		// func - function to trigger
		
		if (typeof jQuery != 'undefined') {
			// jQuery is available
			if (ev == 'load') {
				jQuery(document).ready(func);
			} else if (ev == 'keyup') {
				jQuery(el).keyup(func);
			}
		} else if (typeof MooTools != 'undefined') {
			// MooTools is available
			if (ev == 'load') {
				window.addEvent('load', func);
			} else if (ev == 'keyup') {
				$(el).addEvent('keyup', func);
			}
		} else {
			// no library is available, try adding manually
			if (el.addEventListener) {
				el.addEventListener(ev, func, false);
			} else if (el.attachEvent) {
				el.attachEvent('on' + ev, func);
			} else {
				if (ev == 'load') {
					el.onload = func;
				} else if (ev == 'keyup') {
					el.onkeyup = func;
				}
			}
		}
	},
	getEl: function(el) {
		return document.getElementsByName('jform[' + el + ']')[0];
	}
}

RSFirewallPassword.addEvent(window, 'load', function() {
	var field = RSFirewallPassword.getEl('password');
	
	var parent = field.parentNode;
	var container = document.createElement('span');
	container.innerHTML = Joomla.JText._('COM_RSFIREWALL_PASSWORD_INFO');
	container.style.display = 'block';
	container.style.clear = 'both';
	parent.appendChild(container);
	
	RSFirewallPassword.addEvent(field, 'keyup', function() {
		var value 	= field.value;
		var strong = new RegExp("^(?=.{8,})(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])(?=.*\\W).*$", "g");
		var medium = new RegExp("^(?=.{7,})(((?=.*[A-Z])(?=.*[a-z]))|((?=.*[A-Z])(?=.*[0-9]))|((?=.*[a-z])(?=.*[0-9]))).*$", "g");
		
		if (value.length == 0) {
			container.innerHTML = Joomla.JText._('COM_RSFIREWALL_PLEASE_TYPE_PASSWORD');
			container.style.color = 'black';
		} else if (value.length < 6) {
			container.innerHTML = Joomla.JText._('COM_RSFIREWALL_PASSWORD_MORE_CHARACTERS');
			container.style.color = 'black';
		} else if (strong.test(value)) {
			container.innerHTML = Joomla.JText._('COM_RSFIREWALL_PASSWORD_STRONG');
			container.style.color = 'green';
		} else if (medium.test(value)) {
			container.innerHTML = Joomla.JText._('COM_RSFIREWALL_PASSWORD_MEDIUM');
			container.style.color = 'orange';
		} else {
			container.innerHTML = Joomla.JText._('COM_RSFIREWALL_PASSWORD_WEAK');
			container.style.color = 'red';
		}
	});
});