/**
 * Inline development version. Only to be used while developing since it uses document.write to load scripts.
 */

/*jshint smarttabs:true, undef:true, latedef:true, curly:true, bitwise:true, camelcase:true */
/*globals $code */

(function(exports) {
    "use strict";

    var html = "", baseDir;

    var scripts = document.getElementsByTagName('script');
    for (var i = 0; i < scripts.length; i++) {
        var src = scripts[i].src;

        if (src.indexOf('/image.min.js') != -1) {
            baseDir = src.substring(0, src.lastIndexOf('/'));
        }
    }

    function writeScripts() {
        document.write(html);
    }

    function load(path) {

        if (path.indexOf('.js') !== -1) {
            html += '<script type="text/javascript" src="' + baseDir + '/' + path + '"></script>\n';
        }
    }

    load('lib/image/webgl.js');
    load('lib/image/filter.js');
    load('lib/image/canvas.js');
    load('lib/image/editor.js');

    writeScripts();
})(this);
